/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bts;

import com.intel.bts.AppMain;
import com.intel.bts.QuartusVersionChecker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;

public class CommandShell {
    private Process proc;
    private final String quartus_rootdir = System.getenv("QUARTUS_ROOTDIR");
    private final String binPath = this.quartus_rootdir + "/" + QuartusVersionChecker.getBinaryFolderName() + "/";
    private static int connectFlag = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> listCables() {
        ArrayList<String> cables = new ArrayList<String>();
        Object[] commands = new String[]{this.binPath + "quartus_pgm", "-l"};
        BufferedReader stdInput = null;
        try {
            String output;
            this.proc = new ProcessBuilder((String[])commands).start();
            AppMain.myLogger.info(Arrays.toString(commands));
            Thread.sleep(2000L);
            stdInput = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
            while ((output = stdInput.readLine()) != null) {
                AppMain.myLogger.info(output);
                if (!output.trim().matches("^\\s*\\d+\\).*")) continue;
                cables.add(output.trim());
            }
        }
        catch (IOException | InterruptedException ex) {
            AppMain.myLogger.severe(ex.toString());
        }
        finally {
            if (null != stdInput) {
                try {
                    stdInput.close();
                }
                catch (IOException ex) {
                    AppMain.myLogger.severe(ex.toString());
                }
            }
            this.proc.destroy();
        }
        return cables;
    }

    public static void setJtagClock(String freq) {
        String binDir = System.getenv("QUARTUS_ROOTDIR") + "/" + QuartusVersionChecker.getBinaryFolderName() + "/";
        try {
            String[] clockcmd = new String[]{binDir + "jtagconfig", "--setparam", Integer.toString(1), "JtagClock", freq};
            Process process = new ProcessBuilder(clockcmd).start();
            Thread.sleep(1000L);
            process.destroy();
        }
        catch (IOException | InterruptedException ex) {
            AppMain.myLogger.severe(ex.toString());
        }
    }

    public static String getJtagClock() {
        String binDir = System.getenv("QUARTUS_ROOTDIR") + "/" + QuartusVersionChecker.getBinaryFolderName() + "/";
        String freq = null;
        try {
            String[] clockcmd = new String[]{binDir + "jtagconfig", "--getparam", Integer.toString(1), "JtagClock"};
            Process process = new ProcessBuilder(clockcmd).start();
            Thread.sleep(500L);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            freq = stdInput.readLine();
            stdInput.close();
            process.destroy();
        }
        catch (IOException | InterruptedException ex) {
            AppMain.myLogger.severe(ex.toString());
        }
        return freq;
    }

    public void runProgram(int cableIndex, int deviceIndex, String filePath) throws IOException, InterruptedException {
        String output;
        Object[] commands;
        File f = new File(filePath);
        if (!f.exists() || !f.isFile()) {
            throw new IOException("The image file is not exist!\n");
        }
        if (filePath.contains(".flash")) {
            commands = new String[]{this.binPath + "/nios2-flash-programmer", "-c", Integer.toString(cableIndex), "--base=0x0", filePath.trim()};
            this.proc = new ProcessBuilder((String[])commands).start();
            AppMain.myLogger.info(Arrays.toString(commands));
        } else if (filePath.contains(".cdf")) {
            commands = new String[]{this.binPath + "quartus_pgm", "-c", Integer.toString(cableIndex), filePath.trim()};
            this.proc = new ProcessBuilder((String[])commands).start();
            AppMain.myLogger.info(Arrays.toString(commands));
        } else {
            commands = new String[]{this.binPath + "quartus_pgm", "-c", Integer.toString(cableIndex), "-m", "JTAG", "-o", String.format("P;%s@%d", filePath.trim(), deviceIndex)};
            this.proc = new ProcessBuilder((String[])commands).start();
            AppMain.myLogger.info(Arrays.toString(commands));
        }
        Thread.sleep(10L);
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
        while ((output = stdInput.readLine()) != null) {
            AppMain.myLogger.info(output);
            if (output.contains("not supported")) {
                stdInput.close();
                this.proc.destroy();
                String version = "latest version";
                try {
                    String s;
                    FileReader fr = new FileReader("README.TXT");
                    BufferedReader br = new BufferedReader(fr);
                    while ((s = br.readLine()) != null) {
                        if (!s.contains("Quartus Version ")) continue;
                        version = s.trim().replaceAll(".*Quartus Version (.*)", "$1");
                    }
                    fr.close();
                }
                catch (IOException ex) {
                    AppMain.myLogger.severe(ex.toString());
                    System.out.println("Failed to read README.TXT!");
                }
                output = String.format("Device is not supported! We recommend that you upgrade Quartus to %s. And make sure \"QUARTUS_ROOTDIR\" environment variable point to correct directory.", version);
                throw new IOException(output);
            }
            if (!output.contains("software expired") && !output.contains("unsuccessful") && !output.contains("fail")) continue;
            stdInput.close();
            this.proc.destroy();
            throw new IOException(output);
        }
    }

    public String getBupPrint(int cableIndex, int deviceIndex) throws IOException, InterruptedException {
        Object[] commands = new String[]{this.binPath + "nios2-terminal", "-c", Integer.toString(cableIndex), "-d", Integer.toString(deviceIndex), "--quit-after=5"};
        this.proc = new ProcessBuilder((String[])commands).start();
        AppMain.myLogger.info(Arrays.toString(commands));
        Thread.sleep(10L);
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.proc.getInputStream()));
        String output = null;
        int count = 0;
        while ((output = stdInput.readLine()) != null) {
            ++count;
            AppMain.myLogger.info(output);
            if (output.contains("IP address :")) {
                stdInput.close();
                this.proc.destroy();
                return output;
            }
            if (output.contains("signature mismatch") || output.contains("Please enter")) {
                stdInput.close();
                this.proc.destroy();
                return "No Mac Address";
            }
            if (output.contains("Ethernet Cable Disconnected") || output.contains("Link could not established")) {
                stdInput.close();
                this.proc.destroy();
                return "Ethernet Cable Disconnected";
            }
            if (!output.contains("clock tick")) continue;
            connectFlag = 1;
        }
        stdInput.close();
        if (connectFlag == 1) {
            return "Connecting ...";
        }
        if (count < 9) {
            return "Please click Refresh to get IP address";
        }
        return "Ethernet Cable Disconnected";
    }

    public static void killJtagServer() {
        if (System.getProperty("os.name").contains("Windows")) {
            Runtime rt = Runtime.getRuntime();
            String str = "cmd.exe /c taskkill /f /im jtagserver.exe";
            try {
                rt.exec(str);
            }
            catch (IOException ex) {
                System.out.println("Command run error: " + ex);
            }
        } else {
            try {
                String[] clockcmd = new String[]{"killall", "jtagd"};
                Process process = new ProcessBuilder(clockcmd).start();
                Thread.sleep(1000L);
                process.destroy();
            }
            catch (IOException | InterruptedException ex) {
                AppMain.myLogger.severe(ex.toString());
            }
        }
    }

    public void cancel() {
        if (null != this.proc) {
            this.proc.destroy();
        }
    }
}

