/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bts;

import com.intel.bts.ClientApp;
import com.intel.bts.ClientViewController;
import com.intel.bts.MyLogger;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;

public class AppMain
extends Application {
    private Scene scene;
    private ClientApp clientApp;
    public static final Logger myLogger = MyLogger.getInstance(false);

    public static void main(String[] args) {
        AppMain.launch((String[])args);
    }

    public void start(Stage stage) throws Exception {
        this.initConnection();
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("ClientView.fxml"));
        Parent root = (Parent)fxmlLoader.load();
        this.scene = new Scene(root);
        ClientViewController controller = (ClientViewController)((Object)fxmlLoader.getController());
        controller.postInit(this.clientApp);
        stage.setScene(this.scene);
        stage.setTitle("System Console Client");
        stage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream("res/Quartus_prime_small_icon.png")));
        stage.setOnCloseRequest(evt -> this.windowClosing((WindowEvent)evt));
        stage.show();
    }

    public void initConnection() {
        try {
            this.clientApp = new ClientApp();
            this.clientApp.connect();
        }
        catch (IOException ex) {
            myLogger.severe(ex.toString());
        }
    }

    private void windowClosing(WindowEvent evt) {
        myLogger.info("Application Window Closing...");
        try {
            if (null != this.clientApp) {
                this.clientApp.tearDown();
                for (Handler h : myLogger.getHandlers()) {
                    h.close();
                }
            }
        }
        catch (IOException ex) {
            myLogger.severe(ex.toString());
        }
        System.exit(0);
    }
}

