# (C) 2001-2022 Intel Corporation. All rights reserved.
# Your use of Intel Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files from any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Intel Program License Subscription 
# Agreement, Intel FPGA IP License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Intel and sold by 
# Intel or its authorized distributors.  Please refer to the applicable 
# agreement for further details.


# (C) 2001-2021 Intel Corporation. All rights reserved.
# Your use of Intel Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output 
# files from any of the foregoing (including device programming or simulation 
# files), and any associated documentation or information are expressly subject 
# to the terms and conditions of the Intel Program License Subscription 
# Agreement, Intel FPGA IP License Agreement, or other applicable 
# license agreement, including, without limitation, that your use is for the 
# sole purpose of programming logic devices manufactured by Intel and sold by 
# Intel or its authorized distributors.  Please refer to the applicable 
# agreement for further details.


# issp_reset.tcl

global claimed_issp

proc open_issp {index} {
    global claimed_issp
    
    set claimed_issp [lindex [get_service_paths issp] $index]
    open_service issp $claimed_issp
}

proc close_issp {} {
    global claimed_issp

    close_service issp $claimed_issp;
}

## Apply reset through issp
proc apply_reset {} {
    puts "Applying reset through ISSP"
    global claimed_issp

    # open ISSP instance 0
    get_service_paths issp
    open_issp 0

    # apply reset
    issp_write_source_data $claimed_issp 0x11

    while 1 {
        # check for o_rst_ack_n == 0
        set current_value [issp_read_probe_data $claimed_issp]
        puts "current value : [format 0b%b $current_value]"
        if {[expr $current_value >> 7] == 0} {
            break
        }
        after 100
    }

    after 500
    # release reset
    issp_write_source_data $claimed_issp 0x1E
    after 500
    issp_write_source_data $claimed_issp 0xE
    close_issp
}

## read the values of signals and display in log#

proc read_reset_issp {} {
    global claimed_issp

    get_service_paths issp
    open_issp 0
    set current_value [issp_read_probe_data $claimed_issp]

    set issp_probe [format 0b%b [expr $current_value]]
    puts "Value from issp reset probe is $current_value/$issp_probe"

    close_issp
}

apply_reset

after 2000

read_reset_issp
