/* Copyright (c) <2012>, Intel Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  - Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  - Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *  - Neither the name of Intel Corporation nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __DRR_MODEL_H__
#define __DRR_MODEL_H__

typedef struct _vertex_t
{
    float3 position;
    float3 normal;
    float2 texcoords;
} vertex_t;

typedef struct _mesh_data_t
{
    int vertex_size;
    int vertex_count;
    int index_size;
    int index_count;
} mesh_data_t;

// Model data structure
typedef struct _model_t
{
    unsigned int is_interleaved;

    // interleaved vertex data
    GLuint vertex_buffer;

    // index buffer object
    GLuint index_buffer;

    // non-interleaved data
    GLuint positions_buffer;
    GLuint normals_buffer;
    GLuint texcoords_buffer;

    // mesh data
	vertex_t* vertices;
    unsigned int* indices;

    unsigned int  num_vertices;
    unsigned int  num_indices;
} model_t;

model_t* create_triangle_model( void );
model_t* create_quad_model( unsigned int is_interleaved );
model_t* create_cube_model( void );

model_t* load_mesh( const char* mesh_file_path );

void draw_model( model_t* model, float4x4* view_projection_matrix, float4x4* world_matrix );

#endif // __DRR_MODEL_H__