/* Copyright (c) <2012>, Intel Corporation
 *
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * - Neither the name of Intel Corporation nor the names of its contributors 
 *   may be used to endorse or promote products derived from this software 
 *   without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 */

package com.intel.samples.drr;

import android.app.Activity;
import android.content.res.AssetManager;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.TextView;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;


public class DynamicResolutionActivity extends Activity 
{
    static AssetManager sAssetManager;
    DynamicResolutionView mView;

    private static final int LINEAR_FILTERING = 0;
    private static final int BILINEAR_FILTERING = 1;
    private static final int TRILINEAR_FILTERING = 2;

    // On applications creation
    @Override protected void onCreate( Bundle savedInstanceState ) 
    {
        super.onCreate( savedInstanceState );
        
        // Pass the asset manager to the native code
        sAssetManager = getAssets();
        DynamicResolutionLib.createAssetManager( sAssetManager );

        // Set the layout
        setContentView( R.layout.main );

        // Create our view for OpenGL rendering
        mView = ( DynamicResolutionView )findViewById( R.id.drr_view );

        // UI controls handlers
        findViewById( R.id.button_set_linear ).setOnClickListener( new OnClickListener() {
            @Override public void onClick( View v )
            {
                DynamicResolutionLib.setFiltering( LINEAR_FILTERING );
                ( ( TextView )findViewById( R.id.current_filtering ) ).setText( "Texture filtering: Linear" );
            }
        });
        findViewById( R.id.button_set_bilinear ).setOnClickListener( new OnClickListener() {
            @Override public void onClick( View v )
            {
                DynamicResolutionLib.setFiltering( BILINEAR_FILTERING );
                ( ( TextView )findViewById( R.id.current_filtering ) ).setText( "Texture filtering: Bilinear" );
            }
        });
        findViewById( R.id.button_set_trilinear ).setOnClickListener( new OnClickListener() {
            @Override public void onClick( View v )
            {
                DynamicResolutionLib.setFiltering( TRILINEAR_FILTERING );
                ( ( TextView )findViewById( R.id.current_filtering ) ).setText( "Texture filtering: Trilinear" );
            }
        });

       ( ( SeekBar )findViewById( R.id.resolution_slider ) ).setOnSeekBarChangeListener( new OnSeekBarChangeListener() {
            @Override public void onProgressChanged( SeekBar v, int progress, boolean isUser )
            {
                progress = progress < 1 ? 1 : progress;
                DynamicResolutionLib.setResolution( (float)progress / 100.0f );
                ( ( TextView )findViewById( R.id.current_resolution ) ).setText( "Resolution factor: " + Integer.toString( progress ) + "%" );
            }

            @Override public void onStartTrackingTouch( SeekBar seekBar ) {}
            @Override public void onStopTrackingTouch( SeekBar seekBar ) {}
        });
    }

    @Override protected void onPause() 
    {
        super.onPause();
        mView.onPause();
    }

    @Override protected void onResume() 
    {
        super.onResume();
        mView.onResume();
    }
}
