#ifdef VERTEX

// Uniforms
uniform mat4 u_view_proj_matrix;
uniform mat4 u_world_matrix;

// Attributes
attribute vec3 a_normal;
attribute vec3 a_position;
attribute vec2 a_texCoord;

varying mediump vec3    v_normal;
varying mediump vec2	v_texCoord;

void main()
{
    v_texCoord = a_texCoord;

	// Transform normal to view space
    v_normal = ( u_world_matrix * vec4(a_normal, 0.0) ).xyz;

	// Convert position into screen space
	gl_Position = u_view_proj_matrix * u_world_matrix * vec4(a_position, 1.0);
}
#endif


#ifdef FRAGMENT
precision mediump float;

uniform vec3 u_light_dir;

varying mediump vec3    v_normal;
varying mediump vec2	v_texCoord;

void main()
{
    float ndotl = max( dot( normalize(v_normal), normalize(u_light_dir) ), 0.0 );

	gl_FragColor.rgb = vec3(1, 0.7, 0.2) * ndotl;    	
    gl_FragColor.a = 1.0;
}
#endif
