#ifdef VERTEX
attribute vec3 a_position;
attribute vec2 a_texcoord;

varying vec2 v_texcoord;  

void main()
{
    v_texcoord = a_texcoord;
    
    gl_Position = vec4( a_position, 1 );
}
#endif


#ifdef FRAGMENT
precision mediump float;
uniform sampler2D s_diffuse;

varying vec2 v_texcoord;

void main()
{
    gl_FragColor = texture2D( s_diffuse, v_texcoord.st );
}
#endif
