#------------------------------------------------------------------------------
#
# Copyright (c) 2013-2015 Intel Corporation.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
# * Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in
# the documentation and/or other materials provided with the
# distribution.
# * Neither the name of Intel Corporation nor the names of its
# contributors may be used to endorse or promote products derived
# from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# Module Name:
#
#   SmmInit.S
#
# Abstract:
#
#   Functions for relocating SMBASE's for all processors
#
# Notes:
#
#------------------------------------------------------------------------------

.equ        SSM_SMBAS, 0xfef8
.equ        SSM_IEDBAS, 0xff04

ASM_GLOBAL   ASM_PFX(gSmmCr0)
ASM_GLOBAL   ASM_PFX(gSmmCr3)
ASM_GLOBAL   ASM_PFX(gSmmCr4)
ASM_GLOBAL   ASM_PFX(gcSmmInitTemplate)
ASM_GLOBAL   ASM_PFX(gcSmmInitSize)
ASM_GLOBAL   ASM_PFX(gSmmJmpAddr)
ASM_GLOBAL   ASM_PFX(SmmRelocationSemaphoreComplete)
ASM_GLOBAL   ASM_PFX(SmmRelocationSemaphoreComplete32)
ASM_GLOBAL   ASM_PFX(mRebasedFlagAddr32)
ASM_GLOBAL   ASM_PFX(mSmmRelocationOriginalAddressPtr32)
ASM_GLOBAL   ASM_PFX(gSmmInitStack)

    .data

NullSeg:    .quad      0
CodeSeg64:
            .word -1                    # LimitLow
            .word 0                     # BaseLow
            .byte 0                     # BaseMid
            .byte 0x9b
            .byte 0xaf                  # LimitHigh
            .byte 0                     # BaseHigh
.equ  GDT_SIZE, . - NullSeg

    .text

GdtDesc:
            .word      GDT_SIZE
            .quad      NullSeg

SmmStartup:
    .byte 0x66,0xb8                     # mov eax, imm32
ASM_PFX(gSmmCr3):    .space     4
    movq    %rax, %cr3
    .byte 0x66,0x2e
    lgdt    (GdtDesc - SmmStartup)(%ebp)
    .byte 0x66,0xb8                     # mov eax, imm32
ASM_PFX(gSmmCr4):    .space     4
    movq    %rax, %cr4
    .byte 0x66
    movl    $0xc0000080,%ecx            # IA32_EFER MSR
    rdmsr
    orb     $1,%ah                      # set LME bit
    wrmsr
    .byte 0x66,0xb8                     # mov eax, imm32
ASM_PFX(gSmmCr0):    .space     4
    movq    %rax, %cr0
    .byte 0x66,0xea                     # far jmp to long mode
ASM_PFX(gSmmJmpAddr): .quad      LongMode
LongMode:                               # long-mode starts here
    .byte 0x48,0xbc                     # mov rsp, imm64
ASM_PFX(gSmmInitStack):  .space  8
    andw  $0xfff0, %sp                  # make sure RSP is 16-byte aligned
    addq  $-0x20, %rsp
    call  ASM_PFX(SmmInitHandler)
    addq  $0x20, %rsp
    rsm

ASM_PFX(gcSmmInitTemplate):

_SmmInitTemplate:
    .byte 0x66,0x2e,0x8b,0x2e           # mov ebp, cs:[@F]
    .word      0x800f
    .byte 0x66,0x2e,0x2b,0x2e           # sub ebp, cs:[SSM_SMBAS]
    .word      SSM_SMBAS
    jmp     *%bp                        # jmp ebp actually
L1:
    .quad      SmmStartup

ASM_PFX(gcSmmInitSize):   .word  . - ASM_PFX(gcSmmInitTemplate)

ASM_PFX(SmmRelocationSemaphoreComplete):
    # Create a simple stack frame to store RAX and the original RSM location
    pushq   %rax  # Used to store return address
    pushq   %rax

    # Load the original RSM location onto stack
    movabsq $ASM_PFX(mSmmRelocationOriginalAddress), %rax
    movq    (%rax), %rax
    movq    %rax, 0x08(%rsp)

    # Update rebase flag
    movabsq $ASM_PFX(mRebasedFlag), %rax
    movq    (%rax), %rax
    movb    $1, (%rax)

    #restore RAX and return to original RSM location
    popq    %rax
    retq

#
# Semaphore code running in 32-bit mode
#
ASM_PFX(SmmRelocationSemaphoreComplete32):
    #
    # movb $1, ()
    #
    .byte   0xc6, 0x05
ASM_PFX(mRebasedFlagAddr32):
    .long   0
    .byte   1
    #
    # jmpd ()
    #
    .byte   0xff, 0x25
ASM_PFX(mSmmRelocationOriginalAddressPtr32):
    .long   0

