;-------------------------------------------------------------------------------
;
; Copyright (c) 2013-2015 Intel Corporation.
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions
; are met:
;
; * Redistributions of source code must retain the above copyright
; notice, this list of conditions and the following disclaimer.
; * Redistributions in binary form must reproduce the above copyright
; notice, this list of conditions and the following disclaimer in
; the documentation and/or other materials provided with the
; distribution.
; * Neither the name of Intel Corporation nor the names of its
; contributors may be used to endorse or promote products derived
; from this software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
; LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
; A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
; OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
; SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
; LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
; DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
; THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
; (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
; OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;
; Module Name:
; 
;    AsmVmCall.asm
;
; Abstract:
;
;------------------------------------------------------------------------------

  .686P
  .MMX
  .MODEL SMALL
  .CODE

;------------------------------------------------------------------------------
;  UINT32
;  AsmVmCall (
;    UINT32  Eax,  // [ESP + 8h]
;    UINT32  Ebx,  // [ESP + 0Ch]
;    UINT32  Ecx,  // [ESP + 10h]
;    UINT32  Edx   // [ESP + 14h]
;    )
;------------------------------------------------------------------------------
AsmVmCall PROC C PUBLIC
    push     ebx
    mov      eax, [esp+8h]
    mov      ebx, [esp+0ch]
    mov      ecx, [esp+10h]
    mov      edx, [esp+14h]
    push     esi
    push     edi
    push     ebp
    DB  0fh, 01h, 0c1h           ; VMCALL
    pop      ebp
    pop      edi
    pop      esi
    pop      ebx
    ret
AsmVmCall  ENDP

  END

