/** @file

  Copyright (c) 2015, Intel Corporation. All rights reserved.<BR>
  This program and the accompanying materials
  are licensed and made available under the terms and conditions of the BSD License
  which accompanies this distribution.  The full text of the license may be found at
  http://opensource.org/licenses/bsd-license.php.

  THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS,
  WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.

**/

#include <Base.h>
#include "FrmHandler.h"

//#define HOOK_KBC_RESET

#define KBC_RESET_IO_PORT      0x64
#define KBC_RESET_WRITE_VALUE  0xFE

VOID
IoResetHandler (
  UINT32  Index,
  UINT16  Port,
  UINT8   Data
  )
{
  DEBUG ((EFI_D_INFO, "(FRM) !!!IoResetHandler!!!\n"));

  FrmTeardownBsp (Index);
  AsmWbinvd ();

  //
  // Work-around for CTRL+ALT+DEL, it will pass 0x2.
  //
  Data = Data | 0x6;
  IoWrite8 (Port, Data);

  CpuDeadLoop ();

  return ;
}

VOID
IoResetWriteHandler (
  VOID      *Context,
  UINT16    Port,
  UINT32    Value,
  UINT32    *Action
  )
{
  UINT32  Index;

  Index = ApicToIndex (ReadLocalApicId ());

  DEBUG ((EFI_D_INFO, "(FRM) !!!IoResetHandler!!!\n"));

  FrmTeardownBsp (Index);
  AsmWbinvd ();
  
  //
  // Work-around for CTRL+ALT+DEL, it will pass 0x2.
  //
  Value = Value | 0x6;
  IoWrite8 (Port, (UINT8)Value);

  CpuDeadLoop ();

  *Action = IO_ACTION_PASSTHROUGH;

  return ;
}

VOID
KbcResetWriteHandler (
  VOID      *Context,
  UINT16    Port,
  UINT32    Value,
  UINT32    *Action
  )
{
  UINT32  Index;

  Index = ApicToIndex (ReadLocalApicId ());

  DEBUG ((EFI_D_INFO, "(FRM) !!!KbcResetHandler!!!\n"));

  if ((UINT8)Value != KBC_RESET_WRITE_VALUE) {
    // Normal KB
    *Action = IO_ACTION_PASSTHROUGH;
    return ;
  }

  // Reset
  FrmTeardownBsp (Index);
  AsmWbinvd ();
  *Action = IO_ACTION_PASSTHROUGH;

  return ;
}

VOID
InitializeIoResetHandlers (
  VOID
  )
{
  if (mHostContextCommon.ResetIoPortBaseAddress != 0) {
    RegisterIoWrite (
      mHostContextCommon.ResetIoPortBaseAddress,       // Port
      sizeof(UINT8),                                   // Size = 8-bit
      IoResetWriteHandler,                             // WriteHandler
      NULL                                             // WriteContext
      );
  }
#ifdef HOOK_KBC_RESET
  RegisterIoWrite (
    KBC_RESET_IO_PORT,                               // Port
    sizeof(UINT8),                                   // Size = 8-bit
    KbcResetWriteHandler,                            // WriteHandler
    NULL                                             // WriteContext
    );
#endif
  return ;
}
