/** @file

  Copyright (c) 2015, Intel Corporation. All rights reserved.<BR>
  This program and the accompanying materials
  are licensed and made available under the terms and conditions of the BSD License
  which accompanies this distribution.  The full text of the license may be found at
  http://opensource.org/licenses/bsd-license.php.

  THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS,
  WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.

**/

#ifndef _FRM_HANDLER_H_
#define _FRM_HANDLER_H_

#include <Base.h>
#include "Frm.h"

extern FRM_HOST_CONTEXT_COMMON   mHostContextCommon;
extern FRM_GUEST_CONTEXT_COMMON  mGuestContextCommon;

typedef
VOID
(* FRM_HANDLER) (
  IN UINT32  Index
  );

VOID
UnknownHandler (
  IN UINT32 Index
  );

VOID
CrHandler (
  IN UINT32 Index
  );

VOID
EPTViolationHandler (
  UINT32 Index
  );

VOID
EPTMisconfigurationHandler (
  UINT32  Index
  );

VOID
InvEPTHandler (
  UINT32  Index
  );

VOID
IoHandler (
  UINT32 Index
  );

VOID
CpuidHandler (
  IN UINT32 Index
  );

VOID
ReadMsrHandler (
  IN UINT32 Index
  );

VOID
WriteMsrHandler (
  IN UINT32 Index
  );

VOID
InitHandler (
  IN UINT32 Index
  );

VOID
SipiHandler (
  IN UINT32 Index
  );

VOID
InvdHandler (
  IN UINT32 Index
  );

VOID
WbinvdHandler (
  IN UINT32 Index
  );

VOID
VmcallHandler (
  IN UINT32 Index
  );

VOID
VmxTimerHandler (
  IN UINT32 Index
  );

VOID
ExternalInterruptHandler (
  IN UINT32 Index
  );

VOID
ExceptionNMIHandler (
  IN UINT32 Index
  );

VOID
InterruptWindowHandler (
  IN UINT32 Index
  );

VOID
TaskSwitchHandler (
  IN UINT32 Index
  );

VOID
XsetbvHandler (
  IN UINT32 Index
  );

VOID
IoAcpiHandler (
  UINT32  Index,
  UINT16  Port,
  UINT32  Data
  );

VOID
IoResetHandler (
  UINT32  Index,
  UINT16  Port,
  UINT8   Data
  );

//
// Misc
//
UINT32
ApicToIndex (
  IN UINT32  ApicId
  );

UINTN
GuestVirtualToGuestPhysical (
  UINT32  CpuIndex,
  UINTN   GuestVirtualAddress
  );

UINTN
GuestVirtualToHostPhysical (
  UINT32  CpuIndex,
  UINTN   GuestVirtualAddress
  );

VOID
EPTSetPageAttribute (
  IN UINTN  Addr,
  IN UINTN  R,
  IN UINTN  W,
  IN UINTN  X
  );

VOID
TeardownStm (
  IN UINT32 Index
  );

VOID
FrmTeardownAp (
  IN UINT32 Index
  );

VOID
FrmTeardownBsp (
  IN UINT32 Index
  );

#endif