/** @file

  Copyright (c) 2015, Intel Corporation. All rights reserved.<BR>
  This program and the accompanying materials
  are licensed and made available under the terms and conditions of the BSD License
  which accompanies this distribution.  The full text of the license may be found at
  http://opensource.org/licenses/bsd-license.php.

  THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS,
  WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.

**/

#include <Base.h>
#include "FrmInit.h"

UINTN
CreatePageTable (
  VOID
  )
{
  UINTN                             PageTable;
  UINTN                             i, j;
  UINT64                            *PDE, *PTE;
  UINT64                            *PML4;

  //
  // One more page is needed in 64-bit mode
  //
  i = sizeof (UINTN) == sizeof (UINT64) ? 6 : 5;

  //
  // Allocate the page table
  //
  PageTable = (UINTN)AllocatePages (i);

  //
  // This step is needed only in 64-bit mode
  //
  if (sizeof(UINTN) == sizeof(UINT64)) {
    PML4 = (UINT64*)(UINTN)PageTable;
    PageTable += SIZE_4KB;
    *PML4 = PageTable | IA32_PG_P;
  }

  PDE = (UINT64*)(UINTN)PageTable;
  PTE = PDE + SIZE_4KB / sizeof (*PDE);

  for (i = 0; i < 4; i++) {
    *PDE = (UINTN)PTE | IA32_PG_P;
    PDE++;

    for (j = 0; j < SIZE_4KB / sizeof (*PTE); j++) {
      *PTE = (((i << 9) + j) << 21) |
        IA32_PG_PS | IA32_PG_RW | IA32_PG_P;
      PTE++;
    }
  }

  //
  // This step is needed only in 64-bit mode
  //
  if (sizeof(UINTN) == sizeof(UINT64)) {
    PageTable = (UINTN)PML4;
  }
  return PageTable;
}

UINTN
CreateCompatiblePageTable (
  VOID
  )
{
  UINTN                             PageTable;
  UINTN                             i, j;
  UINT32                            *PDE, *PTE;
  UINT32                            Address;

  i = 1 + 1024;

  //
  // Allocate the page table
  //
  PageTable = (UINTN)AllocatePages (i);

  PDE = (UINT32*)(UINTN)PageTable;
  PTE = (UINT32*)((UINTN)PageTable + SIZE_4KB);

  Address = 0;
  for (i = 0; i < SIZE_4KB / sizeof (*PDE); i++) {
    *PDE = (UINT32)((UINTN)PTE | IA32_PG_P);
    PDE++;

    for (j = 0; j < SIZE_4KB / sizeof (*PTE); j++) {
      *PTE = (UINT32)(Address | IA32_PG_USR | IA32_PG_RW | IA32_PG_P);
      PTE++;
      Address += SIZE_4KB;
    }
  }

  return PageTable;
}

UINTN
CreateCompatiblePageTablePae (
  VOID
  )
{
  UINTN                             PageTable;
  UINTN                             i, j, k;
  UINT64                            *PDPTE, *PDE, *PTE;
  UINT64                            Address;

  i = 1 + 4 + 1024 * 4;

  //
  // Allocate the page table
  //
  PageTable = (UINTN)AllocatePages (i);

  PDPTE = (UINT64*)(UINTN)PageTable;
  PDE = (UINT64*)((UINTN)PageTable + SIZE_4KB);
  PTE = (UINT64*)((UINTN)PageTable + SIZE_4KB * 5);

  Address = 0;
  for (k = 0; k < 4; k++) {
    *PDPTE = (UINT64)((UINTN)PDE | IA32_PG_P);
    PDPTE++;

    for (i = 0; i < SIZE_4KB / sizeof (*PTE); i++) {
      *PDE = (UINT64)((UINTN)PTE | IA32_PG_USR | IA32_PG_RW | IA32_PG_P);
      PDE++;

      for (j = 0; j < SIZE_4KB / sizeof (*PTE); j++) {
        *PTE = (UINT64)(Address | IA32_PG_USR | IA32_PG_RW | IA32_PG_P);
        PTE++;
        Address += SIZE_4KB;
      }
    }
  }

  return PageTable;
}
