/** @file

  Copyright (c) 2015, Intel Corporation. All rights reserved.<BR>
  This program and the accompanying materials
  are licensed and made available under the terms and conditions of the BSD License
  which accompanies this distribution.  The full text of the license may be found at
  http://opensource.org/licenses/bsd-license.php.

  THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS,
  WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.

**/

#ifndef _FRM_INIT_H_
#define _FRM_INIT_H_

#include <Base.h>
#include "Frm.h"

extern FRM_COMMUNICATION_DATA    mCommunicationData;
extern FRM_HOST_CONTEXT_COMMON   mHostContextCommon;
extern FRM_GUEST_CONTEXT_COMMON  mGuestContextCommon;

extern volatile BOOLEAN    *mApFinished;
extern volatile BOOLEAN    mApLaunch;

extern UINT32 mBspIndex;

extern volatile BOOLEAN    *mTeardownFinished;

UINTN
CreatePageTable (
  VOID
  );

UINTN
CreateCompatiblePageTable (
  VOID
  );

UINTN
CreateCompatiblePageTablePae (
  VOID
  );

VOID
EptInit (
  VOID
  );

VOID
IoInit (
  VOID
  );

VOID
VmxTimerInit (
  VOID
  );

VOID
InitAllAps (
  VOID
  );

VOID
WakeupAllAps (
  VOID
  );

VOID *
AllocatePages (
  IN UINTN Pages
  );

VOID
FreePages (
  IN VOID  *Address,
  IN UINTN Pages
  );

VOID
InitHostContextPerCpu (
  IN UINT32 Index
  );

VOID
InitGuestContextPerCpu (
  IN UINT32 Index
  );

VOID
HostEntrypoint (
  VOID
  );

VOID
GuestEntrypoint (
  VOID
  );

VOID
SetVmcsHostField (
  IN UINT32 Index
  );

VOID
SetVmcsControlField (
  IN UINT32 Index
  );

VOID
SetVmcsGuestField (
  IN UINT32 Index
  );

UINT32
ApicToIndex (
  IN UINT32  ApicId
  );

VOID
InitFrmHandler (
  VOID
  );

VOID
ExceptionHandlers (
  VOID
  );

VOID
NmiExceptionHandlers (
  VOID
  );

VOID
LaunchStm (
  IN UINTN                           CpuIndex
  );

#endif