#ifndef GENERATORS_STL_H
#define GENERATORS_STL_H

namespace gen
{
	typedef struct {
		unsigned short key;
		unsigned short value;
	} ITEM;

	template<class Container = std::vector<ITEM>>
	void generate_objects(Container & a, std::size_t size)
	{
		std::random_device rd; std::mt19937 gen(rd());
		std::uniform_int_distribution<> dist_key(1, 100);
		std::uniform_int_distribution<> dist_val(1, 255);

		omp_lock_t lock;
		omp_init_lock(&lock);

		#pragma omp parallel for
		for (std::size_t index = 0; index < size; index++)
		{
			omp_set_lock(&lock);

			ITEM item = { 0 };
			std::memset((void*)& item, 0x00, sizeof(ITEM));
			item.key = dist_key(gen); item.value = dist_val(gen);

			a.push_back(item);

			omp_unset_lock(&lock);
		}
	}
}

#endif // GENERATORS_STL_H
