// Copyright (c) 2009-2014 Intel Corporation
// All rights reserved.
//
// WARRANTY DISCLAIMER
//
// THESE MATERIALS ARE PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR ITS
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THESE
// MATERIALS, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Intel Corporation is the author of the Materials, and requests that all
// problem reports or change requests be submitted to it directly

#ifndef SCENE_H
#define SCENE_H

//scene structures, must stay same as in AOBench.cl
//TODO: should just share the same file right?, then just inclucde in each via #include

typedef struct _vec3
{
	float x;
	float y;
	float z;
} vec3;

typedef struct _intersect_pt
{
	float t;
	vec3 p;
	vec3 n;
	int hit;
} intersect_pt;

typedef struct _sphere
{
	vec3 center;
	float radius;
} sphere;


typedef struct _plane
{
	vec3 p;
	vec3 n;
} plane;

typedef struct _ray
{
	vec3 orig; 
	vec3 dir;
} ray;


//THese are not used host side, placeholders for now, remove before shipping if not needed
//NEED TO GO TO A SCENE.CPP FILE IF NEEDED
/*
float vdot()
{
	return 1.0f;
}

float vcross()
{
	return 1.0f;
}

float vnormalize()
{
	return 1.0f;
}
*/
//end scene structs



#endif //_SCENE_H_