// Copyright (c) 2009-2014 Intel Corporation
// All rights reserved.
//
// WARRANTY DISCLAIMER
//
// THESE MATERIALS ARE PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL INTEL OR ITS
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
// OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THESE
// MATERIALS, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Intel Corporation is the author of the Materials, and requests that all
// problem reports or change requests be submitted to it directly

#ifndef HOST_COMMON_H
#define HOST_COMMON_H

#include <CL/cl.h>
#include <string.h>
#include <cstdlib>
#include <iostream>
#include <string>
#include <fstream>
#include <Windows.h>

#include "scene.h"

#define SUCCESS 0
#define FAIL -1
#define IMAGE_WIDTH 1024
#define IMAGE_HEIGHT 1024
#define CL_KERNELS "..\\common\\kernels.cl"
#define PERF_TEST_ZERO_COPY 1 //don't forget to also decide if you want aligned or unaligned malloc
#define ALIGNED_ALLOCATION 1

//#define CL_DEVICE_CPU_OR_GPU CL_DEVICE_TYPE_GPU
#define CL_DEVICE_CPU_OR_GPU CL_DEVICE_TYPE_CPU


//basic components of any cl sample application
extern cl_context g_clContext;
extern cl_device_id *g_clDevices;
extern cl_command_queue g_clCommandQueue;
extern cl_program g_clProgram;
extern char *g_clProgramString;


//data structures specific to this sample solution
extern float *g_f32_resultImage; 
extern unsigned char *g_img;
extern unsigned int g_h,g_w;
extern unsigned int g_numSubSamples;
extern unsigned int g_imageSize;
extern bool g_bAlignedAlloc;
extern cl_mem g_cl_mem_resultImage;
extern cl_mem g_cl_mem_spheres;
extern cl_mem g_cl_mem_planes;
extern cl_kernel cl_kernel_one_pixel;

//scene graph
extern sphere g_spheres[3];
extern plane g_plane;

//functions for any CL Sample application
int initializeHost(void);
int initializeCL(void);
int initializeCL2(void);
int runCLKernels(void);
int cleanupCL(void);

//lower level functions used to setup the application
//create buffers to be used on the device
int initializeDeviceData();
//compile program and create kernels to be used on device side
int initializeDeviceCode();
int initializeHost(void);
void initializeScene(void);

//Debugging functions
void print1DArray(const std::string arrayName, const unsigned int *arrayData, const unsigned int length);
int HandleCompileError(void);
int convertToString(const char *filename, char *buf);

int ReportPlatformInfo(FILE *fp);
int ReportDeviceInfo(FILE *fp);

//utility functions
//testStatus is intentionally extremely tiny to minimize extraneous code in a sample
void testStatus(int status, char *errorMsg);
int HandleCompileError(void);
std::string convertToString(const char *fileName);
unsigned char clamp(float f);
void savePPM();
unsigned int verifyZeroCopyPtr(void *ptr, unsigned int sizeOfContentsOfPtr);


#endif HOST_COMMON_H
