/*******************************************************************************
* Copyright 2018-2020 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*
* License:
* http://software.intel.com/en-us/articles/intel-sample-source-code-license-agr
* eement/
*******************************************************************************/

#ifndef PRFILTERBRD_TL_H__
#define PRFILTERBRD_TL_H__

#include "ippcore.h"
#include "owndefs_tl.h"
#include "ippcore_tl.h"
#include "ipps.h"
#include "ippi.h"
#include "ippdefs.h"
#include "ownisplit_tl.h"
#include "owni_tl.h"



#ifdef USE_OMP
#include <omp.h>
#endif

#define D_ALIGN 32

typedef struct
{
    IpprPointL  split;
    IpprVolumeL tileSize;
    IpprVolumeL lastTile;
    IppDataType dataType;
    Ipp32u      numChannels;
    IppSizeL    bufsize;
    IppDataType kernelType;
    IpprVolumeL kernelVolume;
} FilterBorderInfo;

#define TILE_S (kernelVolume.depth + 1)

typedef struct _ipprFilterBorder_8u_LT_Str
{
    Ipp8u * pSrc; //const
    IppSizeL srcPlaneStep;
    IppSizeL srcStep;
    Ipp8u * pDst;
    IppSizeL dstPlaneStep;
    IppSizeL dstStep;
    IpprBorderType border;
    Ipp8u * borderValue;
    IpprFilterBorderSpec_LT * pSpec; //const
    Ipp8u * pBuffer;
    IppSizeL bufSize;
    IppSizeL numChannels;
    IpprPointL splitImage;
    IpprVolumeL pTileSize;
    IpprVolumeL pLastSize;
} ipprFilterBorder_8u_LT_Str;
typedef struct _ipprFilterBorder_16u_LT_Str
{
    Ipp16u * pSrc; //const
    IppSizeL srcPlaneStep;
    IppSizeL srcStep;
    Ipp16u * pDst;
    IppSizeL dstPlaneStep;
    IppSizeL dstStep;
    IpprBorderType border;
    Ipp16u * borderValue;
    IpprFilterBorderSpec_LT * pSpec; //const
    Ipp8u * pBuffer;
    IppSizeL bufSize;
    IppSizeL numChannels;
    IpprPointL splitImage;
    IpprVolumeL pTileSize;
    IpprVolumeL pLastSize;
} ipprFilterBorder_16u_LT_Str;
typedef struct _ipprFilterBorder_16s_LT_Str
{
    Ipp16s * pSrc; //const
    IppSizeL srcPlaneStep;
    IppSizeL srcStep;
    Ipp16s * pDst;
    IppSizeL dstPlaneStep;
    IppSizeL dstStep;
    IpprBorderType border;
    Ipp16s * borderValue;
    IpprFilterBorderSpec_LT * pSpec; //const
    Ipp8u * pBuffer;
    IppSizeL bufSize;
    IppSizeL numChannels;
    IpprPointL splitImage;
    IpprVolumeL pTileSize;
    IpprVolumeL pLastSize;
} ipprFilterBorder_16s_LT_Str;
typedef struct _ipprFilterBorder_32f_LT_Str
{
    Ipp32f * pSrc; //const
    IppSizeL srcPlaneStep;
    IppSizeL srcStep;
    Ipp32f * pDst;
    IppSizeL dstPlaneStep;
    IppSizeL dstStep;
    IpprBorderType border;
    Ipp32f * borderValue;
    IpprFilterBorderSpec_LT * pSpec; //const
    Ipp8u * pBuffer;
    IppSizeL bufSize;
    IppSizeL numChannels;
    IpprPointL splitImage;
    IpprVolumeL pTileSize;
    IpprVolumeL pLastSize;
} ipprFilterBorder_32f_LT_Str;
typedef struct _ipprFilterBorder_64f_LT_Str
{
    Ipp64f * pSrc; //const
    IppSizeL srcPlaneStep;
    IppSizeL srcStep;
    Ipp64f * pDst;
    IppSizeL dstPlaneStep;
    IppSizeL dstStep;
    IpprBorderType border;
    Ipp64f * borderValue;
    IpprFilterBorderSpec_LT * pSpec; //const
    Ipp8u * pBuffer;
    IppSizeL bufSize;
    IppSizeL numChannels;
    IpprPointL splitImage;
    IpprVolumeL pTileSize;
    IpprVolumeL pLastSize;
} ipprFilterBorder_64f_LT_Str;

static void fBrdThreadingStructureEncode_8u_LT(
    Ipp8u * pSrc,
    IppSizeL srcPlaneStep,
    IppSizeL srcStep,
    Ipp8u * pDst, 
    IppSizeL dstPlaneStep,
    IppSizeL dstStep,
    IpprBorderType border, 
    Ipp8u * borderValue, 
    IpprFilterBorderSpec_LT * pSpec,
    Ipp8u * pBuffer,
    IppSizeL bufSize,
    IppSizeL numChannels,
    IpprPointL splitImage,
    IpprVolumeL pTileSize, 
    IpprVolumeL pLastSize,   
    ipprFilterBorder_8u_LT_Str * ts
)
{
    ts->pSrc = pSrc;
    ts->srcPlaneStep = srcPlaneStep;
    ts->srcStep = srcStep;
    ts->pDst = pDst;
    ts->dstPlaneStep = dstPlaneStep;
    ts->dstStep = dstStep;
    ts->border = border;
    ts->borderValue = borderValue;
    ts->pSpec = pSpec;
    ts->pBuffer = pBuffer;
    ts->bufSize = bufSize;
    ts->numChannels = numChannels;
    ts->splitImage = splitImage;
    ts->pTileSize = pTileSize;
    ts->pLastSize = pLastSize;
}
static void fBrdThreadingStructureEncode_16u_LT(
    Ipp16u * pSrc,
    IppSizeL srcPlaneStep,
    IppSizeL srcStep,
    Ipp16u * pDst,
    IppSizeL dstPlaneStep,
    IppSizeL dstStep,
    IpprBorderType border,
    Ipp16u * borderValue,
    IpprFilterBorderSpec_LT * pSpec,
    Ipp8u * pBuffer,
    IppSizeL bufSize,
    IppSizeL numChannels,
    IpprPointL splitImage,
    IpprVolumeL pTileSize,
    IpprVolumeL pLastSize,
    ipprFilterBorder_16u_LT_Str * ts
)
{
    ts->pSrc = pSrc;
    ts->srcPlaneStep = srcPlaneStep;
    ts->srcStep = srcStep;
    ts->pDst = pDst;
    ts->dstPlaneStep = dstPlaneStep;
    ts->dstStep = dstStep;
    ts->border = border;
    ts->borderValue = borderValue;
    ts->pSpec = pSpec;
    ts->pBuffer = pBuffer;
    ts->bufSize = bufSize;
    ts->numChannels = numChannels;
    ts->splitImage = splitImage;
    ts->pTileSize = pTileSize;
    ts->pLastSize = pLastSize;
}
static void fBrdThreadingStructureEncode_16s_LT(
    Ipp16s * pSrc,
    IppSizeL srcPlaneStep,
    IppSizeL srcStep,
    Ipp16s * pDst,
    IppSizeL dstPlaneStep,
    IppSizeL dstStep,
    IpprBorderType border,
    Ipp16s * borderValue,
    IpprFilterBorderSpec_LT * pSpec,
    Ipp8u * pBuffer,
    IppSizeL bufSize,
    IppSizeL numChannels,
    IpprPointL splitImage,
    IpprVolumeL pTileSize,
    IpprVolumeL pLastSize,
    ipprFilterBorder_16s_LT_Str * ts
)
{
    ts->pSrc = pSrc;
    ts->srcPlaneStep = srcPlaneStep;
    ts->srcStep = srcStep;
    ts->pDst = pDst;
    ts->dstPlaneStep = dstPlaneStep;
    ts->dstStep = dstStep;
    ts->border = border;
    ts->borderValue = borderValue;
    ts->pSpec = pSpec;
    ts->pBuffer = pBuffer;
    ts->bufSize = bufSize;
    ts->numChannels = numChannels;
    ts->splitImage = splitImage;
    ts->pTileSize = pTileSize;
    ts->pLastSize = pLastSize;
}
static void fBrdThreadingStructureEncode_32f_LT(
    Ipp32f * pSrc,
    IppSizeL srcPlaneStep,
    IppSizeL srcStep,
    Ipp32f * pDst,
    IppSizeL dstPlaneStep,
    IppSizeL dstStep,
    IpprBorderType border,
    Ipp32f * borderValue,
    IpprFilterBorderSpec_LT * pSpec,
    Ipp8u * pBuffer,
    IppSizeL bufSize,
    IppSizeL numChannels,
    IpprPointL splitImage,
    IpprVolumeL pTileSize,
    IpprVolumeL pLastSize,
    ipprFilterBorder_32f_LT_Str * ts
)
{
    ts->pSrc = pSrc;
    ts->srcPlaneStep = srcPlaneStep;
    ts->srcStep = srcStep;
    ts->pDst = pDst;
    ts->dstPlaneStep = dstPlaneStep;
    ts->dstStep = dstStep;
    ts->border = border;
    ts->borderValue = borderValue;
    ts->pSpec = pSpec;
    ts->pBuffer = pBuffer;
    ts->bufSize = bufSize;
    ts->numChannels = numChannels;
    ts->splitImage = splitImage;
    ts->pTileSize = pTileSize;
    ts->pLastSize = pLastSize;
}
static void fBrdThreadingStructureEncode_64f_LT(
    Ipp64f * pSrc,
    IppSizeL srcPlaneStep,
    IppSizeL srcStep,
    Ipp64f * pDst,
    IppSizeL dstPlaneStep,
    IppSizeL dstStep,
    IpprBorderType border,
    Ipp64f * borderValue,
    IpprFilterBorderSpec_LT * pSpec,
    Ipp8u * pBuffer,
    IppSizeL bufSize,
    IppSizeL numChannels,
    IpprPointL splitImage,
    IpprVolumeL pTileSize,
    IpprVolumeL pLastSize,
    ipprFilterBorder_64f_LT_Str * ts
)
{
    ts->pSrc = pSrc;
    ts->srcPlaneStep = srcPlaneStep;
    ts->srcStep = srcStep;
    ts->pDst = pDst;
    ts->dstPlaneStep = dstPlaneStep;
    ts->dstStep = dstStep;
    ts->border = border;
    ts->borderValue = borderValue;
    ts->pSpec = pSpec;
    ts->pBuffer = pBuffer;
    ts->bufSize = bufSize;
    ts->numChannels = numChannels;
    ts->splitImage = splitImage;
    ts->pTileSize = pTileSize;
    ts->pLastSize = pLastSize;
}
#endif // PRFILTERBRD_TL_H__
