/*******************************************************************************
* Copyright 2018-2020 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*
* License:
* http://software.intel.com/en-us/articles/intel-sample-source-code-license-agr
* eement/
*******************************************************************************/

#ifndef PISIMPLEARITHM_TL_H__
#define PISIMPLEARITHM_TL_H__

#include "ippcore.h"
#include "owndefs_tl.h"
#include "ippcore_tl.h"
#include "ipps.h"
#include "ippi.h"
#include "ippdefs.h"
#include "ownisplit_tl.h"
#include "owni_tl.h"


#ifdef USE_OMP
#include <omp.h>
#endif

#ifdef USE_OMP
/* minimal number of addition operations for threading */
#define IPP64_MIN_ADD_2D        128*128
#elif defined(USE_TBB)
/* minimal number of addition operations for threading */
#define IPP64_MIN_ADD_2D        128*128
#else
/* threading is not applied */
#define IPP64_MIN_ADD_2D        IPP_MAX_32S
#endif

/* ////////////////////////////////// SA_8u ////////////////////////////////////////////// */

typedef struct _ippiSimpleArithmetics_8u_LT_Str
{
    Ipp8u* pSrc1; // const
    IppSizeL src1Step;
    Ipp8u* pSrc2; // const
    IppSizeL src2Step;
    Ipp8u* pDst;
    IppSizeL dstStep;
    IppiSizeL roiSize;
    int scaleFactor;
    IppiPointL splitImage;
    IppiSizeL  tileSize;
    IppiSizeL tailSize;
} ippiSimpleArithmetics_8u_LT_Str;

static void simpleArithmeticsThreadingStructureEncode_8u (
    Ipp8u* pSrc1,
    IppSizeL src1Step,
    Ipp8u* pSrc2,
    IppSizeL src2Step,
    Ipp8u* pDst,
    IppSizeL dstStep,
    IppiSizeL roiSize,
    int scaleFactor,
    IppiPointL splitImage,
    IppiSizeL  tileSize,
    IppiSizeL tailSize,
    ippiSimpleArithmetics_8u_LT_Str * ts
)
{
    ts->pSrc1 = pSrc1;
    ts->src1Step = src1Step;
    ts->pSrc2 = pSrc2;
    ts->src2Step = src2Step;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->roiSize = roiSize;
    ts->scaleFactor = scaleFactor;
    ts->splitImage = splitImage;
    ts->tileSize = tileSize;
    ts->tailSize = tailSize;
}

/* ////////////////////////////////// SA_16u ////////////////////////////////////////////// */

typedef struct _ippiSimpleArithmetics_16u_LT_Str
{
    Ipp16u* pSrc1; // const
    IppSizeL src1Step;
    Ipp16u* pSrc2; // const
    IppSizeL src2Step;
    Ipp16u* pDst;
    IppSizeL dstStep;
    IppiSizeL roiSize;
    int scaleFactor;
    IppiPointL splitImage;
    IppiSizeL  tileSize;
    IppiSizeL tailSize;
} ippiSimpleArithmetics_16u_LT_Str;

static void simpleArithmeticsThreadingStructureEncode_16u (
    Ipp16u* pSrc1,
    IppSizeL src1Step,
    Ipp16u* pSrc2,
    IppSizeL src2Step,
    Ipp16u* pDst,
    IppSizeL dstStep,
    IppiSizeL roiSize,
    int scaleFactor,
    IppiPointL splitImage,
    IppiSizeL  tileSize,
    IppiSizeL tailSize,
    ippiSimpleArithmetics_16u_LT_Str * ts
)
{
    ts->pSrc1 = pSrc1;
    ts->src1Step = src1Step;
    ts->pSrc2 = pSrc2;
    ts->src2Step = src2Step;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->roiSize = roiSize;
    ts->scaleFactor = scaleFactor;
    ts->splitImage = splitImage;
    ts->tileSize = tileSize;
    ts->tailSize = tailSize;
}

/* ////////////////////////////////// SA_16s ////////////////////////////////////////////// */

typedef struct _ippiSimpleArithmetics_16s_LT_Str
{
    Ipp16s* pSrc1; // const
    IppSizeL src1Step;
    Ipp16s* pSrc2; // const
    IppSizeL src2Step;
    Ipp16s* pDst;
    IppSizeL dstStep;
    IppiSizeL roiSize;
    int scaleFactor;
    IppiPointL splitImage;
    IppiSizeL  tileSize;
    IppiSizeL tailSize;
} ippiSimpleArithmetics_16s_LT_Str;

static void simpleArithmeticsThreadingStructureEncode_16s (
    Ipp16s* pSrc1,
    IppSizeL src1Step,
    Ipp16s* pSrc2,
    IppSizeL src2Step,
    Ipp16s* pDst,
    IppSizeL dstStep,
    IppiSizeL roiSize,
    int scaleFactor,
    IppiPointL splitImage,
    IppiSizeL  tileSize,
    IppiSizeL tailSize,
    ippiSimpleArithmetics_16s_LT_Str * ts
)
{
    ts->pSrc1 = pSrc1;
    ts->src1Step = src1Step;
    ts->pSrc2 = pSrc2;
    ts->src2Step = src2Step;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->roiSize = roiSize;
    ts->scaleFactor = scaleFactor;
    ts->splitImage = splitImage;
    ts->tileSize = tileSize;
    ts->tailSize = tailSize;
}

/* ////////////////////////////////// SA_32f ////////////////////////////////////////////// */

typedef struct _ippiSimpleArithmetics_32f_LT_Str
{
    Ipp32f* pSrc1; // const
    IppSizeL src1Step;
    Ipp32f* pSrc2; // const
    IppSizeL src2Step;
    Ipp32f* pDst;
    IppSizeL dstStep;
    IppiSizeL roiSize;
    IppiPointL splitImage;
    IppiSizeL  tileSize;
    IppiSizeL tailSize;
    IppSizeL nCh;
} ippiSimpleArithmetics_32f_LT_Str;

static void simpleArithmeticsThreadingStructureEncode_32f (
    Ipp32f* pSrc1,
    IppSizeL src1Step,
    Ipp32f* pSrc2,
    IppSizeL src2Step,
    Ipp32f* pDst,
    IppSizeL dstStep,
    IppiSizeL roiSize,
    IppiPointL splitImage,
    IppiSizeL  tileSize,
    IppiSizeL tailSize,
    IppSizeL nCh,
    ippiSimpleArithmetics_32f_LT_Str * ts
)
{
    ts->pSrc1 = pSrc1;
    ts->src1Step = src1Step;
    ts->pSrc2 = pSrc2;
    ts->src2Step = src2Step;
    ts->pDst = pDst;
    ts->dstStep = dstStep;
    ts->roiSize = roiSize;
    ts->splitImage = splitImage;
    ts->tileSize = tileSize;
    ts->tailSize = tailSize;
    ts->nCh = nCh;
}
#endif // PISIMPLEARITHM_TL_H__
