/*******************************************************************************
* Copyright 2015-2020 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
//   Description:
//       Intel(R) IPP Resize Functions Wrappers for Threading Layer redefinitions:
//       functions with Classic API call their _T versions
//
//   Content:
//
//
//
*/

#if defined( IPP_ENABLED_THREADING_LAYER_REDEFINITIONS )
    #error "This file is not intended to be compiled with -DIPP_ENABLED_THREADING_LAYER_REDEFINITIONS option. Use this option in your application instead."
#endif

#include "owndefs_tl.h"
#include "ippi_tl.h"

/* //////////////////////////////////////////////////////////// */

IPPFUN(IppStatus, ippiFilterBilateralInit_T_Proxy, (IppiFilterBilateralType filter, IppiSize dstRoiSize, int kernelWidthHeight, IppDataType dataType, int numChannels, IppiDistanceMethodType distMethod, Ipp64f valSquareSigma, Ipp64f posSquareSigma, IppiFilterBilateralSpec *pSpec))
{
    return ippiFilterBilateralInit_T(filter, dstRoiSize, kernelWidthHeight, dataType, numChannels, distMethod, valSquareSigma, posSquareSigma, (IppiFilterBilateralSpec_T*)pSpec);
}

#define ippiFilterBilateralC_T_Proxy(type, depth, chan)                                                                     \
IPPFUN(IppStatus, ippiFilterBilateral_##depth##_C##chan##R_T_Proxy, (                                                     \
    const type  *pSrc,                                                                                                    \
    int srcStep,                                                                                                          \
    type  *pDst,                                                                                                          \
    int dstStep,                                                                                                          \
    IppiSize dstRoiSize,                                                                                                  \
    IppiBorderType borderType,                                                                                            \
    const type  pBorderValue[chan],                                                                                       \
    const IppiFilterBilateralSpec *pSpec,                                                                                 \
    Ipp8u* pBuffer))                                                                                                      \
{                                                                                                                         \
    return ippiFilterBilateral_##depth##_C##chan##R_T(pSrc, srcStep, pDst, dstStep, dstRoiSize, borderType, pBorderValue, \
                                                      (IppiFilterBilateralSpec_T*)pSpec, pBuffer);                        \
}

ippiFilterBilateralC_T_Proxy(Ipp8u, 8u, 1)
ippiFilterBilateralC_T_Proxy(Ipp8u, 8u, 3)
ippiFilterBilateralC_T_Proxy(Ipp32f, 32f, 1)
ippiFilterBilateralC_T_Proxy(Ipp32f, 32f, 3)
ippiFilterBilateralC_T_Proxy(Ipp64f, 64f, 1)
ippiFilterBilateralC_T_Proxy(Ipp64f, 64f, 3)

#define ippiFilterBilateralP3_T_Proxy(type, depth)                                                                 \
IPPFUN(IppStatus, ippiFilterBilateral_##depth##_P3R_T_Proxy, (                                                     \
    const type  *pSrc[3],                                                                                          \
    int srcStep[3],                                                                                                \
    type  *pDst[3],                                                                                                \
    int dstStep[3],                                                                                                \
    IppiSize dstRoiSize,                                                                                           \
    IppiBorderType borderType,                                                                                     \
    const type  pBorderValue[3],                                                                                   \
    const IppiFilterBilateralSpec *pSpec,                                                                          \
    Ipp8u* pBuffer))                                                                                               \
{                                                                                                                  \
    return ippiFilterBilateral_##depth##_P3R_T(pSrc, srcStep, pDst, dstStep, dstRoiSize, borderType, pBorderValue, \
                                               (IppiFilterBilateralSpec_T*)pSpec, pBuffer);                        \
}

ippiFilterBilateralP3_T_Proxy(Ipp8u, 8u)
ippiFilterBilateralP3_T_Proxy(Ipp32f, 32f)
ippiFilterBilateralP3_T_Proxy(Ipp64f, 64f)

/* //////////////////////////////////////////////////////////// */
