/*******************************************************************************
* Copyright 2018-2020 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*
* License:
* http://software.intel.com/en-us/articles/intel-sample-source-code-license-agr
* eement/
*******************************************************************************/

#ifndef PRFILTERMED_T_H__
#define PRFILTERMED_T_H__

#include "ippcore.h"
#include "owndefs_tl.h"
#include "ippcore_tl.h"
#include "ipps.h"
#include "ippi.h"
#include "ippdefs.h"
#include "ownisplit_t.h"
#include "owni_tl.h"



#ifdef USE_OMP
#include <omp.h>
#endif

#define D_ALIGN 32

typedef struct
{
    IpprPoint  split;
    IpprVolume tileSize;
    IpprVolume lastTile;
    IppDataType dataType;
    Ipp32u      numChannels;
    int    bufsize;
    IpprVolume kernelVolume;
} FilterMedianInfo;

#define TILE_S (kernelVolume.depth + 1)

typedef struct _ipprFilterMedian_8u_T_Str
{
    const Ipp8u * pSrc; //const
    int srcPlaneStep;
    int srcStep;
    Ipp8u * pDst;
    int dstPlaneStep;
    int dstStep;
    IpprBorderType border;
    const Ipp8u * borderValue;
    IpprFilterMedianSpec * pSpec; //const
    Ipp8u * pBuffer;
    int bufSize;
    int numChannels;
    IpprPoint splitImage;
    IpprVolume pTileSize;
    IpprVolume pLastSize;
} ipprFilterMedian_8u_T_Str;
typedef struct _ipprFilterMedian_16u_T_Str
{
    const Ipp16u * pSrc; //const
    int srcPlaneStep;
    int srcStep;
    Ipp16u * pDst;
    int dstPlaneStep;
    int dstStep;
    IpprBorderType border;
    const Ipp16u * borderValue;
    IpprFilterMedianSpec * pSpec; //const
    Ipp8u * pBuffer;
    int bufSize;
    int numChannels;
    IpprPoint splitImage;
    IpprVolume pTileSize;
    IpprVolume pLastSize;
} ipprFilterMedian_16u_T_Str;
typedef struct _ipprFilterMedian_16s_T_Str
{
    const Ipp16s * pSrc; //const
    int srcPlaneStep;
    int srcStep;
    Ipp16s * pDst;
    int dstPlaneStep;
    int dstStep;
    IpprBorderType border;
    const Ipp16s * borderValue;
    IpprFilterMedianSpec * pSpec; //const
    Ipp8u * pBuffer;
    int bufSize;
    int numChannels;
    IpprPoint splitImage;
    IpprVolume pTileSize;
    IpprVolume pLastSize;
} ipprFilterMedian_16s_T_Str;
typedef struct _ipprFilterMedian_32f_T_Str
{
    const Ipp32f * pSrc; //const
    int srcPlaneStep;
    int srcStep;
    Ipp32f * pDst;
    int dstPlaneStep;
    int dstStep;
    IpprBorderType border;
    const Ipp32f * borderValue;
    IpprFilterMedianSpec * pSpec; //const
    Ipp8u * pBuffer;
    int bufSize;
    int numChannels;
    IpprPoint splitImage;
    IpprVolume pTileSize;
    IpprVolume pLastSize;
} ipprFilterMedian_32f_T_Str;
typedef struct _ipprFilterMedian_64f_T_Str
{
    const Ipp64f * pSrc; //const
    int srcPlaneStep;
    int srcStep;
    Ipp64f * pDst;
    int dstPlaneStep;
    int dstStep;
    IpprBorderType border;
    const Ipp64f * borderValue;
    IpprFilterMedianSpec * pSpec; //const
    Ipp8u * pBuffer;
    int bufSize;
    int numChannels;
    IpprPoint splitImage;
    IpprVolume pTileSize;
    IpprVolume pLastSize;
} ipprFilterMedian_64f_T_Str;

static void fMedThreadingStructureEncode_8u_T(
    const Ipp8u * pSrc,
    int srcPlaneStep,
    int srcStep,
    Ipp8u * pDst, 
    int dstPlaneStep,
    int dstStep,
    IpprBorderType border, 
    const Ipp8u * borderValue, 
    IpprFilterMedianSpec * pSpec,
    Ipp8u * pBuffer,
    int bufSize,
    int numChannels,
    IpprPoint splitImage,
    IpprVolume pTileSize, 
    IpprVolume pLastSize,   
    ipprFilterMedian_8u_T_Str * ts
)
{
    ts->pSrc = pSrc;
    ts->srcPlaneStep = srcPlaneStep;
    ts->srcStep = srcStep;
    ts->pDst = pDst;
    ts->dstPlaneStep = dstPlaneStep;
    ts->dstStep = dstStep;
    ts->border = border;
    ts->borderValue = borderValue;
    ts->pSpec = pSpec;
    ts->pBuffer = pBuffer;
    ts->bufSize = bufSize;
    ts->numChannels = numChannels;
    ts->splitImage = splitImage;
    ts->pTileSize = pTileSize;
    ts->pLastSize = pLastSize;
}
static void fMedThreadingStructureEncode_16u_T(
    const Ipp16u * pSrc,
    int srcPlaneStep,
    int srcStep,
    Ipp16u * pDst,
    int dstPlaneStep,
    int dstStep,
    IpprBorderType border,
    const Ipp16u * borderValue,
    IpprFilterMedianSpec * pSpec,
    Ipp8u * pBuffer,
    int bufSize,
    int numChannels,
    IpprPoint splitImage,
    IpprVolume pTileSize,
    IpprVolume pLastSize,
    ipprFilterMedian_16u_T_Str * ts
)
{
    ts->pSrc = pSrc;
    ts->srcPlaneStep = srcPlaneStep;
    ts->srcStep = srcStep;
    ts->pDst = pDst;
    ts->dstPlaneStep = dstPlaneStep;
    ts->dstStep = dstStep;
    ts->border = border;
    ts->borderValue = borderValue;
    ts->pSpec = pSpec;
    ts->pBuffer = pBuffer;
    ts->bufSize = bufSize;
    ts->numChannels = numChannels;
    ts->splitImage = splitImage;
    ts->pTileSize = pTileSize;
    ts->pLastSize = pLastSize;
}
static void fMedThreadingStructureEncode_16s_T(
    const Ipp16s * pSrc,
    int srcPlaneStep,
    int srcStep,
    Ipp16s * pDst,
    int dstPlaneStep,
    int dstStep,
    IpprBorderType border,
    const Ipp16s * borderValue,
    IpprFilterMedianSpec * pSpec,
    Ipp8u * pBuffer,
    int bufSize,
    int numChannels,
    IpprPoint splitImage,
    IpprVolume pTileSize,
    IpprVolume pLastSize,
    ipprFilterMedian_16s_T_Str * ts
)
{
    ts->pSrc = pSrc;
    ts->srcPlaneStep = srcPlaneStep;
    ts->srcStep = srcStep;
    ts->pDst = pDst;
    ts->dstPlaneStep = dstPlaneStep;
    ts->dstStep = dstStep;
    ts->border = border;
    ts->borderValue = borderValue;
    ts->pSpec = pSpec;
    ts->pBuffer = pBuffer;
    ts->bufSize = bufSize;
    ts->numChannels = numChannels;
    ts->splitImage = splitImage;
    ts->pTileSize = pTileSize;
    ts->pLastSize = pLastSize;
}
static void fMedThreadingStructureEncode_32f_T(
    const Ipp32f * pSrc,
    int srcPlaneStep,
    int srcStep,
    Ipp32f * pDst,
    int dstPlaneStep,
    int dstStep,
    IpprBorderType border,
    const Ipp32f * borderValue,
    IpprFilterMedianSpec * pSpec,
    Ipp8u * pBuffer,
    int bufSize,
    int numChannels,
    IpprPoint splitImage,
    IpprVolume pTileSize,
    IpprVolume pLastSize,
    ipprFilterMedian_32f_T_Str * ts
)
{
    ts->pSrc = pSrc;
    ts->srcPlaneStep = srcPlaneStep;
    ts->srcStep = srcStep;
    ts->pDst = pDst;
    ts->dstPlaneStep = dstPlaneStep;
    ts->dstStep = dstStep;
    ts->border = border;
    ts->borderValue = borderValue;
    ts->pSpec = pSpec;
    ts->pBuffer = pBuffer;
    ts->bufSize = bufSize;
    ts->numChannels = numChannels;
    ts->splitImage = splitImage;
    ts->pTileSize = pTileSize;
    ts->pLastSize = pLastSize;
}
static void fMedThreadingStructureEncode_64f_T(
    const Ipp64f * pSrc,
    int srcPlaneStep,
    int srcStep,
    Ipp64f * pDst,
    int dstPlaneStep,
    int dstStep,
    IpprBorderType border,
    const Ipp64f * borderValue,
    IpprFilterMedianSpec * pSpec,
    Ipp8u * pBuffer,
    int bufSize,
    int numChannels,
    IpprPoint splitImage,
    IpprVolume pTileSize,
    IpprVolume pLastSize,
    ipprFilterMedian_64f_T_Str * ts
)
{
    ts->pSrc = pSrc;
    ts->srcPlaneStep = srcPlaneStep;
    ts->srcStep = srcStep;
    ts->pDst = pDst;
    ts->dstPlaneStep = dstPlaneStep;
    ts->dstStep = dstStep;
    ts->border = border;
    ts->borderValue = borderValue;
    ts->pSpec = pSpec;
    ts->pBuffer = pBuffer;
    ts->bufSize = bufSize;
    ts->numChannels = numChannels;
    ts->splitImage = splitImage;
    ts->pTileSize = pTileSize;
    ts->pLastSize = pLastSize;
}
#endif // PRFILTERMED_T_H__
