/*******************************************************************************
* Copyright 2018-2020 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*
* License:
* http://software.intel.com/en-us/articles/intel-sample-source-code-license-agr
* eement/
*******************************************************************************/

#ifndef PISIMPLEARITHM_T_H__
#define PISIMPLEARITHM_T_H__

#include "ippcore.h"
#include "owndefs_tl.h"
#include "ippcore_tl.h"
#include "ipps.h"
#include "ippi.h"
#include "ippdefs.h"
#include "ownisplit_t.h"
#include "owni_tl.h"

#ifdef USE_OMP
#include <omp.h>
#endif

#ifdef USE_OMP
/* minimal number of addition operations for threading */
#define IPP64_MIN_ADD_2D        128*128
#elif defined(USE_TBB)
/* minimal number of addition operations for threading */
#define IPP64_MIN_ADD_2D        128*128
#else
/* threading is not applied */
#define IPP64_MIN_ADD_2D        IPP_MAX_32S
#endif

/* ////////////////////////////////// SA_16s ////////////////////////////////////////////// */

typedef struct _ippiSimpleArithmetics_16s_T_Str
{
    Ipp16s* pSrc1;
    int src1Step;
    Ipp16s* pSrc2;
    int src2Step;
    Ipp16s* pDst;
    int dstStep;
    IppiSize roiSize;
    int scaleFactor;
    IppiPoint splitImage;
    IppiSize  tileSize;
    IppiSize tailSize;
} ippiSimpleArithmetics_16s_T_Str;

static void simpleArithmeticsThreadingStructureEncode_16s (
    Ipp16s* pSrc1,
    int src1Step,
    Ipp16s* pSrc2,
    int src2Step,
    Ipp16s* pDst,
    int dstStep,
    IppiSize roiSize,
    int scaleFactor,
    IppiPoint splitImage,
    IppiSize  tileSize,
    IppiSize tailSize,
    ippiSimpleArithmetics_16s_T_Str * ts
)
{
    ts->pSrc1       = pSrc1;
    ts->src1Step    = src1Step;
    ts->pSrc2       = pSrc2;
    ts->src2Step    = src2Step;
    ts->pDst        = pDst;
    ts->dstStep     = dstStep;
    ts->roiSize     = roiSize;
    ts->scaleFactor = scaleFactor;
    ts->splitImage  = splitImage;
    ts->tileSize    = tileSize;
    ts->tailSize    = tailSize;
}

/* ////////////////////////////////// SA_32s ////////////////////////////////////////////// */

typedef struct _ippiSimpleArithmetics_32s_T_Str
{
	Ipp32s* pSrc1;
	int src1Step;
	Ipp32s* pSrc2;
	int src2Step;
	Ipp32s* pDst;
	int dstStep;
	IppiSize roiSize;
	int scaleFactor;
	IppiPoint splitImage;
	IppiSize  tileSize;
	IppiSize tailSize;
} ippiSimpleArithmetics_32s_T_Str;

static void simpleArithmeticsThreadingStructureEncode_32s(
	Ipp32s* pSrc1,
	int src1Step,
	Ipp32s* pSrc2,
	int src2Step,
	Ipp32s* pDst,
	int dstStep,
	IppiSize roiSize,
	int scaleFactor,
	IppiPoint splitImage,
	IppiSize  tileSize,
	IppiSize tailSize,
	ippiSimpleArithmetics_32s_T_Str * ts
	)
{
	ts->pSrc1 = pSrc1;
	ts->src1Step = src1Step;
	ts->pSrc2 = pSrc2;
	ts->src2Step = src2Step;
	ts->pDst = pDst;
	ts->dstStep = dstStep;
	ts->roiSize = roiSize;
	ts->scaleFactor = scaleFactor;
	ts->splitImage = splitImage;
	ts->tileSize = tileSize;
	ts->tailSize = tailSize;
}

/* ////////////////////////////////// SA_32s16s ////////////////////////////////////////////// */

typedef struct _ippiSimpleArithmetics_32s16s_T_Str
{
	Ipp32s* pSrc1;
	int src1Step;
	Ipp32s* pSrc2;
	int src2Step;
	Ipp16s* pDst;
	int dstStep;
	IppiSize roiSize;
	int scaleFactor;
	IppiPoint splitImage;
	IppiSize  tileSize;
	IppiSize tailSize;
} ippiSimpleArithmetics_32s16s_T_Str;

static void simpleArithmeticsThreadingStructureEncode_32s16s(
	Ipp32s* pSrc1,
	int src1Step,
	Ipp32s* pSrc2,
	int src2Step,
	Ipp16s* pDst,
	int dstStep,
	IppiSize roiSize,
	int scaleFactor,
	IppiPoint splitImage,
	IppiSize  tileSize,
	IppiSize tailSize,
	ippiSimpleArithmetics_32s16s_T_Str * ts
	)
{
	ts->pSrc1 = pSrc1;
	ts->src1Step = src1Step;
	ts->pSrc2 = pSrc2;
	ts->src2Step = src2Step;
	ts->pDst = pDst;
	ts->dstStep = dstStep;
	ts->roiSize = roiSize;
	ts->scaleFactor = scaleFactor;
	ts->splitImage = splitImage;
	ts->tileSize = tileSize;
	ts->tailSize = tailSize;
}

typedef struct _ippiSimpleArithmetics_16s32s_T_Str {
	const Ipp16s* pSrc1;
	const Ipp16s* pSrc2;
	Ipp32s* pDst;

	int scaleFactor;
	int src1Step;
	int src2Step;
	int dstStep;
	
	IppiPoint splitImage;
	IppiSize roiSize;

	IppiSize  tileSize;
	IppiSize tailSize;
}ippiSimpleArithmetics_16s32s_T_Str;

static void simpleArithmeticsThreadingStructureEncode_16s32s(
	const Ipp16s* pSrc1,
	int src1Step,
	const Ipp16s* pSrc2,
	int src2Step,
	Ipp32s* pDst,
	int dstStep,
	IppiSize roiSize,
	int scaleFactor,
	IppiPoint splitImage,
	IppiSize  tileSize,
	IppiSize tailSize,
	ippiSimpleArithmetics_16s32s_T_Str * ts
) {
	ts->pSrc1       = pSrc1;
	ts->pSrc2       = pSrc2;
	ts->pDst        = pDst;
	ts->src1Step    = src1Step;
	ts->src2Step    = src2Step;
	ts->dstStep     = dstStep;
	ts->scaleFactor = scaleFactor;
	ts->splitImage  = splitImage;
	ts->tailSize    = tailSize;
	ts->tileSize    = tileSize;
	ts->roiSize     = roiSize;
}

#endif // PISIMPLEARITHM_T_H__
