/*******************************************************************************
* Copyright 2015-2020 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
//   Description:
//       Intel(R) IPP Resize Functions Wrappers for Threading Layer redefinitions:
//       functions with _L API call their _LT versions
//
//   Content:
//
//
//
*/

#if defined( IPP_ENABLED_THREADING_LAYER_REDEFINITIONS )
    #error "This file is not intended to be compiled with -DIPP_ENABLED_THREADING_LAYER_REDEFINITIONS option. Use this option in your application instead."
#endif

#include "owndefs_tl.h"
#include "ippi_tl.h"

/* //////////////////////////////////////////////////////////// */

IPPFUN(IppStatus, ippiFilterBilateralBorderInit_LT_Proxy, (IppiFilterBilateralType filter, IppiSizeL dstRoiSize, int radius, IppDataType dataType, int numChannels, IppiDistanceMethodType distMethod, Ipp32f valSquareSigma, Ipp32f posSquareSigma, IppiFilterBilateralSpec *pSpec))
{
    return ippiFilterBilateralBorderInit_LT(filter, dstRoiSize, radius, dataType, numChannels, distMethod, valSquareSigma, posSquareSigma, (IppiFilterBilateralSpec_LT*)pSpec);
}

#define ippiFilterBilateralBorder_LT_Proxy(type, depth, chan)                                                                    \
IPPFUN(IppStatus, ippiFilterBilateralBorder_##depth##_C##chan##R_LT_Proxy, (                                                     \
    const type *pSrc,                                                                                                            \
    IppSizeL srcStep,                                                                                                            \
    type *pDst,                                                                                                                  \
    IppSizeL dstStep,                                                                                                            \
    IppiSizeL dstRoiSize,                                                                                                        \
    IppiBorderType borderType,                                                                                                   \
    type *pBorderValue,                                                                                                          \
    const IppiFilterBilateralSpec *pSpec,                                                                                        \
    Ipp8u* pBuffer))                                                                                                             \
{                                                                                                                                \
    return ippiFilterBilateralBorder_##depth##_C##chan##R_LT(pSrc, srcStep, pDst, dstStep, dstRoiSize, borderType, pBorderValue, \
                                                             (IppiFilterBilateralSpec_LT*)pSpec, pBuffer);                       \
}

ippiFilterBilateralBorder_LT_Proxy(Ipp8u, 8u, 1)
ippiFilterBilateralBorder_LT_Proxy(Ipp8u, 8u, 3)

/* //////////////////////////////////////////////////////////// */
