
%HSX_UCFilterAliases = 
(
   "CBoFilter0"     => "Cn_MSR_PMON_BOX_FILTER",
   "CBoFilter1"     => "Cn_MSR_PMON_BOX_FILTER1",
   "HA_AddrMatch0"  => "HAn_PCI_PMON_BOX_ADDRMATCH0",
   "HA_AddrMatch1"  => "HAn_PCI_PMON_BOX_ADDRMATCH1",
   "HA_OpcodeMatch" => "HAn_PCI_PMON_BOX_OPCODEMATCH",
   "IRPFilter"      => "IRP_PCI_PMON_BOX_FILTER",
   "PCUFilter"      => "PCU_MSR_PMON_BOX_FILTER",
   "QPIRxMask0"     => "Q_Py_PCI_RX_PMON_BOX_MASK0",
   "QPIRxMask1"     => "Q_Py_PCI_RX_PMON_BOX_MASK1",
   "QPIRxMatch0"    => "Q_Py_PCI_RX_PMON_BOX_MATCH0",
   "QPIRxMatch1"    => "Q_Py_PCI_RX_PMON_BOX_MATCH1",
   "QPITxMask0"     => "Q_Py_PCI_TX_PMON_BOX_MASK0",
   "QPITxMask1"     => "Q_Py_PCI_TX_PMON_BOX_MASK1",
   "QPITxMatch0"    => "Q_Py_PCI_TX_PMON_BOX_MATCH0",
   "QPITxMatch1"    => "Q_Py_PCI_TX_PMON_BOX_MATCH1",
   "UBoxFilter"     => "U_MSR_PMON_BOX_FILTER",
);





%HSX_UCDerivedList =
(
   "CBO Box Events" =>
   {
      "AVG_INGRESS_DEPTH" =>
      {
         Category => "INGRESS Events",
         Filter   => "",
         Desc     => "Average Ingress Depth",
         Defn     => "Average Depth of the Ingress Queue through the sample interval",
         Equation => "RxR_OCCUPANCY.IRQ  / SAMPLE_INTERVAL",
      },
      "AVG_INGRESS_LATENCY" =>
      {
         Category => "INGRESS Events",
         Filter   => "",
         Desc     => "Average Ingress Latency",
         Defn     => "Average Latency of Requests through the Ingress Queue in Uncore Clocks",
         Equation => "RxR_OCCUPANCY.IRQ / RxR_INSERTS.IRQ",
      },
      "AVG_INGRESS_LATENCY_WHEN_NE" =>
      {
         Category => "INGRESS Events",
         Filter   => "",
         Desc     => "Average Latency in Non-Empty Ingress",
         Defn     => "Average Latency of Requests through the Ingress Queue in Uncore Clocks when Ingress Queue has at least one entry",
         Equation => "RxR_OCCUPANCY.IRQ / COUNTER0_OCCUPANCY{edge_det,thresh=0x1}",
      },
      "AVG_TOR_DRDS_MISS_WHEN_NE" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20]",
         Desc     => "Average Data Read Misses in Non-Empty TOR",
         Defn     => "Average Number of Data Read Entries that Miss the LLC when the TOR is not empty.",
         Equation => "(TOR_OCCUPANCY.MISS_OPCODE / COUNTER0_OCCUPANCY{edge_det,thresh=0x1})) with:Cn_MSR_PMON_BOX_FILTER1.opc=0x182",
      },
      "AVG_TOR_DRDS_WHEN_NE" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20]",
         Desc     => "Average Data Reads in Non-Empty TOR",
         Defn     => "Average Number of Data Read Entries when the TOR is not empty.",
         Equation => "(TOR_OCCUPANCY.OPCODE / COUNTER0_OCCUPANCY{edge_det,thresh=0x1}) with:Cn_MSR_PMON_BOX_FILTER1.opc=0x182",
      },
      "AVG_TOR_DRD_HIT_LATENCY" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20]",
         Desc     => "Data Read Hit Latency through TOR",
         Defn     => "Average Latency of Data Reads through the TOR that hit the LLC",
         Equation => "((TOR_OCCUPANCY.OPCODE  - TOR_OCCUPANCY.MISS_OPCODE) / (TOR_INSERTS.OPCODE - TOR_INSERTS.MISS_OPCODE)) with:Cn_MSR_PMON_BOX_FILTER.opc=0x182",
      },
      "AVG_TOR_DRD_LATENCY" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20]",
         Desc     => "Data Read Latency through TOR",
         Defn     => "Average Latency of Data Read Entries making their way through the TOR",
         Equation => "(TOR_OCCUPANCY.OPCODE / TOR_INSERTS.OPCODE) with:Cn_MSR_PMON_BOX_FILTER1.opc=0x182",
      },
      "AVG_TOR_DRD_LOC_MISS_LATENCY" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20], CBoFilter1[15:0]",
         Desc     => "Data Read Local Miss Latency through TOR",
         Defn     => "Average Latency of Data Reads through the TOR that miss the LLC and were satsified by Local Memory",
         Equation => "(TOR_OCCUPANCY.MISS_OPCODE / TOR_INSERTS.MISS_OPCODE) with:Cn_MSR_PMON_BOX_FILTER1.{opc,nid}={0x182,my_node}",
      },
      "AVG_TOR_DRD_MISS_LATENCY" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20]",
         Desc     => "Data Read Miss Latency through TOR",
         Defn     => "Average Latency of Data Reads through the TOR that miss the LLC",
         Equation => "(TOR_OCCUPANCY.MISS_OPCODE / TOR_INSERTS.MISS_OPCODE) with:Cn_MSR_PMON_BOX_FILTER1.opc=0x182",
      },
      "AVG_TOR_DRD_REM_MISS_LATENCY" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20], CBoFilter1[15:0]",
         Desc     => "Data Read Remote Miss Latency through TOR",
         Defn     => "Average Latency of Data Reads through the TOR that miss the LLC and were satsified by a Remote cache or Remote Memory",
         Equation => "(TOR_OCCUPANCY.MISS_OPCODE / TOR_INSERTS.MISS_OPCODE) with:Cn_MSR_PMON_BOX_FILTER.{opc,nid}={0x182,other_nodes}",
      },
      "CYC_INGRESS_BLOCKED" =>
      {
         Category => "INGRESS Events",
         Filter   => "",
         Desc     => "Cycles Ingress Blocked",
         Defn     => "Cycles the Ingress Request Queue arbiter was Blocked",
         Equation => "RxR_EXT_STARVED.IRQ  / SAMPLE_INTERVAL",
      },
      "CYC_USED_DN" =>
      {
         Category => "RING Events",
         Filter   => "",
         Desc     => "Cycles Used Down and Even",
         Defn     => "Cycles Used in the Down direction, Even polarity",
         Equation => "RING_BL_USED.CCW / SAMPLE_INTERVAL",
      },
      "CYC_USED_UP" =>
      {
         Category => "RING Events",
         Filter   => "",
         Desc     => "Cycles Used Up and Even",
         Defn     => "Cycles Used in the Up direction, Even polarity",
         Equation => "RING_BL_USED.CW / SAMPLE_INTERVAL",
      },
      "FAST_STR_LLC_MISS" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20]",
         Desc     => "Fast String misses",
         Defn     => "Number of ItoM (fast string) operations that miss the LLC",
         Equation => "TOR_INSERTS.MISS_OPCODE with:Cn_MSR_PMON_BOX_FILTER1.opc=0x1C8
TOR_INSERTS.MISS_OPCODE with:{Cn_MSR_PMON_BOX_FILTER0.tid=0x3E, Cn_MSR_PMON_BOX_FILTER1.opc=0x1C8}",
      },
      "FAST_STR_LLC_REQ" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20]",
         Desc     => "Fast String operations",
         Defn     => "Number of ItoM (fast string) operations that reference the LLC",
         Equation => "TOR_INSERTS.OPCODE with:Cn_MSR_PMON_BOX_FILTER1.opc=0x1C8
TOR_INSERTS.OPCODE with:{Cn_MSR_PMON_BOX_FILTER0.tid=0x3E, Cn_MSR_PMON_BOX_FILTER1.opc=0x1C8}",
      },
      "INGRESS_REJ_V_INS" =>
      {
         Category => "INGRESS Events",
         Filter   => "",
         Desc     => "Ingress Rejects vs. Inserts",
         Defn     => "Ratio of Ingress Request Entries that were rejected vs. inserted",
         Equation => "RxR_INSERTS.IRQ_REJ  / RxR_INSERTS.IRQ",
      },
      "IO_READ_BW" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter0[5:0], CBoFilter1[28:20]",
         Desc     => "IO Read Bandwidth",
         Defn     => "IO Read Bandwidth in MB - Disk or Network Reads",
         Equation => "(TOR_INSERTS.OPCODE with:{Cn_MSR_PMON_BOX_FILTER0.tid=0x3E, Cn_MSR_PMON_BOX_FILTER1.opc=0x1C8} + TOR_INSERTS.OPCODE with:Cn_MSR_PMON_BOX_FILTER.opc=0x1E6) * 64 / 1000000",
      },
      "IO_WRITE_BW" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20]",
         Desc     => "IO Write Bandwidth",
         Defn     => "IO Write Bandwidth in MB - Disk or Network Writes",
         Equation => "(TOR_INSERTS.OPCODE with:Cn_MSR_PMON_BOX_FILTER1.opc=0x19E + TOR_INSERTS.OPCODE with:Cn_MSR_PMON_BOX_FILTER.opc=0x1E4) * 64 / 1000000",
      },
      "LLC_DRD_MISS_PCT" =>
      {
         Category => "CACHE Events",
         Filter   => "CBoFilter0[23:17]",
         Desc     => "LLC DRD Miss Ratio",
         Defn     => "LLC Data Read miss ratio",
         Equation => "LLC_LOOKUP.DATA_READ with:Cn_MSR_PMON_BOX_FILTER0.state=0x1 / LLC_LOOKUP.DATA_READ with:Cn_MSR_PMON_BOX_FILTER.state=0x3F",
      },
      "LLC_MPI" =>
      {
         Category => "CACHE Events",
         Filter   => "CBoFilter0[23:17]",
         Desc     => "LLC MPI",
         Defn     => "LLC Misses Per Instruction (code, read, RFO and prefetches)",
         Equation => "LLC_LOOKUP.ANY (Cn_MSR_PMON_BOX_FILTER0.state=0x1) / INST_RETIRED.ALL (on Core)",
      },
      "LLC_RFO_MISS_PCT" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20]",
         Desc     => "LLC RFO Miss Ratio",
         Defn     => "LLC RFO Miss Ratio",
         Equation => "(TOR_INSERTS.MISS_OPCODE / TOR_INSERTS.OPCODE) with:Cn_MSR_PMON_BOX_FILTER1.opc=0x180 - (TOR_INSERTS.MISS_OPCODE / TOR_INSERTS.OPCODE) with:{Cn_MSR_PMON_BOX_FILTER0.tid=0x3E,Cn_MSR_PMON_BOX_FILTER1.opc=0x180}",
      },
      "MEM_WB_BYTES" =>
      {
         Category => "CACHE Events",
         Filter   => "",
         Desc     => "Memory Writebacks",
         Defn     => "Data written back to memory in Number of Bytes",
         Equation => "LLC_VICTIMS.M_STATE * 64",
      },
      "MMIO_PARTIAL_READS_CPU" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20], CBoFilter1[30]",
         Desc     => "MMIO Partial Reads - CPU",
         Defn     => "Number of Partial MMIO Reads initiated by a Core",
         Equation => "TOR_INSERTS.OPCODE with:{Cn_MSR_PMON_BOX_FILTER0.nc=1, Cn_MSR_PMON_BOX_FILTER1.opc=0x187}",
      },
      "MMIO_WRITES_CPU" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20], CBoFilter1[30]",
         Desc     => "MMIO Writes - CPU",
         Defn     => "Number of MMIO Writes initiated by a Core",
         Equation => "TOR_INSERTS.OPCODE with:{Cn_MSR_PMON_BOX_FILTER0.nc=1, Cn_MSR_PMON_BOX_FILTER1.opc=0x18F}",
      },
      "PARTIAL_PCI_WRITES" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter0[5:0], CBoFilter1[28:20]",
         Desc     => "Partial PCI Writes",
         Defn     => "Number of partial PCI writes",
         Equation => "TOR_INSERTS.OPCODE with:{Cn_MSR_PMON_BOX_FILTER0.tid=0x3E,Cn_MSR_PMON_BOX_FILTER1.opc=0x180}",
      },
      "PCI_READS" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20]",
         Desc     => "PCI Reads",
         Defn     => "Number of PCI reads (full and partial)",
         Equation => "TOR_INSERTS.OPCODE with:Cn_MSR_PMON_BOX_FILTER1.opc=0x19E",
      },
      "PCI_WRITES" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter0[5:0], CBoFilter1[28:20]",
         Desc     => "PCI Writes",
         Defn     => "Number of PCI writes",
         Equation => "TOR_INSERTS.OPCODE with:{Cn_MSR_PMON_BOX_FILTER0.tid=0x3E,Cn_MSR_PMON_BOX_FILTER1.opc=0x1C8}",
      },
      "RING_THRU_DN_BYTES" =>
      {
         Category => "RING Events",
         Filter   => "",
         Desc     => "Ring Throughput Down and Even",
         Defn     => "Ring throughput in the Down direction, Even polarity in Bytes",
         Equation => "RING_BL_USED.CCW* 32",
      },
      "RING_THRU_UP_BYTES" =>
      {
         Category => "RING Events",
         Filter   => "",
         Desc     => "Ring Throughput Up and Even",
         Defn     => "Ring throughput in the Up direction, Even polarity in Bytes",
         Equation => "RING_BL_USED.CW * 32",
      },
      "STREAMED_FULL_STORES" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20]",
         Desc     => "Streaming Stores (Full Line)",
         Defn     => "Number of Streamed Store (of Full Cache Line) Transactions",
         Equation => "TOR_INSERTS.OPCODE with:Cn_MSR_PMON_BOX_FILTER1.opc=0x18C",
      },
      "STREAMED_PART_STORES" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20]",
         Desc     => "Streaming Stores (Partial Line)",
         Defn     => "Number of Streamed Store (of Partial Cache Line) Transactions",
         Equation => "TOR_INSERTS.OPCODE with:Cn_MSR_PMON_BOX_FILTER1.opc=0x18D",
      },
      "UC_READS" =>
      {
         Category => "TOR Events",
         Filter   => "CBoFilter1[28:20]",
         Desc     => "Uncacheable Reads",
         Defn     => "Uncachable Read Transactions",
         Equation => "TOR_INSERTS.MISS_OPCODE with:Cn_MSR_PMON_BOX_FILTER1.opc=0x187",
      },
   },
   "HA Box Events" =>
   {
      "HITME_INSERTS" =>
      {
         Category => "HitME Events",
         Filter   => "",
         Desc     => "",
         Defn     => "",
         Equation => "HITME_LOOKUP.ALLOCS - HITME_HIT.ALLOCS",
      },
      "HITME_INVAL" =>
      {
         Category => "HitME Events",
         Filter   => "",
         Desc     => "",
         Defn     => "",
         Equation => "HITME_HIT.INVALS",
      },
      "PCT_CYCLES_BL_FULL" =>
      {
         Category => "EGRESS Events",
         Filter   => "",
         Desc     => "Percent BL Egress Full",
         Defn     => "Percentage of time the BL Egress Queue is full",
         Equation => "TxR_BL_CYCLES_FULL.ALL / SAMPLE_INTERVAL",
      },
      "PCT_CYCLES_D2C_DISABLED" =>
      {
         Category => "DIRECT2CORE Events",
         Filter   => "",
         Desc     => "Percent D2C Disabled",
         Defn     => "Percentage of time that Direct2Core was disabled.",
         Equation => "DIRECT2CORE_CYCLES_DISABLED / SAMPLE_INTERVAL",
      },
      "PCT_RD_REQUESTS" =>
      {
         Category => "REQUESTS Events",
         Filter   => "",
         Desc     => "Percent Read Requests",
         Defn     => "Percentage of HA traffic that is from Read Requests",
         Equation => "REQUESTS.READS / (REQUESTS.READS + REQUESTS.WRITES)",
      },
      "PCT_WR_REQUESTS" =>
      {
         Category => "REQUESTS Events",
         Filter   => "",
         Desc     => "Percent Write Requests",
         Defn     => "Percentage of HA traffic that is from Write Requests",
         Equation => "REQUESTS.WRITES / (REQUESTS.READS + REQUESTS.WRITES)",
      },
   },
   "PCU Box Events" =>
   {
      "PCT_CYC_FREQ_OS_LTD" =>
      {
         Category => "FREQ_MAX_LIMIT Events",
         Filter   => "",
         Desc     => "Percent Frequency OS Limited",
         Defn     => "Percentage of Cycles the Max Frequency is limited by the OS",
         Equation => "FREQ_MAX_OS_CYCLES / CLOCKTICKS",
      },
      "PCT_CYC_FREQ_POWER_LTD" =>
      {
         Category => "FREQ_MAX_LIMIT Events",
         Filter   => "",
         Desc     => "Percent Frequency Power Limited",
         Defn     => "Percentage of Cycles the Max Frequency is limited by power",
         Equation => "FREQ_MAX_POWER_CYCLES / CLOCKTICKS",
      },
      "PCT_CYC_FREQ_THERMAL_LTD" =>
      {
         Category => "FREQ_MAX_LIMIT Events",
         Filter   => "",
         Desc     => "Percent Frequency Thermal Limited",
         Defn     => "Percentage of Cycles the Max Frequency is limited by thermal issues",
         Equation => "FREQ_MAX_LIMIT_THERMAL_CYCLES / CLOCKTICKS",
      },
   },
   "QPI LL Box Events" =>
   {
      "DATA_FROM_QPI" =>
      {
         Category => "CTO Events",
         Filter   => "",
         Desc     => "Data From QPI",
         Defn     => "Data received from QPI in bytes  ( = DRS + NCB Data messages received from QPI)",
         Equation => "DRS_DATA_MSGS_FROM_QPI + NCB_DATA_MSGS_FROM_QPI",
      },
      "DATA_FROM_QPI_TO_HA_OR_IIO" =>
      {
         Category => "DIRECT2CORE Events",
         Filter   => "",
         Desc     => "Data From QPI To HA or IIO",
         Defn     => "Data received from QPI forwarded to HA or IIO.  Expressed in Bytes",
         Equation => "DATA_FROM_QPI - DATA_FROM_QPI_TO_LLC",
      },
      "DATA_FROM_QPI_TO_LLC" =>
      {
         Category => "DIRECT2CORE Events",
         Filter   => "",
         Desc     => "Data From QPI To LLC",
         Defn     => "Data received from QPI forwarded to LLC.  Expressed in Bytes",
         Equation => "DIRECT2CORE.SUCCESS_RBT_HIT * 64",
      },
      "DATA_FROM_QPI_TO_NODEx" =>
      {
         Category => "CTO Events",
         Filter   => "",
         Desc     => "Data From QPI To Node x",
         Defn     => "Data packets received from QPI sent to Node ID 'x'.  Expressed in bytes",
         Equation => "DRS_DataC_FROM_QPI_TO_NODEx + DRS_WRITE_FROM_QPI_TO_NODEx + NCB_DATA_FROM_QPI_TO_NODEx",
      },
      "DRS_DATA_MSGS_FROM_QPI" =>
      {
         Category => "FLITS_RX Events",
         Filter   => "",
         Desc     => "DRS Data Messges From QPI",
         Defn     => "DRS Data Messges From QPI in bytes",
         Equation => "(RxL_FLITS_G1.DRS_DATA * 8)",
      },
      "DRS_DataC_FROM_QPI_TO_NODEx" =>
      {
         Category => "CTO Events",
         Filter   => "QPIRxMask0[17:0],QPIRxMatch0[17:0];QPITxMask0[17:0],QPITxMatch0[17:0]",
         Desc     => "DRS DataC From QPI To Node x",
         Defn     => "DRS DataC packets received from QPI sent to Node ID 'x'.  Expressed in bytes",
         Equation => "(CTO_COUNT with:{Q_Py_PCI_PMON_PKT_z_MATCH0{[12:0],dnid}={0x1C00,x} Q_Py_PCI_PMON_PKT_z_MASK0[17:0]=0x3FF80) * 64",
      },
      "DRS_DataC_M_FROM_QPI" =>
      {
         Category => "CTO Events",
         Filter   => "QPIMask0[17:0],QPIMatch0[17:0],QPIMask1[19:16],QPIMatch1[19:16]",
         Desc     => "DRS DataC_Ms From QPI",
         Defn     => "DRS DataC_M packets received from QPI.  Expressed in bytes",
         Equation => "(CTO_COUNT  with:{Q_Py_PCI_PMON_PKT_z_MATCH0[12:0]=0x1C00, Q_Py_PCI_PMON_PKT_z_MASK0[12:0]=0x1FE0}, Q_Py_PCI_PMON_PKT_z_MATCH1[19:16]=0x8, Q_Py_PCI_PMON_PKT_z_MASK1[19:16]=0xF }) * 64",
      },
      "DRS_DataC_M_FROM_QPI" =>
      {
         Category => "CTO Events",
         Filter   => "QPIMask0[17:0],QPIMatch0[17:0],QPIMask1[19:16],QPIMatch1[19:16]",
         Desc     => "DRS DataC_Fs From QPI",
         Defn     => "DRS DataC_F packets received from QPI.  Expressed in bytes",
         Equation => "(CTO_COUNT  with:{Q_Py_PCI_PMON_PKT_z_MATCH0[12:0]=0x1C00, Q_Py_PCI_PMON_PKT_z_MASK0[12:0]=0x1FE0}, Q_Py_PCI_PMON_PKT_z_MATCH1[19:16]=0x1, Q_Py_PCI_PMON_PKT_z_MASK1[19:16]=0xF }) * 64",
      },
      "DRS_FULL_CACHELINE_MSGS_FROM_QPI" =>
      {
         Category => "CTO Events",
         Filter   => "QPIRxMask0[12:0],QPIRxMatch0[12:0];QPITxMask0[12:0],QPITxMatch0[12:0]",
         Desc     => "DRS Full Cacheline Data Messges From QPI",
         Defn     => "DRS Full Cacheline Data Messges From QPI in bytes",
         Equation => "(CTO_COUNT with:{Q_Py_PCI_PMON_PKT_z_MATCH0[12:0]=0x1C00,Q_Py_PCI_PMON_PKT_z_MASK0[12:0]=0x1F00}) * 64)",
      },
      "DRS_F_OR_E_FROM_QPI" =>
      {
         Category => "CTO Events",
         Filter   => "QPIRxMask0[12:0],QPIRxMatch0[12:0],QPIRxMask1[19:16],QPIRxMatch1[19:16];QPITxMask0[12:0],QPITxMatch0[12:0],QPITxMask1[19:16],QPITxMatch1[19:16]",
         Desc     => "DRS Data in F or E From QPI",
         Defn     => "DRS response in F or E states received from QPI in bytes.  To calculate the total data response for each cache line state, it's necessary to add the contribution from three flavors {DataC, DataC_FrcAckCnflt, DataC_Cmp} of data response packets for each cache line state.",
         Equation => "((CTO_COUNT with:{Q_Py_PCI_PMON_PKT_z_MATCH0[12:0]=0x1C00, Q_Py_PCI_PMON_PKT_z_MASK0[12:0]=0x1FE0, Q_Py_PCI_PMON_PKT_z_MATCH1[19:16]=0x4, Q_Py_PCI_PMON_PKT_z_MASK1[19:16]=0xF }) + (CTO_COUNT  with:{Q_Py_PCI_PMON_PKT_z_MATCH0[12:0]=0x1C00, Q_Py_PCI_PMON_PKT_z_MASK0[12:0]=0x1FE0, Q_Py_PCI_PMON_PKT_z_MATCH1[19:16]=0x1, Q_Py_PCI_PMON_PKT_z_MASK1[19:16]=0xF }) + (CTO_COUNT  with:{Q_Py_PCI_PMON_PKT_z_MATCH0[12:0]=0x1C40, Q_Py_PCI_PMON_PKT_z_MASK0[12:0]=0x1FE0, Q_Py_PCI_PMON_PKT_z_MATCH1[19:16]=0x4, Q_Py_PCI_PMON_PKT_z_MASK1[19:16]=0xF }) + (CTO_COUNT  with:{Q_Py_PCI_PMON_PKT_z_MATCH0[12:0]=0x1C40, Q_Py_PCI_PMON_PKT_z_MASK0[12:0]=0x1FE0, Q_Py_PCI_PMON_PKT_z_MATCH1[19:16]=0x1, Q_Py_PCI_PMON_PKT_z_MASK1[19:16]=0xF })  + (CTO_COUNT  with:{Q_Py_PCI_PMON_PKT_z_MATCH0[12:0]=0x1C20, Q_Py_PCI_PMON_PKT_z_MASK0[12:0]=0x1FE0, Q_Py_PCI_PMON_PKT_z_MATCH1[19:16]=0x4, Q_Py_PCI_PMON_PKT_z_MASK1[19:16]=0xF }) + (CTO_COUNT  with:{Q_Py_PCI_PMON_PKT_z_MATCH0[12:0]=0x1C20, Q_Py_PCI_PMON_PKT_z_MASK0[12:0]=0x1FE0, Q_Py_PCI_PMON_PKT_z_MATCH1[19:16]=0x1, Q_Py_PCI_PMON_PKT_z_MASK1[19:16]=0xF })) * 64",
      },
      "DRS_M_FROM_QPI" =>
      {
         Category => "CTO Events",
         Filter   => "QPIRxMask0[12:0],QPIRxMatch0[12:0],QPIRxMask1[19:16],QPIRxMatch1[19:16];QPITxMask0[12:0],QPITxMatch0[12:0],QPITxMask1[19:16],QPITxMatch1[19:16]",
         Desc     => "DRS Data in M From QPI",
         Defn     => "DRS response in M state received from QPI in bytes",
         Equation => "(CTO_COUNT  with:{Q_Py_PCI_PMON_PKT_z_MATCH0[12:0]=0x1C00, Q_Py_PCI_PMON_PKT_z_MASK0[12:0]=0x1FE0, Q_Py_PCI_PMON_PKT_z_MATCH1[19:16]=0x8, Q_Py_PCI_PMON_PKT_z_MASK1[19:16]=0xF }) * 64",
      },
      "DRS_PTL_CACHELINE_MSGS_FROM_QPI" =>
      {
         Category => "CTO Events",
         Filter   => "QPIRxMask0[12:0],QPIRxMatch0[12:0];QPITxMask0[12:0],QPITxMatch0[12:0]",
         Desc     => "DRS Partial Cacheline Data Messges From QPI",
         Defn     => "DRS Partial Cacheline Data Messges From QPI in bytes",
         Equation => "(CTO_COUNT with:{Q_Py_PCI_PMON_PKT_z_MATCH0[12:0]=0x1D00, Q_Py_PCI_PMON_PKT_z_MASK0[12:0]=0x1F00}) * 64",
      },
      "DRS_WB_FROM_QPI" =>
      {
         Category => "CTO Events",
         Filter   => "",
         Desc     => "DRS Writeback From QPI",
         Defn     => "DRS writeback packets received from QPI in bytes.  This is the sum of Wb{I,S,E} DRS packets",
         Equation => "DRS_WbI_FROM_QPI + DRS_WbS_FROM_QPI + DRS_WbE_FROM_QPI",
      },
      "DRS_WRITE_FROM_QPI_TO_NODEx" =>
      {
         Category => "CTO Events",
         Filter   => "QPIRxMask0[17:0],QPIRxMatch0[17:0];QPITxMask0[17:0],QPITxMatch0[17:0]",
         Desc     => "DRS Data From QPI To Node x",
         Defn     => "DRS Data packets (Any  - DataC) received from QPI sent to Node ID 'x'.  Expressed in bytes",
         Equation => "((CTO_COUNT with:{Q_Py_PCI_PMON_PKT_z_MATCH0{[12:0],dnid}={0x1C00,x} Q_Py_PCI_PMON_PKT_z_MASK0[17:0]=0x3FE00) - (CTO_COUNT  with:{Q_Py_PCI_PMON_PKT_z_MATCH0{[12:0],dnid}={0x1C00,x} Q_Py_PCI_PMON_PKT_z_MASK0[17:0]=0x3FF80)) * 64",
      },
      "DRS_WbE_FROM_QPI" =>
      {
         Category => "CTO Events",
         Filter   => "QPIRxMask0[12:0],QPIRxMatch0[12:0];QPITxMask0[12:0],QPITxMatch0[12:0]",
         Desc     => "DRS WbE From QPI",
         Defn     => "DRS writeback 'change to E state' packets received from QPI in bytes",
         Equation => "(CTO_COUNT with:{Q_Py_PCI_PMON_PKT_z_MATCH0[12:0]=0x1CC0, Q_Py_PCI_PMON_PKT_z_MASK0[12:0]=0x1FE0) * 64",
      },
      "DRS_WbI_FROM_QPI" =>
      {
         Category => "CTO Events",
         Filter   => "QPIRxMask0[12:0],QPIRxMatch0[12:0];QPITxMask0[12:0],QPITxMatch0[12:0]",
         Desc     => "DRS WbI From QPI",
         Defn     => "DRS writeback 'change to I state' packets received from QPI in bytes",
         Equation => "(CTO_COUNT with:{Q_Py_PCI_PMON_PKT_z_MATCH0[12:0]=0x1C80, Q_Py_PCI_PMON_PKT_z_MASK0[12:0]=0x1FE0) * 64",
      },
      "DRS_WbS_FROM_QPI" =>
      {
         Category => "CTO Events",
         Filter   => "QPIRxMask0[12:0],QPIRxMatch0[12:0];QPITxMask0[12:0],QPITxMatch0[12:0]",
         Desc     => "DRS WbSFrom QPI",
         Defn     => "DRS writeback 'change to S state' packets received from QPI in bytes",
         Equation => "(CTO_COUNT with:{Q_Py_PCI_PMON_PKT_z_MATCH0[12:0]=0x1CA0, Q_Py_PCI_PMON_PKT_z_MASK0[12:0]=0x1FE0) * 64",
      },
      "NCB_DATA_FROM_QPI_TO_NODEx" =>
      {
         Category => "CTO Events",
         Filter   => "QPIRxMask0[17:0],QPIRxMatch0[17:0];QPITxMask0[17:0],QPITxMatch0[17:0]",
         Desc     => "NCB Data From QPI To Node x",
         Defn     => "NCB Data packets (Any - Interrupts) received from QPI sent to Node ID 'x'.  Expressed in bytes",
         Equation => "((CTO_COUNT with:{Q_Py_PCI_PMON_PKT_z_MATCH0{[12:0],dnid}={0x1800,x} Q_Py_PCI_PMON_PKT_z_MASK0[17:0]=0x3FE00) - (CTO_COUNT  with:{Q_Py_PCI_PMON_PKT_z_MATCH0{[12:0],dnid}={0x1900,x} Q_Py_PCI_PMON_PKT_z_MASK0[17:0]=0x3FF80)) * 64",
      },
      "NCB_DATA_MSGS_FROM_QPI" =>
      {
         Category => "FLITS_RX Events",
         Filter   => "",
         Desc     => "NCB Data Messages From QPI",
         Defn     => "NCB Data Messages From QPI in bytes",
         Equation => "(RxL_FLITS_G2.NCB_DATA * 8)",
      },
      "PCT_LINK_FULL_POWER_CYCLES" =>
      {
         Category => "POWER_RX Events",
         Filter   => "",
         Desc     => "Percent Link Full Power Cycles",
         Defn     => "Percent of Cycles the QPI link is at Full Power",
         Equation => "RxL0_POWER_CYCLES / CLOCKTICKS",
      },
      "PCT_LINK_HALF_DISABLED_CYCLES" =>
      {
         Category => "POWER_RX Events",
         Filter   => "",
         Desc     => "Percent Link Half Disabled Cycles",
         Defn     => "Percent of Cycles the QPI link in power mode where half of the lanes are disabled.",
         Equation => "RxL0P_POWER_CYCLES / CLOCKTICKS",
      },
      "PCT_LINK_SHUTDOWN_CYCLES" =>
      {
         Category => "POWER Events",
         Filter   => "",
         Desc     => "Percent Link Shutdown Cycles",
         Defn     => "Percent of Cycles the QPI link is Shutdown",
         Equation => "L1_POWER_CYCLES / CLOCKTICKS",
      },
      "QPI_DATA_BW" =>
      {
         Category => "FLITS_TX Events",
         Filter   => "",
         Desc     => "QPI Data Bandwidth",
         Defn     => "QPI data transmit bandwidth in Bytes",
         Equation => "TxL_FLITS_G0.DATA * 8",
      },
      "QPI_LINK_BW" =>
      {
         Category => "FLITS_TX Events",
         Filter   => "",
         Desc     => "QPI Link Bandwidth",
         Defn     => "QPI total transmit bandwidth in Bytes (includes control)",
         Equation => "(TxL_FLITS_G0.DATA + TxL_FLITS_G0.NON_DATA) * 8",
      },
      "QPI_LINK_UTIL" =>
      {
         Category => "FLITS_TX Events",
         Filter   => "",
         Desc     => "QPI Link Bandwidth",
         Defn     => "QPI total transmit bandwidth in Bytes (includes control)",
         Equation => "(TxL_FLITS_G0.DATA + TxL_FLITS_G0.NON_DATA) / (2 * CLOCKTICKS)",
      },
      "QPI_SPEED" =>
      {
         Category => "CFCLK Events",
         Filter   => "",
         Desc     => "QPI Speed",
         Defn     => "QPI Speed - In GT/s (GigaTransfers / Second) - Max  QPI Bandwidth is 2 * ROUND ( QPI Speed , 0)",
         Equation => "ROUND (( CLOCKTICKS / TSC ) * TSC_SPEED, 0 ) * ( 8 / 1000)",
      },
   },
   "R2PCIe Box Events" =>
   {
      "CYC_USED_DN" =>
      {
         Category => "RING Events",
         Filter   => "",
         Desc     => "Cycles Used Down and Even",
         Defn     => "Cycles Used in the Down direction, Even polarity",
         Equation => "RING_BL_USED.CCW / SAMPLE_INTERVAL",
      },
      "CYC_USED_UP" =>
      {
         Category => "RING Events",
         Filter   => "",
         Desc     => "Cycles Used Up and Even",
         Defn     => "Cycles Used in the Up direction, Even polarity",
         Equation => "RING_BL_USED.CW / SAMPLE_INTERVAL",
      },
      "RING_THRU_DN_BYTES" =>
      {
         Category => "RING Events",
         Filter   => "",
         Desc     => "Ring Throughput Down and Even",
         Defn     => "Ring throughput in the Down direction, Even polarity in Bytes",
         Equation => "RING_BL_USED.CCW* 32",
      },
      "RING_THRU_UP_BYTES" =>
      {
         Category => "RING Events",
         Filter   => "",
         Desc     => "Ring Throughput Up and Even",
         Defn     => "Ring throughput in the Up direction, Even polarity in Bytes",
         Equation => "RING_BL_USED.CW * 32",
      },
   },
   "R3QPI Box Events" =>
   {
   },
   "SBO Box Events" =>
   {
      "CYC_USED_DN" =>
      {
         Category => "RING Events",
         Filter   => "",
         Desc     => "Cycles Used Down and Even",
         Defn     => "Cycles Used in the Down direction, Even polarity",
         Equation => "RING_BL_USED.CCW / SAMPLE_INTERVAL",
      },
      "CYC_USED_UP" =>
      {
         Category => "RING Events",
         Filter   => "",
         Desc     => "Cycles Used Up and Even",
         Defn     => "Cycles Used in the Up direction, Even polarity",
         Equation => "RING_BL_USED.CW / SAMPLE_INTERVAL",
      },
      "RING_THRU_DN_BYTES" =>
      {
         Category => "RING Events",
         Filter   => "",
         Desc     => "Ring Throughput Down and Even",
         Defn     => "Ring throughput in the Down direction, Even polarity in Bytes",
         Equation => "RING_BL_USED.CCW* 32",
      },
      "RING_THRU_UP_BYTES" =>
      {
         Category => "RING Events",
         Filter   => "",
         Desc     => "Ring Throughput Up and Even",
         Defn     => "Ring throughput in the Up direction, Even polarity in Bytes",
         Equation => "RING_BL_USED.CW * 32",
      },
   },
   "iMC Box Events" =>
   {
      "MEM_BW_READS" =>
      {
         Category => "CAS Events",
         Filter   => "",
         Desc     => "Read Memory Bandwidth",
         Defn     => "Memory bandwidth consumed by reads.  Expressed in bytes.",
         Equation => "(CAS_COUNT.RD * 64)",
      },
      "MEM_BW_TOTAL" =>
      {
         Category => "CAS Events",
         Filter   => "",
         Desc     => "Total Memory Bandwidth",
         Defn     => "Total memory bandwidth.  Expressed in bytes.",
         Equation => "MEM_BW_READS + MEM_BW_WRITES",
      },
      "MEM_BW_WRITES" =>
      {
         Category => "CAS Events",
         Filter   => "",
         Desc     => "Write Memory Bandwidth",
         Defn     => "Memory bandwidth consumed by writes  Expressed in bytes.",
         Equation => "(CAS_COUNT.WR * 64)",
      },
      "PCT_CYCLES_CRITICAL_THROTTLE" =>
      {
         Category => "POWER Events",
         Filter   => "",
         Desc     => "Percent Cycles Critical Throttle",
         Defn     => "The percentage of cycles all DRAM ranks in critical thermal throttling",
         Equation => "POWER_CRITICAL_THROTTLE_CYCLES / MC_Chy_PCI_PMON_CTR_FIXED",
      },
      "PCT_CYCLES_DLLOFF" =>
      {
         Category => "POWER Events",
         Filter   => "",
         Desc     => "Percent Cycles DLOFF",
         Defn     => "The percentage of cycles all DRAM ranks in CKE slow (DLOFF) mode",
         Equation => "POWER_CHANNEL_DLLOFF / MC_Chy_PCI_PMON_CTR_FIXED",
      },
      "PCT_CYCLES_DRAM_RANKx_IN_CKE" =>
      {
         Category => "POWER Events",
         Filter   => "",
         Desc     => "Percent Cycles DRAM Rank x in CKE",
         Defn     => "The percentage of cycles DRAM rank (x) spent in CKE ON mode.",
         Equation => "POWER_CKE_CYCLES.RANKx / MC_Chy_PCI_PMON_CTR_FIXED",
      },
      "PCT_CYCLES_DRAM_RANKx_IN_THR" =>
      {
         Category => "POWER Events",
         Filter   => "",
         Desc     => "Percent Cycles DRAM Rank x in CKE",
         Defn     => "The percentage of cycles DRAM rank (x) spent in thermal throttling.",
         Equation => "POWER_THROTTLE_CYCLES.RANKx / MC_Chy_PCI_PMON_CTR_FIXED",
      },
      "PCT_CYCLES_PPD" =>
      {
         Category => "POWER Events",
         Filter   => "",
         Desc     => "Percent Cycles PPD",
         Defn     => "The percentage of cycles all DRAM ranks in PPD mode",
         Equation => "POWER_CHANNEL_PPD / MC_Chy_PCI_PMON_CTR_FIXED",
      },
      "PCT_CYCLES_SELF_REFRESH" =>
      {
         Category => "POWER Events",
         Filter   => "",
         Desc     => "Percent Cycles Self Refresh",
         Defn     => "The percentage of cycles Memory is in self refresh power mode",
         Equation => "POWER_SELF_REFRESH / MC_Chy_PCI_PMON_CTR_FIXED",
      },
      "PCT_REQUESTS_PAGE_EMPTY" =>
      {
         Category => "CAS Events",
         Filter   => "",
         Desc     => "Percent Requests Page Empty",
         Defn     => "Percentage of memory requests that resulted in Page Empty",
         Equation => "(ACT_COUNT - PRE_COUNT.PAGE_MISS)/ (CAS_COUNT.RD + CAS_COUNT.WR)",
      },
      "PCT_REQUESTS_PAGE_HIT" =>
      {
         Category => "CAS Events",
         Filter   => "",
         Desc     => "Percent Requests Page Hit",
         Defn     => "Percentage of memory requests that resulted in Page Hits",
         Equation => "1 - (PCT_REQUESTS_PAGE_EMPTY + PCT_REQUESTS_PAGE_MISS)",
      },
      "PCT_REQUESTS_PAGE_MISS" =>
      {
         Category => "CAS Events",
         Filter   => "",
         Desc     => "Percent Requests Page Miss",
         Defn     => "Percentage of memory requests that resulted in Page Misses",
         Equation => "PRE_COUNT.PAGE_MISS / (CAS_COUNT.RD + CAS_COUNT.WR)",
      },
   },
);
