
%BDX_UCFilterAliases = 
(
   "CBoFilter0"     => "Cn_MSR_PMON_BOX_FILTER",
   "CBoFilter1"     => "Cn_MSR_PMON_BOX_FILTER1",
   "HA_AddrMatch0"  => "HAn_PCI_PMON_BOX_ADDRMATCH0",
   "HA_AddrMatch1"  => "HAn_PCI_PMON_BOX_ADDRMATCH1",
   "HA_OpcodeMatch" => "HAn_PCI_PMON_BOX_OPCODEMATCH",
   "IRPFilter"      => "IRP_PCI_PMON_BOX_FILTER",
   "PCUFilter"      => "PCU_MSR_PMON_BOX_FILTER",
   "QPIRxMask0"     => "Q_Py_PCI_RX_PMON_BOX_MASK0",
   "QPIRxMask1"     => "Q_Py_PCI_RX_PMON_BOX_MASK1",
   "QPIRxMatch0"    => "Q_Py_PCI_RX_PMON_BOX_MATCH0",
   "QPIRxMatch1"    => "Q_Py_PCI_RX_PMON_BOX_MATCH1",
   "QPITxMask0"     => "Q_Py_PCI_TX_PMON_BOX_MASK0",
   "QPITxMask1"     => "Q_Py_PCI_TX_PMON_BOX_MASK1",
   "QPITxMatch0"    => "Q_Py_PCI_TX_PMON_BOX_MATCH0",
   "QPITxMatch1"    => "Q_Py_PCI_TX_PMON_BOX_MATCH1",
   "UBoxFilter"     => "U_MSR_PMON_BOX_FILTER",
);


%BDX_UCEventList =
(
   "CBO Box Events" =>
   {
      "BOUNCE_CONTROL" =>
      {
         Box       => "CBO Box Events",
         Category  => "RING Events",
         EvSel     => 0x0A,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Bounce Control",
         Defn      => "",
      },
      "CLOCKTICKS" =>
      {
         Box       => "CBO Box Events",
         Category  => "UCLK Events",
         EvSel     => 0x00,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Uncore Clocks",
         Defn      => "",
      },
      "COUNTER0_OCCUPANCY" =>
      {
         Box       => "CBO Box Events",
         Category  => "OCCUPANCY Events",
         EvSel     => 0x1F,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 20,
         Desc      => "Counter 0 Occupancy",
         Defn      => "Since occupancy counts can only be captured in the Cbo's 0 counter, this event allows a user to capture occupancy related information by filtering the Cb0 occupancy count captured in Counter 0.   The filtering available is found in the control register - threshold, invert and edge detect.   E.g. setting threshold to 1 can effectively monitor how many cycles the monitored queue has an entry.",
      },
      "FAST_ASSERTED" =>
      {
         Box       => "CBO Box Events",
         Category  => "EGRESS Events",
         EvSel     => 0x09,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "FaST wire asserted",
         Defn      => "Counts the number of cycles either the local distress or incoming distress signals are asserted.  Incoming distress includes both up and dn.",
      },
      "LLC_LOOKUP" =>
      {
         Box       => "CBO Box Events",
         Category  => "CACHE Events",
         EvSel     => 0x34,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Cache Lookups",
         Defn      => "Counts the number of times the LLC was accessed - this includes code, data, prefetches and hints coming from L2.  This has numerous filters available.  Note the non-standard filtering equation.  This event will count requests that lookup the cache multiple times with multiple increments.  One must ALWAYS set umask bit 0 and select a state or states to match.  Otherwise, the event will count nothing.   CBoGlCtrl[22:18] bits correspond to [FMESI] state.",
         Notes     => "Bit 0 of the umask must always be set for this event.  This allows us to match a given state (or states).  The state is programmed in Cn_MSR_PMON_BOX_FILTER.state.   The state field is a bit mask, so you can select (and monitor) multiple states at a time.  0 = I (miss), 1 = S, 2 = E, 3 = M, 4 = F.  For example, if you wanted to monitor F and S hits, you could set 10010b in the 5-bit state field.   To monitor any lookup, set the field to 0x1F.",
         Subevents =>
         {
            "DATA_READ" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "CBoFilter0[23:17]",
               Desc      => "Data Read Request",
               Defn      => "Read transactions",
            },
            "WRITE" =>
            {
               Umask     => "b00000101",
               Counters  => "",
               Filter    => "CBoFilter0[23:17]",
               Desc      => "Write Requests",
               Defn      => "Writeback transactions from L2 to the LLC  This includes all write transactions -- both Cachable and UC.",
            },
            "REMOTE_SNOOP" =>
            {
               Umask     => "b00001001",
               Counters  => "",
               Filter    => "CBoFilter0[23:17]",
               Desc      => "External Snoop Request",
               Defn      => "Filters for only snoop requests coming from the remote socket(s) through the IPQ.",
            },
            "ANY" =>
            {
               Umask     => "b00010001",
               Counters  => "",
               Filter    => "CBoFilter0[23:17]",
               Desc      => "Any Request",
               Defn      => "Filters for any transaction originating from the IPQ or IRQ.  This does not include lookups originating from the ISMQ.",
            },
            "NID" =>
            {
               Umask     => "b01000001",
               Counters  => "",
               Filter    => "CBoFilter0[23:17]",
               Desc      => "Lookups that Match NID",
               Defn      => "Qualify one of the other subevents by the Target NID.  The NID is programmed in Cn_MSR_PMON_BOX_FILTER.nid.   In conjunction with STATE = I, it is possible to monitor misses to specific NIDs in the system.",
            },
            "READ" =>
            {
               Umask     => "b00100001",
               Counters  => "",
               Filter    => "CBoFilter0[22:18]",
               Desc      => "Any Read Request",
               Defn      => "Read transactions",
            },
         },
      },
      "LLC_VICTIMS" =>
      {
         Box       => "CBO Box Events",
         Category  => "CACHE Events",
         EvSel     => 0x37,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Lines Victimized",
         Defn      => "Counts the number of lines that were victimized on a fill.  This can be filtered by the state that the line was in.",
         Subevents =>
         {
            "M_STATE" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Lines in M state",
               Defn      => "",
            },
            "E_STATE" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Lines in E state",
               Defn      => "",
            },
            "I_STATE" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Lines in S State",
               Defn      => "",
            },
            "F_STATE" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
            "NID" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "CBoFilter1[17:10]",
               Desc      => "Victimized Lines that Match NID",
               Defn      => "Qualify one of the other subevents by the Target NID.  The NID is programmed in Cn_MSR_PMON_BOX_FILTER.nid.   In conjunction with STATE = I, it is possible to monitor misses to specific NIDs in the system.",
            },
            "MISS" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
         },
      },
      "MISC" =>
      {
         Box       => "CBO Box Events",
         Category  => "MISC Events",
         EvSel     => 0x39,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Cbo Misc",
         Defn      => "Miscellaneous events in the Cbo.",
         Subevents =>
         {
            "RSPI_WAS_FSE" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Silent Snoop Eviction",
               Defn      => "Counts the number of times when a Snoop hit in FSE states and triggered a silent eviction.  This is useful because this information is lost in the PRE encodings.",
            },
            "WC_ALIASING" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Write Combining Aliasing",
               Defn      => "Counts the number of times that a USWC write (WCIL(F)) transaction hit in the LLC in M state, triggering a WBMtoI followed by the USWC write.  This occurs when there is WC aliasing.",
            },
            "STARTED" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
            "RFO_HIT_S" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "RFO HitS",
               Defn      => "Number of times that an RFO hit in S state.  This is useful for determining if it might be good for a workload to use RspIWB instead of RspSWB.",
            },
            "CVZERO_PREFETCH_VICTIM" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Clean Victim with raw CV=0",
               Defn      => "",
            },
            "CVZERO_PREFETCH_MISS" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "DRd hitting non-M with raw CV=0",
               Defn      => "",
            },
         },
      },
      "RING_AD_USED" =>
      {
         Box       => "CBO Box Events",
         Category  => "RING Events",
         EvSel     => 0x1B,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "AD Ring In Use",
         Defn      => "Counts the number of cycles that the AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  We really have two rings in BDX -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the \"UP\" direction is on the clockwise ring and \"DN\" is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.",
         Notes     => "In any cycle, a ring stop can see up to one packet moving in the UP direction and one packet moving in the DN direction.",
         Subevents =>
         {
            "UP_EVEN" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Up and Even",
               Defn      => "Filters for the Up and Even ring polarity.",
            },
            "UP_ODD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Up and Odd",
               Defn      => "Filters for the Up and Odd ring polarity.",
            },
            "DOWN_EVEN" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Down and Even",
               Defn      => "Filters for the Down and Even ring polarity.",
            },
            "DOWN_ODD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Down and Odd",
               Defn      => "Filters for the Down and Odd ring polarity.",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Up",
               Defn      => "",
            },
            "CCW" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Down",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "",
            },
         },
      },
      "RING_AK_USED" =>
      {
         Box       => "CBO Box Events",
         Category  => "RING Events",
         EvSel     => 0x1C,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "AK Ring In Use",
         Defn      => "Counts the number of cycles that the AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in BDX -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the \"UP\" direction is on the clockwise ring and \"DN\" is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.",
         Notes     => "In any cycle, a ring stop can see up to one packet moving in the UP direction and one packet moving in the DN direction.",
         Subevents =>
         {
            "UP_EVEN" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Up and Even",
               Defn      => "Filters for the Up and Even ring polarity.",
            },
            "UP_ODD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Up and Odd",
               Defn      => "Filters for the Up and Odd ring polarity.",
            },
            "DOWN_EVEN" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Down and Even",
               Defn      => "Filters for the Down and Even ring polarity.",
            },
            "DOWN_ODD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Down and Odd",
               Defn      => "Filters for the Down and Odd ring polarity.",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Up",
               Defn      => "",
            },
            "CCW" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Down",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "",
            },
         },
      },
      "RING_BL_USED" =>
      {
         Box       => "CBO Box Events",
         Category  => "RING Events",
         EvSel     => 0x1D,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "BL Ring in Use",
         Defn      => "Counts the number of cycles that the BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.We really have two rings in BDX -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the \"UP\" direction is on the clockwise ring and \"DN\" is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.",
         Notes     => "In any cycle, a ring stop can see up to one packet moving in the UP direction and one packet moving in the DN direction.",
         Subevents =>
         {
            "UP_EVEN" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Up and Even",
               Defn      => "Filters for the Up and Even ring polarity.",
            },
            "UP_ODD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Up and Odd",
               Defn      => "Filters for the Up and Odd ring polarity.",
            },
            "DOWN_EVEN" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Down and Even",
               Defn      => "Filters for the Down and Even ring polarity.",
            },
            "DOWN_ODD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Down and Odd",
               Defn      => "Filters for the Down and Odd ring polarity.",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Up",
               Defn      => "",
            },
            "CCW" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Down",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "Down",
               Defn      => "",
            },
         },
      },
      "RING_BOUNCES" =>
      {
         Box       => "CBO Box Events",
         Category  => "RING Events",
         EvSel     => 0x05,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Number of LLC responses that bounced on the Ring.",
         Defn      => "",
         Subevents =>
         {
            "AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "AD",
               Defn      => "",
            },
            "AK" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "AK",
               Defn      => "",
            },
            "BL" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL",
               Defn      => "",
            },
            "IV" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "IV",
               Defn      => "",
            },
            "IV" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Snoops of processor's cache.",
               Defn      => "",
            },
         },
      },
      "RING_IV_USED" =>
      {
         Box       => "CBO Box Events",
         Category  => "RING Events",
         EvSel     => 0x1E,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "BL Ring in Use",
         Defn      => "Counts the number of cycles that the IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.  There is only 1 IV ring in BDX  Therefore, if one wants to monitor the \"Even\" ring, they should select both UP_EVEN and DN_EVEN.  To monitor the \"Odd\" ring, they should select both UP_ODD and DN_ODD.",
         Notes     => "IV messages are split into two parts.  In any cycle, a ring stop can see up to one (half-)packet moving in the UP direction and one (half-)packet moving in the DN direction.",
         Subevents =>
         {
            "ANY" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "Any",
               Defn      => "Filters any polarity",
            },
            "UP" =>
            {
               Umask     => "b00110011",
               Counters  => "",
               Filter    => "",
               Desc      => "Up",
               Defn      => "Filters for Up polarity",
            },
            "DOWN" =>
            {
               Umask     => "b11001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Down",
               Defn      => "Filters for Down polarity",
            },
            "UP" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Any",
               Defn      => "Filters any polarity",
            },
            "DN" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Any",
               Defn      => "Filters any polarity",
            },
         },
      },
      "RING_SRC_THRTL" =>
      {
         Box       => "CBO Box Events",
         Category  => "RING Events",
         EvSel     => 0x07,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Number of cycles the Cbo is actively throttling traffic onto the Ring in order to limit bounce traffic.",
         Defn      => "",
      },
      "RxR_EXT_STARVED" =>
      {
         Box       => "CBO Box Events",
         Category  => "INGRESS Events",
         EvSel     => 0x12,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Ingress Arbiter Blocking Cycles",
         Defn      => "Counts cycles in external starvation.  This occurs when one of the ingress queues is being starved by the other queues.",
         Subevents =>
         {
            "IRQ" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "IPQ",
               Defn      => "IRQ is externally starved and therefore we are blocking the IPQ.",
            },
            "IPQ" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "IRQ",
               Defn      => "IPQ is externally startved and therefore we are blocking the IRQ.",
            },
            "PRQ" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "PRQ",
               Defn      => "",
            },
            "ISMQ_BIDS" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "ISMQ_BID",
               Defn      => "Number of times that the ISMQ Bid.",
            },
         },
      },
      "RxR_INSERTS" =>
      {
         Box       => "CBO Box Events",
         Category  => "INGRESS Events",
         EvSel     => 0x13,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Ingress Allocations",
         Defn      => "Counts number of allocations per cycle into the specified Ingress queue.",
         Notes     => "IRQ_REJECTED should not be Ored with the other umasks.",
         Subevents =>
         {
            "IRQ" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "IRQ",
               Defn      => "",
            },
            "IRQ_REJ" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "IRQ Rejected",
               Defn      => "",
            },
            "IPQ" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "IPQ",
               Defn      => "",
            },
            "PRQ" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "PRQ",
               Defn      => "",
            },
            "PRQ_REJ" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "PRQ",
               Defn      => "",
            },
         },
      },
      "RxR_IPQ_RETRY" =>
      {
         Box       => "CBO Box Events",
         Category  => "INGRESS_RETRY Events",
         EvSel     => 0x31,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Probe Queue Retries",
         Defn      => "Number of times a snoop (probe) request had to retry.  Filters exist to cover some of the common cases retries.",
         Subevents =>
         {
            "ANY" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Any Reject",
               Defn      => "Counts the number of times that a request form the IPQ was retried because of a TOR reject.  TOR rejects from the IPQ can be caused by the Egress being full or Address Conflicts.",
            },
            "FULL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "No Egress Credits",
               Defn      => "Counts the number of times that a request form the IPQ was retried because of a TOR reject from the Egress being full.  IPQ requests make use of the AD Egress for regular responses, the BL egress to forward data, and the AK egress to return credits.",
            },
            "ADDR_CONFLICT" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Address Conflict",
               Defn      => "Counts the number of times that a request form the IPQ was retried because of a TOR reject from an address conflicts.  Address conflicts out of the IPQ should be rare.  They will generally only occur if two different sockets are sending requests to the same address at the same time.  This is a true \"conflict\" case, unlike the IPQ Address Conflict which is commonly caused by prefetching characteristics.",
            },
            "QPI_CREDITS" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "No QPI Credits",
               Defn      => "",
            },
         },
      },
      "RxR_IPQ_RETRY2" =>
      {
         Box       => "CBO Box Events",
         Category  => "INGRESS_RETRY Events",
         EvSel     => 0x28,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Probe Queue Retries",
         Defn      => "Number of times a snoop (probe) request had to retry.  Filters exist to cover some of the common cases retries.",
         Subevents =>
         {
            "AD_SBO" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "No AD Sbo Credits",
               Defn      => "Counts the number of times that a request from the IPQ was retried because of it lacked credits to send an AD packet to the Sbo.",
            },
            "TARGET" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "CBoFilter1[15:0]",
               Desc      => "Target Node Filter",
               Defn      => "Counts the number of times that a request from the IPQ was retried filtered by the Target NodeID as specified in the Cbox's Filter register.",
            },
         },
      },
      "RxR_IRQ_RETRY" =>
      {
         Box       => "CBO Box Events",
         Category  => "INGRESS_RETRY Events",
         EvSel     => 0x32,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Ingress Request Queue Rejects",
         Defn      => "",
         Subevents =>
         {
            "ANY" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Any Reject",
               Defn      => "Counts the number of IRQ retries that occur.  Requests from the IRQ are retried if they are rejected from the TOR pipeline for a variety of reasons.  Some of the most common reasons include if the Egress is full, there are no RTIDs, or there is a Physical Address match to another outstanding request.",
            },
            "FULL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "No Egress Credits",
               Defn      => "Counts the number of times that a request from the IRQ was retried because it failed to acquire an entry in the Egress.  The egress is the buffer that queues up for allocating onto the ring.  IRQ requests can make use of all four rings and all four Egresses.  If any of the queues that a given request needs to make use of are full, the request will be retried.",
            },
            "ADDR_CONFLICT" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Address Conflict",
               Defn      => "Counts the number of times that a request from the IRQ was retried because of an address match in the TOR.  In order to maintain coherency, requests to the same address are not allowed to pass each other up in the Cbo.  Therefore, if there is an outstanding request to a given address, one cannot issue another request to that address until it is complete.  This comes up most commonly with prefetches.  Outstanding prefetches occasionally will not complete their memory fetch and a demand request to the same address will then sit in the IRQ and get retried until the prefetch fills the data into the LLC.  Therefore, it will not be uncommon to see this case in high bandwidth streaming workloads when the LLC Prefetcher in the core is enabled.",
            },
            "RTID" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "No RTIDs",
               Defn      => "Counts the number of times that requests from the IRQ were retried because there were no RTIDs available.  RTIDs are required after a request misses the LLC and needs to send snoops and/or requests to memory.  If there are no RTIDs available, requests will queue up in the IRQ and retry until one becomes available.  Note that there are multiple RTID pools for the different sockets.  There may be cases where the local RTIDs are all used, but requests destined for remote memory can still acquire an RTID because there are remote RTIDs available.  This event does not provide any filtering for this case.",
            },
            "QPI_CREDITS" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "No QPI Credits",
               Defn      => "Number of requests rejects because of lack of QPI Ingress credits.  These credits are required in order to send transactions to the QPI agent.  Please see the QPI_IGR_CREDITS events for more information.",
            },
            "IIO_CREDITS" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "No IIO Credits",
               Defn      => "Number of times a request attempted to acquire the NCS/NCB credit for sending messages on BL to the IIO.  There is a single credit in each CBo that is shared between the NCS and NCB message classes for sending transactions on the BL ring (such as read data) to the IIO.",
            },
            "NID" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "CBoFilter1[15:0]",
               Desc      => "",
               Defn      => "Qualify one of the other subevents by a given RTID destination NID.  The NID is programmed in Cn_MSR_PMON_BOX_FILTER1.nid.",
            },
         },
      },
      "RxR_IRQ_RETRY2" =>
      {
         Box       => "CBO Box Events",
         Category  => "INGRESS_RETRY Events",
         EvSel     => 0x29,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Ingress Request Queue Rejects",
         Defn      => "",
         Subevents =>
         {
            "AD_SBO" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "No AD Sbo Credits",
               Defn      => "Counts the number of times that a request from the IPQ was retried because of it lacked credits to send an AD packet to the Sbo.",
            },
            "BL_SBO" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "No BL Sbo Credits",
               Defn      => "Counts the number of times that a request from the IPQ was retried because of it lacked credits to send an BL packet to the Sbo.",
            },
            "TARGET" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "CBoFilter1[15:0]",
               Desc      => "Target Node Filter",
               Defn      => "Counts the number of times that a request from the IPQ was retried filtered by the Target NodeID as specified in the Cbox's Filter register.",
            },
         },
      },
      "RxR_ISMQ_RETRY" =>
      {
         Box       => "CBO Box Events",
         Category  => "INGRESS_RETRY Events",
         EvSel     => 0x33,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "ISMQ Retries",
         Defn      => "Number of times a transaction flowing through the ISMQ had to retry.  Transaction pass through the ISMQ as responses for requests that already exist in the Cbo.  Some examples include: when data is returned or when snoop responses come back from the cores.",
         Subevents =>
         {
            "ANY" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Any Reject",
               Defn      => "Counts the total number of times that a request from the ISMQ retried because of a TOR reject.  ISMQ requests generally will not need to retry (or at least ISMQ retries are less common than IRQ retries).  ISMQ requests will retry if they are not able to acquire a needed Egress credit to get onto the ring, or for cache evictions that need to acquire an RTID.  Most ISMQ requests already have an RTID, so eviction retries will be less common here.",
            },
            "FULL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "No Egress Credits",
               Defn      => "Counts the number of times that a request from the ISMQ retried because of a TOR reject caused by a lack of Egress credits. The egress is the buffer that queues up for allocating onto the ring.  If any of the Egress queues that a given request needs to make use of are full, the request will be retried.",
            },
            "RTID" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "No RTIDs",
               Defn      => "Counts the number of times that a request from the ISMQ retried because of a TOR reject caused by no RTIDs.  M-state cache evictions are serviced through the ISMQ, and must acquire an RTID in order to write back to memory.  If no RTIDs are available, they will be retried.",
            },
            "QPI_CREDITS" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "No QPI Credits",
               Defn      => "",
            },
            "IIO_CREDITS" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "No IIO Credits",
               Defn      => "Number of times a request attempted to acquire the NCS/NCB credit for sending messages on BL to the IIO.  There is a single credit in each CBo that is shared between the NCS and NCB message classes for sending transactions on the BL ring (such as read data) to the IIO.",
            },
            "WB_CREDITS" =>
            {
               Umask     => "b1xxxxxxx",
               Counters  => "",
               Filter    => "CBoFilter1[15:0]",
               Desc      => "",
               Defn      => "Qualify one of the other subevents by a given RTID destination NID.  The NID is programmed in Cn_MSR_PMON_BOX_FILTER1.nid.",
            },
            "NID" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "CBoFilter1[15:0]",
               Desc      => "",
               Defn      => "Qualify one of the other subevents by a given RTID destination NID.  The NID is programmed in Cn_MSR_PMON_BOX_FILTER1.nid.",
            },
         },
      },
      "RxR_ISMQ_RETRY2" =>
      {
         Box       => "CBO Box Events",
         Category  => "INGRESS_RETRY Events",
         EvSel     => 0x2A,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "ISMQ Request Queue Rejects",
         Defn      => "",
         Subevents =>
         {
            "AD_SBO" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "No AD Sbo Credits",
               Defn      => "Counts the number of times that a request from the ISMQ was retried because of it lacked credits to send an AD packet to the Sbo.",
            },
            "BL_SBO" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "No BL Sbo Credits",
               Defn      => "Counts the number of times that a request from the ISMQ was retried because of it lacked credits to send an BL packet to the Sbo.",
            },
            "TARGET" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "CBoFilter1[15:0]",
               Desc      => "Target Node Filter",
               Defn      => "Counts the number of times that a request from the ISMQ was retried filtered by the Target NodeID as specified in the Cbox's Filter register.",
            },
         },
      },
      "RxR_OCCUPANCY" =>
      {
         Box       => "CBO Box Events",
         Category  => "INGRESS Events",
         EvSel     => 0x11,
         Counters  => "0",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 20,
         Desc      => "Ingress Occupancy",
         Defn      => "Counts number of entries in the specified Ingress queue in each cycle.",
         Notes     => "IRQ_REJECTED should not be Ored with the other umasks.",
         Subevents =>
         {
            "IRQ" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "IRQ",
               Defn      => "",
            },
            "IRQ_REJ" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "IRQ Rejected",
               Defn      => "",
            },
            "IPQ" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "IPQ",
               Defn      => "",
            },
            "PRQ_REJ" =>
            {
               Umask     => "b00100000",
               Counters  => "",
               Filter    => "",
               Desc      => "PRQ Rejects",
               Defn      => "",
            },
         },
      },
      "SBO_CREDITS_ACQUIRED" =>
      {
         Box       => "CBO Box Events",
         Category  => "SBO Credit Events",
         EvSel     => 0x3D,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "SBo Credits Acquired",
         Defn      => "Number of Sbo credits acquired in a given cycle, per ring.  Each Cbo is assigned an Sbo it can communicate with.",
         Subevents =>
         {
            "AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "For AD Ring",
               Defn      => "",
            },
            "BL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "For BL Ring",
               Defn      => "",
            },
         },
      },
      "SBO_CREDIT_OCCUPANCY" =>
      {
         Box       => "CBO Box Events",
         Category  => "SBO Credit Events",
         EvSel     => 0x3E,
         Counters  => "0",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 7,
         Desc      => "SBo Credits Occupancy",
         Defn      => "Number of Sbo credits in use in a given cycle, per ring.  Each Cbo is assigned an Sbo it can communicate with.",
         Notes     => "Each Cbo has 3 AD and 2 BL credits into its assigned Sbo.",
         Subevents =>
         {
            "AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "For AD Ring",
               Defn      => "",
            },
            "BL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "For BL Ring",
               Defn      => "",
            },
         },
      },
      "TOR_INSERTS" =>
      {
         Box       => "CBO Box Events",
         Category  => "TOR Events",
         EvSel     => 0x35,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "TOR Inserts",
         Defn      => "Counts the number of entries successfuly inserted into the TOR that match  qualifications specified by the subevent.  There are a number of subevent 'filters' but only a subset of the subevent combinations are valid.  Subevents that require an opcode or NID match require the Cn_MSR_PMON_BOX_FILTER.{opc, nid} field to be set.  If, for example, one wanted to count DRD Local Misses, one should select \"MISS_OPC_MATCH\" and set Cn_MSR_PMON_BOX_FILTER.opc  to DRD (0x182).",
         Subevents =>
         {
            "OPCODE" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "CBoFilter1[28:20]",
               Desc      => "Opcode Match",
               Defn      => "Transactions inserted into the TOR that match an opcode (matched by Cn_MSR_PMON_BOX_FILTER.opc)",
            },
            "EVICTION" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Evictions",
               Defn      => "Eviction transactions inserted into the TOR.  Evictions can be quick, such as when the line is in the F, S, or E states and no core valid bits are set.  They can also be longer if either CV bits are set (so the cores need to be snooped) and/or if there is a HitM (in which case it is necessary to write the request out to memory).",
            },
            "ALL" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "All transactions inserted into the TOR.    This includes requests that reside in the TOR for a short time, such as LLC Hits that do not need to snoop cores or requests that get rejected and have to be retried through one of the ingress queues.  The TOR is more commonly a bottleneck in skews with smaller core counts, where the ratio of RTIDs to TOR entries is larger.  Note that there are reserved TOR entries for various request types, so it is possible that a given request type be blocked with an occupancy that is less than 20.  Also note that generally requests will not be able to arbitrate into the TOR pipeline if there are no available TOR slots.",
            },
            "WB" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "Writebacks",
               Defn      => "Write transactions inserted into the TOR.   This does not include \"RFO\", but actual operations that contain data being sent from the core.",
            },
            "MISS_OPCODE" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "CBoFilter1[28:20]",
               Desc      => "Miss Opcode Match",
               Defn      => "Miss transactions inserted into the TOR that match an opcode.",
            },
            "NID_OPCODE" =>
            {
               Umask     => "b01000001",
               Counters  => "",
               Filter    => "CBoFilter1[28:20], CBoFilter1[15:0]",
               Desc      => "NID and Opcode Matched",
               Defn      => "Transactions inserted into the TOR that match a NID and an opcode.",
            },
            "NID_EVICTION" =>
            {
               Umask     => "b01000100",
               Counters  => "",
               Filter    => "CBoFilter1[15:0]",
               Desc      => "NID Matched Evictions",
               Defn      => "NID matched eviction transactions inserted into the TOR.",
            },
            "NID_ALL" =>
            {
               Umask     => "b01001000",
               Counters  => "",
               Filter    => "CBoFilter1[15:0]",
               Desc      => "NID Matched",
               Defn      => "All NID matched (matches an RTID destination) transactions inserted into the TOR.  The NID is programmed in Cn_MSR_PMON_BOX_FILTER.nid.  In conjunction with STATE = I, it is possible to monitor misses to specific NIDs in the system.",
            },
            "NID_WB" =>
            {
               Umask     => "b01010000",
               Counters  => "",
               Filter    => "CBoFilter1[15:0]",
               Desc      => "NID Matched Writebacks",
               Defn      => "NID matched write transactions inserted into the TOR.",
            },
            "NID_MISS_OPCODE" =>
            {
               Umask     => "b01000011",
               Counters  => "",
               Filter    => "CBoFilter1[28:20], CBoFilter1[15:0]",
               Desc      => "NID and Opcode Matched Miss",
               Defn      => "Miss transactions inserted into the TOR that match a NID and an opcode.",
            },
            "NID_MISS_ALL" =>
            {
               Umask     => "b01001010",
               Counters  => "",
               Filter    => "CBoFilter1[15:0]",
               Desc      => "NID Matched Miss All",
               Defn      => "All NID matched miss requests that were inserted into the TOR.",
            },
            "MISS_LOCAL" =>
            {
               Umask     => "b00101010",
               Counters  => "",
               Filter    => "",
               Desc      => "Misses to Local Memory",
               Defn      => "Miss transactions inserted into the TOR that are satisifed by locally HOMed memory.",
            },
            "MISS_REMOTE" =>
            {
               Umask     => "b10001010",
               Counters  => "",
               Filter    => "",
               Desc      => "Misses to Remote Memory",
               Defn      => "Miss transactions inserted into the TOR that are satisifed by remote caches or remote memory.",
            },
            "LOCAL" =>
            {
               Umask     => "b00101000",
               Counters  => "",
               Filter    => "",
               Desc      => "Local Memory",
               Defn      => "All transactions inserted into the TOR that are satisifed by locally HOMed memory.",
            },
            "REMOTE" =>
            {
               Umask     => "b10001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Remote Memory",
               Defn      => "All transactions inserted into the TOR that are satisifed by remote caches or remote memory.",
            },
            "MISS_LOCAL_OPCODE" =>
            {
               Umask     => "b00100011",
               Counters  => "",
               Filter    => "CBoFilter1[28:20]",
               Desc      => "Misses to Local Memory - Opcode Matched",
               Defn      => "Miss transactions, satisifed by an opcode, inserted into the TOR that are satisifed by locally HOMed memory.",
            },
            "MISS_REMOTE_OPCODE" =>
            {
               Umask     => "b10000011",
               Counters  => "",
               Filter    => "CBoFilter1[28:20]",
               Desc      => "Misses to Remote Memory - Opcode Matched",
               Defn      => "Miss transactions, satisifed by an opcode,  inserted into the TOR that are satisifed by remote caches or remote memory.",
            },
            "LOCAL_OPCODE" =>
            {
               Umask     => "b00100001",
               Counters  => "",
               Filter    => "CBoFilter1[28:20]",
               Desc      => "Local Memory - Opcode Matched",
               Defn      => "All transactions, satisifed by an opcode,  inserted into the TOR that are satisifed by locally HOMed memory.",
            },
            "REMOTE_OPCODE" =>
            {
               Umask     => "b10000001",
               Counters  => "",
               Filter    => "CBoFilter1[28:20]",
               Desc      => "Remote Memory - Opcode Matched",
               Defn      => "All transactions, satisifed by an opcode,  inserted into the TOR that are satisifed by remote caches or remote memory.",
            },
         },
      },
      "TOR_OCCUPANCY" =>
      {
         Box       => "CBO Box Events",
         Category  => "TOR Events",
         EvSel     => 0x36,
         Counters  => "0",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 20,
         Desc      => "TOR Occupancy",
         Defn      => "For each cycle, this event accumulates the number of valid entries in the TOR that match qualifications specified by the subevent.   There are a number of subevent 'filters' but only a subset of the subevent combinations are valid.  Subevents that require an opcode or NID match require the Cn_MSR_PMON_BOX_FILTER.{opc, nid} field to be set.  If, for example, one wanted to count DRD Local Misses, one should select \"MISS_OPC_MATCH\" and set Cn_MSR_PMON_BOX_FILTER.opc to DRD (0x182)",
         Subevents =>
         {
            "OPCODE" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "CBoFilter1[28:20]",
               Desc      => "Opcode Match",
               Defn      => "TOR entries that match an opcode (matched by Cn_MSR_PMON_BOX_FILTER.opc).",
            },
            "EVICTION" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Evictions",
               Defn      => "Number of outstanding eviction transactions in the TOR.  Evictions can be quick, such as when the line is in the F, S, or E states and no core valid bits are set.  They can also be longer if either CV bits are set (so the cores need to be snooped) and/or if there is a HitM (in which case it is necessary to write the request out to memory).",
            },
            "ALL" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Any",
               Defn      => "All valid TOR entries.  This includes requests that reside in the TOR for a short time, such as LLC Hits that do not need to snoop cores or requests that get rejected and have to be retried through one of the ingress queues.  The TOR is more commonly a bottleneck in skews with smaller core counts, where the ratio of RTIDs to TOR entries is larger.  Note that there are reserved TOR entries for various request types, so it is possible that a given request type be blocked with an occupancy that is less than 20.  Also note that generally requests will not be able to arbitrate into the TOR pipeline if there are no available TOR slots.",
            },
            "MISS_OPCODE" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "CBoFilter1[28:20]",
               Desc      => "Miss Opcode Match",
               Defn      => "TOR entries for miss transactions that match an opcode. This generally means that the request was sent to memory or MMIO.",
            },
            "MISS_ALL" =>
            {
               Umask     => "b00001010",
               Counters  => "",
               Filter    => "",
               Desc      => "Miss All",
               Defn      => "Number of outstanding miss requests in the TOR.  'Miss' means the allocation requires an RTID.  This generally means that the request was sent to memory or MMIO.",
            },
            "NID_OPCODE" =>
            {
               Umask     => "b01000001",
               Counters  => "",
               Filter    => "CBoFilter1[28:20], CBoFilter1[15:0]",
               Desc      => "NID and Opcode Matched",
               Defn      => "TOR entries that match a NID and an opcode.",
            },
            "NID_EVICTION" =>
            {
               Umask     => "b01000100",
               Counters  => "",
               Filter    => "CBoFilter1[15:0]",
               Desc      => "NID Matched Evictions",
               Defn      => "Number of outstanding NID matched eviction transactions in the TOR .",
            },
            "NID_ALL" =>
            {
               Umask     => "b01001000",
               Counters  => "",
               Filter    => "CBoFilter1[15:0]",
               Desc      => "NID Matched",
               Defn      => "Number of NID matched outstanding requests in the TOR.  The NID is programmed in Cn_MSR_PMON_BOX_FILTER.nid.In conjunction with STATE = I, it is possible to monitor misses to specific NIDs in the system.",
            },
            "NID_MISS_OPCODE" =>
            {
               Umask     => "b01000011",
               Counters  => "",
               Filter    => "CBoFilter1[28:20], CBoFilter1[15:0]",
               Desc      => "NID and Opcode Matched Miss",
               Defn      => "Number of outstanding Miss requests in the TOR that match a NID and an opcode.",
            },
            "NID_MISS_ALL" =>
            {
               Umask     => "b01001010",
               Counters  => "",
               Filter    => "CBoFilter1[15:0]",
               Desc      => "NID Matched",
               Defn      => "Number of outstanding Miss requests in the TOR that match a NID.",
            },
            "MISS_LOCAL" =>
            {
               Umask     => "b00101010",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
            "MISS_REMOTE" =>
            {
               Umask     => "b10001010",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
            "LOCAL" =>
            {
               Umask     => "b00101000",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
            "REMOTE" =>
            {
               Umask     => "b10001000",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
            "MISS_LOCAL_OPCODE" =>
            {
               Umask     => "b00100011",
               Counters  => "",
               Filter    => "CBoFilter1[28:20]",
               Desc      => "Misses to Local Memory - Opcode Matched",
               Defn      => "Number of outstanding Miss transactions, satisifed by an opcode, in the TOR that are satisifed by locally HOMed memory.",
            },
            "MISS_REMOTE_OPCODE" =>
            {
               Umask     => "b10000011",
               Counters  => "",
               Filter    => "CBoFilter1[28:20]",
               Desc      => "Misses to Remote Memory - Opcode Matched",
               Defn      => "Number of outstanding Miss transactions, satisifed by an opcode, in the TOR that are satisifed by remote caches or remote memory.",
            },
            "LOCAL_OPCODE" =>
            {
               Umask     => "b00100001",
               Counters  => "",
               Filter    => "CBoFilter1[28:20]",
               Desc      => "Local Memory - Opcode Matched",
               Defn      => "Number of outstanding  transactions, satisifed by an opcode,  in the TOR that are satisifed by locally HOMed memory.",
            },
            "REMOTE_OPCODE" =>
            {
               Umask     => "b10000001",
               Counters  => "",
               Filter    => "CBoFilter1[28:20]",
               Desc      => "Remote Memory - Opcode Matched",
               Defn      => "Number of outstanding  transactions, satisifed by an opcode,  in the TOR that are satisifed by remote caches or remote memory.",
            },
            "WB" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "Writebacks",
               Defn      => "Write transactions in the TOR.   This does not include \"RFO\", but actual operations that contain data being sent from the core.",
            },
            "NID_WB" =>
            {
               Umask     => "b01010000",
               Counters  => "",
               Filter    => "CBoFilter1[15:0]",
               Desc      => "NID Matched Writebacks",
               Defn      => "NID matched write transactions int the TOR.",
            },
         },
      },
      "TxR_ADS_USED" =>
      {
         Box       => "CBO Box Events",
         Category  => "EGRESS Events",
         EvSel     => 0x04,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "",
         Defn      => "",
         Subevents =>
         {
            "AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Onto AD Ring",
               Defn      => "",
            },
            "AK" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Onto AK Ring",
               Defn      => "",
            },
            "BL" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Onto BL Ring",
               Defn      => "",
            },
         },
      },
      "TxR_INSERTS" =>
      {
         Box       => "CBO Box Events",
         Category  => "EGRESS Events",
         EvSel     => 0x02,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Egress Allocations",
         Defn      => "Number of allocations into the Cbo Egress.  The Egress is used to queue up requests destined for the ring.",
         Subevents =>
         {
            "AD_CACHE" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "AD - Cachebo",
               Defn      => "Ring transactions from the Cachebo destined for the AD ring.  Some example include outbound requests, snoop requests, and snoop responses.",
            },
            "AK_CACHE" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "AK - Cachebo",
               Defn      => "Ring transactions from the Cachebo destined for the AK ring.  This is commonly used for credit returns and GO responses.",
            },
            "BL_CACHE" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL - Cacheno",
               Defn      => "Ring transactions from the Cachebo destined for the BL ring.  This is commonly used to send data from the cache to various destinations.",
            },
            "IV_CACHE" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "IV - Cachebo",
               Defn      => "Ring transactions from the Cachebo destined for the IV ring.  This is commonly used for snoops to the cores.",
            },
            "AD_CORE" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "AD - Corebo",
               Defn      => "Ring transactions from the Corebo destined for the AD ring.  This is commonly used for outbound requests.",
            },
            "AK_CORE" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "AK - Corebo",
               Defn      => "Ring transactions from the Corebo destined for the AK ring.  This is commonly used for snoop responses coming from the core and destined for a Cachebo.",
            },
            "BL_CORE" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL - Corebo",
               Defn      => "Ring transactions from the Corebo destined for the BL ring.  This is commonly used for transfering writeback data to the cache.",
            },
         },
      },
   },
   "HA Box Events" =>
   {
      "ADDR_OPC_MATCH" =>
      {
         Box       => "HA Box Events",
         Category  => "ADDR_OPCODE_MATCH Events",
         EvSel     => 0x20,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "QPI Address/Opcode Match",
         Defn      => "",
         Subevents =>
         {
            "FILT" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "HA_AddrMatch0[31:6], HA_AddrMatch1[13:0], HA_OpcodeMatch[5:0]",
               Desc      => "Address & Opcode Match",
               Defn      => "",
            },
            "ADDR" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "HA_AddrMatch0[31:6], HA_AddrMatch1[13:0]",
               Desc      => "Address",
               Defn      => "",
            },
            "OPC" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "HA_OpcodeMatch[5:0]",
               Desc      => "Opcode",
               Defn      => "",
            },
            "AD" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "HA_OpcodeMatch[5:0]",
               Desc      => "AD Opcodes",
               Defn      => "",
            },
            "BL" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "HA_OpcodeMatch[5:0]",
               Desc      => "BL Opcodes",
               Defn      => "",
            },
            "AK" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "HA_OpcodeMatch[5:0]",
               Desc      => "AK Opcodes",
               Defn      => "",
            },
         },
      },
      "BT_CYCLES_NE" =>
      {
         Box       => "HA Box Events",
         Category  => "BT (Backup Tracker) Events",
         EvSel     => 0x42,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "BT Cycles Not Empty",
         Defn      => "Cycles the Backup Tracker (BT) is not empty. The BT is the actual HOM tracker in IVT.",
         Notes     => "Will not count case HT is empty and a Bypass happens.",
      },
      "BT_OCCUPANCY" =>
      {
         Box       => "HA Box Events",
         Category  => "BT (Backup Tracker) Events",
         EvSel     => 0x43,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 512,
         Desc      => "BT Occupancy",
         Defn      => "Accumulates the occupancy of the HA BT pool in every cycle.  This can be used with the \"not empty\" stat to calculate average queue occupancy or the \"allocations\" stat in order to calculate average queue latency.  HA BTs are allocated as soon as a request enters the HA and is released after the snoop response and data return (or post in the case of a write) and the response is returned on the ring.",
         Subevents =>
         {
         },
      },
      "BYPASS_IMC" =>
      {
         Box       => "HA Box Events",
         Category  => "BYPASS Events",
         EvSel     => 0x14,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "HA to iMC Bypass",
         Defn      => "Counts the number of times when the HA was able to bypass was attempted.  This is a latency optimization for situations when there is light loadings on the memory subsystem.  This can be filted by when the bypass was taken and when it was not.",
         Notes     => "Only read transactions use iMC bypass",
         Subevents =>
         {
            "TAKEN" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Taken",
               Defn      => "Filter for transactions that succeeded in taking the bypass.",
            },
            "NOT_TAKEN" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Not Taken",
               Defn      => "Filter for transactions that could not take the bypass.",
            },
         },
      },
      "CLOCKTICKS" =>
      {
         Box       => "HA Box Events",
         Category  => "UCLK Events",
         EvSel     => 0x00,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "uclks",
         Defn      => "Counts the number of uclks in the HA.  This will be slightly different than the count in the Ubox because of enable/freeze delays.  The HA is on the other side of the die from the fixed Ubox uclk counter, so the drift could be somewhat larger than in units that are closer like the QPI Agent.",
      },
      "CONFLICT_CYCLES" =>
      {
         Box       => "HA Box Events",
         Category  => "CONFLICTS Events",
         EvSel     => 0x0B,
         Counters  => "1",
         Internal  => 0,
         Filter    => "N",
         SubCtr    => 0,
         MaxIncCyc => 0,
         Desc      => "Conflict Checks",
         Defn      => "Counters the number of cycles there was a conflict in the HA because threads in two different sockets were requesting the same address at the same time",
         Subevents =>
         {
         },
      },
      "DIRECT2CORE_COUNT" =>
      {
         Box       => "HA Box Events",
         Category  => "DIRECT2CORE Events",
         EvSel     => 0x11,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Direct2Core Messages Sent",
         Defn      => "Number of Direct2Core messages sent",
         Notes     => "Will not be implemented since OUTBOUND_TX_BL:0x1 will count DRS to CORE which is effectively the same thing as D2C count",
      },
      "DIRECT2CORE_CYCLES_DISABLED" =>
      {
         Box       => "HA Box Events",
         Category  => "DIRECT2CORE Events",
         EvSel     => 0x12,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Cycles when Direct2Core was Disabled",
         Defn      => "Number of cycles in which Direct2Core was disabled",
      },
      "DIRECT2CORE_TXN_OVERRIDE" =>
      {
         Box       => "HA Box Events",
         Category  => "DIRECT2CORE Events",
         EvSel     => 0x13,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Number of Reads that had Direct2Core Overridden",
         Defn      => "Number of Reads where Direct2Core overridden",
      },
      "DIRECTORY_LAT_OPT" =>
      {
         Box       => "HA Box Events",
         Category  => "DIRECTORY Events",
         EvSel     => 0x41,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Directory Lat Opt Return",
         Defn      => "Directory Latency Optimization Data Return Path Taken. When directory mode is enabled and the directory retuned for a read is Dir=I, then data can be returned using a faster path if certain conditions are met (credits, free pipeline, etc).",
      },
      "DIRECTORY_LOOKUP" =>
      {
         Box       => "HA Box Events",
         Category  => "DIRECTORY Events",
         EvSel     => 0x0C,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Directory Lookups",
         Defn      => "Counts the number of transactions that looked up the directory.  Can be filtered by requests that had to snoop and those that did not have to.",
         Notes     => "Only valid for parts that implement the Directory",
         Subevents =>
         {
            "SNP" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Snoop Needed",
               Defn      => "Filters for transactions that had to send one or more snoops because the directory bit was set.",
            },
            "NO_SNP" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Snoop Not Needed",
               Defn      => "Filters for transactions that did not have to send any snoops because the directory bit was clear.",
            },
         },
      },
      "DIRECTORY_UPDATE" =>
      {
         Box       => "HA Box Events",
         Category  => "DIRECTORY Events",
         EvSel     => 0x0D,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Directory Updates",
         Defn      => "Counts the number of directory updates that were required.  These result in writes to the memory controller.  This can be filtered by directory sets and directory clears.",
         Notes     => "Only valid for parts that implement the Directory",
         Subevents =>
         {
            "SET" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Directory Set",
               Defn      => "Filter for directory sets.  This occurs when a remote read transaction requests memory, bringing it to a remote cache.",
            },
            "CLEAR" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Directory Clear",
               Defn      => "Filter for directory clears.  This occurs when snoops were sent and all returned with RspI.",
            },
            "ANY" =>
            {
               Umask     => "bxxxxxx11",
               Counters  => "",
               Filter    => "",
               Desc      => "Any Directory Update",
               Defn      => "",
            },
         },
      },
      "HITME_HIT" =>
      {
         Box       => "HA Box Events",
         Category  => "HitME Events",
         EvSel     => 0x71,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Counts Number of Hits in HitMe Cache",
         Defn      => "",
         Subevents =>
         {
            "READ_OR_INVITOE" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "op is RdCode, RdData, RdDataMigratory, RdInvOwn, RdCur or InvItoE",
               Defn      => "",
            },
            "WBMTOI" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "op is WbMtoI",
               Defn      => "",
            },
            "ACKCNFLTWBI" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is AckCnfltWbI",
               Defn      => "",
            },
            "WBMTOE_OR_S" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is WbMtoE or WbMtoS",
               Defn      => "",
            },
            "RSPFWDI_REMOTE" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is RspIFwd or RspIFwdWb for a remote request",
               Defn      => "",
            },
            "RSPFWDI_LOCAL" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is RspIFwd or RspIFwdWb for a local request",
               Defn      => "",
            },
            "RSPFWDS" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is RsSFwd or RspSFwdWb",
               Defn      => "",
            },
            "RSP" =>
            {
               Umask     => "b1xxxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is RspI, RspIWb, RspS, RspSWb, RspCnflt or RspCnfltWbI",
               Defn      => "",
            },
            "ALLOCS" =>
            {
               Umask     => "b01110000",
               Counters  => "",
               Filter    => "",
               Desc      => "Allocations",
               Defn      => "",
            },
            "EVICTS" =>
            {
               Umask     => "b01000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Allocations",
               Defn      => "",
            },
            "INVALS" =>
            {
               Umask     => "b00100110",
               Counters  => "",
               Filter    => "",
               Desc      => "Invalidations",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b11111111",
               Counters  => "",
               Filter    => "",
               Desc      => "All Requests",
               Defn      => "",
            },
            "HOM" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM Requests",
               Defn      => "",
            },
         },
      },
      "HITME_HIT_PV_BITS_SET" =>
      {
         Box       => "HA Box Events",
         Category  => "HitME Events",
         EvSel     => 0x72,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Accumulates Number of PV bits set on HitMe Cache Hits",
         Defn      => "",
         Subevents =>
         {
            "READ_OR_INVITOE" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "op is RdCode, RdData, RdDataMigratory, RdInvOwn, RdCur or InvItoE",
               Defn      => "",
            },
            "WBMTOI" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "op is WbMtoI",
               Defn      => "",
            },
            "ACKCNFLTWBI" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is AckCnfltWbI",
               Defn      => "",
            },
            "WBMTOE_OR_S" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is WbMtoE or WbMtoS",
               Defn      => "",
            },
            "RSPFWDI_REMOTE" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is RspIFwd or RspIFwdWb for a remote request",
               Defn      => "",
            },
            "RSPFWDI_LOCAL" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is RspIFwd or RspIFwdWb for a local request",
               Defn      => "",
            },
            "RSPFWDS" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is RsSFwd or RspSFwdWb",
               Defn      => "",
            },
            "RSP" =>
            {
               Umask     => "b1xxxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is RspI, RspIWb, RspS, RspSWb, RspCnflt or RspCnfltWbI",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b11111111",
               Counters  => "",
               Filter    => "",
               Desc      => "All Requests",
               Defn      => "",
            },
            "HOM" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM Requests",
               Defn      => "",
            },
         },
      },
      "HITME_LOOKUP" =>
      {
         Box       => "HA Box Events",
         Category  => "HitME Events",
         EvSel     => 0x70,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Counts Number of times HitMe Cache is accessed",
         Defn      => "",
         Subevents =>
         {
            "READ_OR_INVITOE" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "op is RdCode, RdData, RdDataMigratory, RdInvOwn, RdCur or InvItoE",
               Defn      => "",
            },
            "WBMTOI" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "op is WbMtoI",
               Defn      => "",
            },
            "ACKCNFLTWBI" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is AckCnfltWbI",
               Defn      => "",
            },
            "WBMTOE_OR_S" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is WbMtoE or WbMtoS",
               Defn      => "",
            },
            "RSPFWDI_REMOTE" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is RspIFwd or RspIFwdWb for a remote request",
               Defn      => "",
            },
            "RSPFWDI_LOCAL" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is RspIFwd or RspIFwdWb for a local request",
               Defn      => "",
            },
            "RSPFWDS" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is RsSFwd or RspSFwdWb",
               Defn      => "",
            },
            "RSP" =>
            {
               Umask     => "b1xxxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "op is RspI, RspIWb, RspS, RspSWb, RspCnflt or RspCnfltWbI",
               Defn      => "",
            },
            "ALLOCS" =>
            {
               Umask     => "b01110000",
               Counters  => "",
               Filter    => "",
               Desc      => "Allocations",
               Defn      => "",
            },
            "INVALS" =>
            {
               Umask     => "b00100110",
               Counters  => "",
               Filter    => "",
               Desc      => "Invalidations",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b11111111",
               Counters  => "",
               Filter    => "",
               Desc      => "All Requests",
               Defn      => "",
            },
            "HOM" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM Requests",
               Defn      => "",
            },
         },
      },
      "IGR_NO_CREDIT_CYCLES" =>
      {
         Box       => "HA Box Events",
         Category  => "QPI_IGR_CREDITS Events",
         EvSel     => 0x22,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Cycles without QPI Ingress Credits",
         Defn      => "Counts the number of cycles when the HA does not have credits to send messages to the QPI Agent.  This can be filtered by the different credit pools and the different links.",
         Subevents =>
         {
            "AD_QPI0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "AD to QPI Link 0",
               Defn      => "",
            },
            "AD_QPI1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "AD to QPI Link 1",
               Defn      => "",
            },
            "BL_QPI0" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL to QPI Link 0",
               Defn      => "",
            },
            "BL_QPI1" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL to QPI Link 1",
               Defn      => "",
            },
            "AD_QPI2" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL to QPI Link 0",
               Defn      => "",
            },
            "BL_QPI2" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL to QPI Link 1",
               Defn      => "",
            },
         },
      },
      "IMC_READS" =>
      {
         Box       => "HA Box Events",
         Category  => "IMC_READS Events",
         EvSel     => 0x17,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 4,
         Desc      => "HA to iMC Normal Priority Reads Issued",
         Defn      => "Count of the number of reads issued to any of the memory controller channels.  This can be filtered by the priority of the reads.",
         Notes     => "Does not count reads using the bypass path. That is counted separately in HA_IMC.BYPASS",
         Subevents =>
         {
            "NORMAL" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Normal Priority",
               Defn      => "",
            },
         },
      },
      "IMC_RETRY" =>
      {
         Box       => "HA Box Events",
         Category  => "IMC_MISC Events",
         EvSel     => 0x1E,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Retry Events",
         Defn      => "",
      },
      "IMC_WRITES" =>
      {
         Box       => "HA Box Events",
         Category  => "IMC_WRITES Events",
         EvSel     => 0x1A,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "HA to iMC Full Line Writes Issued",
         Defn      => "Counts the total number of full line writes issued from the HA into the memory controller.  This counts for all four channels.  It can be filtered by full/partial and ISOCH/non-ISOCH.",
         Subevents =>
         {
            "FULL" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Full Line Non-ISOCH",
               Defn      => "",
            },
            "PARTIAL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Partial Non-ISOCH",
               Defn      => "",
            },
            "FULL_ISOCH" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "ISOCH Full Line",
               Defn      => "",
            },
            "PARTIAL_ISOCH" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "ISOCH Partial",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "All Writes",
               Defn      => "",
            },
         },
      },
      "OSB" =>
      {
         Box       => "HA Box Events",
         Category  => "OSB (Opportunistic Snoop Broadcast) Events",
         EvSel     => 0x53,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "OSB Snoop Broadcast",
         Defn      => "Count of OSB snoop broadcasts. Counts by 1 per request causing OSB snoops to be broadcast. Does not count all the snoops generated by OSB.",
         Subevents =>
         {
            "READS_LOCAL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Local Reads",
               Defn      => "",
            },
            "INVITOE_LOCAL" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Local InvItoE",
               Defn      => "",
            },
            "REMOTE" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Remote",
               Defn      => "",
            },
            "CANCELLED" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Cancelled",
               Defn      => "OSB Snoop broadcast cancelled due to D2C or Other. OSB cancel is counted when OSB local read is not allowed even when the transaction in local InItoE. It also counts D2C OSB cancel, but also includes the cases were D2C was not set in the first place for the transaction coming from the ring.",
            },
            "READS_LOCAL_USEFUL" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Reads Local -  Useful",
               Defn      => "",
            },
            "REMOTE_USEFUL" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Remote - Useful",
               Defn      => "",
            },
         },
      },
      "OSB_EDR" =>
      {
         Box       => "HA Box Events",
         Category  => "OSB (Opportunistic Snoop Broadcast) Events",
         EvSel     => 0x54,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "OSB Early Data Return",
         Defn      => "Counts the number of transactions that broadcast snoop due to OSB, but found clean data in memory and was able to do early data return",
         Subevents =>
         {
            "ALL" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "",
            },
            "READS_LOCAL_I" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Reads to Local  I",
               Defn      => "",
            },
            "READS_REMOTE_I" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Reads to Remote I",
               Defn      => "",
            },
            "READS_LOCAL_S" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Reads to Local S",
               Defn      => "",
            },
            "READS_REMOTE_S" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Reads to Remote S",
               Defn      => "",
            },
         },
      },
      "REQUESTS" =>
      {
         Box       => "HA Box Events",
         Category  => "TRACKER Events",
         EvSel     => 0x01,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Read and Write Requests",
         Defn      => "Counts the total number of read requests made into the Home Agent. Reads include all read opcodes (including RFO).  Writes include all writes (streaming, evictions, HitM, etc).",
         Subevents =>
         {
            "READS" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Reads",
               Defn      => "Incoming ead requests.  This is a good proxy for LLC Read Misses (including RFOs).",
            },
            "WRITES" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Writes",
               Defn      => "Incoming write requests.",
            },
            "READS_LOCAL" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Local Reads",
               Defn      => "This filter includes only read requests coming from the local socket.  This is a good proxy for LLC Read Misses (including RFOs) from the local socket.",
            },
            "READS_REMOTE" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Remote Reads",
               Defn      => "This filter includes only read requests coming from the remote socket.  This is a good proxy for LLC Read Misses (including RFOs) from the remote socket.",
            },
            "WRITES_LOCAL" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Local Writes",
               Defn      => "This filter includes only writes coming from the local socket.",
            },
            "WRITES_REMOTE" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Remote Writes",
               Defn      => "This filter includes only writes coming from remote sockets.",
            },
            "INVITOE_LOCAL" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Local InvItoEs",
               Defn      => "This filter includes only InvItoEs coming from the local socket.",
            },
            "INVITOE_REMOTE" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Remote InvItoEs",
               Defn      => "This filter includes only InvItoEs coming from remote sockets.",
            },
         },
      },
      "RING_AD_USED" =>
      {
         Box       => "HA Box Events",
         Category  => "RING Events",
         EvSel     => 0x3E,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "HA AD Ring in Use",
         Defn      => "Counts the number of cycles that the AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.",
         Notes     => "In any cycle, a ring stop can see up to one packet moving in the CW direction and one packet moving in the CCW direction.",
         Subevents =>
         {
            "CW_EVEN" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Even",
               Defn      => "Filters for the Clockwise and Even ring polarity.",
            },
            "CW_ODD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Odd",
               Defn      => "Filters for the Clockwise and Odd ring polarity.",
            },
            "CCW_EVEN" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Even",
               Defn      => "Filters for the Counterclockwise and Even ring polarity.",
            },
            "CCW_ODD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Odd",
               Defn      => "Filters for the Counterclockwise and Odd ring polarity.",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise",
               Defn      => "",
            },
            "CCW" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise",
               Defn      => "",
            },
         },
      },
      "RING_AK_USED" =>
      {
         Box       => "HA Box Events",
         Category  => "RING Events",
         EvSel     => 0x3F,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "HA AK Ring in Use",
         Defn      => "Counts the number of cycles that the AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.",
         Notes     => "In any cycle, a ring stop can see up to one packet moving in the CW direction and one packet moving in the CCW direction.",
         Subevents =>
         {
            "CW_EVEN" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Even",
               Defn      => "Filters for the Clockwise and Even ring polarity.",
            },
            "CW_ODD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Odd",
               Defn      => "Filters for the Clockwise and Odd ring polarity.",
            },
            "CCW_EVEN" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Even",
               Defn      => "Filters for the Counterclockwise and Even ring polarity.",
            },
            "CCW_ODD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Odd",
               Defn      => "Filters for the Counterclockwise and Odd ring polarity.",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise",
               Defn      => "",
            },
            "CCW" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "",
            },
         },
      },
      "RING_BL_USED" =>
      {
         Box       => "HA Box Events",
         Category  => "RING Events",
         EvSel     => 0x40,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "HA BL Ring in Use",
         Defn      => "Counts the number of cycles that the BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.",
         Notes     => "In any cycle, a ring stop can see up to one packet moving in the CW direction and one packet moving in the CCW direction.",
         Subevents =>
         {
            "CW_EVEN" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Even",
               Defn      => "Filters for the Clockwise and Even ring polarity.",
            },
            "CW_ODD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Odd",
               Defn      => "Filters for the Clockwise and Odd ring polarity.",
            },
            "CCW_EVEN" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Even",
               Defn      => "Filters for the Counterclockwise and Even ring polarity.",
            },
            "CCW_ODD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Odd",
               Defn      => "Filters for the Counterclockwise and Odd ring polarity.",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise",
               Defn      => "",
            },
            "CCW" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "",
            },
         },
      },
      "RPQ_CYCLES_NO_REG_CREDITS" =>
      {
         Box       => "HA Box Events",
         Category  => "RPQ_CREDITS Events",
         EvSel     => 0x15,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 4,
         Desc      => "iMC RPQ Credits Empty - Regular",
         Defn      => "Counts the number of cycles when there are no \"regular\" credits available for posting reads from the HA into the iMC.  In order to send reads into the memory controller, the HA must first acquire a credit for the iMC's RPQ (read pending queue).  This queue is broken into regular credits/buffers that are used by general reads, and \"special\" requests such as ISOCH reads.  This count only tracks the regular credits  Common high banwidth workloads should be able to make use of all of the regular buffers, but it will be difficult (and uncommon) to make use of both the regular and special buffers at the same time.  One can filter based on the memory controller channel.  One or more channels can be tracked at a given time.",
         Subevents =>
         {
            "CHN0" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Channel 0",
               Defn      => "Filter for memory controller channel 0 only.",
            },
            "CHN1" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Channel 1",
               Defn      => "Filter for memory controller channel 1 only.",
            },
            "CHN2" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Channel 2",
               Defn      => "Filter for memory controller channel 2 only.",
            },
            "CHN3" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Channel 3",
               Defn      => "Filter for memory controller channel 3 only.",
            },
         },
      },
      "SBO0_CREDITS_ACQUIRED" =>
      {
         Box       => "HA Box Events",
         Category  => "SBO Credit Events",
         EvSel     => 0x68,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "SBo0 Credits Acquired",
         Defn      => "Number of Sbo 0 credits acquired in a given cycle, per ring.",
         Subevents =>
         {
            "AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "For AD Ring",
               Defn      => "",
            },
            "BL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "For BL Ring",
               Defn      => "",
            },
         },
      },
      "SBO0_CREDIT_OCCUPANCY" =>
      {
         Box       => "HA Box Events",
         Category  => "SBO Credit Events",
         EvSel     => 0x6A,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "SBo0 Credits Occupancy",
         Defn      => "Number of Sbo 0 credits in use in a given cycle, per ring.",
         Subevents =>
         {
            "AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "For AD Ring",
               Defn      => "",
            },
            "BL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "For BL Ring",
               Defn      => "",
            },
         },
      },
      "SBO1_CREDITS_ACQUIRED" =>
      {
         Box       => "HA Box Events",
         Category  => "SBO Credit Events",
         EvSel     => 0x69,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "SBo1 Credits Acquired",
         Defn      => "Number of Sbo 1 credits acquired in a given cycle, per ring.",
         Subevents =>
         {
            "AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "For AD Ring",
               Defn      => "",
            },
            "BL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "For BL Ring",
               Defn      => "",
            },
         },
      },
      "SBO1_CREDIT_OCCUPANCY" =>
      {
         Box       => "HA Box Events",
         Category  => "SBO Credit Events",
         EvSel     => 0x6B,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "SBo1 Credits Occupancy",
         Defn      => "Number of Sbo 1 credits in use in a given cycle, per ring.",
         Subevents =>
         {
            "AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "For AD Ring",
               Defn      => "",
            },
            "BL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "For BL Ring",
               Defn      => "",
            },
         },
      },
      "SNOOPS_RSP_AFTER_DATA" =>
      {
         Box       => "HA Box Events",
         Category  => "SNOOPS Events",
         EvSel     => 0x0A,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 127,
         Desc      => "Data beat the Snoop Responses",
         Defn      => "Counts the number of reads when the snoop was on the critical path to the data return.",
         Subevents =>
         {
            "LOCAL" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Local Requests",
               Defn      => "This filter includes only requests coming from the local socket.",
            },
            "REMOTE" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Remote Requests",
               Defn      => "This filter includes only requests coming from remote sockets.",
            },
         },
      },
      "SNOOP_CYCLES_NE" =>
      {
         Box       => "HA Box Events",
         Category  => "SNOOPS Events",
         EvSel     => 0x08,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Cycles with Snoops Outstanding",
         Defn      => "Counts cycles when one or more snoops are outstanding.",
         Subevents =>
         {
            "LOCAL" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Local Requests",
               Defn      => "This filter includes only requests coming from the local socket.",
            },
            "REMOTE" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Remote Requests",
               Defn      => "This filter includes only requests coming from remote sockets.",
            },
            "ALL" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "All Requests",
               Defn      => "Tracked for snoops from both local and remote sockets.",
            },
         },
      },
      "SNOOP_OCCUPANCY" =>
      {
         Box       => "HA Box Events",
         Category  => "SNOOPS Events",
         EvSel     => 0x09,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 127,
         Desc      => "Tracker Snoops Outstanding Accumulator",
         Defn      => "Accumulates the occupancy of either the local HA tracker pool that have snoops pending in every cycle.    This can be used in conjection with the \"not empty\" stat to calculate average queue occupancy or the \"allocations\" stat in order to calculate average queue latency.  HA trackers are allocated as soon as a request enters the HA if an HT (HomeTracker) entry is available and this occupancy is decremented when all the snoop responses have returned.",
         Subevents =>
         {
            "LOCAL" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Local Requests",
               Defn      => "This filter includes only requests coming from the local socket.",
            },
            "REMOTE" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Remote Requests",
               Defn      => "This filter includes only requests coming from remote sockets.",
            },
         },
      },
      "SNOOP_RESP" =>
      {
         Box       => "HA Box Events",
         Category  => "SNP_RESP Events",
         EvSel     => 0x21,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Snoop Responses Received",
         Defn      => "Counts the total number of RspI snoop responses received.  Whenever a snoops are issued, one or more snoop responses will be returned depending on the topology of the system.   In systems larger than 2s, when multiple snoops are returned this will count all the snoops that are received.  For example, if 3 snoops were issued and returned RspI, RspS, and RspSFwd; then each of these sub-events would increment by 1.",
         Subevents =>
         {
            "RSPI" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "RspI",
               Defn      => "Filters for snoops responses of RspI.  RspI is returned when the remote cache does not have the data, or when the remote cache silently evicts data (such as when an RFO hits non-modified data).",
            },
            "RSPS" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "RspS",
               Defn      => "Filters for snoop responses of RspS.  RspS is returned when a remote cache has data but is not forwarding it.  It is a way to let the requesting socket know that it cannot allocate the data in E state.  No data is sent with S RspS.",
            },
            "RSPIFWD" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "RspIFwd",
               Defn      => "Filters for snoop responses of RspIFwd.  This is returned when a remote caching agent forwards data and the requesting agent is able to acquire the data in E or M states.  This is commonly returned with RFO transactions.  It can be either a HitM or a HitFE.",
            },
            "RSPSFWD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "RspSFwd",
               Defn      => "Filters for a snoop response of RspSFwd.  This is returned when a remote caching agent forwards data but holds on to its currentl copy.  This is common for data and code reads that hit in a remote socket in E or F state.",
            },
            "RSP_WB" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Rsp*WB",
               Defn      => "Filters for a snoop response of RspIWB or RspSWB.  This is returned when a non-RFO request hits in M state.  Data and Code Reads can return either RspIWB or RspSWB depending on how the system has been configured.  InvItoE transactions will also return RspIWB because they must acquire ownership.",
            },
            "RSP_FWD_WB" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Rsp*Fwd*WB",
               Defn      => "Filters for a snoop response of Rsp*Fwd*WB.  This snoop response is only used in 4s systems.  It is used when a snoop HITM's in a remote caching agent and it directly forwards data to a requestor, and simultaneously returns data to the home to be written back to memory.",
            },
            "RSPCNFLCT" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "RSPCNFLCT*",
               Defn      => "Filters for snoops responses of RspConflict.  This is returned when a snoop finds an existing outstanding transaction in a remote caching agent when it CAMs that caching agent.  This triggers conflict resolution hardware.  This covers both RspCnflct and RspCnflctWbI.",
            },
         },
      },
      "SNP_RESP_RECV_LOCAL" =>
      {
         Box       => "HA Box Events",
         Category  => "SNP_RESP Events",
         EvSel     => 0x60,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Snoop Responses Received Local",
         Defn      => "Number of snoop responses received for a Local  request",
         Subevents =>
         {
            "RSPI" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "RspI",
               Defn      => "Filters for snoops responses of RspI.  RspI is returned when the remote cache does not have the data, or when the remote cache silently evicts data (such as when an RFO hits non-modified data).",
            },
            "RSPS" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "RspS",
               Defn      => "Filters for snoop responses of RspS.  RspS is returned when a remote cache has data but is not forwarding it.  It is a way to let the requesting socket know that it cannot allocate the data in E state.  No data is sent with S RspS.",
            },
            "RSPIFWD" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "RspIFwd",
               Defn      => "Filters for snoop responses of RspIFwd.  This is returned when a remote caching agent forwards data and the requesting agent is able to acquire the data in E or M states.  This is commonly returned with RFO transactions.  It can be either a HitM or a HitFE.",
            },
            "RSPSFWD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "RspSFwd",
               Defn      => "Filters for a snoop response of RspSFwd.  This is returned when a remote caching agent forwards data but holds on to its currentl copy.  This is common for data and code reads that hit in a remote socket in E or F state.",
            },
            "RSPxWB" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Rsp*WB",
               Defn      => "Filters for a snoop response of RspIWB or RspSWB.  This is returned when a non-RFO request hits in M state.  Data and Code Reads can return either RspIWB or RspSWB depending on how the system has been configured.  InvItoE transactions will also return RspIWB because they must acquire ownership.",
            },
            "RSPxFWDxWB" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Rsp*FWD*WB",
               Defn      => "Filters for a snoop response of Rsp*Fwd*WB.  This snoop response is only used in 4s systems.  It is used when a snoop HITM's in a remote caching agent and it directly forwards data to a requestor, and simultaneously returns data to the home to be written back to memory.",
            },
            "RSPCNFLCT" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "RspCnflct",
               Defn      => "Filters for snoops responses of RspConflict.  This is returned when a snoop finds an existing outstanding transaction in a remote caching agent when it CAMs that caching agent.  This triggers conflict resolution hardware.  This covers both RspCnflct and RspCnflctWbI.",
            },
            "OTHER" =>
            {
               Umask     => "b1xxxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Other",
               Defn      => "Filters for all other snoop responses.",
            },
         },
      },
      "STALL_NO_SBO_CREDIT" =>
      {
         Box       => "HA Box Events",
         Category  => "SBO Credit Events",
         EvSel     => 0x6C,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Stall on No Sbo Credits",
         Defn      => "Number of cycles Egress is stalled waiting for an Sbo credit to become available.  Per Sbo, per Ring.",
         Subevents =>
         {
            "SBO0_AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "For SBo0, AD Ring",
               Defn      => "",
            },
            "SBO1_AD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "For SBo1, AD Ring",
               Defn      => "",
            },
            "SBO0_BL" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "For SBo0, BL Ring",
               Defn      => "",
            },
            "SBO1_BL" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "For SBo1, BL Ring",
               Defn      => "",
            },
         },
      },
      "TAD_REQUESTS_G0" =>
      {
         Box       => "HA Box Events",
         Category  => "TAD Events",
         EvSel     => 0x1B,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "HA Requests to a TAD Region - Group 0",
         Defn      => "Counts the number of HA requests to a given TAD region.  There are up to 11 TAD (target address decode) regions in each home agent.  All requests destined for the memory controller must first be decoded to determine which TAD region they are in.  This event is filtered based on the TAD region ID, and covers regions 0 to 7.  This event is useful for understanding how applications are using the memory that is spread across the different memory regions.  It is particularly useful for \"Monroe\" systems that use the TAD to enable individual channels to enter self-refresh to save power.",
         Subevents =>
         {
            "REGION0" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "TAD Region 0",
               Defn      => "Filters request made to TAD Region 0",
            },
            "REGION1" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "TAD Region 1",
               Defn      => "Filters request made to TAD Region 1",
            },
            "REGION2" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "TAD Region 2",
               Defn      => "Filters request made to TAD Region 2",
            },
            "REGION3" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "TAD Region 3",
               Defn      => "Filters request made to TAD Region 3",
            },
            "REGION4" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "TAD Region 4",
               Defn      => "Filters request made to TAD Region 4",
            },
            "REGION5" =>
            {
               Umask     => "b00100000",
               Counters  => "",
               Filter    => "",
               Desc      => "TAD Region 5",
               Defn      => "Filters request made to TAD Region 5",
            },
            "REGION6" =>
            {
               Umask     => "b01000000",
               Counters  => "",
               Filter    => "",
               Desc      => "TAD Region 6",
               Defn      => "Filters request made to TAD Region 6",
            },
            "REGION7" =>
            {
               Umask     => "b10000000",
               Counters  => "",
               Filter    => "",
               Desc      => "TAD Region 7",
               Defn      => "Filters request made to TAD Region 7",
            },
         },
      },
      "TAD_REQUESTS_G1" =>
      {
         Box       => "HA Box Events",
         Category  => "TAD Events",
         EvSel     => 0x1C,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "HA Requests to a TAD Region - Group 1",
         Defn      => "Counts the number of HA requests to a given TAD region.  There are up to 11 TAD (target address decode) regions in each home agent.  All requests destined for the memory controller must first be decoded to determine which TAD region they are in.  This event is filtered based on the TAD region ID, and covers regions 8 to 10.  This event is useful for understanding how applications are using the memory that is spread across the different memory regions.  It is particularly useful for \"Monroe\" systems that use the TAD to enable individual channels to enter self-refresh to save power.",
         Subevents =>
         {
            "REGION8" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "TAD Region 8",
               Defn      => "Filters request made to TAD Region 8",
            },
            "REGION9" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "TAD Region 9",
               Defn      => "Filters request made to TAD Region 9",
            },
            "REGION10" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "TAD Region 10",
               Defn      => "Filters request made to TAD Region 10",
            },
            "REGION11" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "TAD Region 11",
               Defn      => "Filters request made to TAD Region 11",
            },
         },
      },
      "TRACKER_CYCLES_FULL" =>
      {
         Box       => "HA Box Events",
         Category  => "TRACKER Events",
         EvSel     => 0x02,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Tracker Cycles Full",
         Defn      => "Counts the number of cycles when the local HA tracker pool is completely used.  This can be used with edge detect to identify the number of situations when the pool became fully utilized.  This should not be confused with RTID credit usage -- which must be tracked inside each cbo individually -- but represents the actual tracker buffer structure.  In other words, the system could be starved for RTIDs but not fill up the HA trackers.  HA trackers are allocated as soon as a request enters the HA and is released after the snoop response and data return (or post in the case of a write) and the response is returned on the ring.",
         Subevents =>
         {
            "GP" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Cycles GP Completely Used",
               Defn      => "Counts the number of cycles when the general purpose (GP) HA tracker pool (HT) is completely used.  It will not return valid count when BT is disabled.",
            },
            "ALL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Cycles Completely Used",
               Defn      => "Counts the number of cycles when the HA tracker pool (HT) is completely used including reserved HT entries.  It will not return valid count when BT is disabled.",
            },
         },
      },
      "TRACKER_CYCLES_NE" =>
      {
         Box       => "HA Box Events",
         Category  => "TRACKER Events",
         EvSel     => 0x03,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Tracker Cycles Not Empty",
         Defn      => "Counts the number of cycles when the local HA tracker pool is not empty.  This can be used with edge detect to identify the number of situations when the pool became empty.  This should not be confused with RTID credit usage -- which must be tracked inside each cbo individually -- but represents the actual tracker buffer structure.  In other words, this buffer could be completely empty, but there may still be credits in use by the CBos.  This stat can be used in conjunction with the occupancy accumulation stat in order to calculate average queue occpancy.  HA trackers are allocated as soon as a request enters the HA if an HT (Home Tracker) entry is available and is released after the snoop response and data return (or post in the case of a write) and the response is returned on the ring.",
         Subevents =>
         {
            "LOCAL" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Local Requests",
               Defn      => "This filter includes only requests coming from the local socket.",
            },
            "REMOTE" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Remote Requests",
               Defn      => "This filter includes only requests coming from remote sockets.",
            },
            "ALL" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "All Requests",
               Defn      => "Requests coming from both local and remote sockets.",
            },
         },
      },
      "TRACKER_OCCUPANCY" =>
      {
         Box       => "HA Box Events",
         Category  => "TRACKER Events",
         EvSel     => 0x04,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 128,
         Desc      => "Tracker Occupancy Accumultor",
         Defn      => "Accumulates the occupancy of the local HA tracker pool in every cycle.  This can be used in conjection with the \"not empty\" stat to calculate average queue occupancy or the \"allocations\" stat in order to calculate average queue latency.  HA trackers are allocated as soon as a request enters the HA if a HT (Home Tracker) entry is available and is released after the snoop response and data return (or post in the case of a write) and the response is returned on the ring.",
         Subevents =>
         {
            "READS_LOCAL" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Local Read Requests",
               Defn      => "",
            },
            "READS_REMOTE" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Remote Read Requests",
               Defn      => "",
            },
            "WRITES_LOCAL" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Local Write Requests",
               Defn      => "",
            },
            "WRITES_REMOTE" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Remote Write Requests",
               Defn      => "",
            },
            "INVITOE_LOCAL" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Local InvItoE Requests",
               Defn      => "",
            },
            "INVITOE_REMOTE" =>
            {
               Umask     => "b1xxxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Remote InvItoE Requests",
               Defn      => "",
            },
         },
      },
      "TRACKER_PENDING_OCCUPANCY" =>
      {
         Box       => "HA Box Events",
         Category  => "TRACKER Events",
         EvSel     => 0x05,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 127,
         Desc      => "Data Pending Occupancy Accumultor",
         Defn      => "Accumulates the number of transactions that have data from the memory controller until they get scheduled to the Egress.  This can be used to calculate the queuing latency for two things.  (1) If the system is waiting for snoops, this will increase.  (2) If the system can't schedule to the Egress because of either (a) Egress Credits or (b) QPI BL IGR credits for remote requests.",
         Subevents =>
         {
            "LOCAL" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Local Requests",
               Defn      => "This filter includes only requests coming from the local socket.",
            },
            "REMOTE" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Remote Requests",
               Defn      => "This filter includes only requests coming from remote sockets.",
            },
         },
      },
      "TxR_AD_CYCLES_FULL" =>
      {
         Box       => "HA Box Events",
         Category  => "EGRESS Events",
         EvSel     => 0x2A,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "AD Egress Full",
         Defn      => "AD Egress Full",
         Subevents =>
         {
            "SCHED0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Scheduler 0",
               Defn      => "Filter for cycles full  from scheduler bank 0",
            },
            "SCHED1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Scheduler 1",
               Defn      => "Filter for cycles full  from scheduler bank 1",
            },
            "ALL" =>
            {
               Umask     => "bxxxxxx11",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "Cycles full from both schedulers",
            },
         },
      },
      "TxR_AK" =>
      {
         Box       => "HA Box Events",
         Category  => "OUTBOUND_TX Events",
         EvSel     => 0x0E,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Outbound Ring Transactions on AK",
         Defn      => "",
         Subevents =>
         {
         },
      },
      "TxR_AK_CYCLES_FULL" =>
      {
         Box       => "HA Box Events",
         Category  => "EGRESS Events",
         EvSel     => 0x32,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "AK Egress Full",
         Defn      => "AK Egress Full",
         Subevents =>
         {
            "SCHED0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Scheduler 0",
               Defn      => "Filter for cycles full  from scheduler bank 0",
            },
            "SCHED1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Scheduler 1",
               Defn      => "Filter for cycles full  from scheduler bank 1",
            },
            "ALL" =>
            {
               Umask     => "bxxxxxx11",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "Cycles full from both schedulers",
            },
         },
      },
      "TxR_BL" =>
      {
         Box       => "HA Box Events",
         Category  => "OUTBOUND_TX Events",
         EvSel     => 0x10,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Outbound DRS Ring Transactions to Cache",
         Defn      => "Counts the number of DRS messages sent out on the BL ring.   This can be filtered by the destination.",
         Subevents =>
         {
            "DRS_CACHE" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Data to Cache",
               Defn      => "Filter for data being sent to the cache.",
            },
            "DRS_CORE" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Data to Core",
               Defn      => "Filter for data being sent directly to the requesting core.",
            },
            "DRS_QPI" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Data to QPI",
               Defn      => "Filter for data being sent to a remote socket over QPI.",
            },
         },
      },
      "TxR_BL_CYCLES_FULL" =>
      {
         Box       => "HA Box Events",
         Category  => "EGRESS Events",
         EvSel     => 0x36,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "BL Egress Full",
         Defn      => "BL Egress Full",
         Subevents =>
         {
            "SCHED0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Scheduler 0",
               Defn      => "Filter for cycles full  from scheduler bank 0",
            },
            "SCHED1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Scheduler 1",
               Defn      => "Filter for cycles full  from scheduler bank 1",
            },
            "ALL" =>
            {
               Umask     => "bxxxxxx11",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "Cycles full from both schedulers",
            },
         },
      },
      "TxR_BL_OCCUPANCY" =>
      {
         Box       => "HA Box Events",
         Category  => "BL_EGRESS Events",
         EvSel     => 0x34,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 20,
         Desc      => "BL Egress Occupancy",
         Defn      => "BL Egress Occupancy",
         Subevents =>
         {
         },
      },
      "TxR_STARVED" =>
      {
         Box       => "HA Box Events",
         Category  => "EGRESS Events",
         EvSel     => 0x6D,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Injection Starvation",
         Defn      => "Counts injection starvation.  This starvation is triggered when the Egress cannot send a transaction onto the ring for a long period of time.",
         Subevents =>
         {
            "AK" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "For AK Ring",
               Defn      => "",
            },
            "BL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "For BL Ring",
               Defn      => "",
            },
         },
      },
      "WPQ_CYCLES_NO_REG_CREDITS" =>
      {
         Box       => "HA Box Events",
         Category  => "WPQ_CREDITS Events",
         EvSel     => 0x18,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 4,
         Desc      => "HA iMC CHN0 WPQ Credits Empty - Regular",
         Defn      => "Counts the number of cycles when there are no \"regular\" credits available for posting writes from the HA into the iMC.  In order to send writes into the memory controller, the HA must first acquire a credit for the iMC's WPQ (write pending queue).  This queue is broken into regular credits/buffers that are used by general writes, and \"special\" requests such as ISOCH writes.  This count only tracks the regular credits  Common high banwidth workloads should be able to make use of all of the regular buffers, but it will be difficult (and uncommon) to make use of both the regular and special buffers at the same time.  One can filter based on the memory controller channel.  One or more channels can be tracked at a given time.",
         Subevents =>
         {
            "CHN0" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Channel 0",
               Defn      => "Filter for memory controller channel 0 only.",
            },
            "CHN1" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Channel 1",
               Defn      => "Filter for memory controller channel 1 only.",
            },
            "CHN2" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Channel 2",
               Defn      => "Filter for memory controller channel 2 only.",
            },
            "CHN3" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Channel 3",
               Defn      => "Filter for memory controller channel 3 only.",
            },
         },
      },
   },
   "IRP Box Events" =>
   {
      "CACHE_TOTAL_OCCUPANCY" =>
      {
         Box       => "IRP Box Events",
         Category  => "WRITE_CACHE Events",
         EvSel     => 0x12,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 128,
         Desc      => "Total Write Cache Occupancy",
         Defn      => "Accumulates the number of reads and writes that are outstanding in the uncore in each cycle.  This is effectively the sum of the READ_OCCUPANCY and WRITE_OCCUPANCY events.",
         Subevents =>
         {
            "ANY" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Any Source",
               Defn      => "Tracks all requests from any source port.",
            },
            "SOURCE" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Select Source",
               Defn      => "Tracks only those requests that come from the port specified in the IRP_PmonFilter.OrderingQ register.  This register allows one to select one specific queue.  It is not possible to monitor multiple queues at a time.",
            },
         },
      },
      "CLOCKTICKS" =>
      {
         Box       => "IRP Box Events",
         Category  => "IO_CLKS Events",
         EvSel     => 0x00,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Clocks in the IRP",
         Defn      => "Number of clocks in the IRP.",
      },
      "COHERENT_OPS" =>
      {
         Box       => "IRP Box Events",
         Category  => "Coherency Events",
         EvSel     => 0x13,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Coherent Ops",
         Defn      => "Counts the number of coherency related operations servied by the IRP",
         Subevents =>
         {
            "PCIRDCUR" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "PCIRdCur",
               Defn      => "",
            },
            "CRD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "CRd",
               Defn      => "",
            },
            "DRD" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "DRd",
               Defn      => "",
            },
            "RFO" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "RFO",
               Defn      => "",
            },
            "PCITOM" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "PCIItoM",
               Defn      => "",
            },
            "PCIDCAHINT" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "PCIDCAHin5t",
               Defn      => "",
            },
            "WBMTOI" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "WbMtoI",
               Defn      => "",
            },
            "CLFLUSH" =>
            {
               Umask     => "b1xxxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "CLFlush",
               Defn      => "",
            },
         },
      },
      "MISC0" =>
      {
         Box       => "IRP Box Events",
         Category  => "MISC Events",
         EvSel     => 0x14,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Misc Events - Set 0",
         Defn      => "",
         Subevents =>
         {
            "FAST_REQ" =>
            {
               Umask     => "b000000x1",
               Counters  => "",
               Filter    => "",
               Desc      => "Fastpath Requests",
               Defn      => "",
            },
            "FAST_REJ" =>
            {
               Umask     => "b0000001x",
               Counters  => "",
               Filter    => "",
               Desc      => "Fastpath Rejects",
               Defn      => "",
            },
            "2ND_RD_INSERT" =>
            {
               Umask     => "bx00xx100",
               Counters  => "",
               Filter    => "",
               Desc      => "Cache Inserts of Read Transactions as Secondary",
               Defn      => "",
            },
            "2ND_WR_INSERT" =>
            {
               Umask     => "bx00x1x00",
               Counters  => "",
               Filter    => "",
               Desc      => "Cache Inserts of Write Transactions as Secondary",
               Defn      => "",
            },
            "2ND_ATOMIC_INSERT" =>
            {
               Umask     => "bx001xx00",
               Counters  => "",
               Filter    => "",
               Desc      => "Cache Inserts of Atomic Transactions as Secondary",
               Defn      => "",
            },
            "FAST_XFER" =>
            {
               Umask     => "bxx100000",
               Counters  => "",
               Filter    => "",
               Desc      => "Fastpath Transfers From Primary to Secondary",
               Defn      => "",
            },
            "PF_ACK_HINT" =>
            {
               Umask     => "bx1x00000",
               Counters  => "",
               Filter    => "",
               Desc      => "Prefetch Ack Hints From Primary to Secondary",
               Defn      => "",
            },
            "PF_TIMEOUT" =>
            {
               Umask     => "b1xx00000",
               Counters  => "",
               Filter    => "",
               Desc      => "Prefetch TimeOut",
               Defn      => "Indicates the fetch for a previous prefetch wasn't accepted by the prefetch.   This happens in the case of a prefetch TimeOut",
            },
         },
      },
      "MISC1" =>
      {
         Box       => "IRP Box Events",
         Category  => "MISC Events",
         EvSel     => 0x15,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Misc Events - Set 1",
         Defn      => "",
         Subevents =>
         {
            "SLOW_I" =>
            {
               Umask     => "b000xxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Slow Transfer of I Line",
               Defn      => "Snoop took cacheline ownership before write from data was committed.",
            },
            "SLOW_S" =>
            {
               Umask     => "b000xxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Slow Transfer of S Line",
               Defn      => "Secondary received a transfer that did not have sufficient MESI state",
            },
            "SLOW_E" =>
            {
               Umask     => "b000xx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Slow Transfer of E Line",
               Defn      => "Secondary received a transfer that did have sufficient MESI state",
            },
            "SLOW_M" =>
            {
               Umask     => "b000x1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Slow Transfer of M Line",
               Defn      => "Snoop took cacheline ownership before write from data was committed.",
            },
            "LOST_FWD" =>
            {
               Umask     => "b0001xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
            "SEC_RCVD_INVLD" =>
            {
               Umask     => "bxx1x0000",
               Counters  => "",
               Filter    => "",
               Desc      => "Received Invalid",
               Defn      => "Secondary received a transfer that did not have sufficient MESI state",
            },
            "SEC_RCVD_VLD" =>
            {
               Umask     => "bx1xx0000",
               Counters  => "",
               Filter    => "",
               Desc      => "Received Valid",
               Defn      => "Secondary received a transfer that did have sufficient MESI state",
            },
            "DATA_THROTTLE" =>
            {
               Umask     => "b1xxx0000",
               Counters  => "",
               Filter    => "",
               Desc      => "Data Throttled",
               Defn      => "IRP throttled switch data",
            },
         },
      },
      "RxR_AK_INSERTS" =>
      {
         Box       => "IRP Box Events",
         Category  => "AK_INGRESS Events",
         EvSel     => 0x0A,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "AK Ingress Occupancy",
         Defn      => "Counts the number of allocations into the AK Ingress.  This queue is where the IRP receives responses from R2PCIe (the ring).",
      },
      "RxR_BL_DRS_CYCLES_FULL" =>
      {
         Box       => "IRP Box Events",
         Category  => "BL_INGRESS_DRS Events",
         EvSel     => 0x04,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "",
         Defn      => "Counts the number of cycles when the BL Ingress is full.  This queue is where the IRP receives data from R2PCIe (the ring).  It is used for data returns from read requets as well as outbound MMIO writes.",
      },
      "RxR_BL_DRS_INSERTS" =>
      {
         Box       => "IRP Box Events",
         Category  => "BL_INGRESS_DRS Events",
         EvSel     => 0x01,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "BL Ingress Occupancy - DRS",
         Defn      => "Counts the number of allocations into the BL Ingress.  This queue is where the IRP receives data from R2PCIe (the ring).  It is used for data returns from read requets as well as outbound MMIO writes.",
      },
      "RxR_BL_DRS_OCCUPANCY" =>
      {
         Box       => "IRP Box Events",
         Category  => "BL_INGRESS_DRS Events",
         EvSel     => 0x07,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 24,
         Desc      => "",
         Defn      => "Accumulates the occupancy of the BL Ingress in each cycles.  This queue is where the IRP receives data from R2PCIe (the ring).  It is used for data returns from read requets as well as outbound MMIO writes.",
      },
      "RxR_BL_NCB_CYCLES_FULL" =>
      {
         Box       => "IRP Box Events",
         Category  => "BL_INGRESS_NCB Events",
         EvSel     => 0x05,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "",
         Defn      => "Counts the number of cycles when the BL Ingress is full.  This queue is where the IRP receives data from R2PCIe (the ring).  It is used for data returns from read requets as well as outbound MMIO writes.",
      },
      "RxR_BL_NCB_INSERTS" =>
      {
         Box       => "IRP Box Events",
         Category  => "BL_INGRESS_NCB Events",
         EvSel     => 0x02,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "BL Ingress Occupancy - NCB",
         Defn      => "Counts the number of allocations into the BL Ingress.  This queue is where the IRP receives data from R2PCIe (the ring).  It is used for data returns from read requets as well as outbound MMIO writes.",
      },
      "RxR_BL_NCB_OCCUPANCY" =>
      {
         Box       => "IRP Box Events",
         Category  => "BL_INGRESS_NCB Events",
         EvSel     => 0x08,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 24,
         Desc      => "",
         Defn      => "Accumulates the occupancy of the BL Ingress in each cycles.  This queue is where the IRP receives data from R2PCIe (the ring).  It is used for data returns from read requets as well as outbound MMIO writes.",
      },
      "RxR_BL_NCS_CYCLES_FULL" =>
      {
         Box       => "IRP Box Events",
         Category  => "BL_INGRESS_NCS Events",
         EvSel     => 0x06,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "",
         Defn      => "Counts the number of cycles when the BL Ingress is full.  This queue is where the IRP receives data from R2PCIe (the ring).  It is used for data returns from read requets as well as outbound MMIO writes.",
      },
      "RxR_BL_NCS_INSERTS" =>
      {
         Box       => "IRP Box Events",
         Category  => "BL_INGRESS_NCS Events",
         EvSel     => 0x03,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "BL Ingress Occupancy - NCS",
         Defn      => "Counts the number of allocations into the BL Ingress.  This queue is where the IRP receives data from R2PCIe (the ring).  It is used for data returns from read requets as well as outbound MMIO writes.",
      },
      "RxR_BL_NCS_OCCUPANCY" =>
      {
         Box       => "IRP Box Events",
         Category  => "BL_INGRESS_NCS Events",
         EvSel     => 0x09,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 24,
         Desc      => "",
         Defn      => "Accumulates the occupancy of the BL Ingress in each cycles.  This queue is where the IRP receives data from R2PCIe (the ring).  It is used for data returns from read requets as well as outbound MMIO writes.",
      },
      "SNOOP_RESP" =>
      {
         Box       => "IRP Box Events",
         Category  => "TRANSACTIONS Events",
         EvSel     => 0x17,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Snoop Responses",
         Defn      => "",
         Notes     => "The first 4 subevent bits are the Responses to the Code/Data/Invalid Snoops represented by the last 3 subevent bits.  At least 1 of the bottom 4 bits must be combined with 1 of the top 3 bits to obtain counts.  Unsure which combinations are possible.",
         Subevents =>
         {
            "MISS" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Miss",
               Defn      => "",
            },
            "HIT_I" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Hit I",
               Defn      => "",
            },
            "HIT_ES" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Hit E or S",
               Defn      => "",
            },
            "HIT_M" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Hit M",
               Defn      => "",
            },
            "SNPCODE" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "SnpCode",
               Defn      => "",
            },
            "SNPDATA" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "SnpData",
               Defn      => "",
            },
            "SNPINV" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "SnpInv",
               Defn      => "",
            },
         },
      },
      "TRANSACTIONS" =>
      {
         Box       => "IRP Box Events",
         Category  => "TRANSACTIONS Events",
         EvSel     => 0x16,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Inbound Transaction Count",
         Defn      => "Counts the number of \"Inbound\" transactions from the IRP to the Uncore.  This can be filtered based on request type in addition to the source queue.  Note the special filtering equation.  We do OR-reduction on the request type.  If the SOURCE bit is set, then we also do AND qualification based on the source portID.",
         Notes     => "Bit 7 is a filter that can be applied to the other subevents.  Meaningless by itself.",
         Subevents =>
         {
            "READS" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Reads",
               Defn      => "Tracks only read requests (not including read prefetches).",
            },
            "WRITES" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Writes",
               Defn      => "Tracks only write requests.  Each write request should have a prefetch, so there is no need to explicitly track these requests.",
            },
            "RD_PREF" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Read Prefetches",
               Defn      => "Tracks the number of read prefetches.",
            },
            "WR_PREF" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Write Prefetches",
               Defn      => "Tracks the number of write prefetches.",
            },
            "ATOMIC" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Atomic",
               Defn      => "Tracks the number of atomic transactions",
            },
            "OTHER" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Other",
               Defn      => "Tracks the number of 'other' kinds of transactions.",
            },
            "ORDERINGQ" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "IRPFilter[4:0]",
               Desc      => "Select Source",
               Defn      => "Tracks only those requests that come from the port specified in the IRP_PmonFilter.OrderingQ register.  This register allows one to select one specific queue.  It is not possible to monitor multiple queues at a time.  If this bit is not set, then requests from all sources will be counted.",
            },
         },
      },
      "TxR_AD_STALL_CREDIT_CYCLES" =>
      {
         Box       => "IRP Box Events",
         Category  => "STALL_CYCLES Events",
         EvSel     => 0x18,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "No AD Egress Credit Stalls",
         Defn      => "Counts the number times when it is not possible to issue a request to the R2PCIe because there are no AD Egress Credits available.",
      },
      "TxR_BL_STALL_CREDIT_CYCLES" =>
      {
         Box       => "IRP Box Events",
         Category  => "STALL_CYCLES Events",
         EvSel     => 0x19,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "No BL Egress Credit Stalls",
         Defn      => "Counts the number times when it is not possible to issue data to the R2PCIe because there are no BL Egress Credits available.",
      },
      "TxR_DATA_INSERTS_NCB" =>
      {
         Box       => "IRP Box Events",
         Category  => "OUTBOUND_REQUESTS Events",
         EvSel     => 0x0E,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Outbound Read Requests",
         Defn      => "Counts the number of requests issued to the switch (towards the devices).",
      },
      "TxR_DATA_INSERTS_NCS" =>
      {
         Box       => "IRP Box Events",
         Category  => "OUTBOUND_REQUESTS Events",
         EvSel     => 0x0F,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Outbound Read Requests",
         Defn      => "Counts the number of requests issued to the switch (towards the devices).",
      },
      "TxR_REQUEST_OCCUPANCY" =>
      {
         Box       => "IRP Box Events",
         Category  => "OUTBOUND_REQUESTS Events",
         EvSel     => 0x0D,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 1,
         Desc      => "Outbound Request Queue Occupancy",
         Defn      => "Accumultes the number of outstanding outbound requests from the IRP to the switch (towards the devices).  This can be used in conjuection with the allocations event in order to calculate average latency of outbound requests.",
      },
   },
   "PCU Box Events" =>
   {
      "CLOCKTICKS" =>
      {
         Box       => "PCU Box Events",
         Category  => "PCLK Events",
         EvSel     => 0x00,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "pclk Cycles",
         Defn      => "The PCU runs off a fixed 1 GHz clock.  This event counts the number of pclk cycles measured while the counter was enabled.  The pclk, like the Memory Controller's dclk, counts at a constant rate making it a good measure of actual wall time.",
      },
      "CORE0_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x60,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
         Notes     => "This only tracks the hardware portion in the RCFSM (CFCFSM).  This portion is just doing the core C state transition.  It does not include any necessary frequency/voltage transitions.",
      },
      "CORE10_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x6A,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
      },
      "CORE11_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x6B,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
      },
      "CORE12_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x6C,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
      },
      "CORE13_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x6D,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
      },
      "CORE14_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x6E,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
      },
      "CORE15_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x6F,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
      },
      "CORE16_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x70,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
      },
      "CORE17_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x71,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
      },
      "CORE1_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x61,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
      },
      "CORE2_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x62,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
      },
      "CORE3_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x63,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
      },
      "CORE4_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x64,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
      },
      "CORE5_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x65,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
      },
      "CORE6_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x66,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
      },
      "CORE7_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x67,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
      },
      "CORE8_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x68,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
         Notes     => "This only tracks the hardware portion in the RCFSM (CFCFSM).  This portion is just doing the core C state transition.  It does not include any necessary frequency/voltage transitions.",
      },
      "CORE9_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x69,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions.  There is one event per core.",
      },
      "DEMOTIONS_CORE0" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x30,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE1" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x31,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE10" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x3A,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE11" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x3B,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE12" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x3C,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE13" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x3D,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE14" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x3E,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE15" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x3F,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE16" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x40,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE17" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x41,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE2" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x32,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE3" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x33,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE4" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x34,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE5" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x35,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE6" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x36,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE7" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x37,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE8" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x38,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "DEMOTIONS_CORE9" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x39,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Core C State Demotions",
         Defn      => "Counts the number of times when a configurable cores had a C-state demotion",
      },
      "FREQ_MAX_LIMIT_THERMAL_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "FREQ_MAX_LIMIT Events",
         EvSel     => 0x04,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Thermal Strongest Upper Limit Cycles",
         Defn      => "Counts the number of cycles when thermal conditions are the upper limit on frequency.  This is related to the THERMAL_THROTTLE CYCLES_ABOVE_TEMP event, which always counts cycles when we are above the thermal temperature.  This event (STRONGEST_UPPER_LIMIT) is sampled at the output of the algorithm that determines the actual frequency, while THERMAL_THROTTLE looks at the input.",
      },
      "FREQ_MAX_OS_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "FREQ_MAX_LIMIT Events",
         EvSel     => 0x06,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "OS Strongest Upper Limit Cycles",
         Defn      => "Counts the number of cycles when the OS is the upper limit on frequency.",
         Notes     => "Essentially, this event says the OS is getting the frequency it requested.",
      },
      "FREQ_MAX_POWER_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "FREQ_MAX_LIMIT Events",
         EvSel     => 0x05,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Power Strongest Upper Limit Cycles",
         Defn      => "Counts the number of cycles when power is the upper limit on frequency.",
      },
      "FREQ_MIN_IO_P_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "FREQ_MIN_LIMIT Events",
         EvSel     => 0x73,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "IO P Limit Strongest Lower Limit Cycles",
         Defn      => "Counts the number of cycles when IO P Limit is preventing us from dropping the frequency lower.  This algorithm monitors the needs to the IO subsystem on both local and remote sockets and will maintain a frequency high enough to maintain good IO BW.  This is necessary for when all the IA cores on a socket are idle but a user still would like to maintain high IO Bandwidth.",
      },
      "FREQ_TRANS_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "FREQ_TRANS Events",
         EvSel     => 0x74,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Cycles spent changing Frequency",
         Defn      => "Counts the number of cycles when the system is changing frequency.  This can not be filtered by thread ID.  One can also use it with the occupancy counter that monitors number of threads in C0 to estimate the performance impact that frequency transitions had on the system.",
      },
      "MEMORY_PHASE_SHEDDING_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "MEMORY_PHASE_SHEDDING Events",
         EvSel     => 0x2F,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Memory Phase Shedding Cycles",
         Defn      => "Counts the number of cycles that the PCU has triggered memory phase shedding.  This is a mode that can be run in the iMC physicals that saves power at the expense of additional latency.",
         Notes     => "Package C1",
      },
      "PKG_RESIDENCY_C0_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "PKG_C_STATE_RESIDENCY Events",
         EvSel     => 0x2A,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Package C State Residency - C0",
         Defn      => "Counts the number of cycles when the package was in C0.  This event can be used in conjunction with edge detect to count C0 entrances (or exits using invert).  Residency events do not include transition times.",
      },
      "PKG_RESIDENCY_C1E_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "PKG_C_STATE_RESIDENCY Events",
         EvSel     => 0x4E,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Package C State Residency - C1E",
         Defn      => "Counts the number of cycles when the package was in C1E.  This event can be used in conjunction with edge detect to count C1E entrances (or exits using invert).  Residency events do not include transition times.",
      },
      "PKG_RESIDENCY_C2E_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "PKG_C_STATE_RESIDENCY Events",
         EvSel     => 0x2B,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Package C State Residency - C2E",
         Defn      => "Counts the number of cycles when the package was in C2E.  This event can be used in conjunction with edge detect to count C2E entrances (or exits using invert).  Residency events do not include transition times.",
      },
      "PKG_RESIDENCY_C3_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "PKG_C_STATE_RESIDENCY Events",
         EvSel     => 0x2C,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Package C State Residency - C3",
         Defn      => "Counts the number of cycles when the package was in C3.  This event can be used in conjunction with edge detect to count C3 entrances (or exits using invert).  Residency events do not include transition times.",
      },
      "PKG_RESIDENCY_C6_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "PKG_C_STATE_RESIDENCY Events",
         EvSel     => 0x2D,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Package C State Residency - C6",
         Defn      => "Counts the number of cycles when the package was in C6.  This event can be used in conjunction with edge detect to count C6 entrances (or exits using invert).  Residency events do not include transition times.",
      },
      "PKG_RESIDENCY_C7_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "PKG_C_STATE_RESIDENCY Events",
         EvSel     => 0x2E,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Package C7 State Residency",
         Defn      => "Counts the number of cycles when the package was in C7.  This event can be used in conjunction with edge detect to count C7 entrances (or exits using invert).  Residency events do not include transition times.",
      },
      "POWER_STATE_OCCUPANCY" =>
      {
         Box       => "PCU Box Events",
         Category  => "POWER_STATE_OCC Events",
         EvSel     => 0x80,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 8,
         Desc      => "Number of cores in C-State",
         Defn      => "This is an occupancy event that tracks the number of cores that are in the chosen C-State.  It can be used by itself to get the average number of cores in that C-state with threshholding to generate histograms, or with other PCU events and occupancy triggering to capture other details.",
         Subevents =>
         {
            "CORES_C0" =>
            {
               Umask     => "b01000000",
               Counters  => "",
               Filter    => "",
               Desc      => "C0 and C1",
               Defn      => "",
            },
            "CORES_C3" =>
            {
               Umask     => "b10000000",
               Counters  => "",
               Filter    => "",
               Desc      => "C3",
               Defn      => "",
            },
            "CORES_C6" =>
            {
               Umask     => "b11000000",
               Counters  => "",
               Filter    => "",
               Desc      => "C6 and C7",
               Defn      => "",
            },
         },
      },
      "PROCHOT_EXTERNAL_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "PROCHOT Events",
         EvSel     => 0x0A,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "External Prochot",
         Defn      => "Counts the number of cycles that we are in external PROCHOT mode.  This mode is triggered when a sensor off the die determines that something off-die (like DRAM) is too hot and must throttle to avoid damaging the chip.",
      },
      "PROCHOT_INTERNAL_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "PROCHOT Events",
         EvSel     => 0x09,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Internal Prochot",
         Defn      => "Counts the number of cycles that we are in Interal PROCHOT mode.  This mode is triggered when a sensor on the die determines that we are too hot and must throttle to avoid damaging the chip.",
      },
      "TOTAL_TRANSITION_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "CORE_C_STATE_TRANSITION Events",
         EvSel     => 0x72,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Total Core C State Transition Cycles",
         Defn      => "Number of cycles spent performing core C state transitions across all cores.",
      },
      "UFS_TRANSITIONS_RING_GV" =>
      {
         Box       => "PCU Box Events",
         Category  => "UFS Events",
         EvSel     => 0x79,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "",
         Defn      => "Ring GV with same final and initial frequency",
      },
      "VR_HOT_CYCLES" =>
      {
         Box       => "PCU Box Events",
         Category  => "VR_HOT Events",
         EvSel     => 0x42,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "VR Hot",
         Defn      => "",
      },
   },
   "QPI LL Box Events" =>
   {
      "CLOCKTICKS" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "CFCLK Events",
         EvSel     => 0x14,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Number of qfclks",
         Defn      => "Counts the number of clocks in the QPI LL.  This clock runs at 1/4th the \"GT/s\" speed of the QPI link.  For example, a 4GT/s link will have qfclk or 1GHz.  BDX does not support dynamic link speeds, so this frequency is fixed.",
      },
      "CTO_COUNT" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "CTO Events",
         EvSel     => 0x38,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "QPIMask0[17:0],QPIMatch0[17:0],QPIMask1[19:16],QPIMatch1[19:16]",
         SubCtr    => 1,
         MaxIncCyc => 2,
         Desc      => "Count of CTO Events",
         Defn      => "Counts the number of CTO (cluster trigger outs) events that were asserted across the two slots.  If both slots trigger in a given cycle, the event will increment by 2.  You can use edge detect to count the number of cases when both events triggered.",
      },
      "DIRECT2CORE" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "DIRECT2CORE Events",
         EvSel     => 0x13,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Direct 2 Core Spawning",
         Defn      => "Counts the number of DRS packets that we attempted to do direct2core on.  There are 4 mutually exlusive filters.  Filter [0] can be used to get successful spawns, while [1:3] provide the different failure cases.  Note that this does not count packets that are not candidates for Direct2Core.  The only candidates for Direct2Core are DRS packets destined for Cbos.",
         Subevents =>
         {
            "SUCCESS_RBT_HIT" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Spawn Success",
               Defn      => "The spawn was successful.  There were sufficient credits, the RBT valid bit was set and there was an RBT tag match.  The message was marked to spawn direct2core.",
            },
            "FAILURE_CREDITS" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Spawn Failure - Egress Credits",
               Defn      => "The spawn failed because there were not enough Egress credits.  Had there been enough credits, the spawn would have worked as the RBT bit was set and the RBT tag matched.",
            },
            "FAILURE_RBT_HIT" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Spawn Failure - RBT Invalid",
               Defn      => "The spawn failed because the route-back table (RBT) specified that the transaction should not trigger a direct2core tranaction.  This is common for IO transactions.  There were enough Egress credits and the RBT tag matched but the valid bit was not set.",
            },
            "FAILURE_CREDITS_RBT" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Spawn Failure - Egress and RBT Invalid",
               Defn      => "The spawn failed because there were not enough Egress credits AND the RBT bit was not set, but the RBT tag matched.",
            },
            "FAILURE_MISS" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Spawn Failure - RBT Miss",
               Defn      => "The spawn failed because the RBT tag did not match although the valid bit was set and there were enough Egress credits.",
            },
            "FAILURE_CREDITS_MISS" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Spawn Failure - Egress and RBT Miss",
               Defn      => "The spawn failed because the RBT tag did not match and there weren't enough Egress credits.   The valid bit was set.",
            },
            "FAILURE_RBT_MISS" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Spawn Failure - RBT Miss and Invalid",
               Defn      => "The spawn failed because the RBT tag did not match and the valid bit was not set although there were enough Egress credits.",
            },
            "FAILURE_CREDITS_RBT_MISS" =>
            {
               Umask     => "b1xxxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Spawn Failure - Egress and RBT Miss, Invalid",
               Defn      => "The spawn failed because the RBT tag did not match, the valid bit was not set and there weren't enough Egress credits.",
            },
         },
      },
      "L1_POWER_CYCLES" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "POWER Events",
         EvSel     => 0x12,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Cycles in L1",
         Defn      => "Number of QPI qfclk cycles spent in L1 power mode.  L1 is a mode that totally shuts down a QPI link.  Use edge detect to count the number of instances when the QPI link entered L1.  Link power states are per link and per direction, so for example the Tx direction could be in one state while Rx was in another. Because L1 totally shuts down the link, it takes a good amount of time to exit this mode.",
      },
      "RxL0P_POWER_CYCLES" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "POWER_RX Events",
         EvSel     => 0x10,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Cycles in L0p",
         Defn      => "Number of QPI qfclk cycles spent in L0p power mode.  L0p is a mode where we disable 1/2 of the QPI lanes, decreasing our bandwidth in order to save power.  It increases snoop and data transfer latencies and decreases overall bandwidth.  This mode can be very useful in NUMA optimized workloads that largely only utilize QPI for snoops and their responses.  Use edge detect to count the number of instances when the QPI link entered L0p.  Link power states are per link and per direction, so for example the Tx direction could be in one state while Rx was in another.",
         Notes     => "Using .edge_det to count transitions does not function if L1_POWER_CYCLES > 0.",
      },
      "RxL0_POWER_CYCLES" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "POWER_RX Events",
         EvSel     => 0x0F,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Cycles in L0",
         Defn      => "Number of QPI qfclk cycles spent in L0 power mode in the Link Layer.  L0 is the default mode which provides the highest performance with the most power.  Use edge detect to count the number of instances that the link entered L0.  Link power states are per link and per direction, so for example the Tx direction could be in one state while Rx was in another.  The phy layer  sometimes leaves L0 for training, which will not be captured by this event.",
         Notes     => "Includes L0p cycles.  To get just L0, subtract RxL0P_POWER_CYCLES",
      },
      "RxL_BYPASSED" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RXQ Events",
         EvSel     => 0x09,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Rx Flit Buffer Bypassed",
         Defn      => "Counts the number of times that an incoming flit was able to bypass the flit buffer and pass directly across the BGF and into the Egress.  This is a latency optimization, and should generally be the common case.  If this value is less than the number of flits transfered, it implies that there was queueing getting onto the ring, and thus the transactions saw higher latency.",
      },
      "RxL_CREDITS_CONSUMED_VN0" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RX_CREDITS_CONSUMED Events",
         EvSel     => 0x1E,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "VN0 Credit Consumed",
         Defn      => "Counts the number of times that an RxQ VN0 credit was consumed (i.e. message uses a VN0 credit for the Rx Buffer).  This includes packets that went through the RxQ and those that were bypasssed.",
         Subevents =>
         {
            "DRS" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS",
               Defn      => "VN0 credit for the DRS message class.",
            },
            "NCB" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "NCB",
               Defn      => "VN0 credit for the NCB message class.",
            },
            "NCS" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCS",
               Defn      => "VN0 credit for the NCS message class.",
            },
            "HOM" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM",
               Defn      => "VN0 credit for the HOM message class.",
            },
            "SNP" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "SNP",
               Defn      => "VN0 credit for the SNP message class.",
            },
            "NDR" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NDR",
               Defn      => "VN0 credit for the NDR message class.",
            },
         },
      },
      "RxL_CREDITS_CONSUMED_VN1" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RX_CREDITS_CONSUMED Events",
         EvSel     => 0x39,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "VN1 Credit Consumed",
         Defn      => "Counts the number of times that an RxQ VN1 credit was consumed (i.e. message uses a VN1 credit for the Rx Buffer).  This includes packets that went through the RxQ and those that were bypasssed.",
         Subevents =>
         {
            "DRS" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS",
               Defn      => "VN1 credit for the DRS message class.",
            },
            "NCB" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "NCB",
               Defn      => "VN1 credit for the NCB message class.",
            },
            "NCS" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCS",
               Defn      => "VN1 credit for the NCS message class.",
            },
            "HOM" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM",
               Defn      => "VN1 credit for the HOM message class.",
            },
            "SNP" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "SNP",
               Defn      => "VN1 credit for the SNP message class.",
            },
            "NDR" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NDR",
               Defn      => "VN1 credit for the NDR message class.",
            },
         },
      },
      "RxL_CREDITS_CONSUMED_VNA" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RX_CREDITS_CONSUMED Events",
         EvSel     => 0x1D,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "VNA Credit Consumed",
         Defn      => "Counts the number of times that an RxQ VNA credit was consumed (i.e. message uses a VNA credit for the Rx Buffer).  This includes packets that went through the RxQ and those that were bypasssed.",
      },
      "RxL_CYCLES_NE" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RXQ Events",
         EvSel     => 0x0A,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "RxQ Cycles Not Empty",
         Defn      => "Counts the number of cycles that the QPI RxQ was not empty.  Generally, when data is transmitted across QPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Occupancy Accumulator event to calculate the average occupancy.",
      },
      "RxL_FLITS_G1" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "FLITS_RX Events",
         EvSel     => 0x02,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "Flits Received - Group 1",
         Defn      => "Counts the number of flits received from the QPI Link.  This is one of three \"groups\" that allow us to track flits.  It includes filters for SNP, HOM, and DRS message classes.  Each \"flit\" is made up of 80 bits of information (in addition to some ECC data).  In full-width (L0) mode, flits are made up of four \"fits\", each of which contains 20 bits of data (along with some additional ECC data).   In half-width (L0p) mode, the fits are only 10 bits, and therefore it takes twice as many fits to transmit a flit.  When one talks about QPI \"speed\" (for example, 8.0 GT/s), the \"transfers\" here refer to \"fits\".  Therefore, in L0, the system will transfer 1 \"flit\" at the rate of 1/4th the QPI speed.  One can calculate the bandwidth of the link by taking: flits*80b/time.  Note that this is not the same as \"data\" bandwidth.  For example, when we are transfering a 64B cacheline across QPI, we will break it into 9 flits -- 1 with header information and 8 with 64 bits of actual \"data\" and an additional 16 bits of other information.  To calculate \"data\" bandwidth, one should therefore do: data flits * 8B / time.",
         Subevents =>
         {
            "SNP" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "SNP Flits",
               Defn      => "Counts the number of snoop request flits received over QPI.  These requests are contained in the snoop channel.  This does not include snoop responses, which are received on the home channel.",
            },
            "HOM_REQ" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM Request Flits",
               Defn      => "Counts the number of data request received over QPI on the home channel.  This basically counts the number of remote memory requests received over QPI.  In conjunction with the local read count in the Home Agent, one can calculate the number of LLC Misses.",
            },
            "HOM_NONREQ" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM Non-Request Flits",
               Defn      => "Counts the number of non-request flits received over QPI on the home channel.  These are most commonly snoop responses, and this event can be used as a proxy for that.",
            },
            "HOM" =>
            {
               Umask     => "b00000110",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM Flits",
               Defn      => "Counts the number of flits received over QPI on the home channel.",
            },
            "DRS_DATA" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS Data Flits",
               Defn      => "Counts the total number of data flits received over QPI on the DRS (Data Response) channel.  DRS flits are used to transmit data with coherency.  This does not count data flits received over the NCB channel which transmits non-coherent data.  This includes only the data flits (not the header).",
            },
            "DRS_NONDATA" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS Header Flits",
               Defn      => "Counts the total number of protocol flits received over QPI on the DRS (Data Response) channel.  DRS flits are used to transmit data with coherency.  This does not count data flits received over the NCB channel which transmits non-coherent data.  This includes only the header flits (not the data).  This includes extended headers.",
            },
            "DRS" =>
            {
               Umask     => "b00011000",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS Flits (both Header and Data)",
               Defn      => "Counts the total number of flits received over QPI on the DRS (Data Response) channel.  DRS flits are used to transmit data with coherency.  This does not count data flits received over the NCB channel which transmits non-coherent data.",
            },
         },
      },
      "RxL_FLITS_G2" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "FLITS_RX Events",
         EvSel     => 0x03,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "Flits Received - Group 2",
         Defn      => "Counts the number of flits received from the QPI Link.  This is one of three \"groups\" that allow us to track flits.  It includes filters for NDR, NCB, and NCS message classes.  Each \"flit\" is made up of 80 bits of information (in addition to some ECC data).  In full-width (L0) mode, flits are made up of four \"fits\", each of which contains 20 bits of data (along with some additional ECC data).   In half-width (L0p) mode, the fits are only 10 bits, and therefore it takes twice as many fits to transmit a flit.  When one talks about QPI \"speed\" (for example, 8.0 GT/s), the \"transfers\" here refer to \"fits\".  Therefore, in L0, the system will transfer 1 \"flit\" at the rate of 1/4th the QPI speed.  One can calculate the bandwidth of the link by taking: flits*80b/time.  Note that this is not the same as \"data\" bandwidth.  For example, when we are transfering a 64B cacheline across QPI, we will break it into 9 flits -- 1 with header information and 8 with 64 bits of actual \"data\" and an additional 16 bits of other information.  To calculate \"data\" bandwidth, one should therefore do: data flits * 8B / time.",
         Subevents =>
         {
            "NDR_AD" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Non-Data Response Rx Flits - AD",
               Defn      => "Counts the total number of flits received over the NDR (Non-Data Response) channel.  This channel is used to send a variety of protocol flits including grants and completions.  This is only for NDR packets to the local socket which use the AK ring.",
            },
            "NDR_AK" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Non-Data Response Rx Flits - AK",
               Defn      => "Counts the total number of flits received over the NDR (Non-Data Response) channel.  This channel is used to send a variety of protocol flits including grants and completions.  This is only for NDR packets destined for Route-thru to a remote socket.",
            },
            "NCB_DATA" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Non-Coherent data Rx Flits",
               Defn      => "Number of Non-Coherent Bypass data flits.  These flits are generally used to transmit non-coherent data across QPI.  This does not include a count of the DRS (coherent) data flits.  This only counts the data flits, not the NCB headers.",
            },
            "NCB_NONDATA" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Non-Coherent non-data Rx Flits",
               Defn      => "Number of Non-Coherent Bypass non-data flits.  These packets are generally used to transmit non-coherent data across QPI, and the flits counted here are for headers and other non-data flits.  This includes extended headers.",
            },
            "NCB" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Non-Coherent Rx Flits",
               Defn      => "Number of Non-Coherent Bypass flits.  These packets are generally used to transmit non-coherent data across QPI.",
            },
            "NCS" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "Non-Coherent standard Rx Flits",
               Defn      => "Number of NCS (non-coherent standard) flits received over QPI.    This includes extended headers.",
            },
         },
      },
      "RxL_INSERTS" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RXQ Events",
         EvSel     => 0x08,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Rx Flit Buffer Allocations",
         Defn      => "Number of allocations into the QPI Rx Flit Buffer.  Generally, when data is transmitted across QPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Occupancy event in order to calculate the average flit buffer lifetime.",
      },
      "RxL_INSERTS_DRS" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RXQ Events",
         EvSel     => 0x09,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Rx Flit Buffer Allocations - DRS",
         Defn      => "Number of allocations into the QPI Rx Flit Buffer.  Generally, when data is transmitted across QPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Occupancy event in order to calculate the average flit buffer lifetime.  This monitors only DRS flits.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "RxL_INSERTS_HOM" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RXQ Events",
         EvSel     => 0x0C,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Rx Flit Buffer Allocations - HOM",
         Defn      => "Number of allocations into the QPI Rx Flit Buffer.  Generally, when data is transmitted across QPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Occupancy event in order to calculate the average flit buffer lifetime.  This monitors only HOM flits.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "RxL_INSERTS_NCB" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RXQ Events",
         EvSel     => 0x0A,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Rx Flit Buffer Allocations - NCB",
         Defn      => "Number of allocations into the QPI Rx Flit Buffer.  Generally, when data is transmitted across QPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Occupancy event in order to calculate the average flit buffer lifetime.  This monitors only NCB flits.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "RxL_INSERTS_NCS" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RXQ Events",
         EvSel     => 0x0B,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Rx Flit Buffer Allocations - NCS",
         Defn      => "Number of allocations into the QPI Rx Flit Buffer.  Generally, when data is transmitted across QPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Occupancy event in order to calculate the average flit buffer lifetime.  This monitors only NCS flits.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "RxL_INSERTS_NDR" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RXQ Events",
         EvSel     => 0x0E,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Rx Flit Buffer Allocations - NDR",
         Defn      => "Number of allocations into the QPI Rx Flit Buffer.  Generally, when data is transmitted across QPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Occupancy event in order to calculate the average flit buffer lifetime.  This monitors only NDR flits.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "RxL_INSERTS_SNP" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RXQ Events",
         EvSel     => 0x0D,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Rx Flit Buffer Allocations - SNP",
         Defn      => "Number of allocations into the QPI Rx Flit Buffer.  Generally, when data is transmitted across QPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Occupancy event in order to calculate the average flit buffer lifetime.  This monitors only SNP flits.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "RxL_OCCUPANCY" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RXQ Events",
         EvSel     => 0x0B,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 128,
         Desc      => "RxQ Occupancy - All Packets",
         Defn      => "Accumulates the number of elements in the QPI RxQ in each cycle.  Generally, when data is transmitted across QPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Not Empty event to calculate average occupancy, or with the Flit Buffer Allocations event to track average lifetime.",
      },
      "RxL_OCCUPANCY_DRS" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RXQ Events",
         EvSel     => 0x15,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 128,
         Desc      => "RxQ Occupancy - DRS",
         Defn      => "Accumulates the number of elements in the QPI RxQ in each cycle.  Generally, when data is transmitted across QPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Not Empty event to calculate average occupancy, or with the Flit Buffer Allocations event to track average lifetime.  This monitors DRS flits only.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "RxL_OCCUPANCY_HOM" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RXQ Events",
         EvSel     => 0x18,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 128,
         Desc      => "RxQ Occupancy - HOM",
         Defn      => "Accumulates the number of elements in the QPI RxQ in each cycle.  Generally, when data is transmitted across QPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Not Empty event to calculate average occupancy, or with the Flit Buffer Allocations event to track average lifetime.  This monitors HOM flits only.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "RxL_OCCUPANCY_NCB" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RXQ Events",
         EvSel     => 0x16,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 128,
         Desc      => "RxQ Occupancy - NCB",
         Defn      => "Accumulates the number of elements in the QPI RxQ in each cycle.  Generally, when data is transmitted across QPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Not Empty event to calculate average occupancy, or with the Flit Buffer Allocations event to track average lifetime.  This monitors NCB flits only.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "RxL_OCCUPANCY_NCS" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RXQ Events",
         EvSel     => 0x17,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 128,
         Desc      => "RxQ Occupancy - NCS",
         Defn      => "Accumulates the number of elements in the QPI RxQ in each cycle.  Generally, when data is transmitted across QPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Not Empty event to calculate average occupancy, or with the Flit Buffer Allocations event to track average lifetime.  This monitors NCS flits only.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "RxL_OCCUPANCY_NDR" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RXQ Events",
         EvSel     => 0x1A,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 128,
         Desc      => "RxQ Occupancy - NDR",
         Defn      => "Accumulates the number of elements in the QPI RxQ in each cycle.  Generally, when data is transmitted across QPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Not Empty event to calculate average occupancy, or with the Flit Buffer Allocations event to track average lifetime.  This monitors NDR flits only.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "RxL_OCCUPANCY_SNP" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "RXQ Events",
         EvSel     => 0x19,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 128,
         Desc      => "RxQ Occupancy - SNP",
         Defn      => "Accumulates the number of elements in the QPI RxQ in each cycle.  Generally, when data is transmitted across QPI, it will bypass the RxQ and pass directly to the ring interface.  If things back up getting transmitted onto the ring, however, it may need to allocate into this buffer, thus increasing the latency.  This event can be used in conjunction with the Flit Buffer Not Empty event to calculate average occupancy, or with the Flit Buffer Allocations event to track average lifetime.  This monitors SNP flits only.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "TxL0P_POWER_CYCLES" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "POWER_TX Events",
         EvSel     => 0x0D,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Cycles in L0p",
         Defn      => "Number of QPI qfclk cycles spent in L0p power mode.  L0p is a mode where we disable 1/2 of the QPI lanes, decreasing our bandwidth in order to save power.  It increases snoop and data transfer latencies and decreases overall bandwidth.  This mode can be very useful in NUMA optimized workloads that largely only utilize QPI for snoops and their responses.  Use edge detect to count the number of instances when the QPI link entered L0p.  Link power states are per link and per direction, so for example the Tx direction could be in one state while Rx was in another.",
         Notes     => "Using .edge_det to count transitions does not function if L1_POWER_CYCLES > 0.",
      },
      "TxL0_POWER_CYCLES" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "POWER_TX Events",
         EvSel     => 0x0C,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Cycles in L0",
         Defn      => "Number of QPI qfclk cycles spent in L0 power mode in the Link Layer.  L0 is the default mode which provides the highest performance with the most power.  Use edge detect to count the number of instances that the link entered L0.  Link power states are per link and per direction, so for example the Tx direction could be in one state while Rx was in another.  The phy layer  sometimes leaves L0 for training, which will not be captured by this event.",
         Notes     => "Includes L0p cycles.  To get just L0, subtract TxL0P_POWER_CYCLES",
      },
      "TxL_BYPASSED" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "TXQ Events",
         EvSel     => 0x05,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Tx Flit Buffer Bypassed",
         Defn      => "Counts the number of times that an incoming flit was able to bypass the Tx flit buffer and pass directly out the QPI Link. Generally, when data is transmitted across QPI, it will bypass the TxQ and pass directly to the link.  However, the TxQ will be used with L0p and when LLR occurs, increasing latency to transfer out to the link.",
      },
      "TxL_CYCLES_NE" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "TXQ Events",
         EvSel     => 0x06,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Tx Flit Buffer Cycles not Empty",
         Defn      => "Counts the number of cycles when the TxQ is not empty. Generally, when data is transmitted across QPI, it will bypass the TxQ and pass directly to the link.  However, the TxQ will be used with L0p and when LLR occurs, increasing latency to transfer out to the link.",
      },
      "TxL_FLITS_G0" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "FLITS_TX Events",
         EvSel     => 0x00,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "Flits Transferred - Group 0",
         Defn      => "Counts the number of flits transmitted across the QPI Link.  It includes filters for Idle, protocol, and Data Flits.  Each \"flit\" is made up of 80 bits of information (in addition to some ECC data).  In full-width (L0) mode, flits are made up of four \"fits\", each of which contains 20 bits of data (along with some additional ECC data).   In half-width (L0p) mode, the fits are only 10 bits, and therefore it takes twice as many fits to transmit a flit.  When one talks about QPI \"speed\" (for example, 8.0 GT/s), the \"transfers\" here refer to \"fits\".  Therefore, in L0, the system will transfer 1 \"flit\" at the rate of 1/4th the QPI speed.  One can calculate the bandwidth of the link by taking: flits*80b/time.  Note that this is not the same as \"data\" bandwidth.  For example, when we are transfering a 64B cacheline across QPI, we will break it into 9 flits -- 1 with header information and 8 with 64 bits of actual \"data\" and an additional 16 bits of other information.  To calculate \"data\" bandwidth, one should therefore do: data flits * 8B / time (for L0) or 4B instead of 8B for L0p.",
         Subevents =>
         {
            "DATA" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Data Tx Flits",
               Defn      => "Number of data flits transmitted over QPI.  Each flit contains 64b of data.  This includes both DRS and NCB data flits (coherent and non-coherent).  This can be used to calculate the data bandwidth of the QPI link.  One can get a good picture of the QPI-link characteristics by evaluating the protocol flits, data flits, and idle/null flits.  This does not include the header flits that go in data packets.",
            },
            "NON_DATA" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Non-Data protocol Tx Flits",
               Defn      => "Number of non-NULL non-data flits transmitted across QPI.  This basically tracks the protocol overhead on the QPI link.  One can get a good picture of the QPI-link characteristics by evaluating the protocol flits, data flits, and idle/null flits.  This includes the header flits for data packets.",
            },
         },
      },
      "TxL_FLITS_G1" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "FLITS_TX Events",
         EvSel     => 0x00,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "Flits Transferred - Group 1",
         Defn      => "Counts the number of flits trasmitted across the QPI Link.  This is one of three \"groups\" that allow us to track flits.  It includes filters for SNP, HOM, and DRS message classes.  Each \"flit\" is made up of 80 bits of information (in addition to some ECC data).  In full-width (L0) mode, flits are made up of four \"fits\", each of which contains 20 bits of data (along with some additional ECC data).   In half-width (L0p) mode, the fits are only 10 bits, and therefore it takes twice as many fits to transmit a flit.  When one talks about QPI \"speed\" (for example, 8.0 GT/s), the \"transfers\" here refer to \"fits\".  Therefore, in L0, the system will transfer 1 \"flit\" at the rate of 1/4th the QPI speed.  One can calculate the bandwidth of the link by taking: flits*80b/time.  Note that this is not the same as \"data\" bandwidth.  For example, when we are transfering a 64B cacheline across QPI, we will break it into 9 flits -- 1 with header information and 8 with 64 bits of actual \"data\" and an additional 16 bits of other information.  To calculate \"data\" bandwidth, one should therefore do: data flits * 8B / time.",
         Subevents =>
         {
            "SNP" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "SNP Flits",
               Defn      => "Counts the number of snoop request flits transmitted over QPI.  These requests are contained in the snoop channel.  This does not include snoop responses, which are transmitted on the home channel.",
            },
            "HOM_REQ" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM Request Flits",
               Defn      => "Counts the number of data request transmitted over QPI on the home channel.  This basically counts the number of remote memory requests transmitted over QPI.  In conjunction with the local read count in the Home Agent, one can calculate the number of LLC Misses.",
            },
            "HOM_NONREQ" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM Non-Request Flits",
               Defn      => "Counts the number of non-request flits transmitted over QPI on the home channel.  These are most commonly snoop responses, and this event can be used as a proxy for that.",
            },
            "HOM" =>
            {
               Umask     => "b00000110",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM Flits",
               Defn      => "Counts the number of flits transmitted over QPI on the home channel.",
            },
            "DRS_DATA" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS Data Flits",
               Defn      => "Counts the total number of data flits transmitted over QPI on the DRS (Data Response) channel.  DRS flits are used to transmit data with coherency.  This does not count data flits transmitted over the NCB channel which transmits non-coherent data.  This includes only the data flits (not the header).",
            },
            "DRS_NONDATA" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS Header Flits",
               Defn      => "Counts the total number of protocol flits transmitted over QPI on the DRS (Data Response) channel.  DRS flits are used to transmit data with coherency.  This does not count data flits transmitted over the NCB channel which transmits non-coherent data.  This includes only the header flits (not the data).  This includes extended headers.",
            },
            "DRS" =>
            {
               Umask     => "b00011000",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS Flits (both Header and Data)",
               Defn      => "Counts the total number of flits transmitted over QPI on the DRS (Data Response) channel.  DRS flits are used to transmit data with coherency.",
            },
         },
      },
      "TxL_FLITS_G2" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "FLITS_TX Events",
         EvSel     => 0x01,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "Flits Transferred - Group 2",
         Defn      => "Counts the number of flits trasmitted across the QPI Link.  This is one of three \"groups\" that allow us to track flits.  It includes filters for NDR, NCB, and NCS message classes.  Each \"flit\" is made up of 80 bits of information (in addition to some ECC data).  In full-width (L0) mode, flits are made up of four \"fits\", each of which contains 20 bits of data (along with some additional ECC data).   In half-width (L0p) mode, the fits are only 10 bits, and therefore it takes twice as many fits to transmit a flit.  When one talks about QPI \"speed\" (for example, 8.0 GT/s), the \"transfers\" here refer to \"fits\".  Therefore, in L0, the system will transfer 1 \"flit\" at the rate of 1/4th the QPI speed.  One can calculate the bandwidth of the link by taking: flits*80b/time.  Note that this is not the same as \"data\" bandwidth.  For example, when we are transfering a 64B cacheline across QPI, we will break it into 9 flits -- 1 with header information and 8 with 64 bits of actual \"data\" and an additional 16 bits of other information.  To calculate \"data\" bandwidth, one should therefore do: data flits * 8B / time.",
         Subevents =>
         {
            "NDR_AD" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Non-Data Response Tx Flits - AD",
               Defn      => "Counts the total number of flits transmitted over the NDR (Non-Data Response) channel.  This channel is used to send a variety of protocol flits including grants and completions.  This is only for NDR packets to the local socket which use the AK ring.",
            },
            "NDR_AK" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Non-Data Response Tx Flits - AK",
               Defn      => "Counts the total number of flits transmitted over the NDR (Non-Data Response) channel.  This channel is used to send a variety of protocol flits including grants and completions.  This is only for NDR packets destined for Route-thru to a remote socket.",
            },
            "NCB_DATA" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Non-Coherent data Tx Flits",
               Defn      => "Number of Non-Coherent Bypass data flits.  These flits are generally used to transmit non-coherent data across QPI.  This does not include a count of the DRS (coherent) data flits.  This only counts the data flits, not te NCB headers.",
            },
            "NCB_NONDATA" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Non-Coherent non-data Tx Flits",
               Defn      => "Number of Non-Coherent Bypass non-data flits.  These packets are generally used to transmit non-coherent data across QPI, and the flits counted here are for headers and other non-data flits.  This includes extended headers.",
            },
            "NCB" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Non-Coherent Bypass Tx Flits",
               Defn      => "Number of Non-Coherent Bypass flits.  These packets are generally used to transmit non-coherent data across QPI.",
            },
            "NCS" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "Non-Coherent standard Tx Flits",
               Defn      => "Number of NCS (non-coherent standard) flits transmitted over QPI.    This includes extended headers.",
            },
         },
      },
      "TxL_INSERTS" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "TXQ Events",
         EvSel     => 0x04,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Tx Flit Buffer Allocations",
         Defn      => "Number of allocations into the QPI Tx Flit Buffer.  Generally, when data is transmitted across QPI, it will bypass the TxQ and pass directly to the link.  However, the TxQ will be used with L0p and when LLR occurs, increasing latency to transfer out to the link.  This event can be used in conjunction with the Flit Buffer Occupancy event in order to calculate the average flit buffer lifetime.",
      },
      "TxL_OCCUPANCY" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "TXQ Events",
         EvSel     => 0x07,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Tx Flit Buffer Occupancy",
         Defn      => "Accumulates the number of flits in the TxQ.  Generally, when data is transmitted across QPI, it will bypass the TxQ and pass directly to the link.  However, the TxQ will be used with L0p and when LLR occurs, increasing latency to transfer out to the link. This can be used with the cycles not empty event to track average occupancy, or the allocations event to track average lifetime in the TxQ.",
      },
      "TxR_AD_HOM_CREDIT_ACQUIRED" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "R3QPI_EGRESS_CREDITS Events",
         EvSel     => 0x26,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "R3QPI Egress Credit Occupancy - HOM",
         Defn      => "Number of link layer credits into the R3 (for transactions across the BGF) acquired each cycle. Flow Control FIFO for Home messages on AD.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "TxR_AD_HOM_CREDIT_OCCUPANCY" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "R3QPI_EGRESS_CREDITS Events",
         EvSel     => 0x22,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 28,
         Desc      => "R3QPI Egress Credit Occupancy - AD HOM",
         Defn      => "Occupancy event that tracks the number of link layer credits into the R3 (for transactions across the BGF) available in each cycle.  Flow Control FIFO for HOM messages on AD.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "TxR_AD_NDR_CREDIT_ACQUIRED" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "R3QPI_EGRESS_CREDITS Events",
         EvSel     => 0x28,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "R3QPI Egress Credit Occupancy - AD NDR",
         Defn      => "Number of link layer credits into the R3 (for transactions across the BGF) acquired each cycle.  Flow Control FIFO for NDR messages on AD.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "TxR_AD_NDR_CREDIT_OCCUPANCY" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "R3QPI_EGRESS_CREDITS Events",
         EvSel     => 0x24,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 8,
         Desc      => "R3QPI Egress Credit Occupancy - AD NDR",
         Defn      => "Occupancy event that tracks the number of link layer credits into the R3 (for transactions across the BGF) available in each cycle. Flow Control FIFO  for NDR messages on AD.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "TxR_AD_SNP_CREDIT_ACQUIRED" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "R3QPI_EGRESS_CREDITS Events",
         EvSel     => 0x27,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "R3QPI Egress Credit Occupancy - SNP",
         Defn      => "Number of link layer credits into the R3 (for transactions across the BGF) acquired each cycle.  Flow Control FIFO for Snoop messages on AD.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "TxR_AD_SNP_CREDIT_OCCUPANCY" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "R3QPI_EGRESS_CREDITS Events",
         EvSel     => 0x23,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 28,
         Desc      => "R3QPI Egress Credit Occupancy - AD SNP",
         Defn      => "Occupancy event that tracks the number of link layer credits into the R3 (for transactions across the BGF) available in each cycle.  Flow Control FIFO fro Snoop messages on AD.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "TxR_AK_NDR_CREDIT_ACQUIRED" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "R3QPI_EGRESS_CREDITS Events",
         EvSel     => 0x29,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "R3QPI Egress Credit Occupancy - AK NDR",
         Defn      => "Number of credits into the R3 (for transactions across the BGF) acquired each cycle. Local NDR message class to AK Egress.",
      },
      "TxR_AK_NDR_CREDIT_OCCUPANCY" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "R3QPI_EGRESS_CREDITS Events",
         EvSel     => 0x25,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 6,
         Desc      => "R3QPI Egress Credit Occupancy - AK NDR",
         Defn      => "Occupancy event that tracks the number of credits into the R3 (for transactions across the BGF) available in each cycle.  Local NDR message class to AK Egress.",
      },
      "TxR_BL_DRS_CREDIT_ACQUIRED" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "R3QPI_EGRESS_CREDITS Events",
         EvSel     => 0x2A,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "R3QPI Egress Credit Occupancy - DRS",
         Defn      => "Number of credits into the R3 (for transactions across the BGF) acquired each cycle. DRS message class to BL Egress.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
            "VN_SHR" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "for Shared VN",
               Defn      => "",
            },
         },
      },
      "TxR_BL_DRS_CREDIT_OCCUPANCY" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "R3QPI_EGRESS_CREDITS Events",
         EvSel     => 0x1F,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 8,
         Desc      => "R3QPI Egress Credit Occupancy - BL DRS",
         Defn      => "Occupancy event that tracks the number of credits into the R3 (for transactions across the BGF) available in each cycle.  DRS message class to BL Egress.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
            "VN_SHR" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "for Shared VN",
               Defn      => "",
            },
         },
      },
      "TxR_BL_NCB_CREDIT_ACQUIRED" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "R3QPI_EGRESS_CREDITS Events",
         EvSel     => 0x2B,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "R3QPI Egress Credit Occupancy - NCB",
         Defn      => "Number of credits into the R3 (for transactions across the BGF) acquired each cycle. NCB message class to BL Egress.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "TxR_BL_NCB_CREDIT_OCCUPANCY" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "R3QPI_EGRESS_CREDITS Events",
         EvSel     => 0x20,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 2,
         Desc      => "R3QPI Egress Credit Occupancy - BL NCB",
         Defn      => "Occupancy event that tracks the number of credits into the R3 (for transactions across the BGF) available in each cycle.  NCB message class to BL Egress.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "TxR_BL_NCS_CREDIT_ACQUIRED" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "R3QPI_EGRESS_CREDITS Events",
         EvSel     => 0x2C,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "R3QPI Egress Credit Occupancy - NCS",
         Defn      => "Number of credits into the R3 (for transactions across the BGF) acquired each cycle. NCS message class to BL Egress.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "TxR_BL_NCS_CREDIT_OCCUPANCY" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "R3QPI_EGRESS_CREDITS Events",
         EvSel     => 0x21,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 2,
         Desc      => "R3QPI Egress Credit Occupancy - BL NCS",
         Defn      => "Occupancy event that tracks the number of credits into the R3 (for transactions across the BGF) available in each cycle.  NCS message class to BL Egress.",
         Subevents =>
         {
            "VN0" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN0",
               Defn      => "",
            },
            "VN1" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "for VN1",
               Defn      => "",
            },
         },
      },
      "VNA_CREDIT_RETURNS" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "VNA_CREDIT_RETURN Events",
         EvSel     => 0x1C,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "VNA Credits Returned",
         Defn      => "Number of VNA credits returned.",
      },
      "VNA_CREDIT_RETURN_OCCUPANCY" =>
      {
         Box       => "QPI LL Box Events",
         Category  => "VNA_CREDIT_RETURN Events",
         EvSel     => 0x1B,
         Counters  => "0-3",
         Internal  => 1,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 128,
         Desc      => "VNA Credits Pending Return - Occupancy",
         Defn      => "Number of VNA credits in the Rx side that are waitng to be returned back across the link.",
      },
   },
   "R2PCIe Box Events" =>
   {
      "CLOCKTICKS" =>
      {
         Box       => "R2PCIe Box Events",
         Category  => "UCLK Events",
         EvSel     => 0x01,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Number of uclks in domain",
         Defn      => "Counts the number of uclks in the R2PCIe uclk domain.  This could be slightly different than the count in the Ubox because of enable/freeze delays.  However, because the R2PCIe is close to the Ubox, they generally should not diverge by more than a handful of cycles.",
      },
      "IIO_CREDIT" =>
      {
         Box       => "R2PCIe Box Events",
         Category  => "IIO Credit Events",
         EvSel     => 0x2D,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 4,
         Desc      => "",
         Defn      => "",
         Subevents =>
         {
            "PRQ_QPI0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
            "PRQ_QPI1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
            "ISOCH_QPI0" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
            "ISOCH_QPI1" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
         },
      },
      "RING_AD_USED" =>
      {
         Box       => "R2PCIe Box Events",
         Category  => "RING Events",
         EvSel     => 0x07,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "R2 AD Ring in Use",
         Defn      => "Counts the number of cycles that the AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.",
         Notes     => "In any cycle, a ring stop can see up to one packet moving in the CW direction and one packet moving in the CCW direction.",
         Subevents =>
         {
            "CW_EVEN" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Even",
               Defn      => "Filters for the Clockwise and Even ring polarity.",
            },
            "CW_ODD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Odd",
               Defn      => "Filters for the Clockwise and Odd ring polarity.",
            },
            "CCW_EVEN" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Even",
               Defn      => "Filters for the Counterclockwise and Even ring polarity.",
            },
            "CCW_ODD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Odd",
               Defn      => "Filters for the Counterclockwise and Odd ring polarity.",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise",
               Defn      => "",
            },
            "CCW" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "",
            },
         },
      },
      "RING_AK_BOUNCES" =>
      {
         Box       => "R2PCIe Box Events",
         Category  => "RING Events",
         EvSel     => 0x12,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "AK Ingress Bounced",
         Defn      => "Counts the number of times when a request destined for the AK ingress bounced.",
         Subevents =>
         {
            "UP" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Up",
               Defn      => "",
            },
            "DN" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Dn",
               Defn      => "",
            },
         },
      },
      "RING_AK_USED" =>
      {
         Box       => "R2PCIe Box Events",
         Category  => "RING Events",
         EvSel     => 0x08,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "R2 AK Ring in Use",
         Defn      => "Counts the number of cycles that the AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.",
         Notes     => "In any cycle, a ring stop can see up to one packet moving in the CW direction and one packet moving in the CCW direction.",
         Subevents =>
         {
            "CW_EVEN" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Even",
               Defn      => "Filters for the Clockwise and Even ring polarity.",
            },
            "CW_ODD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Odd",
               Defn      => "Filters for the Clockwise and Odd ring polarity.",
            },
            "CCW_EVEN" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Even",
               Defn      => "Filters for the Counterclockwise and Even ring polarity.",
            },
            "CCW_ODD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Odd",
               Defn      => "Filters for the Counterclockwise and Odd ring polarity.",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise",
               Defn      => "",
            },
            "CCW" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "",
            },
         },
      },
      "RING_BL_USED" =>
      {
         Box       => "R2PCIe Box Events",
         Category  => "RING Events",
         EvSel     => 0x09,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "R2 BL Ring in Use",
         Defn      => "Counts the number of cycles that the BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.",
         Notes     => "In any cycle, a ring stop can see up to one packet moving in the CW direction and one packet moving in the CCW direction.",
         Subevents =>
         {
            "CW_EVEN" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Even",
               Defn      => "Filters for the Clockwise and Even ring polarity.",
            },
            "CW_ODD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Odd",
               Defn      => "Filters for the Clockwise and Odd ring polarity.",
            },
            "CCW_EVEN" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Even",
               Defn      => "Filters for the Counterclockwise and Even ring polarity.",
            },
            "CCW_ODD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Odd",
               Defn      => "Filters for the Counterclockwise and Odd ring polarity.",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise",
               Defn      => "",
            },
            "CCW" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "",
            },
         },
      },
      "RING_IV_USED" =>
      {
         Box       => "R2PCIe Box Events",
         Category  => "RING Events",
         EvSel     => 0x0A,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "R2 IV Ring in Use",
         Defn      => "Counts the number of cycles that the IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sent, but does not include when packets are being sunk into the ring stop.",
         Notes     => "IV messages are split into two parts.  In any cycle, a ring stop can see up to one (half-)packet moving in the CW direction and one (half-)packet moving in the CCW direction.",
         Subevents =>
         {
            "CW" =>
            {
               Umask     => "b00110011",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise",
               Defn      => "Filters for Clockwise polarity",
            },
            "CCW" =>
            {
               Umask     => "b11001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise",
               Defn      => "Filters for Counterclockwise polarity",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise",
               Defn      => "",
            },
            "CCW" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise",
               Defn      => "",
            },
            "ANY" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "Any",
               Defn      => "",
            },
         },
      },
      "RxR_CYCLES_NE" =>
      {
         Box       => "R2PCIe Box Events",
         Category  => "INGRESS Events",
         EvSel     => 0x10,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Ingress Cycles Not Empty",
         Defn      => "Counts the number of cycles when the R2PCIe Ingress is not empty.  This tracks one of the three rings that are used by the R2PCIe agent.  This can be used in conjunction with the R2PCIe Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple ingress buffers can be tracked at a given time using multiple counters.",
         Subevents =>
         {
            "NCB" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCB",
               Defn      => "NCB Ingress Queue",
            },
            "NCS" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCS",
               Defn      => "NCS Ingress Queue",
            },
         },
      },
      "RxR_INSERTS" =>
      {
         Box       => "R2PCIe Box Events",
         Category  => "INGRESS Events",
         EvSel     => 0x11,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Ingress Allocations",
         Defn      => "Counts the number of allocations into the R2PCIe Ingress.  This tracks one of the three rings that are used by the R2PCIe agent.  This can be used in conjunction with the R2PCIe Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters.",
         Subevents =>
         {
            "NCB" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCB",
               Defn      => "NCB Ingress Queue",
            },
            "NCS" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCS",
               Defn      => "NCS Ingress Queue",
            },
         },
      },
      "RxR_OCCUPANCY" =>
      {
         Box       => "R2PCIe Box Events",
         Category  => "INGRESS Events",
         EvSel     => 0x13,
         Counters  => "0",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 24,
         Desc      => "Ingress Occupancy Accumulator",
         Defn      => "Accumulates the occupancy of a given R2PCIe Ingress queue in each cycles.  This tracks one of the three ring Ingress buffers.  This can be used with the R2PCIe Ingress Not Empty event to calculate average occupancy or the R2PCIe Ingress Allocations event in order to calculate average queuing latency.",
         Subevents =>
         {
            "DRS" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS",
               Defn      => "DRS Ingress Queue",
            },
         },
      },
      "SBO0_CREDITS_ACQUIRED" =>
      {
         Box       => "R2PCIe Box Events",
         Category  => "SBO Credit Events",
         EvSel     => 0x28,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "SBo0 Credits Acquired",
         Defn      => "Number of Sbo 0 credits acquired in a given cycle, per ring.",
         Subevents =>
         {
            "AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "For AD Ring",
               Defn      => "",
            },
            "BL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "For BL Ring",
               Defn      => "",
            },
         },
      },
      "STALL_NO_SBO_CREDIT" =>
      {
         Box       => "R2PCIe Box Events",
         Category  => "SBO Credit Events",
         EvSel     => 0x2C,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 4,
         Desc      => "Stall on No Sbo Credits",
         Defn      => "Number of cycles Egress is stalled waiting for an Sbo credit to become available.  Per Sbo, per Ring.",
         Subevents =>
         {
            "SBO0_AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "For SBo0, AD Ring",
               Defn      => "",
            },
            "SBO1_AD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "For SBo1, AD Ring",
               Defn      => "",
            },
            "SBO0_BL" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "For SBo0, BL Ring",
               Defn      => "",
            },
            "SBO1_BL" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "For SBo1, BL Ring",
               Defn      => "",
            },
         },
      },
      "TxR_CYCLES_FULL" =>
      {
         Box       => "R2PCIe Box Events",
         Category  => "EGRESS Events",
         EvSel     => 0x25,
         Counters  => "0",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Egress Cycles Full",
         Defn      => "Counts the number of cycles when the R2PCIe Egress buffer is full.",
         Subevents =>
         {
            "AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "AD",
               Defn      => "AD Egress Queue",
            },
            "AK" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "AK",
               Defn      => "AK Egress Queue",
            },
            "BL" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL",
               Defn      => "BL Egress Queue",
            },
         },
      },
      "TxR_CYCLES_NE" =>
      {
         Box       => "R2PCIe Box Events",
         Category  => "EGRESS Events",
         EvSel     => 0x23,
         Counters  => "0",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Egress Cycles Not Empty",
         Defn      => "Counts the number of cycles when the R2PCIe Egress is not empty.  This tracks one of the three rings that are used by the R2PCIe agent.  This can be used in conjunction with the R2PCIe Egress Occupancy Accumulator event in order to calculate average queue occupancy.  Only a single Egress queue can be tracked at any given time.  It is not possible to filter based on direction or polarity.",
         Subevents =>
         {
            "AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "AD",
               Defn      => "AD Egress Queue",
            },
            "AK" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "AK",
               Defn      => "AK Egress Queue",
            },
            "BL" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL",
               Defn      => "BL Egress Queue",
            },
         },
      },
      "TxR_NACK_CW" =>
      {
         Box       => "R2PCIe Box Events",
         Category  => "EGRESS Events",
         EvSel     => 0x26,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Egress CCW NACK",
         Defn      => "",
         Subevents =>
         {
            "DN_AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "AD CCW",
               Defn      => "AD CounterClockwise Egress Queue",
            },
            "DN_BL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "BL CCW",
               Defn      => "BL CounterClockwise Egress Queue",
            },
            "DN_AK" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "AK CCW",
               Defn      => "AK CounterClockwise Egress Queue",
            },
            "UP_AD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "AK CCW",
               Defn      => "BL CounterClockwise Egress Queue",
            },
            "UP_BL" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL CCW",
               Defn      => "AD CounterClockwise Egress Queue",
            },
            "UP_AK" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL CW",
               Defn      => "AD Clockwise Egress Queue",
            },
         },
      },
   },
   "R3QPI Box Events" =>
   {
      "CLOCKTICKS" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "UCLK Events",
         EvSel     => 0x01,
         Counters  => "0-2",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 0,
         Desc      => "Number of uclks in domain",
         Defn      => "Counts the number of uclks in the QPI uclk domain.  This could be slightly different than the count in the Ubox because of enable/freeze delays.  However, because the QPI Agent is close to the Ubox, they generally should not diverge by more than a handful of cycles.",
      },
      "C_HI_AD_CREDITS_EMPTY" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "EGRESS Credit Events",
         EvSel     => 0x1F,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "CBox AD Credits Empty",
         Defn      => "No credits available to send to Cbox on the AD Ring (covers higher CBoxes)",
         Subevents =>
         {
            "CBO8" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "Cbox 8",
            },
            "CBO9" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "Cbox 9",
            },
            "CBO10" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "Cbox 10",
            },
            "CBO11" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "Cbox 11",
            },
            "CBO12" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "Cbox 12",
            },
            "CBO13" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "Cbox 13",
            },
            "CBO14_16" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "Cbox 14&16",
            },
            "CBO_15_17" =>
            {
               Umask     => "b1xxxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "Cbox 15&17",
            },
         },
      },
      "C_LO_AD_CREDITS_EMPTY" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "EGRESS Credit Events",
         EvSel     => 0x22,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "CBox AD Credits Empty",
         Defn      => "No credits available to send to Cbox on the AD Ring (covers lower CBoxes)",
         Subevents =>
         {
            "CBO0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "Cbox 0",
            },
            "CBO1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "Cbox 1",
            },
            "CBO2" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "Cbox 2",
            },
            "CBO3" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "Cbox 3",
            },
            "CBO4" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "Cbox 4",
            },
            "CBO5" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "Cbox 5",
            },
            "CBO6" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "Cbox 6",
            },
            "CBO7" =>
            {
               Umask     => "b1xxxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "Cbox 7",
            },
         },
      },
      "HA_R2_BL_CREDITS_EMPTY" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "EGRESS Credit Events",
         EvSel     => 0x2D,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "HA/R2 AD Credits Empty",
         Defn      => "No credits available to send to either HA or R2 on the BL Ring",
         Notes     => "Counter 0 counts lack of credits to the lesser numbered Cboxes (0-8)  Counter 1 counts lack of credits to Cbox to the higher numbered CBoxes (8-13,15+17,16+18)",
         Subevents =>
         {
            "HA0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "HA0",
            },
            "HA1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "HA1",
            },
            "R2_NCB" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "R2 NCB Messages",
            },
            "R2_NCS" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "R2 NCS Messages",
            },
         },
      },
      "QPI0_AD_CREDITS_EMPTY" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "EGRESS Credit Events",
         EvSel     => 0x20,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "QPI0 AD Credits Empty",
         Defn      => "No credits available to send to QPI0 on the AD Ring",
         Subevents =>
         {
            "VNA" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VNA",
            },
            "VN0_HOM" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN0 HOM Messages",
            },
            "VN0_SNP" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN0 SNP Messages",
            },
            "VN0_NDR" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN0 NDR Messages",
            },
            "VN1_HOM" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN1 HOM Messages",
            },
            "VN1_SNP" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN1 SNP Messages",
            },
            "VN1_NDR" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN1 NDR Messages",
            },
         },
      },
      "QPI0_BL_CREDITS_EMPTY" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "EGRESS Credit Events",
         EvSel     => 0x21,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "QPI0 BL Credits Empty",
         Defn      => "No credits available to send to QPI0 on the BL Ring",
         Subevents =>
         {
            "VNA" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VNA",
            },
            "VN1_HOM" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN1 HOM Messages",
            },
            "VN1_SNP" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN1 SNP Messages",
            },
            "VN1_NDR" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN1 NDR Messages",
            },
         },
      },
      "QPI1_AD_CREDITS_EMPTY" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "EGRESS Credit Events",
         EvSel     => 0x2E,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "QPI1 AD Credits Empty",
         Defn      => "No credits available to send to QPI1 on the AD Ring",
         Subevents =>
         {
            "VNA" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VNA",
            },
            "VN1_HOM" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN1 HOM Messages",
            },
            "VN1_SNP" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN1 SNP Messages",
            },
            "VN1_NDR" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN1 NDR Messages",
            },
         },
      },
      "QPI1_BL_CREDITS_EMPTY" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "EGRESS Credit Events",
         EvSel     => 0x2F,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "QPI1 BL Credits Empty",
         Defn      => "No credits available to send to QPI1 on the BL Ring",
         Subevents =>
         {
            "VNA" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VNA",
            },
            "VN0_HOM" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN0 HOM Messages",
            },
            "VN0_SNP" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN0 SNP Messages",
            },
            "VN0_NDR" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN0 NDR Messages",
            },
            "VN1_HOM" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN1 HOM Messages",
            },
            "VN1_SNP" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN1 SNP Messages",
            },
            "VN1_NDR" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "VN1 NDR Messages",
            },
         },
      },
      "RING_AD_USED" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "RING Events",
         EvSel     => 0x07,
         Counters  => "0-2",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "R3 AD Ring in Use",
         Defn      => "Counts the number of cycles that the AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.",
         Notes     => "In any cycle, a ring stop can see up to one packet moving in the CW direction and one packet moving in the CCW direction.",
         Subevents =>
         {
            "CW_EVEN" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Even",
               Defn      => "Filters for the Clockwise and Even ring polarity.",
            },
            "CW_ODD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Odd",
               Defn      => "Filters for the Clockwise and Odd ring polarity.",
            },
            "CCW_EVEN" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Even",
               Defn      => "Filters for the Counterclockwise and Even ring polarity.",
            },
            "CCW_ODD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Odd",
               Defn      => "Filters for the Counterclockwise and Odd ring polarity.",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise",
               Defn      => "",
            },
            "CCW" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "",
            },
         },
      },
      "RING_AK_USED" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "RING Events",
         EvSel     => 0x08,
         Counters  => "0-2",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "R3 AK Ring in Use",
         Defn      => "Counts the number of cycles that the AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.",
         Notes     => "In any cycle, a ring stop can see up to one packet moving in the CW direction and one packet moving in the CCW direction.",
         Subevents =>
         {
            "CW_EVEN" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Even",
               Defn      => "Filters for the Clockwise and Even ring polarity.",
            },
            "CW_ODD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Odd",
               Defn      => "Filters for the Clockwise and Odd ring polarity.",
            },
            "CCW_EVEN" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Even",
               Defn      => "Filters for the Counterclockwise and Even ring polarity.",
            },
            "CCW_ODD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Odd",
               Defn      => "Filters for the Counterclockwise and Odd ring polarity.",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise",
               Defn      => "",
            },
            "CCW" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "",
            },
         },
      },
      "RING_BL_USED" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "RING Events",
         EvSel     => 0x09,
         Counters  => "0-2",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "R3 BL Ring in Use",
         Defn      => "Counts the number of cycles that the BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sunk, but does not include when packets are being sent from the ring stop.",
         Notes     => "In any cycle, a ring stop can see up to one packet moving in the CW direction and one packet moving in the CCW direction.",
         Subevents =>
         {
            "CW_EVEN" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Even",
               Defn      => "Filters for the Clockwise and Even ring polarity.",
            },
            "CW_ODD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise and Odd",
               Defn      => "Filters for the Clockwise and Odd ring polarity.",
            },
            "CCW_EVEN" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Even",
               Defn      => "Filters for the Counterclockwise and Even ring polarity.",
            },
            "CCW_ODD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise and Odd",
               Defn      => "Filters for the Counterclockwise and Odd ring polarity.",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise",
               Defn      => "",
            },
            "CCW" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "",
            },
         },
      },
      "RING_IV_USED" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "RING Events",
         EvSel     => 0x0A,
         Counters  => "0-2",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "R3 IV Ring in Use",
         Defn      => "Counts the number of cycles that the IV ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sent, but does not include when packets are being sunk into the ring stop.",
         Notes     => "IV messages are split into two parts.  In any cycle, a ring stop can see up to one (half-)packet moving in the CW direction and one (half-)packet moving in the CCW direction.",
         Subevents =>
         {
            "CW" =>
            {
               Umask     => "b00110011",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise",
               Defn      => "Filters for Clockwise polarity",
            },
            "CCW" =>
            {
               Umask     => "b11001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise",
               Defn      => "Filters for Counterclockwise polarity",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise",
               Defn      => "",
            },
            "ANY" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "Any",
               Defn      => "",
            },
         },
      },
      "RING_SINK_STARVED" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "RING Events",
         EvSel     => 0x0E,
         Counters  => "0-2",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "Ring Stop Starved",
         Defn      => "Number of cycles the ringstop is in starvation (per ring)",
         Subevents =>
         {
            "AK" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "AK",
               Defn      => "",
            },
         },
      },
      "RxR_CYCLES_NE" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "INGRESS Events",
         EvSel     => 0x10,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Ingress Cycles Not Empty",
         Defn      => "Counts the number of cycles when the QPI Ingress is not empty.  This tracks one of the three rings that are used by the QPI agent.  This can be used in conjunction with the QPI Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple ingress buffers can be tracked at a given time using multiple counters.",
         Subevents =>
         {
            "HOM" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM",
               Defn      => "HOM Ingress Queue",
            },
            "SNP" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "SNP",
               Defn      => "SNP Ingress Queue",
            },
            "NDR" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "NDR",
               Defn      => "NDR Ingress Queue",
            },
         },
      },
      "RxR_CYCLES_NE_VN1" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "INGRESS Events",
         EvSel     => 0x14,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "VN1 Ingress Cycles Not Empty",
         Defn      => "Counts the number of cycles when the QPI VN1  Ingress is not empty.  This tracks one of the three rings that are used by the QPI agent.  This can be used in conjunction with the QPI VN1  Ingress Occupancy Accumulator event in order to calculate average queue occupancy.  Multiple ingress buffers can be tracked at a given time using multiple counters.",
         Subevents =>
         {
            "HOM" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM",
               Defn      => "HOM Ingress Queue",
            },
            "SNP" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "SNP",
               Defn      => "SNP Ingress Queue",
            },
            "NDR" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "NDR",
               Defn      => "NDR Ingress Queue",
            },
            "DRS" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS",
               Defn      => "DRS Ingress Queue",
            },
            "NCB" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCB",
               Defn      => "NCB Ingress Queue",
            },
            "NCS" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCS",
               Defn      => "NCS Ingress Queue",
            },
         },
      },
      "RxR_INSERTS" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "INGRESS Events",
         EvSel     => 0x11,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Ingress Allocations",
         Defn      => "Counts the number of allocations into the QPI Ingress.  This tracks one of the three rings that are used by the QPI agent.  This can be used in conjunction with the QPI Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters.",
         Subevents =>
         {
            "HOM" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM",
               Defn      => "HOM Ingress Queue",
            },
            "SNP" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "SNP",
               Defn      => "SNP Ingress Queue",
            },
            "NDR" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "NDR",
               Defn      => "NDR Ingress Queue",
            },
            "DRS" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS",
               Defn      => "DRS Ingress Queue",
            },
            "NCB" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCB",
               Defn      => "NCB Ingress Queue",
            },
            "NCS" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCS",
               Defn      => "NCS Ingress Queue",
            },
         },
      },
      "RxR_INSERTS_VN1" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "INGRESS Events",
         EvSel     => 0x15,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "VN1 Ingress Allocations",
         Defn      => "Counts the number of allocations into the QPI VN1  Ingress.  This tracks one of the three rings that are used by the QPI agent.  This can be used in conjunction with the QPI VN1  Ingress Occupancy Accumulator event in order to calculate average queue latency.  Multiple ingress buffers can be tracked at a given time using multiple counters.",
         Subevents =>
         {
            "HOM" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM",
               Defn      => "HOM Ingress Queue",
            },
            "SNP" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "SNP",
               Defn      => "SNP Ingress Queue",
            },
            "NDR" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "NDR",
               Defn      => "NDR Ingress Queue",
            },
            "DRS" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS",
               Defn      => "DRS Ingress Queue",
            },
            "NCB" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCB",
               Defn      => "NCB Ingress Queue",
            },
            "NCS" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCS",
               Defn      => "NCS Ingress Queue",
            },
         },
      },
      "RxR_OCCUPANCY_VN1" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "INGRESS Events",
         EvSel     => 0x13,
         Counters  => "0",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 32,
         Desc      => "VN1 Ingress Occupancy Accumulator",
         Defn      => "Accumulates the occupancy of a given QPI VN1  Ingress queue in each cycles.  This tracks one of the three ring Ingress buffers.  This can be used with the QPI VN1  Ingress Not Empty event to calculate average occupancy or the QPI VN1  Ingress Allocations event in order to calculate average queuing latency.",
         Notes     => "Supposed to be 0x16",
         Subevents =>
         {
            "HOM" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM",
               Defn      => "HOM Ingress Queue",
            },
            "SNP" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "SNP",
               Defn      => "SNP Ingress Queue",
            },
            "NDR" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "NDR",
               Defn      => "NDR Ingress Queue",
            },
            "DRS" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS",
               Defn      => "DRS Ingress Queue",
            },
            "NCB" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCB",
               Defn      => "NCB Ingress Queue",
            },
            "NCS" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCS",
               Defn      => "NCS Ingress Queue",
            },
         },
      },
      "SBO0_CREDITS_ACQUIRED" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "SBO Credit Events",
         EvSel     => 0x28,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "SBo0 Credits Acquired",
         Defn      => "Number of Sbo 0 credits acquired in a given cycle, per ring.",
         Subevents =>
         {
            "AD" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "For AD Ring",
               Defn      => "",
            },
            "BL" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "For BL Ring",
               Defn      => "",
            },
         },
      },
      "SBO1_CREDITS_ACQUIRED" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "SBO Credit Events",
         EvSel     => 0x29,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "SBo1 Credits Acquired",
         Defn      => "Number of Sbo 1 credits acquired in a given cycle, per ring.",
         Subevents =>
         {
            "AD" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "For AD Ring",
               Defn      => "",
            },
            "BL" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "For BL Ring",
               Defn      => "",
            },
         },
      },
      "STALL_NO_SBO_CREDIT" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "SBO Credit Events",
         EvSel     => 0x2C,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 4,
         Desc      => "Stall on No Sbo Credits",
         Defn      => "Number of cycles Egress is stalled waiting for an Sbo credit to become available.  Per Sbo, per Ring.",
         Subevents =>
         {
            "SBO0_AD" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "For SBo0, AD Ring",
               Defn      => "",
            },
            "SBO1_AD" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "For SBo1, AD Ring",
               Defn      => "",
            },
            "SBO0_BL" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "For SBo0, BL Ring",
               Defn      => "",
            },
            "SBO1_BL" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "For SBo1, BL Ring",
               Defn      => "",
            },
         },
      },
      "TxR_NACK" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "EGRESS Events",
         EvSel     => 0x26,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Egress CCW NACK",
         Defn      => "",
         Subevents =>
         {
            "DN_AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "AD CCW",
               Defn      => "AD CounterClockwise Egress Queue",
            },
            "DN_BL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "BL CCW",
               Defn      => "BL CounterClockwise Egress Queue",
            },
            "DN_AK" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "AK CCW",
               Defn      => "AK CounterClockwise Egress Queue",
            },
            "UP_AD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "AK CCW",
               Defn      => "BL CounterClockwise Egress Queue",
            },
            "UP_BL" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL CCW",
               Defn      => "AD CounterClockwise Egress Queue",
            },
            "UP_AK" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL CW",
               Defn      => "AD Clockwise Egress Queue",
            },
         },
      },
      "VN0_CREDITS_REJECT" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "LINK_VN0_CREDITS Events",
         EvSel     => 0x37,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "VN0 Credit Acquisition Failed on DRS",
         Defn      => "Number of times a request failed to acquire a DRS VN0 credit.  In order for a request to be transferred across QPI, it must be guaranteed to have a flit buffer on the remote socket to sink into.  There are two credit pools, VNA and VN0.  VNA is a shared pool used to achieve high performance.  The VN0 pool has reserved entries for each message class and is used to prevent deadlock.  Requests first attempt to acquire a VNA credit, and then fall back to VN0 if they fail.  This therefore counts the number of times when a request failed to acquire either a VNA or VN0 credit and is delayed.  This should generally be a rare situation.",
         Subevents =>
         {
            "HOM" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM Message Class",
               Defn      => "Filter for the Home (HOM) message class.  HOM is generally used to send requests, request responses, and snoop responses.",
            },
            "SNP" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "SNP Message Class",
               Defn      => "Filter for Snoop (SNP) message class.  SNP is used for outgoing snoops.  Note that snoop responses flow on the HOM message class.",
            },
            "NDR" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "NDR Message Class",
               Defn      => "NDR packets are used to transmit a variety of protocol flits including grants and completions (CMP).",
            },
            "DRS" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS Message Class",
               Defn      => "Filter for Data Response (DRS).  DRS is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using DRS.",
            },
            "NCB" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCB Message Class",
               Defn      => "Filter for Non-Coherent Broadcast (NCB).  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.",
            },
            "NCS" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCS Message Class",
               Defn      => "Filter for Non-Coherent Standard (NCS).  NCS is commonly used for ",
            },
         },
      },
      "VN0_CREDITS_USED" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "LINK_VN0_CREDITS Events",
         EvSel     => 0x36,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "VN0 Credit Used",
         Defn      => "Number of times a VN0 credit was used on the DRS message channel.  In order for a request to be transferred across QPI, it must be guaranteed to have a flit buffer on the remote socket to sink into.  There are two credit pools, VNA and VN0.  VNA is a shared pool used to achieve high performance.  The VN0 pool has reserved entries for each message class and is used to prevent deadlock.  Requests first attempt to acquire a VNA credit, and then fall back to VN0 if they fail.  This counts the number of times a VN0 credit was used.  Note that a single VN0 credit holds access to potentially multiple flit buffers.  For example, a transfer that uses VNA could use 9 flit buffers and in that case uses 9 credits.  A transfer on VN0 will only count a single credit even though it may use multiple buffers.",
         Subevents =>
         {
            "HOM" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM Message Class",
               Defn      => "Filter for the Home (HOM) message class.  HOM is generally used to send requests, request responses, and snoop responses.",
            },
            "SNP" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "SNP Message Class",
               Defn      => "Filter for Snoop (SNP) message class.  SNP is used for outgoing snoops.  Note that snoop responses flow on the HOM message class.",
            },
            "NDR" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "NDR Message Class",
               Defn      => "NDR packets are used to transmit a variety of protocol flits including grants and completions (CMP).",
            },
            "DRS" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS Message Class",
               Defn      => "Filter for Data Response (DRS).  DRS is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using DRS.",
            },
            "NCB" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCB Message Class",
               Defn      => "Filter for Non-Coherent Broadcast (NCB).  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.",
            },
            "NCS" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCS Message Class",
               Defn      => "Filter for Non-Coherent Standard (NCS).  NCS is commonly used for ",
            },
         },
      },
      "VN1_CREDITS_REJECT" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "LINK_VN1_CREDITS Events",
         EvSel     => 0x39,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "VN1 Credit Acquisition Failed on DRS",
         Defn      => "Number of times a request failed to acquire a VN1 credit.  In order for a request to be transferred across QPI, it must be guaranteed to have a flit buffer on the remote socket to sink into.  There are two credit pools, VNA and VN1.  VNA is a shared pool used to achieve high performance.  The VN1 pool has reserved entries for each message class and is used to prevent deadlock.  Requests first attempt to acquire a VNA credit, and then fall back to VN1 if they fail.  This therefore counts the number of times when a request failed to acquire either a VNA or VN1 credit and is delayed.  This should generally be a rare situation.",
         Subevents =>
         {
            "HOM" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM Message Class",
               Defn      => "Filter for the Home (HOM) message class.  HOM is generally used to send requests, request responses, and snoop responses.",
            },
            "SNP" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "SNP Message Class",
               Defn      => "Filter for Snoop (SNP) message class.  SNP is used for outgoing snoops.  Note that snoop responses flow on the HOM message class.",
            },
            "NDR" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "NDR Message Class",
               Defn      => "NDR packets are used to transmit a variety of protocol flits including grants and completions (CMP).",
            },
            "DRS" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS Message Class",
               Defn      => "Filter for Data Response (DRS).  DRS is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using DRS.",
            },
            "NCB" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCB Message Class",
               Defn      => "Filter for Non-Coherent Broadcast (NCB).  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.",
            },
            "NCS" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCS Message Class",
               Defn      => "Filter for Non-Coherent Standard (NCS).  NCS is commonly used for ",
            },
         },
      },
      "VN1_CREDITS_USED" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "LINK_VN1_CREDITS Events",
         EvSel     => 0x38,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "VN1 Credit Used",
         Defn      => "Number of times a VN1 credit was used on the DRS message channel.  In order for a request to be transferred across QPI, it must be guaranteed to have a flit buffer on the remote socket to sink into.  There are two credit pools, VNA and VN1.  VNA is a shared pool used to achieve high performance.  The VN1 pool has reserved entries for each message class and is used to prevent deadlock.  Requests first attempt to acquire a VNA credit, and then fall back to VN1 if they fail.  This counts the number of times a VN1 credit was used.  Note that a single VN1 credit holds access to potentially multiple flit buffers.  For example, a transfer that uses VNA could use 9 flit buffers and in that case uses 9 credits.  A transfer on VN1 will only count a single credit even though it may use multiple buffers.",
         Subevents =>
         {
            "HOM" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM Message Class",
               Defn      => "Filter for the Home (HOM) message class.  HOM is generally used to send requests, request responses, and snoop responses.",
            },
            "SNP" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "SNP Message Class",
               Defn      => "Filter for Snoop (SNP) message class.  SNP is used for outgoing snoops.  Note that snoop responses flow on the HOM message class.",
            },
            "NDR" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "NDR Message Class",
               Defn      => "NDR packets are used to transmit a variety of protocol flits including grants and completions (CMP).",
            },
            "DRS" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS Message Class",
               Defn      => "Filter for Data Response (DRS).  DRS is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using DRS.",
            },
            "NCB" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCB Message Class",
               Defn      => "Filter for Non-Coherent Broadcast (NCB).  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.",
            },
            "NCS" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCS Message Class",
               Defn      => "Filter for Non-Coherent Standard (NCS).  NCS is commonly used for ",
            },
         },
      },
      "VNA_CREDITS_ACQUIRED" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "LINK_VNA_CREDITS Events",
         EvSel     => 0x33,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 4,
         Desc      => "VNA credit Acquisitions",
         Defn      => "Number of QPI VNA Credit acquisitions.  This event can be used in conjunction with the VNA In-Use Accumulator to calculate the average lifetime of a credit holder.  VNA credits are used by all message classes in order to communicate across QPI.  If a packet is unable to acquire credits, it will then attempt to use credts from the VN0 pool.  Note that a single packet may require multiple flit buffers (i.e. when data is being transfered).  Therefore, this event will increment by the number of credits acquired in each cycle.  Filtering based on message class is not provided.  One can count the number of packets transfered in a given message class using an qfclk event.",
         Subevents =>
         {
            "AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM Message Class",
               Defn      => "Filter for the Home (HOM) message class.  HOM is generally used to send requests, request responses, and snoop responses.",
            },
            "BL" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM Message Class",
               Defn      => "Filter for the Home (HOM) message class.  HOM is generally used to send requests, request responses, and snoop responses.",
            },
         },
      },
      "VNA_CREDITS_REJECT" =>
      {
         Box       => "R3QPI Box Events",
         Category  => "LINK_VNA_CREDITS Events",
         EvSel     => 0x34,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "VNA Credit Reject",
         Defn      => "Number of attempted VNA credit acquisitions that were rejected because the VNA credit pool was full (or almost full).  It is possible to filter this event by message class.  Some packets use more than one flit buffer, and therefore must acquire multiple credits.  Therefore, one could get a reject even if the VNA credits were not fully used up.  The VNA pool is generally used to provide the bulk of the QPI bandwidth (as opposed to the VN0 pool which is used to guarantee forward progress).  VNA credits can run out if the flit buffer on the receiving side starts to queue up substantially.  This can happen if the rest of the uncore is unable to drain the requests fast enough.",
         Subevents =>
         {
            "HOM" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "HOM Message Class",
               Defn      => "Filter for the Home (HOM) message class.  HOM is generally used to send requests, request responses, and snoop responses.",
            },
            "SNP" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "SNP Message Class",
               Defn      => "Filter for Snoop (SNP) message class.  SNP is used for outgoing snoops.  Note that snoop responses flow on the HOM message class.",
            },
            "NDR" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "NDR Message Class",
               Defn      => "NDR packets are used to transmit a variety of protocol flits including grants and completions (CMP).",
            },
            "DRS" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "DRS Message Class",
               Defn      => "Filter for Data Response (DRS).  DRS is generally used to transmit data with coherency.  For example, remote reads and writes, or cache to cache transfers will transmit their data using DRS.",
            },
            "NCB" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCB Message Class",
               Defn      => "Filter for Non-Coherent Broadcast (NCB).  NCB is generally used to transmit data without coherency.  For example, non-coherent read data returns.",
            },
            "NCS" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "NCS Message Class",
               Defn      => "Filter for Non-Coherent Standard (NCS).",
            },
         },
      },
   },
   "SBO Box Events" =>
   {
      "BOUNCE_CONTROL" =>
      {
         Box       => "SBO Box Events",
         Category  => "RING Events",
         EvSel     => 0x0A,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Bounce Control",
         Defn      => "",
      },
      "CLOCKTICKS" =>
      {
         Box       => "SBO Box Events",
         Category  => "UCLK Events",
         EvSel     => 0x00,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Uncore Clocks",
         Defn      => "",
      },
      "FAST_ASSERTED" =>
      {
         Box       => "SBO Box Events",
         Category  => "RING Events",
         EvSel     => 0x09,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "FaST wire asserted",
         Defn      => "Counts the number of cycles either the local or incoming distress signals are asserted.  Incoming distress includes up, dn and across.",
      },
      "RING_AD_USED" =>
      {
         Box       => "SBO Box Events",
         Category  => "RING Events",
         EvSel     => 0x1B,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "AD Ring In Use",
         Defn      => "Counts the number of cycles that the AD ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sent, but does not include when packets are being sunk into the ring stop.  We really have two rings in BDX -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the \"UP\" direction is on the clockwise ring and \"DN\" is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.",
         Notes     => "In any cycle, a ring stop can see up to one packet moving in the UP direction and one packet moving in the DN direction.",
         Subevents =>
         {
            "UP_EVEN" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Up and Even",
               Defn      => "Filters for the Up and Even ring polarity.",
            },
            "UP_ODD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Up and Odd",
               Defn      => "Filters for the Up and Odd ring polarity.",
            },
            "DOWN_EVEN" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Down and Event",
               Defn      => "Filters for the Down and Event ring polarity.",
            },
            "DOWN_ODD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Down and Odd",
               Defn      => "Filters for the Down and Odd ring polarity.",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise",
               Defn      => "",
            },
            "CCW" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "",
            },
         },
      },
      "RING_AK_USED" =>
      {
         Box       => "SBO Box Events",
         Category  => "RING Events",
         EvSel     => 0x1C,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "AK Ring In Use",
         Defn      => "Counts the number of cycles that the AK ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sent, but does not include when packets are being sunk into the ring stop. We really have two rings in BDX -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the \"UP\" direction is on the clockwise ring and \"DN\" is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.",
         Notes     => "In any cycle, a ring stop can see up to one packet moving in the UP direction and one packet moving in the DN direction.",
         Subevents =>
         {
            "UP_EVEN" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Up and Even",
               Defn      => "Filters for the Up and Even ring polarity.",
            },
            "UP_ODD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Up and Odd",
               Defn      => "Filters for the Up and Odd ring polarity.",
            },
            "DOWN_EVEN" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Down and Event",
               Defn      => "Filters for the Down and Event ring polarity.",
            },
            "DOWN_ODD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Down and Odd",
               Defn      => "Filters for the Down and Odd ring polarity.",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise",
               Defn      => "",
            },
            "CCW" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "",
            },
         },
      },
      "RING_BL_USED" =>
      {
         Box       => "SBO Box Events",
         Category  => "RING Events",
         EvSel     => 0x1D,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "BL Ring in Use",
         Defn      => "Counts the number of cycles that the BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sent, but does not include when packets are being sunk into the ring stop. We really have two rings in BDX -- a clockwise ring and a counter-clockwise ring.  On the left side of the ring, the \"UP\" direction is on the clockwise ring and \"DN\" is on the counter-clockwise ring.  On the right side of the ring, this is reversed.  The first half of the CBos are on the left side of the ring, and the 2nd half are on the right side of the ring.  In other words (for example), in a 4c part, Cbo 0 UP AD is NOT the same ring as CBo 2 UP AD because they are on opposite sides of the ring.",
         Notes     => "In any cycle, a ring stop can see up to one packet moving in the UP direction and one packet moving in the DN direction.",
         Subevents =>
         {
            "UP_EVEN" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Up and Even",
               Defn      => "Filters for the Up and Even ring polarity.",
            },
            "UP_ODD" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Up and Odd",
               Defn      => "Filters for the Up and Odd ring polarity.",
            },
            "DOWN_EVEN" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Down and Event",
               Defn      => "Filters for the Down and Event ring polarity.",
            },
            "DOWN_ODD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Down and Odd",
               Defn      => "Filters for the Down and Odd ring polarity.",
            },
            "CW" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Clockwise",
               Defn      => "",
            },
            "CCW" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Counterclockwise",
               Defn      => "",
            },
            "ALL" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "All",
               Defn      => "",
            },
         },
      },
      "RING_BOUNCES" =>
      {
         Box       => "SBO Box Events",
         Category  => "RING Events",
         EvSel     => 0x05,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 2,
         Desc      => "Number of LLC responses that bounced on the Ring.",
         Defn      => "",
         Subevents =>
         {
            "AD_CACHE" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
            "AK_CORE" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Acknowledgements to core",
               Defn      => "",
            },
            "BL_CORE" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Data Responses to core",
               Defn      => "",
            },
            "IV_CORE" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Snoops of processor's cache.",
               Defn      => "",
            },
         },
      },
      "RING_IV_USED" =>
      {
         Box       => "SBO Box Events",
         Category  => "RING Events",
         EvSel     => 0x1E,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "BL Ring in Use",
         Defn      => "Counts the number of cycles that the BL ring is being used at this ring stop.  This includes when packets are passing by and when packets are being sent, but does not include when packets are being sunk into the ring stop.  There is only 1 IV ring in BDX.  Therefore, if one wants to monitor the \"Even\" ring, they should select both UP_EVEN and DN_EVEN.  To monitor the \"Odd\" ring, they should select both UP_ODD and DN_ODD.",
         Notes     => "IV messages are split into two parts.  In any cycle, a ring stop can see up to one (half-)packet moving in the UP direction and one (half-)packet moving in the DN direction.",
         Subevents =>
         {
            "UP" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Any",
               Defn      => "Filters any polarity",
            },
            "DN" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Any",
               Defn      => "Filters any polarity",
            },
         },
      },
      "RxR_BYPASS" =>
      {
         Box       => "SBO Box Events",
         Category  => "INGRESS Events",
         EvSel     => 0x12,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 12,
         Desc      => "Bypass",
         Defn      => "Bypass the Sbo Ingress.",
         Subevents =>
         {
            "AD_CRD" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "AD - Credits",
               Defn      => "",
            },
            "AD_BNC" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "AD - Bounces",
               Defn      => "",
            },
            "BL_CRD" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "BL - Credits",
               Defn      => "",
            },
            "BL_BNC" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "BL - Bounces",
               Defn      => "",
            },
            "AK" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "AK",
               Defn      => "",
            },
            "IV" =>
            {
               Umask     => "b00100000",
               Counters  => "",
               Filter    => "",
               Desc      => "IV",
               Defn      => "",
            },
         },
      },
      "RxR_INSERTS" =>
      {
         Box       => "SBO Box Events",
         Category  => "INGRESS Events",
         EvSel     => 0x13,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Ingress Allocations",
         Defn      => "Number of allocations into the Sbo Ingress  The Ingress is used to queue up requests received from the ring.",
         Subevents =>
         {
            "AD_CRD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "AD - Credits",
               Defn      => "",
            },
            "AD_BNC" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "AD - Bounces",
               Defn      => "",
            },
            "BL_CRD" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL - Credits",
               Defn      => "",
            },
            "BL_BNC" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL - Bounces",
               Defn      => "",
            },
            "AK" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "AK",
               Defn      => "",
            },
            "IV" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "IV",
               Defn      => "",
            },
         },
      },
      "RxR_OCCUPANCY" =>
      {
         Box       => "SBO Box Events",
         Category  => "INGRESS Events",
         EvSel     => 0x11,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 12,
         Desc      => "Ingress Occupancy",
         Defn      => "Occupancy event for the Ingress buffers in the Sbo.  The Ingress is used to queue up requests received from the ring.",
         Subevents =>
         {
            "AD_CRD" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "AD - Credits",
               Defn      => "",
            },
            "AD_BNC" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "AD - Bounces",
               Defn      => "",
            },
            "BL_CRD" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "BL - Credits",
               Defn      => "",
            },
            "BL_BNC" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "BL - Bounces",
               Defn      => "",
            },
            "AK" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "AK",
               Defn      => "",
            },
            "IV" =>
            {
               Umask     => "b00100000",
               Counters  => "",
               Filter    => "",
               Desc      => "IV",
               Defn      => "",
            },
         },
      },
      "TxR_ADS_USED" =>
      {
         Box       => "SBO Box Events",
         Category  => "EGRESS Events",
         EvSel     => 0x04,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "",
         Defn      => "",
         Subevents =>
         {
            "AD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
            "AK" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
            "BL" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
         },
      },
      "TxR_INSERTS" =>
      {
         Box       => "SBO Box Events",
         Category  => "EGRESS Events",
         EvSel     => 0x02,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Egress Allocations",
         Defn      => "Number of allocations into the Sbo Egress.  The Egress is used to queue up requests destined for the ring.",
         Subevents =>
         {
            "AD_CRD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "AD - Credits",
               Defn      => "",
            },
            "AD_BNC" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "AD - Bounces",
               Defn      => "",
            },
            "BL_CRD" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL - Credits",
               Defn      => "",
            },
            "BL_BNC" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "BL - Bounces",
               Defn      => "",
            },
            "AK" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "AK",
               Defn      => "",
            },
            "IV" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "IV",
               Defn      => "",
            },
         },
      },
      "TxR_OCCUPANCY" =>
      {
         Box       => "SBO Box Events",
         Category  => "EGRESS Events",
         EvSel     => 0x01,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 12,
         Desc      => "Egress Occupancy",
         Defn      => "Occupancy event for the Egress buffers in the Sbo.  The egress is used to queue up requests destined for the ring.",
         Subevents =>
         {
            "AD_CRD" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "AD - Credits",
               Defn      => "",
            },
            "AD_BNC" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "AD - Bounces",
               Defn      => "",
            },
            "BL_CRD" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "BL - Credits",
               Defn      => "",
            },
            "BL_BNC" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "BL - Bounces",
               Defn      => "",
            },
            "AK" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "AK",
               Defn      => "",
            },
            "IV" =>
            {
               Umask     => "b00100000",
               Counters  => "",
               Filter    => "",
               Desc      => "IV",
               Defn      => "",
            },
         },
      },
   },
   "UBOX Box Events" =>
   {
      "EVENT_MSG" =>
      {
         Box       => "UBOX Box Events",
         Category  => "EVENT_MSG Events",
         EvSel     => 0x42,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "VLW Received",
         Defn      => "Virtual Logical Wire (legacy) message were received from Uncore.   Specify the thread to filter on using NCUPMONCTRLGLCTR.ThreadID.",
         Subevents =>
         {
            "DOORBELL_RCVD" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
         },
      },
      "PHOLD_CYCLES" =>
      {
         Box       => "UBOX Box Events",
         Category  => "PHOLD Events",
         EvSel     => 0x45,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Cycles PHOLD Assert to Ack",
         Defn      => "PHOLD cycles.  Filter from source CoreID.",
         Subevents =>
         {
            "ASSERT_TO_ACK" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Assert to ACK",
               Defn      => "",
            },
         },
      },
      "RACU_REQUESTS" =>
      {
         Box       => "UBOX Box Events",
         Category  => "RACU Events",
         EvSel     => 0x46,
         Counters  => "0-1",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "RACU Request",
         Defn      => "Number outstanding register requests within message channel tracker",
      },
   },
   "iMC Box Events" =>
   {
      "ACT_COUNT" =>
      {
         Box       => "iMC Box Events",
         Category  => "ACT Events",
         EvSel     => 0x01,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "DRAM Activate Count",
         Defn      => "Counts the number of DRAM Activate commands sent on this channel.  Activate commands are issued to open up a page on the DRAM devices so that it can be read or written to with a CAS.  One can calculate the number of Page Misses by subtracting the number of Page Miss precharges from the number of Activates.",
         Subevents =>
         {
            "RD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Activate due to Read",
               Defn      => "",
            },
            "WR" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Activate due to Write",
               Defn      => "",
            },
            "BYP" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Activate due to Write",
               Defn      => "",
            },
         },
      },
      "BYP_CMDS" =>
      {
         Box       => "iMC Box Events",
         Category  => "BYPASS Command Events",
         EvSel     => 0xA1,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "",
         Defn      => "",
         Subevents =>
         {
            "ACT" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "ACT command issued by 2 cycle bypass",
               Defn      => "",
            },
            "CAS" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "CAS command issued by 2 cycle bypass",
               Defn      => "",
            },
            "PRE" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "PRE command issued by 2 cycle bypass",
               Defn      => "",
            },
         },
      },
      "CAS_COUNT" =>
      {
         Box       => "iMC Box Events",
         Category  => "PRE Events",
         EvSel     => 0x04,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "DRAM RD_CAS and WR_CAS Commands.",
         Defn      => "DRAM RD_CAS and WR_CAS Commands",
         Subevents =>
         {
            "RD_REG" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "All DRAM RD_CAS (w/ and w/out auto-pre)",
               Defn      => "Counts the total number or DRAM Read CAS commands issued on this channel.  This includes both regular RD CAS commands as well as those with implicit Precharge.  AutoPre is only used in systems that are using closed page policy.  We do not filter based on major mode, as RD_CAS is not issued during WMM (with the exception of underfills).",
            },
            "RD_UNDERFILL" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Underfill Read Issued",
               Defn      => "Counts the number of underfill reads that are issued by the memory controller.  This will generally be about the same as the number of partial writes, but may be slightly less because of partials hitting in the WPQ.  While it is possible for underfills to be issed in both WMM and RMM, this event counts both.",
            },
            "RD" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "All DRAM Reads (RD_CAS + Underfills)",
               Defn      => "Counts the total number of DRAM Read CAS commands issued on this channel (including underfills).",
            },
            "WR_WMM" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "DRAM WR_CAS (w/ and w/out auto-pre) in Write Major Mode",
               Defn      => "Counts the total number or DRAM Write CAS commands issued on this channel while in Write-Major-Mode.",
            },
            "WR_RMM" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "DRAM WR_CAS (w/ and w/out auto-pre) in Read Major Mode",
               Defn      => "Counts the total number of Opportunistic\" DRAM Write CAS commands issued on this channel while in Read-Major-Mode.",
            },
            "WR" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "All DRAM WR_CAS (both Modes)",
               Defn      => "Counts the total number of DRAM Write CAS commands issued on this channel.",
            },
            "ALL" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "All DRAM WR_CAS (w/ and w/out auto-pre)",
               Defn      => "Counts the total number of DRAM CAS commands issued on this channel.",
            },
            "RD_WMM" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Read CAS issued in WMM",
               Defn      => "",
            },
            "RD_RMM" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Read CAS issued in RMM",
               Defn      => "",
            },
         },
      },
      "DCLOCKTICKS" =>
      {
         Box       => "iMC Box Events",
         Category  => "DCLK Events",
         EvSel     => 0x00,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "DRAM Clockticks",
         Defn      => "",
      },
      "DRAM_PRE_ALL" =>
      {
         Box       => "iMC Box Events",
         Category  => "DRAM_PRE_ALL Events",
         EvSel     => 0x06,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "DRAM Precharge All Commands",
         Defn      => "Counts the number of times that the precharge all command was sent.",
      },
      "DRAM_REFRESH" =>
      {
         Box       => "iMC Box Events",
         Category  => "DRAM_REFRESH Events",
         EvSel     => 0x05,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Number of DRAM Refreshes Issued",
         Defn      => "Counts the number of refreshes issued.",
         Subevents =>
         {
            "PANIC" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
            "HIGH" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
         },
      },
      "ECC_CORRECTABLE_ERRORS" =>
      {
         Box       => "iMC Box Events",
         Category  => "ECC Events",
         EvSel     => 0x09,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "ECC Correctable Errors",
         Defn      => "Counts the number of ECC errors detected and corrected by the iMC on this channel.  This counter is only useful with ECC DRAM devices.  This count will increment one time for each correction regardless of the number of bits corrected.  The iMC can correct up to 4 bit errors in independent channel mode and 8 bit erros in lockstep mode.",
      },
      "MAJOR_MODES" =>
      {
         Box       => "iMC Box Events",
         Category  => "MAJOR_MODES Events",
         EvSel     => 0x07,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Cycles in a Major Mode",
         Defn      => "Counts the total number of cycles spent in a major mode (selected by a filter) on the given channel.   Major modea are channel-wide, and not a per-rank (or dimm or bank) mode.",
         Subevents =>
         {
            "READ" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Read Major Mode",
               Defn      => "Read Major Mode is the default mode for the iMC, as reads are generally more critical to forward progress than writes.",
            },
            "WRITE" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Write Major Mode",
               Defn      => "This mode is triggered when the WPQ hits high occupancy and causes writes to be higher priority than reads.  This can cause blips in the available read bandwidth in the system and temporarily increase read latencies in order to achieve better bus utilizations and higher bandwidth.",
            },
            "PARTIAL" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Partial Major Mode",
               Defn      => "This major mode is used to drain starved underfill reads.  Regular reads and writes are blocked and only underfill reads will be processed.",
            },
            "ISOCH" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Isoch Major Mode",
               Defn      => "We group these two modes together so that we can use four counters to track each of the major modes at one time.  These major modes are used whenever there is an ISOCH txn in the memory controller.  In these mode, only ISOCH transactions are processed.",
            },
         },
      },
      "POWER_CHANNEL_DLLOFF" =>
      {
         Box       => "iMC Box Events",
         Category  => "POWER Events",
         EvSel     => 0x84,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Channel DLLOFF Cycles",
         Defn      => "Number of cycles when all the ranks in the channel are in CKE Slow (DLLOFF) mode.",
         Notes     => "IBT = Input Buffer Termination = Off",
      },
      "POWER_CHANNEL_PPD" =>
      {
         Box       => "iMC Box Events",
         Category  => "POWER Events",
         EvSel     => 0x85,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 4,
         Desc      => "Channel PPD Cycles",
         Defn      => "Number of cycles when all the ranks in the channel are in PPD mode.  If IBT=off is enabled, then this can be used to count those cycles.  If it is not enabled, then this can count the number of cycles when that could have been taken advantage of.",
         Notes     => "IBT = Input Buffer Termination = On.   ALL Ranks must be populated in order to measure",
      },
      "POWER_CKE_CYCLES" =>
      {
         Box       => "iMC Box Events",
         Category  => "POWER Events",
         EvSel     => 0x83,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 16,
         Desc      => "CKE_ON_CYCLES by Rank",
         Defn      => "Number of cycles spent in CKE ON mode.  The filter allows you to select a rank to monitor.  If multiple ranks are in CKE ON mode at one time, the counter will ONLY increment by one rather than doing accumulation.  Multiple counters will need to be used to track multiple ranks simultaneously.  There is no distinction between the different CKE modes (APD, PPDS, PPDF).  This can be determined based on the system programming.  These events should commonly be used with Invert to get the number of cycles in power saving mode.  Edge Detect is also useful here.  Make sure that you do NOT use Invert with Edge Detect (this just confuses the system and is not necessary).",
         Subevents =>
         {
            "RANK0" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "DIMM ID",
               Defn      => "",
            },
            "RANK1" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "DIMM ID",
               Defn      => "",
            },
            "RANK2" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "DIMM ID",
               Defn      => "",
            },
            "RANK3" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "DIMM ID",
               Defn      => "",
            },
            "RANK4" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "DIMM ID",
               Defn      => "",
            },
            "RANK5" =>
            {
               Umask     => "b00100000",
               Counters  => "",
               Filter    => "",
               Desc      => "DIMM ID",
               Defn      => "",
            },
            "RANK6" =>
            {
               Umask     => "b01000000",
               Counters  => "",
               Filter    => "",
               Desc      => "DIMM ID",
               Defn      => "",
            },
            "RANK7" =>
            {
               Umask     => "b10000000",
               Counters  => "",
               Filter    => "",
               Desc      => "DIMM ID",
               Defn      => "",
            },
         },
      },
      "POWER_CRITICAL_THROTTLE_CYCLES" =>
      {
         Box       => "iMC Box Events",
         Category  => "POWER Events",
         EvSel     => 0x86,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Critical Throttle Cycles",
         Defn      => "Counts the number of cycles when the iMC is in critical thermal throttling.  When this happens, all traffic is blocked.  This should be rare unless something bad is going on in the platform.  There is no filtering by rank for this event.",
      },
      "POWER_PCU_THROTTLING" =>
      {
         Box       => "iMC Box Events",
         Category  => "POWER Events",
         EvSel     => 0x42,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "",
         Defn      => "",
      },
      "POWER_SELF_REFRESH" =>
      {
         Box       => "iMC Box Events",
         Category  => "POWER Events",
         EvSel     => 0x43,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 0,
         Desc      => "Clock-Enabled Self-Refresh",
         Defn      => "Counts the number of cycles when the iMC is in self-refresh and the iMC still has a clock.  This happens in some package C-states.  For example, the PCU may ask the iMC to enter self-refresh even though some of the cores are still processing.  One use of this is for Monroe technology.  Self-refresh is required during package C3 and C6, but there is no clock in the iMC at this time, so it is not possible to count these cases.",
      },
      "POWER_THROTTLE_CYCLES" =>
      {
         Box       => "iMC Box Events",
         Category  => "POWER Events",
         EvSel     => 0x41,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Throttle Cycles for Rank 0",
         Defn      => "Counts the number of cycles while the iMC is being throttled by either thermal constraints or by the PCU throttling.  It is not possible to distinguish between the two.  This can be filtered by rank.  If multiple ranks are selected and are being throttled at the same time, the counter will only increment by 1.",
         Subevents =>
         {
            "RANK0" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "DIMM ID",
               Defn      => "Thermal throttling is performed per DIMM.  We support 3 DIMMs per channel.  This ID allows us to filter by ID.",
            },
            "RANK1" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "DIMM ID",
               Defn      => "",
            },
            "RANK2" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "DIMM ID",
               Defn      => "",
            },
            "RANK3" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "DIMM ID",
               Defn      => "",
            },
            "RANK4" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "DIMM ID",
               Defn      => "",
            },
            "RANK5" =>
            {
               Umask     => "bxx1xxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "DIMM ID",
               Defn      => "",
            },
            "RANK6" =>
            {
               Umask     => "bx1xxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "DIMM ID",
               Defn      => "",
            },
            "RANK7" =>
            {
               Umask     => "b1xxxxxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "DIMM ID",
               Defn      => "",
            },
         },
      },
      "PREEMPTION" =>
      {
         Box       => "iMC Box Events",
         Category  => "PREEMPTION Events",
         EvSel     => 0x08,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Read Preemption Count",
         Defn      => "Counts the number of times a read in the iMC preempts another read or write.  Generally reads to an open page are issued ahead of requests to closed pages.  This improves the page hit rate of the system.  However, high priority requests can cause pages of active requests to be closed in order to get them out.  This will reduce the latency of the high-priority request at the expense of lower bandwidth and increased overall average latency.",
         Subevents =>
         {
            "RD_PREEMPT_RD" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Read over Read Preemption",
               Defn      => "Filter for when a read preempts another read.",
            },
            "RD_PREEMPT_WR" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Read over Write Preemption",
               Defn      => "Filter for when a read preempts a write.",
            },
         },
      },
      "PRE_COUNT" =>
      {
         Box       => "iMC Box Events",
         Category  => "PRE Events",
         EvSel     => 0x02,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "DRAM Precharge commands.",
         Defn      => "Counts the number of DRAM Precharge commands sent on this channel.",
         Subevents =>
         {
            "PAGE_MISS" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Precharges due to page miss",
               Defn      => "Counts the number of DRAM Precharge commands sent on this channel as a result of page misses.  This does not include explicit precharge commands sent with CAS commands in Auto-Precharge mode.  This does not include PRE commands sent as a result of the page close counter expiration.",
            },
            "PAGE_CLOSE" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Precharge due to timer expiration",
               Defn      => "Counts the number of DRAM Precharge commands sent on this channel as a result of the page close counter expiring.  This does not include implicit precharge commands sent in auto-precharge mode.",
            },
            "RD" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Precharge due to read",
               Defn      => "",
            },
            "WR" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Precharge due to write",
               Defn      => "",
            },
            "BYP" =>
            {
               Umask     => "bxxx1xxxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Precharge due to bypass",
               Defn      => "",
            },
         },
      },
      "RD_CAS_PRIO" =>
      {
         Box       => "iMC Box Events",
         Category  => "CAS Events",
         EvSel     => 0xA0,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "",
         Defn      => "",
         Subevents =>
         {
            "LOW" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Read CAS issued with LOW priority",
               Defn      => "",
            },
            "MED" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "Read CAS issued with MEDIUM priority",
               Defn      => "",
            },
            "HIGH" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "Read CAS issued with HIGH priority",
               Defn      => "",
            },
            "PANIC" =>
            {
               Umask     => "bxxxx1xxx",
               Counters  => "",
               Filter    => "",
               Desc      => "Read CAS issued with PANIC NON ISOCH priority (starved)",
               Defn      => "",
            },
         },
      },
      "RD_CAS_RANK0" =>
      {
         Box       => "iMC Box Events",
         Category  => "CAS Events",
         EvSel     => 0xB0,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "RD_CAS Access to Rank 0",
         Defn      => "",
         Subevents =>
         {
            "BANK1" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 1",
               Defn      => "",
            },
            "BANK2" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 2",
               Defn      => "",
            },
            "BANK4" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 4",
               Defn      => "",
            },
            "BANK8" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 8",
               Defn      => "",
            },
            "ALLBANKS" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "All Banks",
               Defn      => "",
            },
            "BANK0" =>
            {
               Umask     => "b00000000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 0",
               Defn      => "",
            },
            "BANK3" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 3",
               Defn      => "",
            },
            "BANK5" =>
            {
               Umask     => "b00000101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 5",
               Defn      => "",
            },
            "BANK6" =>
            {
               Umask     => "b00000110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 6",
               Defn      => "",
            },
            "BANK7" =>
            {
               Umask     => "b00000111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 7",
               Defn      => "",
            },
            "BANK9" =>
            {
               Umask     => "b00001001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 9",
               Defn      => "",
            },
            "BANK10" =>
            {
               Umask     => "b00001010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 10",
               Defn      => "",
            },
            "BANK11" =>
            {
               Umask     => "b00001011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 11",
               Defn      => "",
            },
            "BANK12" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 12",
               Defn      => "",
            },
            "BANK13" =>
            {
               Umask     => "b00001101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 13",
               Defn      => "",
            },
            "BANK14" =>
            {
               Umask     => "b00001110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 14",
               Defn      => "",
            },
            "BANK15" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 15",
               Defn      => "",
            },
            "BANKG0" =>
            {
               Umask     => "b00010001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 0 (Banks 0-3)",
               Defn      => "",
            },
            "BANKG1" =>
            {
               Umask     => "b00010010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 1 (Banks 4-7)",
               Defn      => "",
            },
            "BANKG2" =>
            {
               Umask     => "b00010011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 2 (Banks 8-11)",
               Defn      => "",
            },
            "BANKG3" =>
            {
               Umask     => "b00010100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 3 (Banks 12-15)",
               Defn      => "",
            },
         },
      },
      "RD_CAS_RANK1" =>
      {
         Box       => "iMC Box Events",
         Category  => "CAS Events",
         EvSel     => 0xB1,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "RD_CAS Access to Rank 1",
         Defn      => "",
         Subevents =>
         {
            "BANK1" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 1",
               Defn      => "",
            },
            "BANK2" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 2",
               Defn      => "",
            },
            "BANK4" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 4",
               Defn      => "",
            },
            "BANK8" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 8",
               Defn      => "",
            },
            "ALLBANKS" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "All Banks",
               Defn      => "",
            },
            "BANK0" =>
            {
               Umask     => "b00000000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 0",
               Defn      => "",
            },
            "BANK3" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 3",
               Defn      => "",
            },
            "BANK5" =>
            {
               Umask     => "b00000101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 5",
               Defn      => "",
            },
            "BANK6" =>
            {
               Umask     => "b00000110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 6",
               Defn      => "",
            },
            "BANK7" =>
            {
               Umask     => "b00000111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 7",
               Defn      => "",
            },
            "BANK9" =>
            {
               Umask     => "b00001001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 9",
               Defn      => "",
            },
            "BANK10" =>
            {
               Umask     => "b00001010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 10",
               Defn      => "",
            },
            "BANK11" =>
            {
               Umask     => "b00001011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 11",
               Defn      => "",
            },
            "BANK12" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 12",
               Defn      => "",
            },
            "BANK13" =>
            {
               Umask     => "b00001101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 13",
               Defn      => "",
            },
            "BANK14" =>
            {
               Umask     => "b00001110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 14",
               Defn      => "",
            },
            "BANK15" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 15",
               Defn      => "",
            },
            "BANKG0" =>
            {
               Umask     => "b00010001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 0 (Banks 0-3)",
               Defn      => "",
            },
            "BANKG1" =>
            {
               Umask     => "b00010010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 1 (Banks 4-7)",
               Defn      => "",
            },
            "BANKG2" =>
            {
               Umask     => "b00010011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 2 (Banks 8-11)",
               Defn      => "",
            },
            "BANKG3" =>
            {
               Umask     => "b00010100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 3 (Banks 12-15)",
               Defn      => "",
            },
         },
      },
      "RD_CAS_RANK2" =>
      {
         Box       => "iMC Box Events",
         Category  => "CAS Events",
         EvSel     => 0xB2,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "RD_CAS Access to Rank 2",
         Defn      => "",
         Subevents =>
         {
            "BANK0" =>
            {
               Umask     => "b00000000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 0",
               Defn      => "",
            },
         },
      },
      "RD_CAS_RANK4" =>
      {
         Box       => "iMC Box Events",
         Category  => "CAS Events",
         EvSel     => 0xB4,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "RD_CAS Access to Rank 4",
         Defn      => "",
         Subevents =>
         {
            "BANK1" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 1",
               Defn      => "",
            },
            "BANK2" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 2",
               Defn      => "",
            },
            "BANK4" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 4",
               Defn      => "",
            },
            "BANK8" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 8",
               Defn      => "",
            },
            "ALLBANKS" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "All Banks",
               Defn      => "",
            },
            "BANK0" =>
            {
               Umask     => "b00000000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 0",
               Defn      => "",
            },
            "BANK3" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 3",
               Defn      => "",
            },
            "BANK5" =>
            {
               Umask     => "b00000101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 5",
               Defn      => "",
            },
            "BANK6" =>
            {
               Umask     => "b00000110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 6",
               Defn      => "",
            },
            "BANK7" =>
            {
               Umask     => "b00000111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 7",
               Defn      => "",
            },
            "BANK9" =>
            {
               Umask     => "b00001001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 9",
               Defn      => "",
            },
            "BANK10" =>
            {
               Umask     => "b00001010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 10",
               Defn      => "",
            },
            "BANK11" =>
            {
               Umask     => "b00001011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 11",
               Defn      => "",
            },
            "BANK12" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 12",
               Defn      => "",
            },
            "BANK13" =>
            {
               Umask     => "b00001101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 13",
               Defn      => "",
            },
            "BANK14" =>
            {
               Umask     => "b00001110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 14",
               Defn      => "",
            },
            "BANK15" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 15",
               Defn      => "",
            },
            "BANKG0" =>
            {
               Umask     => "b00010001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 0 (Banks 0-3)",
               Defn      => "",
            },
            "BANKG1" =>
            {
               Umask     => "b00010010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 1 (Banks 4-7)",
               Defn      => "",
            },
            "BANKG2" =>
            {
               Umask     => "b00010011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 2 (Banks 8-11)",
               Defn      => "",
            },
            "BANKG3" =>
            {
               Umask     => "b00010100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 3 (Banks 12-15)",
               Defn      => "",
            },
         },
      },
      "RD_CAS_RANK5" =>
      {
         Box       => "iMC Box Events",
         Category  => "CAS Events",
         EvSel     => 0xB5,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "RD_CAS Access to Rank 5",
         Defn      => "",
         Subevents =>
         {
            "BANK1" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 1",
               Defn      => "",
            },
            "BANK2" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 2",
               Defn      => "",
            },
            "BANK4" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 4",
               Defn      => "",
            },
            "BANK8" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 8",
               Defn      => "",
            },
            "ALLBANKS" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "All Banks",
               Defn      => "",
            },
            "BANK0" =>
            {
               Umask     => "b00000000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 0",
               Defn      => "",
            },
            "BANK3" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 3",
               Defn      => "",
            },
            "BANK5" =>
            {
               Umask     => "b00000101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 5",
               Defn      => "",
            },
            "BANK6" =>
            {
               Umask     => "b00000110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 6",
               Defn      => "",
            },
            "BANK7" =>
            {
               Umask     => "b00000111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 7",
               Defn      => "",
            },
            "BANK9" =>
            {
               Umask     => "b00001001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 9",
               Defn      => "",
            },
            "BANK10" =>
            {
               Umask     => "b00001010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 10",
               Defn      => "",
            },
            "BANK11" =>
            {
               Umask     => "b00001011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 11",
               Defn      => "",
            },
            "BANK12" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 12",
               Defn      => "",
            },
            "BANK13" =>
            {
               Umask     => "b00001101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 13",
               Defn      => "",
            },
            "BANK14" =>
            {
               Umask     => "b00001110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 14",
               Defn      => "",
            },
            "BANK15" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 15",
               Defn      => "",
            },
            "BANKG0" =>
            {
               Umask     => "b00010001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 0 (Banks 0-3)",
               Defn      => "",
            },
            "BANKG1" =>
            {
               Umask     => "b00010010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 1 (Banks 4-7)",
               Defn      => "",
            },
            "BANKG2" =>
            {
               Umask     => "b00010011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 2 (Banks 8-11)",
               Defn      => "",
            },
            "BANKG3" =>
            {
               Umask     => "b00010100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 3 (Banks 12-15)",
               Defn      => "",
            },
         },
      },
      "RD_CAS_RANK6" =>
      {
         Box       => "iMC Box Events",
         Category  => "CAS Events",
         EvSel     => 0xB6,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "RD_CAS Access to Rank 6",
         Defn      => "",
         Subevents =>
         {
            "BANK1" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 1",
               Defn      => "",
            },
            "BANK2" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 2",
               Defn      => "",
            },
            "BANK4" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 4",
               Defn      => "",
            },
            "BANK8" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 8",
               Defn      => "",
            },
            "ALLBANKS" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "All Banks",
               Defn      => "",
            },
            "BANK0" =>
            {
               Umask     => "b00000000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 0",
               Defn      => "",
            },
            "BANK3" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 3",
               Defn      => "",
            },
            "BANK5" =>
            {
               Umask     => "b00000101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 5",
               Defn      => "",
            },
            "BANK6" =>
            {
               Umask     => "b00000110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 6",
               Defn      => "",
            },
            "BANK7" =>
            {
               Umask     => "b00000111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 7",
               Defn      => "",
            },
            "BANK9" =>
            {
               Umask     => "b00001001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 9",
               Defn      => "",
            },
            "BANK10" =>
            {
               Umask     => "b00001010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 10",
               Defn      => "",
            },
            "BANK11" =>
            {
               Umask     => "b00001011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 11",
               Defn      => "",
            },
            "BANK12" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 12",
               Defn      => "",
            },
            "BANK13" =>
            {
               Umask     => "b00001101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 13",
               Defn      => "",
            },
            "BANK14" =>
            {
               Umask     => "b00001110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 14",
               Defn      => "",
            },
            "BANK15" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 15",
               Defn      => "",
            },
            "BANKG0" =>
            {
               Umask     => "b00010001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 0 (Banks 0-3)",
               Defn      => "",
            },
            "BANKG1" =>
            {
               Umask     => "b00010010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 1 (Banks 4-7)",
               Defn      => "",
            },
            "BANKG2" =>
            {
               Umask     => "b00010011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 2 (Banks 8-11)",
               Defn      => "",
            },
            "BANKG3" =>
            {
               Umask     => "b00010100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 3 (Banks 12-15)",
               Defn      => "",
            },
         },
      },
      "RD_CAS_RANK7" =>
      {
         Box       => "iMC Box Events",
         Category  => "CAS Events",
         EvSel     => 0xB7,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "RD_CAS Access to Rank 7",
         Defn      => "",
         Subevents =>
         {
            "BANK1" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 1",
               Defn      => "",
            },
            "BANK2" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 2",
               Defn      => "",
            },
            "BANK4" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 4",
               Defn      => "",
            },
            "BANK8" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 8",
               Defn      => "",
            },
            "ALLBANKS" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "All Banks",
               Defn      => "",
            },
            "BANK0" =>
            {
               Umask     => "b00000000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 0",
               Defn      => "",
            },
            "BANK3" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 3",
               Defn      => "",
            },
            "BANK5" =>
            {
               Umask     => "b00000101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 5",
               Defn      => "",
            },
            "BANK6" =>
            {
               Umask     => "b00000110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 6",
               Defn      => "",
            },
            "BANK7" =>
            {
               Umask     => "b00000111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 7",
               Defn      => "",
            },
            "BANK9" =>
            {
               Umask     => "b00001001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 9",
               Defn      => "",
            },
            "BANK10" =>
            {
               Umask     => "b00001010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 10",
               Defn      => "",
            },
            "BANK11" =>
            {
               Umask     => "b00001011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 11",
               Defn      => "",
            },
            "BANK12" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 12",
               Defn      => "",
            },
            "BANK13" =>
            {
               Umask     => "b00001101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 13",
               Defn      => "",
            },
            "BANK14" =>
            {
               Umask     => "b00001110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 14",
               Defn      => "",
            },
            "BANK15" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 15",
               Defn      => "",
            },
            "BANKG0" =>
            {
               Umask     => "b00010001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 0 (Banks 0-3)",
               Defn      => "",
            },
            "BANKG1" =>
            {
               Umask     => "b00010010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 1 (Banks 4-7)",
               Defn      => "",
            },
            "BANKG2" =>
            {
               Umask     => "b00010011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 2 (Banks 8-11)",
               Defn      => "",
            },
            "BANKG3" =>
            {
               Umask     => "b00010100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 3 (Banks 12-15)",
               Defn      => "",
            },
         },
      },
      "RPQ_CYCLES_NE" =>
      {
         Box       => "iMC Box Events",
         Category  => "RPQ Events",
         EvSel     => 0x11,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Read Pending Queue Not Empty",
         Defn      => "Counts the number of cycles that the Read Pending Queue is not empty.  This can then be used to calculate the average occupancy (in conjunction with the Read Pending Queue Occupancy count).  The RPQ is used to schedule reads out to the memory controller and to track the requests.  Requests allocate into the RPQ soon after they enter the memory controller, and need credits for an entry in this buffer before being sent from the HA to the iMC.  They deallocate after the CAS command has been issued to memory.  This filter is to be used in conjunction with the occupancy filter so that one can correctly track the average occupancies for schedulable entries and scheduled requests.",
      },
      "RPQ_INSERTS" =>
      {
         Box       => "iMC Box Events",
         Category  => "RPQ Events",
         EvSel     => 0x10,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Read Pending Queue Allocations",
         Defn      => "Counts the number of allocations into the Read Pending Queue.  This queue is used to schedule reads out to the memory controller and to track the requests.  Requests allocate into the RPQ soon after they enter the memory controller, and need credits for an entry in this buffer before being sent from the HA to the iMC.  They deallocate after the CAS command has been issued to memory.  This includes both ISOCH and non-ISOCH requests.",
      },
      "VMSE_MXB_WR_OCCUPANCY" =>
      {
         Box       => "iMC Box Events",
         Category  => "VMSE Events",
         EvSel     => 0x91,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 1,
         MaxIncCyc => 32,
         Desc      => "VMSE MXB write buffer occupancy",
         Defn      => "",
      },
      "VMSE_WR_PUSH" =>
      {
         Box       => "iMC Box Events",
         Category  => "VMSE Events",
         EvSel     => 0x90,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "VMSE WR PUSH issued",
         Defn      => "",
         Subevents =>
         {
            "WMM" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "VMSE write PUSH issued in WMM",
               Defn      => "",
            },
            "RMM" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "VMSE write PUSH issued in RMM",
               Defn      => "",
            },
         },
      },
      "WMM_TO_RMM" =>
      {
         Box       => "iMC Box Events",
         Category  => "MAJOR_MODES Events",
         EvSel     => 0xC0,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Transition from WMM to RMM because of low threshold",
         Defn      => "",
         Subevents =>
         {
            "LOW_THRESH" =>
            {
               Umask     => "bxxxxxxx1",
               Counters  => "",
               Filter    => "",
               Desc      => "Transition from WMM to RMM because of starve counter",
               Defn      => "",
            },
            "STARVE" =>
            {
               Umask     => "bxxxxxx1x",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
            "VMSE_RETRY" =>
            {
               Umask     => "bxxxxx1xx",
               Counters  => "",
               Filter    => "",
               Desc      => "",
               Defn      => "",
            },
         },
      },
      "WPQ_CYCLES_FULL" =>
      {
         Box       => "iMC Box Events",
         Category  => "WPQ Events",
         EvSel     => 0x22,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Write Pending Queue Full Cycles",
         Defn      => "Counts the number of cycles when the Write Pending Queue is full.  When the WPQ is full, the HA will not be able to issue any additional read requests into the iMC.  This count should be similar count in the HA which tracks the number of cycles that the HA has no WPQ credits, just somewhat smaller to account for the credit return overhead.",
      },
      "WPQ_CYCLES_NE" =>
      {
         Box       => "iMC Box Events",
         Category  => "WPQ Events",
         EvSel     => 0x21,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Write Pending Queue Not Empty",
         Defn      => "Counts the number of cycles that the Write Pending Queue is not empty.  This can then be used to calculate the average queue occupancy (in conjunction with the WPQ Occupancy Accumulation count).  The WPQ is used to schedule write out to the memory controller and to track the writes.  Requests allocate into the WPQ soon after they enter the memory controller, and need credits for an entry in this buffer before being sent from the HA to the iMC.  They deallocate after being issued to DRAM.  Write requests themselves are able to complete (from the perspective of the rest of the system) as soon they have \"posted\" to the iMC.  This is not to be confused with actually performing the write to DRAM.  Therefore, the average latency for this queue is actually not useful for deconstruction intermediate write latencies.",
      },
      "WPQ_READ_HIT" =>
      {
         Box       => "iMC Box Events",
         Category  => "WPQ Events",
         EvSel     => 0x23,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Write Pending Queue CAM Match",
         Defn      => "Counts the number of times a request hits in the WPQ (write-pending queue).  The iMC allows writes and reads to pass up other writes to different addresses.  Before a read or a write is issued, it will first CAM the WPQ to see if there is a write pending to that address.  When reads hit, they are able to directly pull their data from the WPQ instead of going to memory.  Writes that hit will overwrite the existing data.  Partial writes that hit will not need to do underfill reads and will simply update their relevant sections.",
      },
      "WPQ_WRITE_HIT" =>
      {
         Box       => "iMC Box Events",
         Category  => "WPQ Events",
         EvSel     => 0x24,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Write Pending Queue CAM Match",
         Defn      => "Counts the number of times a request hits in the WPQ (write-pending queue).  The iMC allows writes and reads to pass up other writes to different addresses.  Before a read or a write is issued, it will first CAM the WPQ to see if there is a write pending to that address.  When reads hit, they are able to directly pull their data from the WPQ instead of going to memory.  Writes that hit will overwrite the existing data.  Partial writes that hit will not need to do underfill reads and will simply update their relevant sections.",
      },
      "WRONG_MM" =>
      {
         Box       => "iMC Box Events",
         Category  => "MAJOR_MODES Events",
         EvSel     => 0xC1,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "Not getting the requested Major Mode",
         Defn      => "",
      },
      "WR_CAS_RANK0" =>
      {
         Box       => "iMC Box Events",
         Category  => "CAS Events",
         EvSel     => 0xB8,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "WR_CAS Access to Rank 0",
         Defn      => "",
         Subevents =>
         {
            "BANK1" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 1",
               Defn      => "",
            },
            "BANK2" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 2",
               Defn      => "",
            },
            "BANK4" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 4",
               Defn      => "",
            },
            "BANK8" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 8",
               Defn      => "",
            },
            "ALLBANKS" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "All Banks",
               Defn      => "",
            },
            "BANK0" =>
            {
               Umask     => "b00000000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 0",
               Defn      => "",
            },
            "BANK3" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 3",
               Defn      => "",
            },
            "BANK5" =>
            {
               Umask     => "b00000101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 5",
               Defn      => "",
            },
            "BANK6" =>
            {
               Umask     => "b00000110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 6",
               Defn      => "",
            },
            "BANK7" =>
            {
               Umask     => "b00000111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 7",
               Defn      => "",
            },
            "BANK9" =>
            {
               Umask     => "b00001001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 9",
               Defn      => "",
            },
            "BANK10" =>
            {
               Umask     => "b00001010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 10",
               Defn      => "",
            },
            "BANK11" =>
            {
               Umask     => "b00001011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 11",
               Defn      => "",
            },
            "BANK12" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 12",
               Defn      => "",
            },
            "BANK13" =>
            {
               Umask     => "b00001101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 13",
               Defn      => "",
            },
            "BANK14" =>
            {
               Umask     => "b00001110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 14",
               Defn      => "",
            },
            "BANK15" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 15",
               Defn      => "",
            },
            "BANKG0" =>
            {
               Umask     => "b00010001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 0 (Banks 0-3)",
               Defn      => "",
            },
            "BANKG1" =>
            {
               Umask     => "b00010010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 1 (Banks 4-7)",
               Defn      => "",
            },
            "BANKG2" =>
            {
               Umask     => "b00010011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 2 (Banks 8-11)",
               Defn      => "",
            },
            "BANKG3" =>
            {
               Umask     => "b00010100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 3 (Banks 12-15)",
               Defn      => "",
            },
         },
      },
      "WR_CAS_RANK1" =>
      {
         Box       => "iMC Box Events",
         Category  => "CAS Events",
         EvSel     => 0xB9,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "WR_CAS Access to Rank 1",
         Defn      => "",
         Subevents =>
         {
            "BANK1" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 1",
               Defn      => "",
            },
            "BANK2" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 2",
               Defn      => "",
            },
            "BANK4" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 4",
               Defn      => "",
            },
            "BANK8" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 8",
               Defn      => "",
            },
            "ALLBANKS" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "All Banks",
               Defn      => "",
            },
            "BANK0" =>
            {
               Umask     => "b00000000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 0",
               Defn      => "",
            },
            "BANK3" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 3",
               Defn      => "",
            },
            "BANK5" =>
            {
               Umask     => "b00000101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 5",
               Defn      => "",
            },
            "BANK6" =>
            {
               Umask     => "b00000110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 6",
               Defn      => "",
            },
            "BANK7" =>
            {
               Umask     => "b00000111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 7",
               Defn      => "",
            },
            "BANK9" =>
            {
               Umask     => "b00001001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 9",
               Defn      => "",
            },
            "BANK10" =>
            {
               Umask     => "b00001010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 10",
               Defn      => "",
            },
            "BANK11" =>
            {
               Umask     => "b00001011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 11",
               Defn      => "",
            },
            "BANK12" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 12",
               Defn      => "",
            },
            "BANK13" =>
            {
               Umask     => "b00001101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 13",
               Defn      => "",
            },
            "BANK14" =>
            {
               Umask     => "b00001110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 14",
               Defn      => "",
            },
            "BANK15" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 15",
               Defn      => "",
            },
            "BANKG0" =>
            {
               Umask     => "b00010001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 0 (Banks 0-3)",
               Defn      => "",
            },
            "BANKG1" =>
            {
               Umask     => "b00010010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 1 (Banks 4-7)",
               Defn      => "",
            },
            "BANKG2" =>
            {
               Umask     => "b00010011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 2 (Banks 8-11)",
               Defn      => "",
            },
            "BANKG3" =>
            {
               Umask     => "b00010100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 3 (Banks 12-15)",
               Defn      => "",
            },
         },
      },
      "WR_CAS_RANK2" =>
      {
         Box       => "iMC Box Events",
         Category  => "CAS Events",
         EvSel     => 0xBA,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "WR_CAS Access to Rank 2",
         Defn      => "",
         Subevents =>
         {
         },
      },
      "WR_CAS_RANK3" =>
      {
         Box       => "iMC Box Events",
         Category  => "CAS Events",
         EvSel     => 0xBB,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "WR_CAS Access to Rank 3",
         Defn      => "",
         Subevents =>
         {
         },
      },
      "WR_CAS_RANK4" =>
      {
         Box       => "iMC Box Events",
         Category  => "CAS Events",
         EvSel     => 0xBC,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "WR_CAS Access to Rank 4",
         Defn      => "",
         Subevents =>
         {
            "BANK1" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 1",
               Defn      => "",
            },
            "BANK2" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 2",
               Defn      => "",
            },
            "BANK4" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 4",
               Defn      => "",
            },
            "BANK8" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 8",
               Defn      => "",
            },
            "ALLBANKS" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "All Banks",
               Defn      => "",
            },
            "BANK0" =>
            {
               Umask     => "b00000000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 0",
               Defn      => "",
            },
            "BANK3" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 3",
               Defn      => "",
            },
            "BANK5" =>
            {
               Umask     => "b00000101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 5",
               Defn      => "",
            },
            "BANK6" =>
            {
               Umask     => "b00000110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 6",
               Defn      => "",
            },
            "BANK7" =>
            {
               Umask     => "b00000111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 7",
               Defn      => "",
            },
            "BANK9" =>
            {
               Umask     => "b00001001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 9",
               Defn      => "",
            },
            "BANK10" =>
            {
               Umask     => "b00001010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 10",
               Defn      => "",
            },
            "BANK11" =>
            {
               Umask     => "b00001011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 11",
               Defn      => "",
            },
            "BANK12" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 12",
               Defn      => "",
            },
            "BANK13" =>
            {
               Umask     => "b00001101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 13",
               Defn      => "",
            },
            "BANK14" =>
            {
               Umask     => "b00001110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 14",
               Defn      => "",
            },
            "BANK15" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 15",
               Defn      => "",
            },
            "BANKG0" =>
            {
               Umask     => "b00010001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 0 (Banks 0-3)",
               Defn      => "",
            },
            "BANKG1" =>
            {
               Umask     => "b00010010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 1 (Banks 4-7)",
               Defn      => "",
            },
            "BANKG2" =>
            {
               Umask     => "b00010011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 2 (Banks 8-11)",
               Defn      => "",
            },
            "BANKG3" =>
            {
               Umask     => "b00010100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 3 (Banks 12-15)",
               Defn      => "",
            },
         },
      },
      "WR_CAS_RANK5" =>
      {
         Box       => "iMC Box Events",
         Category  => "CAS Events",
         EvSel     => 0xBD,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "WR_CAS Access to Rank 5",
         Defn      => "",
         Subevents =>
         {
            "BANK1" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 1",
               Defn      => "",
            },
            "BANK2" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 2",
               Defn      => "",
            },
            "BANK4" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 4",
               Defn      => "",
            },
            "BANK8" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 8",
               Defn      => "",
            },
            "ALLBANKS" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "All Banks",
               Defn      => "",
            },
            "BANK0" =>
            {
               Umask     => "b00000000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 0",
               Defn      => "",
            },
            "BANK3" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 3",
               Defn      => "",
            },
            "BANK5" =>
            {
               Umask     => "b00000101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 5",
               Defn      => "",
            },
            "BANK6" =>
            {
               Umask     => "b00000110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 6",
               Defn      => "",
            },
            "BANK7" =>
            {
               Umask     => "b00000111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 7",
               Defn      => "",
            },
            "BANK9" =>
            {
               Umask     => "b00001001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 9",
               Defn      => "",
            },
            "BANK10" =>
            {
               Umask     => "b00001010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 10",
               Defn      => "",
            },
            "BANK11" =>
            {
               Umask     => "b00001011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 11",
               Defn      => "",
            },
            "BANK12" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 12",
               Defn      => "",
            },
            "BANK13" =>
            {
               Umask     => "b00001101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 13",
               Defn      => "",
            },
            "BANK14" =>
            {
               Umask     => "b00001110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 14",
               Defn      => "",
            },
            "BANK15" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 15",
               Defn      => "",
            },
            "BANKG0" =>
            {
               Umask     => "b00010001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 0 (Banks 0-3)",
               Defn      => "",
            },
            "BANKG1" =>
            {
               Umask     => "b00010010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 1 (Banks 4-7)",
               Defn      => "",
            },
            "BANKG2" =>
            {
               Umask     => "b00010011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 2 (Banks 8-11)",
               Defn      => "",
            },
            "BANKG3" =>
            {
               Umask     => "b00010100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 3 (Banks 12-15)",
               Defn      => "",
            },
         },
      },
      "WR_CAS_RANK6" =>
      {
         Box       => "iMC Box Events",
         Category  => "CAS Events",
         EvSel     => 0xBE,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "WR_CAS Access to Rank 6",
         Defn      => "",
         Subevents =>
         {
            "BANK1" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 1",
               Defn      => "",
            },
            "BANK2" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 2",
               Defn      => "",
            },
            "BANK4" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 4",
               Defn      => "",
            },
            "BANK8" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 8",
               Defn      => "",
            },
            "ALLBANKS" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "All Banks",
               Defn      => "",
            },
            "BANK0" =>
            {
               Umask     => "b00000000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 0",
               Defn      => "",
            },
            "BANK3" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 3",
               Defn      => "",
            },
            "BANK5" =>
            {
               Umask     => "b00000101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 5",
               Defn      => "",
            },
            "BANK6" =>
            {
               Umask     => "b00000110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 6",
               Defn      => "",
            },
            "BANK7" =>
            {
               Umask     => "b00000111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 7",
               Defn      => "",
            },
            "BANK9" =>
            {
               Umask     => "b00001001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 9",
               Defn      => "",
            },
            "BANK10" =>
            {
               Umask     => "b00001010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 10",
               Defn      => "",
            },
            "BANK11" =>
            {
               Umask     => "b00001011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 11",
               Defn      => "",
            },
            "BANK12" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 12",
               Defn      => "",
            },
            "BANK13" =>
            {
               Umask     => "b00001101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 13",
               Defn      => "",
            },
            "BANK14" =>
            {
               Umask     => "b00001110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 14",
               Defn      => "",
            },
            "BANK15" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 15",
               Defn      => "",
            },
            "BANKG0" =>
            {
               Umask     => "b00010001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 0 (Banks 0-3)",
               Defn      => "",
            },
            "BANKG1" =>
            {
               Umask     => "b00010010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 1 (Banks 4-7)",
               Defn      => "",
            },
            "BANKG2" =>
            {
               Umask     => "b00010011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 2 (Banks 8-11)",
               Defn      => "",
            },
            "BANKG3" =>
            {
               Umask     => "b00010100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 3 (Banks 12-15)",
               Defn      => "",
            },
         },
      },
      "WR_CAS_RANK7" =>
      {
         Box       => "iMC Box Events",
         Category  => "CAS Events",
         EvSel     => 0xBF,
         Counters  => "0-3",
         Internal  => 0,
         Filter    => "",
         SubCtr    => 0,
         MaxIncCyc => 1,
         Desc      => "WR_CAS Access to Rank 7",
         Defn      => "",
         Subevents =>
         {
            "BANK1" =>
            {
               Umask     => "b00000001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 1",
               Defn      => "",
            },
            "BANK2" =>
            {
               Umask     => "b00000010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 2",
               Defn      => "",
            },
            "BANK4" =>
            {
               Umask     => "b00000100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 4",
               Defn      => "",
            },
            "BANK8" =>
            {
               Umask     => "b00001000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 8",
               Defn      => "",
            },
            "ALLBANKS" =>
            {
               Umask     => "b00010000",
               Counters  => "",
               Filter    => "",
               Desc      => "All Banks",
               Defn      => "",
            },
            "BANK0" =>
            {
               Umask     => "b00000000",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 0",
               Defn      => "",
            },
            "BANK3" =>
            {
               Umask     => "b00000011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 3",
               Defn      => "",
            },
            "BANK5" =>
            {
               Umask     => "b00000101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 5",
               Defn      => "",
            },
            "BANK6" =>
            {
               Umask     => "b00000110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 6",
               Defn      => "",
            },
            "BANK7" =>
            {
               Umask     => "b00000111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 7",
               Defn      => "",
            },
            "BANK9" =>
            {
               Umask     => "b00001001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 9",
               Defn      => "",
            },
            "BANK10" =>
            {
               Umask     => "b00001010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 10",
               Defn      => "",
            },
            "BANK11" =>
            {
               Umask     => "b00001011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 11",
               Defn      => "",
            },
            "BANK12" =>
            {
               Umask     => "b00001100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 12",
               Defn      => "",
            },
            "BANK13" =>
            {
               Umask     => "b00001101",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 13",
               Defn      => "",
            },
            "BANK14" =>
            {
               Umask     => "b00001110",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 14",
               Defn      => "",
            },
            "BANK15" =>
            {
               Umask     => "b00001111",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank 15",
               Defn      => "",
            },
            "BANKG0" =>
            {
               Umask     => "b00010001",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 0 (Banks 0-3)",
               Defn      => "",
            },
            "BANKG1" =>
            {
               Umask     => "b00010010",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 1 (Banks 4-7)",
               Defn      => "",
            },
            "BANKG2" =>
            {
               Umask     => "b00010011",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 2 (Banks 8-11)",
               Defn      => "",
            },
            "BANKG3" =>
            {
               Umask     => "b00010100",
               Counters  => "",
               Filter    => "",
               Desc      => "Bank Group 3 (Banks 12-15)",
               Defn      => "",
            },
         },
      },
   },
);
