################################################################################
# Event List for Pouson BBox
################################################################################
%PSNBBoxEventList=
(
  "ARB_Q0_INSERTS" =>
  {
    Category  => "ARB Events",
    EvSel     => "0x9",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Arbiter Queue 0 Inserts",
    Defn      => "An insert (write) to the selected ARB queue.]",
    SubEvents  =>
    {
       "CFL0" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x00",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 0",
       },
       "CFL1" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x01",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 1",
       },
       "CFL2" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x02",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 2",
       },
       "CFL3" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x03",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 3",
       },
       "CFL4" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x04",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 4",
       },
       "CFL5" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x05",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 5",
       },
       "CFL6" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x06",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 6",
       },
       "CFL7" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x07",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 7",
       },
       "CFL8" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x08",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 8",
       },
       "CFL9" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x09",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 9",
       },
       "CFL10" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0a",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 10",
       },
       "CFL11" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0b",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 11",
       },
       "CFL12" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0c",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 12",
       },
       "CFL13" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0d",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 13",
       },
       "CFL14" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0e",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 14",
       },
       "CFL15" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0f",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 15",
       },
       "CFL16" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x10",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 16",
       },
       "CFL17" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x11",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 17",
       },
       "CFL18" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x12",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 18",
       },
       "CFL19" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x13",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 19",
       },
       "CFL20" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x14",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 20",
       },
       "CFL21" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x15",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 21",
       },
       "CFL22" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x16",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 22",
       },
       "CFL23" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x17",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 23",
       },
       "CFL24" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x18",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 24",
       },
       "CFL25" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x19",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 25",
       },
       "CFL26" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1a",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 26",
       },
       "CFL27" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1b",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 27",
       },
       "CFL28" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1c",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 28",
       },
       "CFL29" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1d",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 29",
       },
       "CFL30" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1e",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 30",
       },
       "CFL31" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1f",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 31",
       },
       "CFL32" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x20",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 32",
       },
       "CFL33" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x21",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 33",
       },
       "CFL34" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x22",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 34",
       },
       "CFL35" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x23",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 35",
       },
       "CFL36" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x24",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 36",
       },
       "CFL37" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x25",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 37",
       },
       "CFL38" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x26",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 38",
       },
       "CFL39" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x27",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 39",
       },
       "CFL40" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x28",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 40",
       },
       "CFL41" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x29",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 41",
       },
       "CFL42" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2a",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 42",
       },
       "CFL43" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2b",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 43",
       },
       "CFL44" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2c",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 44",
       },
       "CFL45" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2d",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 45",
       },
       "CFL46" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2e",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 46",
       },
       "CFL47" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2f",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 47",
       },
       "ANY_CFL" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x30",
          RegSubCtr  => "",
          Desc       => "Any Conflict Queue",
       },
       "RIAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x31",
          RegSubCtr  => "",
          Desc       => "RIAQ(NCS) Queue",
       },
       "WIAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x32",
          RegSubCtr  => "",
          Desc       => "WIAQ(NCB) Queue",
       },
       "BRAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x33",
          RegSubCtr  => "",
          Desc       => "BRAQ(DRS) Queue",
       },
       "NBRAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x34",
          RegSubCtr  => "",
          Desc       => "NBAQ(NBR) Queue",
       },
       "COHQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x35",
          RegSubCtr  => "",
          Desc       => "COHQ Queue",
       },
       "NONE" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x36",
          RegSubCtr  => "",
          Desc       => "(* nothing will be counted *)",
       },
       "CLM" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x37",
          RegSubCtr  => "",
          Desc       => "CLM Queue",
       },
       "SAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x38",
          RegSubCtr  => "",
          Desc       => "Or of CLM ,BRAQ, RIAQ and WIAQ Queues",
       },
       "ANY_CFL2" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x39",
          RegSubCtr  => "",
          Desc       => "Any Conflict Queues",
       },
       "NONE2" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x3f-3a",
          RegSubCtr  => "",
          Desc       => "(* nothing will be counted *)",
       },
     },
  },
  "ARB_Q0_NE_CYCLES" =>
  {
    Category  => "ARB Events",
    EvSel     => "0xb",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Cycles Arbiter Queue 0 Not Empty",
    Defn      => "Cycles when the selected queue(s) is not empty",
    SubEvents  =>
    {
       "CFL0" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x00",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 0",
       },
       "CFL1" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x01",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 1",
       },
       "CFL2" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x02",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 2",
       },
       "CFL3" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x03",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 3",
       },
       "CFL4" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x04",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 4",
       },
       "CFL5" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x05",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 5",
       },
       "CFL6" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x06",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 6",
       },
       "CFL7" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x07",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 7",
       },
       "CFL8" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x08",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 8",
       },
       "CFL9" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x09",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 9",
       },
       "CFL10" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0a",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 10",
       },
       "CFL11" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0b",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 11",
       },
       "CFL12" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0c",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 12",
       },
       "CFL13" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0d",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 13",
       },
       "CFL14" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0e",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 14",
       },
       "CFL15" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0f",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 15",
       },
       "CFL16" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x10",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 16",
       },
       "CFL17" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x11",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 17",
       },
       "CFL18" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x12",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 18",
       },
       "CFL19" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x13",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 19",
       },
       "CFL20" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x14",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 20",
       },
       "CFL21" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x15",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 21",
       },
       "CFL22" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x16",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 22",
       },
       "CFL23" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x17",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 23",
       },
       "CFL24" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x18",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 24",
       },
       "CFL25" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x19",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 25",
       },
       "CFL26" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1a",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 26",
       },
       "CFL27" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1b",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 27",
       },
       "CFL28" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1c",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 28",
       },
       "CFL29" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1d",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 29",
       },
       "CFL30" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1e",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 30",
       },
       "CFL31" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1f",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 31",
       },
       "CFL32" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x20",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 32",
       },
       "CFL33" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x21",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 33",
       },
       "CFL34" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x22",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 34",
       },
       "CFL35" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x23",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 35",
       },
       "CFL36" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x24",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 36",
       },
       "CFL37" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x25",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 37",
       },
       "CFL38" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x26",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 38",
       },
       "CFL39" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x27",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 39",
       },
       "CFL40" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x28",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 40",
       },
       "CFL41" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x29",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 41",
       },
       "CFL42" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2a",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 42",
       },
       "CFL43" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2b",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 43",
       },
       "CFL44" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2c",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 44",
       },
       "CFL45" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2d",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 45",
       },
       "CFL46" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2e",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 46",
       },
       "CFL47" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2f",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 47",
       },
       "ANY_CFL" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x30",
          RegSubCtr  => "",
          Desc       => "Any Conflict Queue",
       },
       "RIAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x31",
          RegSubCtr  => "",
          Desc       => "RIAQ(NCS) Queue",
       },
       "WIAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x32",
          RegSubCtr  => "",
          Desc       => "WIAQ(NCB) Queue",
       },
       "BRAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x33",
          RegSubCtr  => "",
          Desc       => "BRAQ(DRS) Queue",
       },
       "NBRAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x34",
          RegSubCtr  => "",
          Desc       => "NBAQ(NBR) Queue",
       },
       "COHQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x35",
          RegSubCtr  => "",
          Desc       => "COHQ Queue",
       },
       "NONE" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x36",
          RegSubCtr  => "",
          Desc       => "(* nothing will be counted *)",
       },
       "CLM" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x37",
          RegSubCtr  => "",
          Desc       => "CLM Queue",
       },
       "SAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x38",
          RegSubCtr  => "",
          Desc       => "Or of CLM ,BRAQ, RIAQ and WIAQ Queues",
       },
       "ANY_CFL2" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x39",
          RegSubCtr  => "",
          Desc       => "Any Conflict Queues",
       },
       "NONE2" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x3f-3a",
          RegSubCtr  => "",
          Desc       => "(* nothing will be counted *)",
       },
     },
  },
  "ARB_Q0_OCCUPANCY" =>
  {
    Category  => "ARB Events",
    EvSel     => "0x8",
    MaxIncCyc => 1,
    RegSubCtr => "B_CSR_ARB_PERF_CNT0",
    Desc      => "Arbiter Queue 0 Occupancy",
    Defn      => "Overflow from arbiter subcounter accumulating live events B_CSR_PERF_CTL2.arbq_sel0 selects which arbiter queue(s) to monitor.",
    Notes     => "Set B_CSR_PERF_CTL0.arb_en to enable the subcounter which, in turn, enables this event. To obtain the number of arbiter transactions, multiply by 2^10 and add B_CSR_ARB_PERF_CNT0.accum_cnt[9:0].",
    SubEvents  =>
    {
       "NONE1" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,B_CSR_PERF_CTL2",
          RegDepBits => "[10]0x1,[5:0]0x2f-0x00",
          RegSubCtr  => "",
          Desc       => "(* nothing will be counted *)",
       },
       "NE_CFL" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,B_CSR_PERF_CTL2",
          RegDepBits => "[10]0x1,[5:0]0x30",
          RegSubCtr  => "",
          Desc       => "Number of Non-Empty Conflict Queues",
       },
       "RIAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,B_CSR_PERF_CTL2",
          RegDepBits => "[10]0x1,[5:0]0x31",
          RegSubCtr  => "",
          Desc       => "RIAQ(NCS) Queue",
       },
       "WIAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,B_CSR_PERF_CTL2",
          RegDepBits => "[10]0x1,[5:0]0x32",
          RegSubCtr  => "",
          Desc       => "WIAQ(NCB) Queue",
       },
       "BRAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,B_CSR_PERF_CTL2",
          RegDepBits => "[10]0x1,[5:0]0x33",
          RegSubCtr  => "",
          Desc       => "BRAQ(DRS) Queue",
       },
       "NBAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,B_CSR_PERF_CTL2",
          RegDepBits => "[10]0x1,[5:0]0x34",
          RegSubCtr  => "",
          Desc       => "NBAQ(NBR) Queue",
       },
       "COHQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,B_CSR_PERF_CTL2",
          RegDepBits => "[10]0x1,[5:0]0x35",
          RegSubCtr  => "",
          Desc       => "COHQ Queue",
       },
       "NONE" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,B_CSR_PERF_CTL2",
          RegDepBits => "[10]0x1,[5:0]0x36",
          RegSubCtr  => "",
          Desc       => "(* nothing will be counted *)",
       },
       "CLM" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,B_CSR_PERF_CTL2",
          RegDepBits => "[10]0x1,[5:0]0x37",
          RegSubCtr  => "",
          Desc       => "CLM Queue",
       },
       "NONE2" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,B_CSR_PERF_CTL2",
          RegDepBits => "[10]0x1,[5:0]0x3f-0x38",
          RegSubCtr  => "",
          Desc       => "(* nothing will be counted *)",
       },
     },
  },
  "ARB_Q0_REMOVE" =>
  {
    Category  => "ARB Events",
    EvSel     => "0xa",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Arbiter Queue 0 Remove",
    Defn      => "A remove (read) from the selected ARB queue.",
    SubEvents  =>
    {
       "CFL0" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x00",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 0",
       },
       "CFL1" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x01",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 1",
       },
       "CFL2" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x02",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 2",
       },
       "CFL3" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x03",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 3",
       },
       "CFL4" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x04",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 4",
       },
       "CFL5" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x05",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 5",
       },
       "CFL6" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x06",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 6",
       },
       "CFL7" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x07",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 7",
       },
       "CFL8" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x08",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 8",
       },
       "CFL9" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x09",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 9",
       },
       "CFL10" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0a",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 10",
       },
       "CFL11" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0b",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 11",
       },
       "CFL12" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0c",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 12",
       },
       "CFL13" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0d",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 13",
       },
       "CFL14" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0e",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 14",
       },
       "CFL15" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0f",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 15",
       },
       "CFL16" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x10",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 16",
       },
       "CFL17" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x11",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 17",
       },
       "CFL18" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x12",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 18",
       },
       "CFL19" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x13",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 19",
       },
       "CFL20" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x14",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 20",
       },
       "CFL21" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x15",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 21",
       },
       "CFL22" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x16",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 22",
       },
       "CFL23" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x17",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 23",
       },
       "CFL24" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x18",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 24",
       },
       "CFL25" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x19",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 25",
       },
       "CFL26" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1a",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 26",
       },
       "CFL27" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1b",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 27",
       },
       "CFL28" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1c",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 28",
       },
       "CFL29" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1d",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 29",
       },
       "CFL30" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1e",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 30",
       },
       "CFL31" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1f",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 31",
       },
       "CFL32" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x20",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 32",
       },
       "CFL33" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x21",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 33",
       },
       "CFL34" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x22",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 34",
       },
       "CFL35" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x23",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 35",
       },
       "CFL36" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x24",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 36",
       },
       "CFL37" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x25",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 37",
       },
       "CFL38" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x26",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 38",
       },
       "CFL39" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x27",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 39",
       },
       "CFL40" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x28",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 40",
       },
       "CFL41" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x29",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 41",
       },
       "CFL42" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2a",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 42",
       },
       "CFL43" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2b",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 43",
       },
       "CFL44" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2c",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 44",
       },
       "CFL45" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2d",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 45",
       },
       "CFL46" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2e",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 46",
       },
       "CFL47" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2f",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 47",
       },
       "ANY_CFL" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x30",
          RegSubCtr  => "",
          Desc       => "Any Conflict Queue",
       },
       "RIAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x31",
          RegSubCtr  => "",
          Desc       => "RIAQ(NCS) Queue",
       },
       "WIAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x32",
          RegSubCtr  => "",
          Desc       => "WIAQ(NCB) Queue",
       },
       "BRAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x33",
          RegSubCtr  => "",
          Desc       => "BRAQ(DRS) Queue",
       },
       "NBRAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x34",
          RegSubCtr  => "",
          Desc       => "NBAQ(NBR) Queue",
       },
       "COHQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x35",
          RegSubCtr  => "",
          Desc       => "COHQ Queue",
       },
       "NONE" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x36",
          RegSubCtr  => "",
          Desc       => "(* nothing will be counted *)",
       },
       "CLM" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x37",
          RegSubCtr  => "",
          Desc       => "CLM Queue",
       },
       "SAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x38",
          RegSubCtr  => "",
          Desc       => "Or of CLM ,BRAQ, RIAQ and WIAQ Queues",
       },
       "ANY_CFL2" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x39",
          RegSubCtr  => "",
          Desc       => "Any Conflict Queues",
       },
       "NONE2" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x3f-3a",
          RegSubCtr  => "",
          Desc       => "(* nothing will be counted *)",
       },
     },
  },
  "ARB_Q0_THOCCUPANCY" =>
  {
    Category  => "ARB Events",
    EvSel     => "0xc",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Arbiter Queue 0 Occupancy (Thresholded)",
    Defn      => "Cycles selected arbiter queues occupancy exceeds threshold.",
    Notes     => "Set B_CSR_PERF_CTL0.arb_en to enable the subcounter which, in turn, enables this event. To obtain the number of arbiter transactions, multiply by 2^10 and add B_CSR_ARB_PERF_CNT0.accum_cnt[9:0]. The occupancy of the selected ARBQ is tested against the B_CSR_PERF_CTL2.arb_thresh (bits [17:12]). In any given cycle, if the occupancy exceeds the threshold, this event will be recorded.",
    SubEvents  =>
    {
       "NONE" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,",
          RegDepBits => "[10]0x1,[5:0]0x30-0x00",
          RegSubCtr  => "",
          Desc       => "(* nothing will be counted *)",
       },
       "RIAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,",
          RegDepBits => "[10]0x1,[5:0]0x31, [17:12] US",
          RegSubCtr  => "",
          Desc       => "RIAQ(NCS) Queue",
       },
       "WIAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,",
          RegDepBits => "[10]0x1,[5:0]0x32, [17:12] US",
          RegSubCtr  => "",
          Desc       => "WIAQ(NCB) Queue",
       },
       "BRAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,",
          RegDepBits => "[10]0x1,[5:0]0x33, [17:12] US",
          RegSubCtr  => "",
          Desc       => "BRAQ(DRS) Queue",
       },
       "NBRAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,",
          RegDepBits => "[10]0x1,[5:0]0x34, [17:12] US",
          RegSubCtr  => "",
          Desc       => "NBAQ(NBR) Queue",
       },
       "COHQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,",
          RegDepBits => "[10]0x1,[5:0]0x35, [17:12] US",
          RegSubCtr  => "",
          Desc       => "COHQ Queue",
       },
       "NONE2" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,",
          RegDepBits => "[10]0x1,[5:0]0x36",
          RegSubCtr  => "",
          Desc       => "(* nothing will be counted *)",
       },
       "CLM" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,",
          RegDepBits => "[10]0x1,[5:0]0x37, [17:12] US",
          RegSubCtr  => "",
          Desc       => "CLM Queue",
       },
       "SAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,",
          RegDepBits => "[10]0x1,[5:0]0x38, [17:12] US",
          RegSubCtr  => "",
          Desc       => "Or of CLM ,BRAQ, RIAQ and WIAQ Queues",
       },
       "ANY_CFL2" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,",
          RegDepBits => "[10]0x1,[5:0]0x39, [17:12] US",
          RegSubCtr  => "",
          Desc       => "First Insert into any empty conflict queue",
       },
       "NONE3" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,",
          RegDepBits => "[10]0x1,[5:0]0x3f-3a",
          RegSubCtr  => "",
          Desc       => "(* nothing will be counted *)",
       },
     },
  },
  "ARB_Q1_EMPTY_INSERT" =>
  {
    Category  => "ARB Events",
    EvSel     => "0x11",
    MaxIncCyc => 1,
    RegDep     => "B_CSR_PERF_CTL0",
    RegDepBits => "[10]0x1",
    RegSubCtr => "",
    Desc      => "Insert to Empty Arbiter Queue",
    Defn      => "Insert to any empty arb counter(s).",
  },
  "ARB_Q1_INSERTS" =>
  {
    Category  => "ARB Events",
    EvSel     => "0xe",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Arbiter Queue 1 Inserts",
    Defn      => "An insert (write) to the selected ARB queue.]",
  },
  "ARB_Q1_NE_CYCLES" =>
  {
    Category  => "ARB Events",
    EvSel     => "0x10",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Cycles Arbiter Queue 1 Not Empty",
    Defn      => "Cycles when the selected queue(s) is not empty",
    SubEvents  =>
    {
       "CFL0" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x00",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 0",
       },
       "CFL1" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x01",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 1",
       },
       "CFL2" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x02",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 2",
       },
       "CFL3" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x03",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 3",
       },
       "CFL4" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x04",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 4",
       },
       "CFL5" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x05",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 5",
       },
       "CFL6" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x06",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 6",
       },
       "CFL7" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x07",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 7",
       },
       "CFL8" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x08",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 8",
       },
       "CFL9" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x09",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 9",
       },
       "CFL10" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0a",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 10",
       },
       "CFL11" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0b",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 11",
       },
       "CFL12" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0c",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 12",
       },
       "CFL13" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0d",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 13",
       },
       "CFL14" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0e",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 14",
       },
       "CFL15" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x0f",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 15",
       },
       "CFL16" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x10",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 16",
       },
       "CFL17" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x11",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 17",
       },
       "CFL18" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x12",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 18",
       },
       "CFL19" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x13",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 19",
       },
       "CFL20" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x14",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 20",
       },
       "CFL21" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x15",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 21",
       },
       "CFL22" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x16",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 22",
       },
       "CFL23" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x17",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 23",
       },
       "CFL24" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x18",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 24",
       },
       "CFL25" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x19",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 25",
       },
       "CFL26" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1a",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 26",
       },
       "CFL27" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1b",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 27",
       },
       "CFL28" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1c",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 28",
       },
       "CFL29" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1d",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 29",
       },
       "CFL30" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1e",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 30",
       },
       "CFL31" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x1f",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 31",
       },
       "CFL32" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x20",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 32",
       },
       "CFL33" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x21",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 33",
       },
       "CFL34" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x22",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 34",
       },
       "CFL35" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x23",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 35",
       },
       "CFL36" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x24",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 36",
       },
       "CFL37" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x25",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 37",
       },
       "CFL38" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x26",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 38",
       },
       "CFL39" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x27",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 39",
       },
       "CFL40" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x28",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 40",
       },
       "CFL41" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x29",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 41",
       },
       "CFL42" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2a",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 42",
       },
       "CFL43" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2b",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 43",
       },
       "CFL44" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2c",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 44",
       },
       "CFL45" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2d",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 45",
       },
       "CFL46" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2e",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 46",
       },
       "CFL47" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x2f",
          RegSubCtr  => "",
          Desc       => "Conflict Queue 47",
       },
       "ANY_CFL" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x30",
          RegSubCtr  => "",
          Desc       => "Any Conflict Queue",
       },
       "RIAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x31",
          RegSubCtr  => "",
          Desc       => "RIAQ(NCS) Queue",
       },
       "WIAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x32",
          RegSubCtr  => "",
          Desc       => "WIAQ(NCB) Queue",
       },
       "BRAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x33",
          RegSubCtr  => "",
          Desc       => "BRAQ(DRS) Queue",
       },
       "NBRAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x34",
          RegSubCtr  => "",
          Desc       => "NBAQ(NBR) Queue",
       },
       "COHQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x35",
          RegSubCtr  => "",
          Desc       => "COHQ Queue",
       },
       "NONE" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x36",
          RegSubCtr  => "",
          Desc       => "(* nothing will be counted *)",
       },
       "CLM" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x37",
          RegSubCtr  => "",
          Desc       => "CLM Queue",
       },
       "SAQ" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x38",
          RegSubCtr  => "",
          Desc       => "Or of CLM ,BRAQ, RIAQ and WIAQ Queues",
       },
       "ANY_CFL2" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x39",
          RegSubCtr  => "",
          Desc       => "Any Conflict Queues",
       },
       "NONE2" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[5:0]0x3f-3a",
          RegSubCtr  => "",
          Desc       => "(* nothing will be counted *)",
       },
     },
  },
  "ARB_Q1_OCCUPANCY" =>
  {
    Category  => "ARB Events",
    EvSel     => "0xd",
    MaxIncCyc => 1,
    RegDep     => "B_CSR_PERF_CTL0",
    RegDepBits => "[10]0x1",
    RegSubCtr => "B_CSR_ARB_PERF_CNT0",
    Desc      => "Arbiter Queue 1 Occupancy",
    Defn      => "Overflow from arbiter subcounter accumulating live events B_CSR_PERF_CTL2.arbq_sel0 selects which arbiter queue(s) to monitor.",
    Notes     => "Set B_CSR_PERF_CTL0.arb_en to enable the subcounter which, in turn, enables this event. To obtain the number of arbiter transactions, multiply by 2^10 and add B_CSR_ARB_PERF_CNT0.accum_cnt[9:0].",
  },
  "ARB_Q1_REMOVE" =>
  {
    Category  => "ARB Events",
    EvSel     => "0xf",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Arbiter Queue 1 Remove",
    Defn      => "A remove (read) from the selected ARB queue.",
  },
  "BZ_ACK" =>
  {
    Category  => "BZ Events",
    EvSel     => "0x22",
    MaxIncCyc => 1,
    RegDep     => "B_CSR_PERF_CTL0,B_CSR_PERF_CTL2",
    RegDepBits => "[12]0x1, [36:21]US",
    RegSubCtr => "",
    Desc      => "BZ Acknowledge",
    Defn      => "First BZ acknowledge that acknowledges a BZ command that matched B_CSR_PERF_CTL2.z_op.",
    Notes     => "Enabled by B_CSR_PERF_CTL0.bz_en. Since fill2b requests are not acknowledged by ZBox , a local acknowledge is created so count of all requests equals count of all acknowledges. Fill2b events should be counted separately from any other opcodes (configured by B_CSR_PERF_CTL2.z_op (CTL2[36:21])). Used to compute avg. z-box latency; (if this event is used to monitor latency need to exclude fill2b)",
  },
  "BZ_ACK_ALL" =>
  {
    Category  => "BZ Events",
    EvSel     => "0x23",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "All BZ Acknowledges",
    Defn      => "Number of BZ commands acknowledged by Z-box.  Not possible to pick commands; Possible that Z-box sent multiple acks per command it received.",
    Notes     => "fill2b are not ack by Z-box; Hence these are not counted here",
  },
  "BZ_CYCLES_TRANS_OUT" =>
  {
    Category  => "BZ Events",
    EvSel     => "0x24",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Cycles Z-Box Transactions Outstanding",
    Defn      => "Cycles there are outstanding transactions destined for the Z-Box within a given threshold.",
    Notes     => "Enabled by B_CSR_PERF_CTL0.bz_en.",
    SubEvents  =>
    {
       "LT_THRESH" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,B_CSR_PERF_CTL2",
          RegDepBits => "[12]0x1,[42:37]US && [43]0x0",
          RegSubCtr  => "",
          Desc       => "less than watermark",
       },
       "GE_THRESH" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,B_CSR_PERF_CTL2",
          RegDepBits => "[12]0x1,[42:37]US && [43]0x1",
          RegSubCtr  => "",
          Desc       => "greater than or equal to watermark",
       },
     },
  },
  "BZ_OCCUPANCY" =>
  {
    Category  => "BZ Events",
    EvSel     => "0x21",
    MaxIncCyc => 1,
    RegDep     => "B_CSR_PERF_CTL0,B_CSR_PERF_CTL2",
    RegDepBits => "[12]0x1, [36:21]US",
    RegSubCtr => "B_CSR_BZ_PERF_CNT",
    Desc      => "BZ Occupancy",
    Defn      => "Cumulative number of selected BZ commands outstanding in Z-box
Fully decoded bits are present to select combination of opcodes",
    Notes     => "Enabled by B_CSR_PERF_CTL0.bz_en. To obtain correct number of BZ Transactions, multiply by 2^6 and add B_CSR_BZ_PERF_CNT.accum_cnt[5:0]. Since fill2b are not acknowledged by ZBox, fill2b opcode should be excluded from B_CSR_PERF_CTL2.z_op (CTL2[36:21]). Used to compute avg. z-box latency; Partial latency of b-box included (customers should program correctly to exclude fill2b)",
  },
  "BZ_OP_MATCH" =>
  {
    Category  => "BZ Events",
    EvSel     => "0x31",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "BZ Request Opcode Match",
    Defn      => "BZ requests that match opcodes selected in B_CSR_PERF_CTL2.z_op",
  },
  "B_CYCLES" =>
  {
    Category  => "Miscellaneous Events",
    EvSel     => "0x25",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "B-Box Clock Cycles",
    Defn      => "Increment by 1 every clock (when the counter is enabled)",
  },
  "DC_EVENT0" =>
  {
    Category  => "DC Events",
    EvSel     => "0x12",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Directory Cache Event 0",
    Defn      => "Directory Cache Event 0",
    SubEvents  =>
    {
       "TRANS_OCCUPANCY" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_CTL1",
          RegDepBits => "[4:0]0x0, [15:0]US",
          RegSubCtr  => "B_CSR_DC_PERF_CNT",
          Desc       => "Outstanding transactions matching DC Opcode (B_CSR_DC_PERF_CTL1.dc_opcode) that have overflowed the accumulator (B_CSR_DC_PERF_CNT).",
       },
       "TRANS_INSERT" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_CTL1",
          RegDepBits => "[4:0]0x1, [15:0]US",
          RegSubCtr  => "",
          Desc       => "Number of transactions entering DC matching DC Opcode (B_CSR_DC_PERF_CTL1.dc_opcode)",
       },
       "TRANS_REMOVE" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_CTL1",
          RegDepBits => "[4:0]0x2, [15:0]US",
          RegSubCtr  => "",
          Desc       => "Number of transactions removed from DC matching DC Opcode (B_CSR_DC_PERF_CTL1.dc_opcode)",
       },
       "TRANS_INSERT" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_WMARK",
          RegDepBits => "[4:0]0x3, [5:0]US && [6]0x0",
          RegSubCtr  => "",
          Desc       => "Cycles that number of outstanding DC transactions is less than or equal to number specified in B_CSR_DC_PERF_WMARK[5:0].",
       },
       "CYCLES_TRANS_OUT.THRESH_GT" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_WMARK",
          RegDepBits => "[4:0]0x3, [5:0]US && [6]0x1",
          RegSubCtr  => "",
          Desc       => "Cycles that number of outstanding DC transactions is greater than or equal to number specified in B_CSR_DC_PERF_WMARK[5:0].",
       },
       "FULL" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x4",
          RegSubCtr  => "",
          Desc       => "DC is full",
       },
       "NON_EMPTY" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x5",
          RegSubCtr  => "",
          Desc       => "DC is not empty",
       },
       "MATCH_READ" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_CTL1",
          RegDepBits => "[4:0]0x6, [15:0]US",
          RegSubCtr  => "",
          Desc       => "Matching DC read event.",
       },
       "MATCH_WRITE" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x7",
          RegSubCtr  => "",
          Desc       => "Matching DC write event.",
       },
       "NEED_SNOOPS" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x8",
          RegSubCtr  => "",
          Desc       => "New transaction requires snoops",
       },
       "LINE_EVICT" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x9",
          RegSubCtr  => "",
          Desc       => "DC line eviction event.",
       },
       "MATCH_READ_2ND_LOOK" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0xa, [15:0]US",
          RegSubCtr  => "",
          Desc       => "Matching DC read second lookup.",
       },
       "SNP_LOC" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0xb",
          RegSubCtr  => "",
          Desc       => "Snoops caused by cell local memory accesses",
       },
       "MATCH_WRITE2" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0xc",
          RegSubCtr  => "",
          Desc       => "Matching DC write event 2",
       },
       "LINE_ALLOC" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0xd",
          RegSubCtr  => "",
          Desc       => "DC line allocation event",
       },
     },
  },
  "DC_EVENT1" =>
  {
    Category  => "DC Events",
    EvSel     => "0x13",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Directory Cache Event 1",
    Defn      => "Directory Cache Event 1",
    SubEvents  =>
    {
       "TRANS_OCCUPANCY" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_CTL1",
          RegDepBits => "[11]0x1, [4:0]0x0, [15:0]US",
          RegSubCtr  => "B_CSR_DC_PERF_CNT",
          Desc       => "Outstanding transactions matching DC Opcode (B_CSR_DC_PERF_CTL1.dc_opcode) that have overflowed the accumulator (B_CSR_DC_PERF_CNT).",
       },
       "TRANS_INSERT" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_CTL1",
          RegDepBits => "[4:0]0x1, [15:0]US",
          RegSubCtr  => "",
          Desc       => "Number of transactions entering DC matching DC Opcode (B_CSR_DC_PERF_CTL1.dc_opcode)",
       },
       "TRANS_REMOVE" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_CTL1",
          RegDepBits => "[4:0]0x2, [15:0]US",
          RegSubCtr  => "",
          Desc       => "Number of transactions removed from DC matching DC Opcode (B_CSR_DC_PERF_CTL1.dc_opcode)",
       },
       "CYCLES_TRANS_OUT.THRESH_LE" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_WMARK",
          RegDepBits => "[4:0]0x3, [5:0]US && [6]0x0",
          RegSubCtr  => "",
          Desc       => "Cycles that number of outstanding DC transactions is less than or equal to number specified in B_CSR_DC_PERF_WMARK[5:0].",
       },
       "CYCLES_TRANS_OUT.THRESH_GT" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_WMARK",
          RegDepBits => "[4:0]0x3, [5:0]US && [6]0x1",
          RegSubCtr  => "",
          Desc       => "Cycles that number of outstanding DC transactions is greater than or equal to number specified in B_CSR_DC_PERF_WMARK[5:0].",
       },
       "FULL" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x4",
          RegSubCtr  => "",
          Desc       => "DC is full",
       },
       "NON_EMPTY" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x5",
          RegSubCtr  => "",
          Desc       => "DC is not empty",
       },
       "MATCH_READ" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_CTL1",
          RegDepBits => "[4:0]0x6, [15:0]US",
          RegSubCtr  => "",
          Desc       => "Matching DC read event.",
       },
       "MATCH_WRITE" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x7",
          RegSubCtr  => "",
          Desc       => "Matching DC write event.",
       },
       "NEED_SNOOPS" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x8",
          RegSubCtr  => "",
          Desc       => "New transaction requires snoops",
       },
       "LINE_EVICT" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x9",
          RegSubCtr  => "",
          Desc       => "DC line eviction event.",
       },
       "MATCH_READ_2ND_LOOk" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0xa, [15:0]US",
          RegSubCtr  => "",
          Desc       => "Matching DC read second lookup.",
       },
       "SNP_LOC" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0xb",
          RegSubCtr  => "",
          Desc       => "Snoops caused by cell local memory accesses",
       },
       "MATCH_WRITE2" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0xc",
          RegSubCtr  => "",
          Desc       => "Matching DC write event 2",
       },
       "LINE_ALLOC" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0xd",
          RegSubCtr  => "",
          Desc       => "DC line allocation event",
       },
     },
  },
  "DC_EVENT2" =>
  {
    Category  => "DC Events",
    EvSel     => "0x14",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Directory Cache Event 2",
    Defn      => "Directory Cache Event 2",
    SubEvents  =>
    {
       "TRANS_OCCUPANCY" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_CTL1",
          RegDepBits => "[11]0x1, [4:0]0x0, [15:0]US",
          RegSubCtr  => "B_CSR_DC_PERF_CNT",
          Desc       => "Outstanding transactions matching DC Opcode (B_CSR_DC_PERF_CTL1.dc_opcode) that have overflowed the accumulator (B_CSR_DC_PERF_CNT).",
       },
       "TRANS_INSERT" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_CTL1",
          RegDepBits => "[4:0]0x1, [15:0]US",
          RegSubCtr  => "",
          Desc       => "Number of transactions entering DC matching DC Opcode (B_CSR_DC_PERF_CTL1.dc_opcode)",
       },
       "TRANS_REMOVE" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_CTL1",
          RegDepBits => "[4:0]0x2, [15:0]US",
          RegSubCtr  => "",
          Desc       => "Number of transactions removed from DC matching DC Opcode (B_CSR_DC_PERF_CTL1.dc_opcode)",
       },
       "CYCLES_TRANS_OUT.THRESH_LE" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_WMARK",
          RegDepBits => "[4:0]0x3, [5:0]US && [6]0x0",
          RegSubCtr  => "",
          Desc       => "Cycles that number of outstanding DC transactions is less than or equal to number specified in B_CSR_DC_PERF_WMARK[5:0].",
       },
       "CYCLES_TRANS_OUT.THRESH_GT" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_WMARK",
          RegDepBits => "[4:0]0x3, [5:0]US && [6]0x1",
          RegSubCtr  => "",
          Desc       => "Cycles that number of outstanding DC transactions is greater than or equal to number specified in B_CSR_DC_PERF_WMARK[5:0].",
       },
       "FULL" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x4",
          RegSubCtr  => "",
          Desc       => "DC is full",
       },
       "NON_EMPTY" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x5",
          RegSubCtr  => "",
          Desc       => "DC is not empty",
       },
       "MATCH_READ" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_CTL1",
          RegDepBits => "[4:0]0x6, [15:0]US",
          RegSubCtr  => "",
          Desc       => "Matching DC read event.",
       },
       "MATCH_WRITE" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x7",
          RegSubCtr  => "",
          Desc       => "Matching DC write event.",
       },
       "NEED_SNOOPS" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x8",
          RegSubCtr  => "",
          Desc       => "New transaction requires snoops",
       },
       "LINE_EVICT" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x9",
          RegSubCtr  => "",
          Desc       => "DC line eviction event.",
       },
       "MATCH_READ_2ND_LOOk" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0xa, [15:0]US",
          RegSubCtr  => "",
          Desc       => "Matching DC read second lookup.",
       },
       "SNP_LOC" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0xb",
          RegSubCtr  => "",
          Desc       => "Snoops caused by cell local memory accesses",
       },
       "MATCH_WRITE2" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0xc",
          RegSubCtr  => "",
          Desc       => "Matching DC write event 2",
       },
       "LINE_ALLOC" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0xd",
          RegSubCtr  => "",
          Desc       => "DC line allocation event",
       },
     },
  },
  "DC_EVENT3" =>
  {
    Category  => "DC Events",
    EvSel     => "0x15",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Directory Cache Event 3",
    Defn      => "Directory Cache Event 3",
    SubEvents  =>
    {
       "TRANS_OCCUPANCY" =>
       {
          RegDep     => "B_CSR_PERF_CTL0,B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_CTL1",
          RegDepBits => "[11]0x1, [4:0]0x0, [15:0]US",
          RegSubCtr  => "B_CSR_DC_PERF_CNT",
          Desc       => "Outstanding transactions matching DC Opcode (B_CSR_DC_PERF_CTL1.dc_opcode) that have overflowed the accumulator (B_CSR_DC_PERF_CNT).",
       },
       "TRANS_INSERT" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_CTL1",
          RegDepBits => "[4:0]0x1, [15:0]US",
          RegSubCtr  => "",
          Desc       => "Number of transactions entering DC matching DC Opcode (B_CSR_DC_PERF_CTL1.dc_opcode)",
       },
       "TRANS_REMOVE" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_CTL1",
          RegDepBits => "[4:0]0x2, [15:0]US",
          RegSubCtr  => "",
          Desc       => "Number of transactions removed from DC matching DC Opcode (B_CSR_DC_PERF_CTL1.dc_opcode)",
       },
       "CYCLES_TRANS_OUT.THRESH_LE" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_WMARK",
          RegDepBits => "[4:0]0x3, [5:0]US && [6]0x0",
          RegSubCtr  => "",
          Desc       => "Cycles that number of outstanding DC transactions is less than or equal to number specified in B_CSR_DC_PERF_WMARK[5:0].",
       },
       "CYCLES_TRANS_OUT.THRESH_GT" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_WMARK",
          RegDepBits => "[4:0]0x3, [5:0]US && [6]0x1",
          RegSubCtr  => "",
          Desc       => "Cycles that number of outstanding DC transactions is greater than or equal to number specified in B_CSR_DC_PERF_WMARK[5:0].",
       },
       "FULL" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x4",
          RegSubCtr  => "",
          Desc       => "DC is full",
       },
       "NON_EMPTY" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x5",
          RegSubCtr  => "",
          Desc       => "DC is not empty",
       },
       "MATCH_READ" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0,B_CSR_DC_PERF_CTL1",
          RegDepBits => "[4:0]0x6, [15:0]US",
          RegSubCtr  => "",
          Desc       => "Matching DC read event.",
       },
       "MATCH_WRITE" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x7",
          RegSubCtr  => "",
          Desc       => "Matching DC write event.",
       },
       "NEED_SNOOPS" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x8",
          RegSubCtr  => "",
          Desc       => "New transaction requires snoops",
       },
       "LINE_EVICT" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0x9",
          RegSubCtr  => "",
          Desc       => "DC line eviction event.",
       },
       "MATCH_READ_2ND_LOOk" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0xa, [15:0]US",
          RegSubCtr  => "",
          Desc       => "Matching DC read second lookup.",
       },
       "SNP_LOC" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0xb",
          RegSubCtr  => "",
          Desc       => "Snoops caused by cell local memory accesses",
       },
       "MATCH_WRITE2" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0xc",
          RegSubCtr  => "",
          Desc       => "Matching DC write event 2",
       },
       "LINE_ALLOC" =>
       {
          RegDep     => "B_CSR_DC_PERF_CTL0",
          RegDepBits => "[4:0]0xd",
          RegSubCtr  => "",
          Desc       => "DC line allocation event",
       },
     },
  },
  "IMT_ALLOC" =>
  {
    Category  => "IMT Events",
    EvSel     => "0x5",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "IMT Allocations",
    Defn      => "Number of IMT entries allocated.",
    Notes     => "No rd/wr break down",
  },
  "IMT_FULL" =>
  {
    Category  => "IMT Events",
    EvSel     => "0x2a",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Cycles IMT Full",
    Defn      => "Number of cycles when IMT is full",
  },
  "IMT_FULL_CURR_PIPE" =>
  {
    Category  => "IMT Events",
    EvSel     => "0x29",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Cycles IMT Full for Current Pipe Pass",
    Defn      => "Indicates that the half of the IMT selected for the current pipeline is full.",
  },
  "IMT_NE_CYCLES" =>
  {
    Category  => "IMT Events",
    EvSel     => "0x7",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Cycles IMT Not Empty",
    Defn      => "Number of cycles when IMT is not empty",
  },
  "IMT_OCCUPANCY" =>
  {
    Category  => "IMT Events",
    EvSel     => "0x4",
    MaxIncCyc => 1,
    RegDep     => "B_CSR_PERF_CTL0",
    RegDepBits => "[9]0x1",
    RegSubCtr => "B_CSR_IMT_PERF_CNT",
    Desc      => "IMT Valid Occupancy",
    Defn      => "Number of IMT counter overflows",
    Notes     => "Set B_CSR_PERF_CTL0.imt_en to enable the subcounter which, in turn, enables this event. No rd/wr breakdown. To calculate the number of IMT events, multiply the counter value by 2^6 and add B_CSR_IMT_PERF_CNT.accum_cnt[5:0].",
  },
  "IMT_POP_CFL" =>
  {
    Category  => "IMT Events",
    EvSel     => "0x6",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "IMT Pop Conflicts",
    Defn      => "Number of IMT pop conflicts",
  },
  "IOB_INSERTS" =>
  {
    Category  => "IOB Events",
    EvSel     => "0x17",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "IOB Inserts of Live Trans",
    Defn      => "IOB live transaction counter increment.",
    SubEvents  =>
    {
       "IN_PKTS.RHNID" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[16]0x0 && [17]0x0 && [20:19]0x1",
          RegSubCtr  => "",
          Desc       => "New input packets; RHNID of input Intel QPI packet is used to determine local or remote socket",
       },
       "IN_PKTS.RSNID" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[16]0x0 && [17]0x1 && [20:19]0x1",
          RegSubCtr  => "",
          Desc       => "New input packets; RSNID of input Intel QPI packet is used to determine local or remote socket",
       },
       "SNOOPS" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[16:15]0x2",
          RegSubCtr  => "",
          Desc       => "Snoop packets launched by B-Box.",
       },
     },
  },
  "IOB_IN_PKTS" =>
  {
    Category  => "IOB Events",
    EvSel     => "0x19",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "IOB Input Packets",
    Defn      => "Number of IOB input packets",
    Notes     => "User can filter according to class or opcode by setting bits in B_CSR_PERF_CTL3.{class_in, opcode_in}",
    SubEvents  =>
    {
       "RHNID" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[17]0x0 && [20:19]0x1",
          RegSubCtr  => "",
          Desc       => "RHNID of input Intel QPI packet is used to determine local or remote socket",
       },
       "RSNID" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[17]0x1 && [20:19]0x1",
          RegSubCtr  => "",
          Desc       => "RSNID of input Intel QPI packet is used to determine local or remote socket",
       },
     },
  },
  "IOB_OCCUPANCY" =>
  {
    Category  => "IOB Events",
    EvSel     => "0x16",
    MaxIncCyc => 1,
    RegDep     => "B_CSR_PERF_CTL0",
    RegDepBits => "[13]0x1",
    RegSubCtr => "B_CSR_IOB_PERF_CNT",
    Desc      => "IOB Overflows",
    Defn      => "Number of IOB counter overflows.",
    Notes     => "Set B_CSR_PERF_CTL0.iob_en to enable the subcounter which, in turn, enables this event. To calculate the number of IOB transaction events, multiply the counter value by 2^11 and add B_CSR_IOB_PERF_CNT.accum_cnt[10:0].",
  },
  "IOB_OUT_PKTS" =>
  {
    Category  => "IOB Events",
    EvSel     => "0x1a",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "IOB Output Packets",
    Defn      => "Number of IOB output packets",
    Notes     => "User can filter according to class or opcode by setting bits in B_CSR_PERF_CTL3.{class_out, opcode_out}",
    SubEvents  =>
    {
       "RHNID" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[18]0x0 && [20:19]0x1",
          RegSubCtr  => "",
          Desc       => "RHNID of output Intel QPI packet is used to determine local or remote socket",
       },
       "RSNID" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[18]0x1 && [20:19]0x1",
          RegSubCtr  => "",
          Desc       => "RSNID of output Intel QPI packet is used to determine local or remote socket",
       },
     },
  },
  "IOB_REMOVES" =>
  {
    Category  => "IOB Events",
    EvSel     => "0x18",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "IOB Removals of Live Trans",
    Defn      => "",
    SubEvents  =>
    {
       "OUT_PKTS.RHNID" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[16:15]0x0 && [18]0x0 && [20:19]0x1",
          RegSubCtr  => "",
          Desc       => "New output packets; RHNID of output Intel QPI packet is used to determine local or remote socket",
       },
       "OUT_PKTS.RSNID" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[16:15]0x0 && [18]0x1 && [20:19]0x1",
          RegSubCtr  => "",
          Desc       => "New output packets; RSNID of output Intel QPI packet is used to determine local or remote socket",
       },
       "IN_PKT_COMPLETES" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[16:15]0x1",
          RegSubCtr  => "",
          Desc       => "All completions to packets that matched input packet criteria in IOB_INSERTS.",
       },
       "SNOOPS" =>
       {
          RegDep     => "B_CSR_PERF_CTL2",
          RegDepBits => "[16:15]0x2",
          RegSubCtr  => "",
          Desc       => "Snoop response packets received by B-Box.",
       },
     },
  },
  "MEM_HINT_DC_LUP" =>
  {
    Category  => "Mem Hint Events",
    EvSel     => "0x2d",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Memory Hint in DC Lookup",
    Defn      => "Lookup in DC a request that has local memory hint bit set.",
  },
  "MEM_HINT_Z_RESP" =>
  {
    Category  => "Mem Hint Events",
    EvSel     => "0x2e",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Memory Hint in Z-Box Response",
    Defn      => "Received a response from the Z-Box that has local memory hint bit set.",
  },
  "NSL_EVENT0" =>
  {
    Category  => "NSL Events",
    EvSel     => "0x2b",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "NSL Event 0",
    Defn      => "NSL Event 0",
  },
  "NSL_EVENT1" =>
  {
    Category  => "NSL Events",
    EvSel     => "0x2c",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "NSL Event 1",
    Defn      => "NSL Event 1",
  },
  "NSL_REJ" =>
  {
    Category  => "NSL Events",
    EvSel     => "0x28",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "NSL Reject",
    Defn      => "Rejected NSL pipeline pass",
  },
  "NSL_SUCC" =>
  {
    Category  => "NSL Events",
    EvSel     => "0x26",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "NSL Success",
    Defn      => "Successful NSL pipeline pass",
  },
  "POISON_RECV" =>
  {
    Category  => "Miscellaneous Events",
    EvSel     => "0x2f",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Received Poison Packet",
    Defn      => "Received a packet with poison.  The received packet poison errors need to be enabled in B_CSR_ERR_MAS_0.erecv_poison.",
  },
  "POISON_SENT" =>
  {
    Category  => "Miscellaneous Events",
    EvSel     => "0x30",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Sent Poison Packet",
    Defn      => "Sent a packet with poison.  The sent packet poison errors need to be enabled in B_CSR_ERR_MAS_0.esent_poison.",
  },
  "RFP_LOC_LOC" =>
  {
    Category  => "RFP Events",
    EvSel     => "0x0",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "RFP Local/Local",
    Defn      => "Response forward packet arriving in B-Box. Local requestor and local responder.",
  },
  "RFP_LOC_REM" =>
  {
    Category  => "RFP Events",
    EvSel     => "0x2",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "RFP Local/Remote",
    Defn      => "Response forward packet arriving in B-Box. Local requestor and remote responder",
  },
  "RFP_REM_LOC" =>
  {
    Category  => "RFP Events",
    EvSel     => "0x1",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "RFP Remote/Local",
    Defn      => "Response forward packet arriving in B-Box. Remote requestor and local responder",
  },
  "RFP_REM_REM" =>
  {
    Category  => "RFP Events",
    EvSel     => "0x3",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "RFP Remote/Remote",
    Defn      => "Response forward packet arriving in B-Box. Remote requestor and remote responder",
  },
  "SNP_REQ_ALL" =>
  {
    Category  => "Snoop Events",
    EvSel     => "0x1b",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "All Snoop Requests",
    Defn      => "Snoop requests (remote or local).",
  },
  "SNP_REQ_LOC" =>
  {
    Category  => "Snoop Events",
    EvSel     => "0x1c",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Local Snoop Requests",
    Defn      => "Local snoop requests.",
  },
  "SNP_REQ_REM" =>
  {
    Category  => "Snoop Events",
    EvSel     => "0x1d",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Remote Snoop Requests",
    Defn      => "Remote snoop requests.",
  },
  "SNP_RSP_ALL" =>
  {
    Category  => "Snoop Events",
    EvSel     => "0x1e",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "All Snoop Responses",
    Defn      => "Snoop responses (remote or local).",
  },
  "SNP_RSP_LOC" =>
  {
    Category  => "Snoop Events",
    EvSel     => "0x1f",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Local Snoop Responses",
    Defn      => "Local snoop responses.",
  },
  "SNP_RSP_REM" =>
  {
    Category  => "Snoop Events",
    EvSel     => "0x20",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Remote Snoop Responses",
    Defn      => "Remote snoop responses.",
  },
  "TRACKER_IMT_HAZARD" =>
  {
    Category  => "Miscellaneous Events",
    EvSel     => "0x27",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Tracker/IMT Hazard",
    Defn      => "Tracker/IMT Hazard",
  },
  "Z_OPT_V2V" =>
  {
    Category  => "Miscellaneous Events",
    EvSel     => "0x32",
    MaxIncCyc => 1,
    RegSubCtr => "",
    Desc      => "Z-Box V2V Optimized Requests",
    Defn      => "Z-Box V2V requests to Z-Box when read optimization is performed.",
  },
);



################################################################################
# Event List for Pouson CBox
################################################################################
%PSNCBoxEventList=
(
  "ARB_LOSSES" =>
  {
    Category  => "Ring - Egress",
    EvSel     => "0x0A",
    MaxIncCyc => 7,
    Desc      => "Arbiter Losses.",
    Defn      => "Number of Ring arbitration losses. A loss occurs when a message injection on to the ring fails. This could occur either because there was another message resident on the ring at that ring stop or because the co-located ring agent issued a message onto the ring in the same cycle",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "AD_SB" =>
       {
          Umask    => "b00000001",
          Desc       => "AD ring in the direction that points toward the nearest Sbox",
       },
       "AD_NSB" =>
       {
          Umask    => "b00000010",
          Desc       => "AD ring in the direction that points away from the nearest Sbox",
       },
       "AD_ALL" =>
       {
          Umask    => "b00000011",
          Desc       => "AD ring in either direction.",
       },
       "AK_SB" =>
       {
          Umask    => "b00000100",
          Desc       => "AK ring in the direction that points toward the nearest Sbox",
       },
       "AK_NSB" =>
       {
          Umask    => "b00001000",
          Desc       => "AK ring in the direction that points away from the nearest Sbox",
       },
       "AK_ALL" =>
       {
          Umask    => "b00001100",
          Desc       => "AK ring in either direction.",
       },
       "BL_SB" =>
       {
          Umask    => "b00010000",
          Desc       => "BL ring in the direction that points toward the nearest Sbox",
       },
       "BL_NSB" =>
       {
          Umask    => "b00100000",
          Desc       => "BL ring in the direction that points away from the nearest Sbox",
       },
       "BL_ALL" =>
       {
          Umask    => "b00110000",
          Desc       => "BL ring in either direction.",
       },
       "IV" =>
       {
          Umask    => "b01000000",
          Desc       => "IV ring",
       },
       "ALL" =>
       {
          Umask    => "b01111111",
          Desc       => "All rings",
       },
     },
  },
  "ARB_WINS" =>
  {
    Category  => "Ring - Egress",
    EvSel     => "0x09",
    MaxIncCyc => 7,
    Desc      => "Arbiter Wins",
    Defn      => "Number of Ring arbitration wins. A win is when a message was successfully injected onto the ring.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "AD_SB" =>
       {
          Umask    => "b00000001",
          Desc       => "AD ring in the direction that points toward the nearest Sbox",
       },
       "AD_NSB" =>
       {
          Umask    => "b00000010",
          Desc       => "AD ring in the direction that points away from the nearest Sbox",
       },
       "AD_ALL" =>
       {
          Umask    => "b00000011",
          Desc       => "AD ring in either direction.",
       },
       "AK_SB" =>
       {
          Umask    => "b00000100",
          Desc       => "AK ring in the direction that points toward the nearest Sbox",
       },
       "AK_NSB" =>
       {
          Umask    => "b00001000",
          Desc       => "AK ring in the direction that points away from the nearest Sbox",
       },
       "AK_ALL" =>
       {
          Umask    => "b00001100",
          Desc       => "AK ring in either direction.",
       },
       "BL_SB" =>
       {
          Umask    => "b00010000",
          Desc       => "BL ring in the direction that points toward the nearest Sbox",
       },
       "BL_NSB" =>
       {
          Umask    => "b00100000",
          Desc       => "BL ring in the direction that points away from the nearest Sbox",
       },
       "BL_ALL" =>
       {
          Umask    => "b00110000",
          Desc       => "BL ring in either direction.",
       },
       "IV" =>
       {
          Umask    => "b01000000",
          Desc       => "IV ring",
       },
       "ALL" =>
       {
          Umask    => "b01111111",
          Desc       => "All rings",
       },
     },
  },
  "BOUNCES_C2P_AK" =>
  {
    Category  => "Ring - WIR",
    EvSel     => "0x02",
    MaxIncCyc => 1,
    Desc      => "C2P AK Bounces",
    Defn      => "Number of LLC Ack responses to the core that bounced on the AK ring.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "SB" =>
       {
          Umask    => "b000000x1",
          Desc       => "Direction that points toward the nearest Sbox",
       },
       "NSB" =>
       {
          Umask    => "b0000001x",
          Desc       => "Direction that points away from the nearest Sbox",
       },
       "ALL" =>
       {
          Umask    => "b00000011",
          Desc       => "Either direction",
       },
     },
  },
  "BOUNCES_C2P_BL" =>
  {
    Category  => "Ring - WIR",
    EvSel     => "0x03",
    MaxIncCyc => 1,
    Desc      => "C2P BL Bounces",
    Defn      => "Number of LLC data responses to the core that bounced on the BL ring",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "C2P BL Bounces",
       },
       "SB" =>
       {
          Umask    => "b000000x1",
          Desc       => "Direction that points toward the nearest Sbox",
       },
       "NSB" =>
       {
          Umask    => "b0000001x",
          Desc       => "Direction that points away from the nearest Sbox",
       },
       "ALL" =>
       {
          Umask    => "b00000011",
          Desc       => "Either direction",
       },
     },
  },
  "BOUNCES_C2P_IV" =>
  {
    Category  => "Ring - WIR",
    EvSel     => "0x04",
    MaxIncCyc => 1,
    Desc      => "C2P IV Bounces",
    Defn      => "Number of C-Box snoops of a processors cache that bounced on the IV ring.",
  },
  "BOUNCES_P2C_AD" =>
  {
    Category  => "Ring - WIR",
    EvSel     => "0x01",
    MaxIncCyc => 1,
    Desc      => "P2C AD Bounces",
    Defn      => "Core request to LLC bounces on AD ring.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "SB" =>
       {
          Umask    => "b000000x1",
          Desc       => "Direction that points toward the nearest Sbox",
       },
       "NSB" =>
       {
          Umask    => "b0000001x",
          Desc       => "Direction that points away from the nearest Sbox",
       },
       "ALL" =>
       {
          Umask    => "b00000011",
          Desc       => "Either direction",
       },
     },
  },
  "CORR_ERR" =>
  {
    Category  => "Local - CC",
    EvSel     => "0x26",
    MaxIncCyc => 1,
    Desc      => "Correctable Errors",
    Defn      => "Correctable Errors",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "TAG" =>
       {
          Umask    => "b000xxxx1",
          Desc       => "correctable error in the LLC tag array",
       },
       "SCV" =>
       {
          Umask    => "b000xxx1x",
          Desc       => "correctable error in the LLC Core-Valid bit vector",
       },
       "LRU_1B" =>
       {
          Umask    => "b000xx1xx",
          Desc       => "correctalbe 1-bit error in the LLC LRU array",
       },
       "DATA_1B" =>
       {
          Umask    => "b000x1xxx",
          Desc       => "correctable 1-bit error in the LLC data",
       },
       "DATA_2B" =>
       {
          Umask    => "b0001xxxx",
          Desc       => "correctable 2-bit error in the LLC data",
       },
     },
  },
  "EGRESS_BYPASS_WINS" =>
  {
    Category  => "Local - Egress",
    EvSel     => "0x0C",
    MaxIncCyc => 7,
    Desc      => "Egress Bypass Wins",
    Defn      => "Number of times a ring egress bypass was taken when a message was injected onto the ring. The subevent field allows tracking of each available egress queue bypass path, including both 0 and 1 cycle versions.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "AD_BYP0" =>
       {
          Umask    => "b00000001",
          Desc       => "0 cycle AD egress bypass",
       },
       "AD_BYP1" =>
       {
          Umask    => "b00000010",
          Desc       => "1 cycle AD egress bypass",
       },
       "AK_BYP0" =>
       {
          Umask    => "b00000100",
          Desc       => "0 cycle AK egress bypass",
       },
       "AK_BYP1" =>
       {
          Umask    => "b00001000",
          Desc       => "1 cycle AK egress bypass",
       },
       "BL_BYP0" =>
       {
          Umask    => "b00010000",
          Desc       => "0 cycle BL egress bypass",
       },
       "BL_BYP1" =>
       {
          Umask    => "b00100000",
          Desc       => "1 cycle BL egress bypass",
       },
       "IV_BYP0" =>
       {
          Umask    => "b01000000",
          Desc       => "0 cycle IV egress bypass",
       },
       "IV_BYP1" =>
       {
          Umask    => "b10000000",
          Desc       => "1 cycle IV egress bypass",
       },
     },
  },
  "INGRESS_BYPASS_WINS_AD" =>
  {
    Category  => "Local - Egress",
    EvSel     => "0x0E",
    MaxIncCyc => 1,
    Desc      => "Ingress S-Box/Non S-Box Bypass Wins",
    Defn      => "Number of times that a message, off the AD ring, sunk by the Cbox took one of the ingress queue bypasses. The subevent field allows tracking of each available ingress queue bypass path, including both 0 and 1 cycle versions.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "IRQ_BYP0" =>
       {
          Umask    => "b00000001",
          Desc       => "0 cycle Ingress Request Queue bypass",
       },
       "IRQ_BYP1" =>
       {
          Umask    => "b00000010",
          Desc       => "1 cycle Ingress Request Queue bypass",
       },
       "IPQ_BYP0" =>
       {
          Umask    => "b00000100",
          Desc       => "0 cycle Ingress Probe Queue bypass",
       },
       "IPQ_BYP1" =>
       {
          Umask    => "b00001000",
          Desc       => "1 cycle Ingress Probe Queue bypass",
       },
     },
  },
  "LLC_HITS" =>
  {
    Category  => "Local - CC",
    EvSel     => "0x15",
    MaxIncCyc => 1,
    Desc      => "LLC Hits",
    Defn      => "Last Level Cache Hits",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "M" =>
       {
          Umask    => "b00000xx1",
          Desc       => "Modified",
       },
       "E" =>
       {
          Umask    => "b00000x1x",
          Desc       => "Exclusive",
       },
       "S" =>
       {
          Umask    => "b000001xx",
          Desc       => "Shared",
       },
       "ALL" =>
       {
          Umask    => "b00000111",
          Desc       => "All hits (to any cacheline state)",
       },
     },
  },
  "LLC_MISSES" =>
  {
    Category  => "Local - CC",
    EvSel     => "0x14",
    MaxIncCyc => 1,
    Desc      => "LLC Misses",
    Defn      => "Last Level Cache Misses",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "S" =>
       {
          Umask    => "b000000x1",
          Desc       => "Shared - request requires S line to be upgraded (due to RFO)",
       },
       "I" =>
       {
          Umask    => "b0000001x",
          Desc       => "Invalid - address not found",
       },
       "ALL" =>
       {
          Umask    => "b00000011",
          Desc       => "All misses",
       },
     },
  },
  "LLC_READS_D" =>
  {
    Category  => "Local - CC",
    EvSel     => "0x2A",
    MaxIncCyc => 1,
    Desc      => "LLC Data Reads",
    Defn      => "Last Level Cache Data Reads (Opcode is DRd or RFO)",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "HIT" =>
       {
          Umask    => "b0000xxx1",
          Desc       => "LLC Data Reads  - Hits",
       },
       "MISS" =>
       {
          Umask    => "b0000xx1x",
          Desc       => "LLC Data Reads  - Misses",
       },
       "FILL" =>
       {
          Umask    => "b0000x1xx",
          Desc       => "LLC Data Reads  - Fill",
       },
       "VICTIM" =>
       {
          Umask    => "b00001xxx",
          Desc       => "LLC Data Reads  - Victim",
       },
       "ALL" =>
       {
          Umask    => "b00001111",
          Desc       => "ALL LLC Data Reads",
       },
     },
  },
  "LLC_READS_I" =>
  {
    Category  => "Local - CC",
    EvSel     => "0x29",
    MaxIncCyc => 1,
    Desc      => "LLC Inst Reads",
    Defn      => "Last Level Cache Instruction Reads (Opcode is CRd)",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "HIT" =>
       {
          Umask    => "b0000xxx1",
          Desc       => "LLC Inst Reads  - Hits",
       },
       "MISS" =>
       {
          Umask    => "b0000xx1x",
          Desc       => "LLC Inst Reads  - Misses",
       },
       "FILL" =>
       {
          Umask    => "b0000x1xx",
          Desc       => "LLC Inst Reads  - Fill",
       },
       "VICTIM" =>
       {
          Umask    => "b00001xxx",
          Desc       => "LLC Inst Reads  - Victim",
       },
       "ALL" =>
       {
          Umask    => "b00001111",
          Desc       => "ALL LLC Inst Reads",
       },
     },
  },
  "LLC_S_FILLS" =>
  {
    Category  => "Local - CC",
    EvSel     => "0x16",
    MaxIncCyc => 1,
    Desc      => "LLC S-Box Fills",
    Defn      => "Last Level Cache lines filled from S-Box",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "",
       },
       "M" =>
       {
          Umask    => "b00000xx1",
          Desc       => "Filled to LLC in Modified (remote socket forwarded M data without writing back to memory controller)",
       },
       "E" =>
       {
          Umask    => "b00000x1x",
          Desc       => "Filled to LLC in Exclusve",
       },
       "S" =>
       {
          Umask    => "b000001xx",
          Desc       => "Filled to LLC in Shared",
       },
       "ALL" =>
       {
          Umask    => "b00000111",
          Desc       => "All fills to LLC",
       },
     },
  },
  "LLC_VICTIMS" =>
  {
    Category  => "Local - CC",
    EvSel     => "0x17",
    MaxIncCyc => 1,
    Desc      => "LLC Lines Victimized",
    Defn      => "Last Level Cache lines victimized",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "M" =>
       {
          Umask    => "b0000xxx1",
          Desc       => "Modified data victimized (explicit WB to memory)",
       },
       "E" =>
       {
          Umask    => "b0000xx1x",
          Desc       => "Exclusive data victimized",
       },
       "S" =>
       {
          Umask    => "b0000x1xx",
          Desc       => "Shared data victimized",
       },
       "I" =>
       {
          Umask    => "b00001xxx",
          Desc       => "LLC fill that occurred without victimizing any data",
       },
     },
  },
  "LLC_WRITES" =>
  {
    Category  => "Local - CC",
    EvSel     => "0x2B",
    MaxIncCyc => 1,
    Desc      => "LLC Writes",
    Defn      => "Last Level Cache Misses (Opcode is WBMtoS or FC)",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "HIT" =>
       {
          Umask    => "b000000x1",
          Desc       => "LLC Writes  - Hits",
       },
       "MISS" =>
       {
          Umask    => "b0000001x",
          Desc       => "LLC Writes  - Misses",
       },
       "ALL" =>
       {
          Umask    => "b00000011",
          Desc       => "All LLC Writes",
       },
     },
  },
  "MAF_ACK" =>
  {
    Category  => "Local - MAF",
    EvSel     => "0x10",
    MaxIncCyc => 1,
    Desc      => "MAF ACK",
    Defn      => "Miss Address File Acknowledgements.",
  },
  "MAF_NACK1" =>
  {
    Category  => "Local - MAF",
    EvSel     => "0x11",
    MaxIncCyc => 1,
    Desc      => "MAF NACK1",
    Defn      => "Rejected (not-acknowledged) LLC pipeline passes (Set 1)",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "GO_PENDING" =>
       {
          Umask    => "bxxxxxxx1",
          Desc       => "A message associated with a transaction monitored by the MAF was delayed  because the transaction had a GO pending in the requesting core.",
       },
       "VIC_PENDING" =>
       {
          Umask    => "bxxxxxx1x",
          Desc       => "An LLC fill was delayed because the victimized data in the LLC was still being processed.",
       },
       "SNP_PENDING" =>
       {
          Umask    => "bxxxxx1xx",
          Desc       => "A message associated with a transaction monitored by the MAF was delayed because the transaction had a snoop pending.",
       },
       "AC_PENDING" =>
       {
          Umask    => "bxxxx1xxx",
          Desc       => "An incoming remote QPI snoop was delayed because it conflicted with an existing MAF transaction that had an Ack Conflict pending.",
       },
       "SCIDX_BLOCK" =>
       {
          Umask    => "bxxx1xxxx",
          Desc       => "SideCam index blocking.",
       },
       "PA_BLOCK" =>
       {
          Umask    => "bxx1xxxxx",
          Desc       => "If this count is very high, it likely means that software is frequently issuing requests to the same physical address from disparate threads simultaneously.  Though there will also sometimes be a small number of PA_BLOCK nacks in the background due to cases when a pair of messages associated with the same transaction happen to arrive at the LLC at the same time and one of them gets delayed.",
       },
       "IDLE_QPI" =>
       {
          Umask    => "bx1xxxxxx",
          Desc       => "Idle Intel QPI State",
       },
       "ALL_MAF_NACK2" =>
       {
          Umask    => "b1xxxxxxx",
          Desc       => "A message was rejected when one or more of the sub-events under MAF_NACK2 was true. This is included in MAF_NACK1 so that MAF_NACK1 with sub-event 0xFF will count the total number of Nacks.",
       },
       "TOTAL_MAF_NACKS" =>
       {
          Umask    => "b11111111",
          Desc       => "Total number of LLC pipeline passes that were nacked.",
       },
     },
  },
  "MAF_NACK2" =>
  {
    Category  => "Local - MAF",
    EvSel     => "0x12",
    MaxIncCyc => 1,
    Desc      => "MAF NACK2",
    Defn      => "Rejected (not-acknowledged) LLC pipeline passes (Set 2)",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "MAF_FULL" =>
       {
          Umask    => "bxxxxxxx1",
          Desc       => "An incoming local processor RD/WR or remote QPI snoop request that required a MAF entry was delayed because no MAF entry was available.",
       },
       "EGRESS_FULL" =>
       {
          Umask    => "bxxxxxx1x",
          Desc       => "Some incoming message to the LLC that needed to generate a response message for transmission onto the ring was delayed due to ring back pressure.",
       },
       "VIQ_FULL" =>
       {
          Umask    => "bxxxxx1xx",
          Desc       => "An incoming local processor RD request that missed the LLC was delayed because the LLC victim buffer was full.",
       },
       "NO_TRACKER_CREDITS" =>
       {
          Umask    => "bxxxx1xxx",
          Desc       => "An incoming local processor RD or WR request was delayed because it required a Home tracker credit (for example, LLC RD Miss) and no credit was available.",
       },
       "NO_S_FIFO_CREDITS" =>
       {
          Umask    => "bxxx1xxxx",
          Desc       => "Some incoming message to the LLC that needed to generate a message to the Sbox was delayed due to lack of available buffering resources in the Sbox.",
       },
       "NO_S_REQTBL_ENTRIES" =>
       {
          Umask    => "bxx1xxxxx",
          Desc       => "An incoming local processor Rd or WR that needed to generate a transaction to Home (for example, LLC RD Miss) was delayed because the Sbox Request Table was full.",
       },
       "WB_PENDING" =>
       {
          Umask    => "bx1xxxxxx",
          Desc       => "An incoming remote QPI snoop request to the LLC was delayed because it conflicted with an existing transaction that had a WB to Home pending.",
       },
       "NACK2_ELSE" =>
       {
          Umask    => "b1xxxxxxx",
          Desc       => "Some incoming message to the LLC was delayed for a reason not covered by any of the other MAF_NACK1 or MAF_NACK2 sub-events.",
       },
     },
  },
  "OCCUPANCY_IPQ" =>
  {
    Category  => "Queue Occupancy",
    EvSel     => "0x1A",
    MaxIncCyc => 8,
    Desc      => "IPQ Occupancy",
    Defn      => "Cumulative count of occupancy in the LLCs Ingress Probe Queue.",
  },
  "OCCUPANCY_IRQ" =>
  {
    Category  => "Queue Occupancy",
    EvSel     => "0x18",
    MaxIncCyc => 24,
    Desc      => "IRQ Occupancy",
    Defn      => "Cumulative count of occupancy in the LLCs Ingress Response Queue",
  },
  "OCCUPANCY_MAF" =>
  {
    Category  => "Queue Occupancy",
    EvSel     => "0x1E",
    MaxIncCyc => 16,
    Desc      => "MAF Occupancy",
    Defn      => "Cumulative count of occupancy in the LLCs Miss Address File.",
  },
  "OCCUPANCY_VIQ" =>
  {
    Category  => "Queue Occupancy",
    EvSel     => "0x1C",
    MaxIncCyc => 8,
    Desc      => "VIQ Occupancy",
    Defn      => "Cumulative count of the occupancy in the Victim Ingress Queue.",
  },
  "QUEUE_BID_CYCLES" =>
  {
    Category  => "Local - Ingress",
    EvSel     => "0x0F",
    MaxIncCyc => 7,
    Desc      => "Cycles a Queue Bids",
    Defn      => "Number of cycles a Queue Bids for an opportunity to be issued into the C-Box pipeline.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "IRQ" =>
       {
          Umask    => "b00000001",
          Desc       => "Ingress Request Queue",
       },
       "IPQ" =>
       {
          Umask    => "b00000010",
          Desc       => "Ingress Probe Queue",
       },
       "VIQ" =>
       {
          Umask    => "b00000100",
          Desc       => "Victim Queue",
       },
       "IDQ" =>
       {
          Umask    => "b00001000",
          Desc       => "Ingress Data Queue",
       },
       "ICQ" =>
       {
          Umask    => "b00010000",
          Desc       => "Ingress Complete Queue",
       },
       "SRQ" =>
       {
          Umask    => "b00100000",
          Desc       => "Snoop Response Queue",
       },
       "IGQ" =>
       {
          Umask    => "b01000000",
          Desc       => "Ingress GO-Pending-Reset Queue",
       },
     },
  },
  "QUEUE_REJECT_CYCLES" =>
  {
    Category  => "Local - Ingress",
    EvSel     => "0x13",
    MaxIncCyc => 7,
    Desc      => "Cycles Queue was Rejected",
    Defn      => "Number of cycles a Queue was rejected by the MAF.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "IRQ" =>
       {
          Umask    => "b00000001",
          Desc       => "Ingress Request Queue",
       },
       "IPQ" =>
       {
          Umask    => "b00000010",
          Desc       => "Ingress Probe Queue",
       },
       "VIQ" =>
       {
          Umask    => "b00000100",
          Desc       => "Victim Queue",
       },
       "IDQ" =>
       {
          Umask    => "b00001000",
          Desc       => "Ingress Data Queue",
       },
       "ICQ" =>
       {
          Umask    => "b00010000",
          Desc       => "Ingress Complete Queue",
       },
       "SRQ" =>
       {
          Umask    => "b00100000",
          Desc       => "Snoop Response Queue",
       },
       "IGQ" =>
       {
          Umask    => "b01000000",
          Desc       => "Ingress GO-Pending-Reset Queue",
       },
     },
  },
  "SEMAPHORE_NACKS" =>
  {
    Category  => "Local - CC",
    EvSel     => "0x20",
    MaxIncCyc => 1,
    Desc      => "Semaphore NACKs",
    Defn      => "Number of Semaphore NACKS. Gives extent of local socket degradation generated by the fairness logic.",
  },
  "SINKS_C2P" =>
  {
    Category  => "Ring - WIR",
    EvSel     => "0x06",
    MaxIncCyc => 3,
    Desc      => "C2P Sinks",
    Defn      => "Number of messages sunk by the processor that were sent by one of the C-Boxes.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "IV" =>
       {
          Umask    => "b00000001",
          Desc       => "IV (C-Box snoops of a processors cache)",
       },
       "AK" =>
       {
          Umask    => "b00000010",
          Desc       => "AK (GO messages send to the processor)",
       },
       "BL" =>
       {
          Umask    => "b00000100",
          Desc       => "BL (LLC data sent back to processor)",
       },
     },
  },
  "SINKS_P2C" =>
  {
    Category  => "Ring - WIR",
    EvSel     => "0x05",
    MaxIncCyc => 3,
    Desc      => "P2C Sinks",
    Defn      => "Number of messages sunk from the ring at the C-Box that were sent by one of the local processors",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "AD" =>
       {
          Umask    => "b00000001",
          Desc       => "AD (Core RD/WR requests to the LLC)",
       },
       "AK" =>
       {
          Umask    => "b00000010",
          Desc       => "AK (Core snoop responses to the LLC)",
       },
       "BL" =>
       {
          Umask    => "b00000100",
          Desc       => "BL (explicit and implicit WB data from the core to the LLC)",
       },
     },
  },
  "SINKS_S2C" =>
  {
    Category  => "Ring - WIR",
    EvSel     => "0x07",
    MaxIncCyc => 3,
    Desc      => "S2C Sinks",
    Defn      => "Number of messages sunk from the ring at the Cbox that were sent by the Sbox.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "AD" =>
       {
          Umask    => "b00000001",
          Desc       => "AD (Intel QPI snoop request of LLC)",
       },
       "AK" =>
       {
          Umask    => "b00000010",
          Desc       => "AK (Intel QPI completions sent to LLC)",
       },
       "BL" =>
       {
          Umask    => "b00000100",
          Desc       => "BL (Data Fills sent to the LLC in response to RD requests)",
       },
     },
  },
  "SINKS_S2P_BL" =>
  {
    Category  => "Ring - WIR",
    EvSel     => "0x08",
    MaxIncCyc => 1,
    Desc      => "S2P Sinks",
    Defn      => "Number BL ring messages sunk by the processor that were sent from the S-Box. This covers BL only, because that is the only kind of message the S-Box can send to a processor.",
  },
  "SNPS" =>
  {
    Category  => "Local - CC",
    EvSel     => "0x27",
    MaxIncCyc => 1,
    Desc      => "Snoops to LLC",
    Defn      => "Number of Intel QPI snoops seen by the LLC.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "REMOTE_RD" =>
       {
          Umask    => "b000000x1",
          Desc       => "Remote Read - Goto S State. Intel QPI snoops (SnpData or SnpCode) to LLC that caused a transition to S in the cache.",
       },
       "REMOTE_RFO" =>
       {
          Umask    => "b0000001x",
          Desc       => "Remote RFO - Goto I State. Intel QPI snoops (SnpInvOwn or SnpInvItoE) to LLC that caused an invalidate of a cache line.",
       },
       "REMOTE_ANY" =>
       {
          Umask    => "b00000011",
          Desc       => "Intel QPI snoops to LLC that hit in the cache line",
       },
     },
  },
  "SNP_HITS" =>
  {
    Category  => "Local - CC",
    EvSel     => "0x28",
    MaxIncCyc => 1,
    Desc      => "Snoop Hits in LLC",
    Defn      => "Number of Intel QPI snoops that hit in the LLC according to state of LLC when hit occured. GotoS: LLC Data or Code Read Snoop Hit x state in remote cache. GotoI: LLC Data Read for Ownership Snoop Hit x state in remote cache.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "REMOTE_RD_HITM" =>
       {
          Umask    => "b00xxxxx1",
          Desc       => "Intel QPI SnpData or SnpCode hit M line in LLC",
       },
       "REMOTE_RD_HITE" =>
       {
          Umask    => "b00xxxx1x",
          Desc       => "Intel QPI SnpData or SnpCode hit E line in LLC",
       },
       "REMOTE_RD_HITS" =>
       {
          Umask    => "b00xxx1xx",
          Desc       => "Intel QPI SnpData or SnpCode hit S line in LLC",
       },
       "REMOTE_RFO_HITM" =>
       {
          Umask    => "b00xx1xxx",
          Desc       => "Intel QPI SnpInvOwn or SnpInvItoE hit M line in LLC",
       },
       "REMOTE_RFO_HITE" =>
       {
          Umask    => "b00x1xxxx",
          Desc       => "Intel QPI SnpInvOwn or SnpInvItoE hit E line in LLC",
       },
       "REMOTE_RFO_HITS" =>
       {
          Umask    => "b001xxxxx",
          Desc       => "Intel QPI SnpInvOwn or SnpInvItoE hit S line in LLC",
       },
       "REMOTE_HITM" =>
       {
          Umask    => "b00xx1xx1",
          Desc       => "Intel QPI Snoops that hit M line in LLC",
       },
       "REMOTE_HITE" =>
       {
          Umask    => "b00x1xx1x",
          Desc       => "Intel QPI Snoops that hit E line in LLC",
       },
       "REMOTE_HITS" =>
       {
          Umask    => "b001xx1xx",
          Desc       => "Intel QPI Snoops that hit S line in LLC",
       },
       "REMOTE_ANY" =>
       {
          Umask    => "b00111111",
          Desc       => "Intel QPI Snoops that hit in LLC (any line state)",
       },
     },
  },
  "STARVED" =>
  {
    Category  => "Local - Ingress",
    EvSel     => "0x0D",
    MaxIncCyc => 6,
    Desc      => "Internal/External Starvation",
    Defn      => "Number of cycles that an LLC Ingress Queue is in starvation",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "IRQ" =>
       {
          Umask    => "b00000001",
          Desc       => "Ingress Request Queue (RD/WR requests from processor)",
       },
       "IPQ" =>
       {
          Umask    => "b00000010",
          Desc       => "Ingress Probe Queue (Intel QPI snoop probes)",
       },
       "VIQ" =>
       {
          Umask    => "b00000100",
          Desc       => "Victim Queue (LLC victims)",
       },
       "IDQ" =>
       {
          Umask    => "b00001000",
          Desc       => "Ingress Data Queue (Data fills)",
       },
       "ICQ" =>
       {
          Umask    => "b00010000",
          Desc       => "Ingress Completion Queue (Intel QPI completions)",
       },
       "SRQ" =>
       {
          Umask    => "b00100000",
          Desc       => "Snoop Response Queue (snoop responses from the local processors)",
       },
     },
  },
  "STARVED_EGRESS" =>
  {
    Category  => "Local - Egress",
    EvSel     => "0x0B",
    MaxIncCyc => 8,
    Desc      => "Egress Queue Starved",
    Defn      => "Number of cycles that an Egress Queue is in starvation",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b00000000",
          Desc       => "(* nothing will be counted *)",
       },
       "P2C_AD_SB" =>
       {
          Umask    => "b00000001",
          Desc       => "Processor-to-C-Box AD Egress that injects in the direction toward the nearest S-Box",
       },
       "C2S_AD_SB" =>
       {
          Umask    => "b00000010",
          Desc       => "C-Box to S-Box AD Egress.",
       },
       "AD_SB" =>
       {
          Umask    => "b00000011",
          Desc       => "Sum of AD Egresses that injects in the direction toward the nearest S-Box",
       },
       "AD_NSB" =>
       {
          Umask    => "b00000100",
          Desc       => "Sum across both AD Egress that inject in the direction away from the nearest S-Box.",
       },
       "AD" =>
       {
          Umask    => "b00000111",
          Desc       => "Sum across all AD Egresses",
       },
       "AK_SB" =>
       {
          Umask    => "b00001000",
          Desc       => "AK Egress that injects in the direction toward the nearest Sbox.",
       },
       "AK_NSB" =>
       {
          Umask    => "b00010000",
          Desc       => "AK Egress that injects in the direction away from the nearest S-Box.",
       },
       "AK" =>
       {
          Umask    => "b00011000",
          Desc       => "Sum across all AK Egresses.",
       },
       "BL_SB" =>
       {
          Umask    => "b00100000",
          Desc       => "BL Egress that injects in the direction toward the nearest Sbox.",
       },
       "BL_NSB" =>
       {
          Umask    => "b01000000",
          Desc       => "BL Egress that injects in the direction away from the nearest S-Box.",
       },
       "BL" =>
       {
          Umask    => "b01100000",
          Desc       => "Sum across all BL Egresses.",
       },
       "IV" =>
       {
          Umask    => "b10000000",
          Desc       => "IV Egress",
       },
     },
  },
  "TRANS_IPQ" =>
  {
    Category  => "Queue Occupancy",
    EvSel     => "0x1B",
    MaxIncCyc => 1,
    Desc      => "IPQ Transactions",
    Defn      => "Number of Intel QPI snoop probes that entered the LLCs Ingress Probe Queue.",
  },
  "TRANS_IRQ" =>
  {
    Category  => "Queue Occupancy",
    EvSel     => "0x19",
    MaxIncCyc => 1,
    Desc      => "IRQ Transactions",
    Defn      => "Number of processor RD and/or WR requests to the LLC that entered the Ingress Response Queue.",
  },
  "TRANS_MAF" =>
  {
    Category  => "Queue Occupancy",
    EvSel     => "0x1F",
    MaxIncCyc => 1,
    Desc      => "MAF Transactions",
    Defn      => "Number of transactions to allocate entries in LLCs Miss Address File.",
  },
  "TRANS_VIQ" =>
  {
    Category  => "Queue Occupancy",
    EvSel     => "0x1D",
    MaxIncCyc => 1,
    Desc      => "VIQ Transactions",
    Defn      => "Number of LLC victims to enter the Victim Ingress Queue. All LLC victims pass through this queue. Including those that end up not requiring a WB.",
  },
);



################################################################################
# Event List for Pouson RBox
################################################################################
%PSNRBoxEventList=
(
  "ALLOC_TO_ARB" =>
  {
    Category  => "RIX Events",
    EvSel     => "na",
    MaxIncCyc => 1,
    Desc      => "Transactions allocated to ARB",
    Defn      => "Transactions entered into Entry Table; This also means that they are now available for ARB",
    Notes     => "Program IPERF bits [15:9] to represent the Message Class(es) to be measured
. Message Class:
         0b1XXXXX: Snoop
         0bX1XXXX: Home 
         0bXX1XXX: Non-Data Response
         0bXXX1XX: Data Response
         0bXXXX1X: Non-Coherent Standard
         0bXXXXX1: Non-Coherent Bypass",
    SubEvents  =>
    {
       "NONE" =>
       {
          SubEvSel => "[15:9]0000000",
          Desc       => "(*nothing will be counted*)",
       },
       "NCB" =>
       {
          SubEvSel => "[15:9]bxxxxxx1",
          Desc       => "Non-Coherent Bypass Messages",
       },
       "NCS" =>
       {
          SubEvSel => "[15:9]bxxxxx1x",
          Desc       => "Non-Coherent Standard Messages",
       },
       "DRS" =>
       {
          SubEvSel => "[15:9]bxxxx1xx",
          Desc       => "Data Response Messages",
       },
       "NDR" =>
       {
          SubEvSel => "[15:9]bxxx1xxx",
          Desc       => "Non-Data Response Messages",
       },
       "SNP" =>
       {
          SubEvSel => "[15:9]bxx1xxxx",
          Desc       => "Snoop Messages",
       },
       "HOM_VN1" =>
       {
          SubEvSel => "[15:9]bx1xxxxx",
          Desc       => "Home (VN1) Messages",
       },
       "HOM_VN0" =>
       {
          SubEvSel => "[15:9]b1xxxxxx",
          Desc       => "Home (VN0) Messages",
       },
       "ALL" =>
       {
          SubEvSel => "[15:9]b1111111",
          Desc       => "All Messages",
       },
     },
  },
  "EOT_INSERTS" =>
  {
    Category  => "RIX Events",
    EvSel     => "[20]0x1",
    MaxIncCyc => 1,
    Desc      => "Number of Inserts Into EOT",
    Defn      => "Used with MC field. Accumulated depth of packets captured in the Entry Overflow Table for specified message types (i.e. EOT count by MC)",
    Notes     => "This basically counts VNA.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          SubEvSel => "[19:17] 0x0",
          Desc       => "(*nothing will be counted*)",
       },
       "HM0" =>
       {
          SubEvSel => "[19:17] 0x1",
          Desc       => "Home0 Messages",
       },
       "HM1" =>
       {
          SubEvSel => "[19:17] 0x2",
          Desc       => "Home1 Messages",
       },
       "SNP" =>
       {
          SubEvSel => "[19:17] 0x3",
          Desc       => "Snoop Messages",
       },
       "NDR" =>
       {
          SubEvSel => "[19:17] 0x4",
          Desc       => "Non-Data Response Messages",
       },
       "DRS" =>
       {
          SubEvSel => "[19:17] 0x5",
          Desc       => "Data Response Messages",
       },
       "NCS" =>
       {
          SubEvSel => "[19:17] 0x6",
          Desc       => "Non-Coherent Standard Messages",
       },
       "NCB" =>
       {
          SubEvSel => "[19:17] 0x7",
          Desc       => "Non-Coherent Bypass Messages",
       },
       "NONE2" =>
       {
          SubEvSel => "[19:17] 0xF-0x9",
          Desc       => "(*nothing will be counted*)",
       },
     },
  },
  "EOT_NE_CYCLES" =>
  {
    Category  => "RIX Events",
    EvSel     => "[16]0x1",
    MaxIncCyc => 1,
    Desc      => "Cycles EOT Not Empty",
    Defn      => "Number of cycles the Entry Overflow Table buffer is not empty (MC counts are not all zero).",
    Notes     => "Signals only if EOTs for ALL message classes are empty",
  },
  "EOT_OCCUPANCY" =>
  {
    Category  => "RIX Events",
    EvSel     => "[21]0x1",
    MaxIncCyc => 1,
    Desc      => "EOT Occupancy",
    Defn      => "Used with MC field. Accumulated depth of packets captured in the Entry Overflow Table for specified message types (i.e. EOT count by MC)",
    Notes     => "This basically counts VNA. This event collects the overflow of a subcounter that accurately tracks EOT depth. Multiply this event by 32 to determine the correct EOT depth count. Unlike other packets, ALL HOM packets go through EOT only to stay ordered. HOM0 corresponds to VN0/VNA0 packets while HOM1 corresonds to VN1/VNA1. They are independent meaning HOM0 only need to stay ordered within HOM0 packets and same for HOM1.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          SubEvSel => "[19:17] 0x00",
          Desc       => "(*nothing will be counted*)",
       },
       "HM0" =>
       {
          SubEvSel => "[19:17] 0x01",
          Desc       => "Home0 Messages",
       },
       "HM1" =>
       {
          SubEvSel => "[19:17] 0x02",
          Desc       => "Home1 Messages",
       },
       "SNP" =>
       {
          SubEvSel => "[19:17] 0x03",
          Desc       => "Snoop Messages",
       },
       "NDR" =>
       {
          SubEvSel => "[19:17] 0x04",
          Desc       => "Non-Data Response Messages",
       },
       "DRS" =>
       {
          SubEvSel => "[19:17] 0x05",
          Desc       => "Data Response Messages",
       },
       "NCS" =>
       {
          SubEvSel => "[19:17] 0x06",
          Desc       => "Non-Coherent Standard Messages",
       },
       "NCB" =>
       {
          SubEvSel => "[19:17] 0x07",
          Desc       => "Non-Coherent Bypass Messages",
       },
       "NONE1" =>
       {
          SubEvSel => "[19:17] 0xF-0x9",
          Desc       => "(*nothing will be counted*)",
       },
     },
  },
  "ET_OCCUPANCY" =>
  {
    Category  => "QLX Events",
    EvSel     => "[3:0]0xc",
    MaxIncCyc => 1,
    Desc      => "Entry Table Occupancy",
    Defn      => "Accumulated depth of Entry Table for specified message types",
    Notes     => "This event collects the overflow of a subcounter that accurately tracks ET depth. Multiply this event by 32 to determine the correct ET depth count.",
    SubEvents  =>
    {
       "HOM" =>
       {
          SubEvSel => "[6:4]0x0",
          Desc       => "Home Messages",
       },
       "SNP" =>
       {
          SubEvSel => "[6:4]0x1",
          Desc       => "Snoop Messages",
       },
       "NDR" =>
       {
          SubEvSel => "[6:4]0x2",
          Desc       => "Non-Data Response Messages",
       },
       "NCS" =>
       {
          SubEvSel => "[6:4]0x3",
          Desc       => "Non-Coherent Standard Messages",
       },
       "DRS" =>
       {
          SubEvSel => "[6:4]0x4",
          Desc       => "Data Response Messages",
       },
       "NCB" =>
       {
          SubEvSel => "[6:4]0x5",
          Desc       => "Non-Coherent Bypass Messages",
       },
       "ILLEGAL1" =>
       {
          SubEvSel => "[6:4]0x7-0x6",
          Desc       => "(*illegal selection*)",
       },
     },
  },
  "FAST_ENOUGH" =>
  {
    Category  => "RIX Events",
    EvSel     => "[22]0x1",
    MaxIncCyc => 1,
    Desc      => "Fast Packets",
    Defn      => "How often a multi-flit packet uses the optimized path",
  },
  "FLITS_RCVD" =>
  {
    Category  => "RIX Events",
    EvSel     => "[30]0x1",
    MaxIncCyc => 1,
    Desc      => "Flits Received",
    Defn      => "Counts all flits received",
  },
  "FLITS_RCVD_NSP" =>
  {
    Category  => "RIX Events",
    EvSel     => "[28]0x1",
    MaxIncCyc => 1,
    Desc      => "Non-Special Flits Received",
    Defn      => "Counts all non-special flits received",
  },
  "FLITS_SENT" =>
  {
    Category  => "RIX Events",
    EvSel     => "[31]0x1",
    MaxIncCyc => 1,
    Desc      => "Flits Sent",
    Defn      => "Counts all flits",
  },
  "FLITS_SENT_NSP" =>
  {
    Category  => "RIX Events",
    EvSel     => "[29]0x1",
    MaxIncCyc => 1,
    Desc      => "Non-Special Flits Sent",
    Defn      => "Counts all non-special flits sent",
    Notes     => "BROKEN",
  },
  "GLOBAL_ARB_BID" =>
  {
    Category  => "QLX Events",
    EvSel     => "[3:0]0x8",
    MaxIncCyc => 1,
    Desc      => "Global ARB Bids",
    Defn      => "Count global arbitration bids from the port.",
  },
  "GLOBAL_ARB_BID_FAIL" =>
  {
    Category  => "QLX Events",
    EvSel     => "[3:0]0x9",
    MaxIncCyc => 1,
    Desc      => "Global ARB Bid Failure",
    Defn      => "Count failed global arbitration bids from the port. Represents multi-flit kills.",
  },
  "GLOBAL_HOM_ORDER_KILL" =>
  {
    Category  => "QLX Events",
    EvSel     => "[3:0]0xa",
    MaxIncCyc => 1,
    Desc      => "Global Home Order Kills",
    Defn      => "Arbitration attempts killed in the HOM channel of the global ARB that violate ordering. HOM packets may be issued back to back through the ARBs, but if the first HOM was not chosen by the ARB, the second one will be killed due to ordering rules. This event accounts for often this situation occurs in the global ARB.",
  },
  "INQUE_READ_WIN" =>
  {
    Category  => "RIX Events",
    EvSel     => "[8]0x1",
    MaxIncCyc => 1,
    Desc      => "Input Queue Read Win.",
    Defn      => "Bid wins arbitration. Counts number of IQA reads and drains to XBAR.",
  },
  "LOCAL_ARB_BID" =>
  {
    Category  => "QLX Events",
    EvSel     => "[3:0]0x4",
    MaxIncCyc => 1,
    Desc      => "Local ARB Bids",
    Defn      => "Number of bids to exit port. Occurs on input port.",
  },
  "LOCAL_ARB_BID_FAIL" =>
  {
    Category  => "QLX Events",
    EvSel     => "[3:0]0x5",
    MaxIncCyc => 1,
    Desc      => "Failed Local ARB Bids",
    Defn      => "Number of bids to exit port that failed. Occurs on input port.",
  },
  "LOCAL_HOME_ORDER_KILL" =>
  {
    Category  => "QLX Events",
    EvSel     => "[3:0]0x6",
    MaxIncCyc => 1,
    Desc      => "Local Home Order Kills",
    Defn      => "Arbitration attempts killed in the HOM channel of the local ARB that violate ordering. HOM packets may be issued back to back through the ARBs, but if the first HOM was not chosen by the ARB, the second one will be killed due to ordering rules. This event accounts for often this situation occurs in the local ARB.",
  },
  "NEW_PACKETS_RECV" =>
  {
    Category  => "RIX Events",
    EvSel     => "na",
    MaxIncCyc => 1,
    Desc      => "New Packets Received by Port",
    Defn      => "Counts new packets receivedby port, according to the Virtual Network and Message Class specified.",
    Notes     => "Program IPERF bits [5:0] to represent the Message Class(es) to be measured. Each packet gets allocated to the ARB exactly once.
. Message Class:
         0b1XXXXX: Snoop
         0bX1XXXX: Home 
         0bXX1XXX: Non-Data Response
         0bXXX1XX: Data Response
         0bXXXX1X: Non-Coherent Standard
         0bXXXXX1: Non-Coherent Bypass",
    SubEvents  =>
    {
       "VN0.NCB" =>
       {
          SubEvSel => "[7:6]0x0 && [5:0] bxxxxx1",
          Desc       => "VN0 Non-Coherent Bypass Messages",
       },
       "VN0.NCS" =>
       {
          SubEvSel => "[7:6]0x0 && [5:0] bxxxx1x",
          Desc       => "VN0 Non-Coherent Standard Messages",
       },
       "VN0.DRS" =>
       {
          SubEvSel => "[7:6]0x0 && [5:0] bxxx1xx",
          Desc       => "VN0 Data Response Messages",
       },
       "VN0.NDR" =>
       {
          SubEvSel => "[7:6]0x0 && [5:0] bxx1xxx",
          Desc       => "VN0 Non-Data Response Messages",
       },
       "VN0.HOM" =>
       {
          SubEvSel => "[7:6]0x0 && [5:0] bx1xxxx",
          Desc       => "VN0 Home Messages",
       },
       "VN0.SNP" =>
       {
          SubEvSel => "[7:6]0x0 && [5:0] b1xxxxx",
          Desc       => "VN0 Snoop Messages",
       },
       "VN0.ALL" =>
       {
          SubEvSel => "[7:6]0x0 && [5:0] b111111",
          Desc       => "VN0 All Messages",
       },
       "VN1.NCB" =>
       {
          SubEvSel => "[7:6]0x1 && [5:0] bxxxxx1",
          Desc       => "VN1 Non-Coherent Bypass Messages",
       },
       "VN1.NCS" =>
       {
          SubEvSel => "[7:6]0x1 && [5:0] bxxxx1x",
          Desc       => "VN1 Non-Coherent Standard Messages",
       },
       "VN1.DRS" =>
       {
          SubEvSel => "[7:6]0x1 && [5:0] bxxx1xx",
          Desc       => "VN1 Data Response Messages",
       },
       "VN1.NDR" =>
       {
          SubEvSel => "[7:6]0x1 && [5:0] bxx1xxx",
          Desc       => "VN1 Non-Data Response Messages",
       },
       "VN1.HOM" =>
       {
          SubEvSel => "[7:6]0x1 && [5:0] bx1xxxx",
          Desc       => "VN1 Home Messages",
       },
       "VN1.SNP" =>
       {
          SubEvSel => "[7:6]0x1 && [5:0] b1xxxxx",
          Desc       => "VN1 Snoop Messages",
       },
       "VN1.ALL" =>
       {
          SubEvSel => "[7:6]0x1 && [5:0] b111111",
          Desc       => "VN1 All Messages",
       },
       "VNA.NCB" =>
       {
          SubEvSel => "[7:6]0x2 && [5:0] bxxxxx1",
          Desc       => "VNA Non-Coherent Bypass Messages",
       },
       "VNA.NCS" =>
       {
          SubEvSel => "[7:6]0x2 && [5:0] bxxxx1x",
          Desc       => "VNA Non-Coherent Standard Messages",
       },
       "VNA.DRS" =>
       {
          SubEvSel => "[7:6]0x2 && [5:0] bxxx1xx",
          Desc       => "VNA Data Response Messages",
       },
       "VNA.NDR" =>
       {
          SubEvSel => "[7:6]0x2 && [5:0] bxx1xxx",
          Desc       => "VNA Non-Data Response Messages",
       },
       "VNA.HOM" =>
       {
          SubEvSel => "[7:6]0x2 && [5:0] bx1xxxx",
          Desc       => "VNA Home Messages",
       },
       "VNA.SNP" =>
       {
          SubEvSel => "[7:6]0x2 && [5:0] b1xxxxx",
          Desc       => "VNA Snoop Messages",
       },
       "VNA.ALL" =>
       {
          SubEvSel => "[7:6]0x2 && [5:0] b111111",
          Desc       => "VNA All Messages",
       },
       "ANY.NCB" =>
       {
          SubEvSel => "[7:6]0x3 && [5:0] bxxxxx1",
          Desc       => "ANY Non-Coherent Bypass Messages",
       },
       "ANY.NCS" =>
       {
          SubEvSel => "[7:6]0x3 && [5:0] bxxxx1x",
          Desc       => "ANY Non-Coherent Standard Messages",
       },
       "ANY.DRS" =>
       {
          SubEvSel => "[7:6]0x3 && [5:0] bxxx1xx",
          Desc       => "ANY Data Response Messages",
       },
       "ANY.NDR" =>
       {
          SubEvSel => "[7:6]0x3 && [5:0] bxx1xxx",
          Desc       => "ANY Non-Data Response Messages",
       },
       "ANY.HOM" =>
       {
          SubEvSel => "[7:6]0x3 && [5:0] bx1xxxx",
          Desc       => "ANY Home Messages",
       },
       "ANY.SNP" =>
       {
          SubEvSel => "[7:6]0x3 && [5:0] b1xxxxx",
          Desc       => "ANY Snoop Messages",
       },
       "ANY.ALL" =>
       {
          SubEvSel => "[7:6]0x3 && [5:0] b111111",
          Desc       => "ANY All Messages",
       },
     },
  },
  "OUTPUTQ_IN" =>
  {
    Category  => "RIX Events",
    EvSel     => "[26]0x1",
    MaxIncCyc => 1,
    Desc      => "Output Queue  Inserts",
    Defn      => "Number of flits inserted to the Output Buffer",
    Notes     => "For a full-width port the output buffer is always by-passed",
  },
  "OUTPUTQ_NE" =>
  {
    Category  => "RIX Events",
    EvSel     => "[25]0x1",
    MaxIncCyc => 1,
    Desc      => "Cycles Output Queue  Not Empty",
    Defn      => "Number of cycles the Output Buffer is not empty.",
    Notes     => "For a full-width port the output buffer is always by-passed",
  },
  "OUTPUTQ_OVFL" =>
  {
    Category  => "RIX Events",
    EvSel     => "[27]0x1",
    MaxIncCyc => 1,
    Desc      => "Output Queue Overflow Accumulator",
    Defn      => "Running count of number of times the Output Buffer overflows.",
    Notes     => "For a full-width port the output buffer is always by-passed.  This event collects the overflow of a subcounter that accurately tracks the output buffer depth. Multiply this event by 128 to determine the correct output buffer depth count.",
  },
  "PCKT_ERR_IN" =>
  {
    Category  => "RIX Events",
    EvSel     => "[23]0x1",
    MaxIncCyc => 1,
    Desc      => "Incoming Packet Errors",
    Defn      => "Incoming Packet Error (#times input port requested retry from the sender?)",
  },
  "QUE_ARB_BID" =>
  {
    Category  => "QLX Events",
    EvSel     => "[3:0]0x0",
    MaxIncCyc => 1,
    Desc      => "Queue Arb Bids",
    Defn      => "Number of queue ARB bids. Each message class has its own queue. Occurs on input port.",
    SubEvents  =>
    {
       "HOM" =>
       {
          SubEvSel => "[6:4]0x0",
          Desc       => "Home Messages",
       },
       "SNP" =>
       {
          SubEvSel => "[6:4]0x1",
          Desc       => "Snoop Messages",
       },
       "NDR" =>
       {
          SubEvSel => "[6:4]0x2",
          Desc       => "Non-Data Response Messages",
       },
       "NCS" =>
       {
          SubEvSel => "[6:4]0x3",
          Desc       => "Non-Coherent Standard Messages",
       },
       "DRS" =>
       {
          SubEvSel => "[6:4]0x4",
          Desc       => "Data Response Messages",
       },
       "NCB" =>
       {
          SubEvSel => "[6:4]0x5",
          Desc       => "Non-Coherent Bypass Messages",
       },
       "ILLEGAL1" =>
       {
          SubEvSel => "[6:4]0x7-0x6",
          Desc       => "(*illegal selection*)",
       },
     },
  },
  "QUE_ARB_BID_FAIL" =>
  {
    Category  => "QLX Events",
    EvSel     => "[3:0]0x1",
    MaxIncCyc => 1,
    Desc      => "Failed Queue ARB Bids",
    Defn      => "Number of failed queue ARB bids. Each message class has its own queue. Occurs on input port. Home order kill only way to receive failed queue arb bid.",
    SubEvents  =>
    {
       "HOM" =>
       {
          SubEvSel => "[6:4]0x0",
          Desc       => "Home Messages",
       },
       "SNP" =>
       {
          SubEvSel => "[6:4]0x1",
          Desc       => "Snoop Messages",
       },
       "NDR" =>
       {
          SubEvSel => "[6:4]0x2",
          Desc       => "Non-Data Response Messages",
       },
       "NCS" =>
       {
          SubEvSel => "[6:4]0x3",
          Desc       => "Non-Coherent Standard Messages",
       },
       "DRS" =>
       {
          SubEvSel => "[6:4]0x4",
          Desc       => "Data Response Messages",
       },
       "NCB" =>
       {
          SubEvSel => "[6:4]0x5",
          Desc       => "Non-Coherent Bypass Messages",
       },
       "ILLEGAL1" =>
       {
          SubEvSel => "[6:4]0x7-0x6",
          Desc       => "(*illegal selection*)",
       },
     },
  },
  "QUE_HOME_ORDER_KILL" =>
  {
    Category  => "QLX Events",
    EvSel     => "[3:0]0x2",
    MaxIncCyc => 1,
    Desc      => "Queue Home Order Kills",
    Defn      => "Arbitration attempts killed in the HOM channel of the global ARB that violate ordering. HOM packets may be issued back to back through the ARBs, but if the first HOM was not chosen by the ARB, the second one will be killed due to ordering rules. This event accounts for often this situation occurs in the global ARB.",
  },
  "RETRYQ_READS" =>
  {
    Category  => "RIX Events",
    EvSel     => "[24]0x1",
    MaxIncCyc => 1,
    Desc      => "Retry Buffer Reads",
    Defn      => "Number of flits sent from the retry buffer.",
  },
  "TARGET_AVAILABLE" =>
  {
    Category  => "QLX Events",
    EvSel     => "[3:0]0xb",
    MaxIncCyc => 1,
    Desc      => "Target Available",
    Defn      => "There are enough credits on the target port to allow a bid. The target is unavailable if the output buffer is full or there are no credits.",
    SubEvents  =>
    {
       "VN0.HOM" =>
       {
          SubEvSel => "[6:4]0x0 && [7]0x0",
          Desc       => "VN0 Home Messages",
       },
       "VN1.HOM" =>
       {
          SubEvSel => "[6:4]0x0 && [7]0x1",
          Desc       => "VN0 Snoop Messages",
       },
       "VN0.SNP" =>
       {
          SubEvSel => "[6:4]0x1 && [7]0x0",
          Desc       => "VN0 Non-Data Response Messages",
       },
       "VN1.SNP" =>
       {
          SubEvSel => "[6:4]0x1 && [7]0x1",
          Desc       => "VN0 Non-Coherent Standard Messages",
       },
       "VN0.NDR" =>
       {
          SubEvSel => "[6:4]0x2 && [7]0x0",
          Desc       => "VN0 Data Response Messages",
       },
       "VN1.NDR" =>
       {
          SubEvSel => "[6:4]0x2 && [7]0x1",
          Desc       => "VN0 Non-Coherent Bypass Messages",
       },
       "VN0.NCS" =>
       {
          SubEvSel => "[6:4]0x3 && [7]0x0",
          Desc       => "VN1 Home Messages",
       },
       "VN1.NCS" =>
       {
          SubEvSel => "[6:4]0x3 && [7]0x1",
          Desc       => "VN1 Snoop Messages",
       },
       "VN0.DRS" =>
       {
          SubEvSel => "[6:4]0x4 && [7]0x0",
          Desc       => "VN1 Non-Data Response Messages",
       },
       "VN1.DRS" =>
       {
          SubEvSel => "[6:4]0x4 && [7]0x1",
          Desc       => "VN1 Non-Coherent Standard Messages",
       },
       "VN0.NCB" =>
       {
          SubEvSel => "[6:4]0x5 && [7]0x0",
          Desc       => "VN1 Data Response Messages",
       },
       "VN1.NCB" =>
       {
          SubEvSel => "[6:4]0x5 && [7]0x1",
          Desc       => "VN1 Non-Coherent Bypass Messages",
       },
       "VN0.VSM" =>
       {
          SubEvSel => "[6:4]0x6 && [7]0x0",
          Desc       => "VN0 VNA-small (<= 3 flits) Messages",
       },
       "VN1.VSM" =>
       {
          SubEvSel => "[6:4]0x6 && [7]0x1",
          Desc       => "VN1 VNA-small (<= 3 flits) Messages",
       },
       "VN0.VLG" =>
       {
          SubEvSel => "[6:4]0x7 && [7]0x0",
          Desc       => "VN0 VNA-large (9-11 flits) Messages",
       },
       "VN1.VLG" =>
       {
          SubEvSel => "[6:4]0x7 && [7]0x1",
          Desc       => "VN1 VNA-large (9-11 flits) Messages",
       },
     },
  },
);



################################################################################
# Event List for Pouson SBox
################################################################################
%PSNSBoxEventList=
(
  "CRD_UNAVAIL_AD" =>
  {
    Category  => "Ring Bound Credits",
    EvSel     => "0x87",
    MaxIncCyc => 1,
    Desc      => "AD Ring Credit Unavailable",
    Defn      => "Number of times the S-Box has a pending SNP, NCS or NCB message to send and there is no credit for the target egress FIFO.",
  },
  "CRD_UNAVAIL_AK" =>
  {
    Category  => "Ring Bound Credits",
    EvSel     => "0x88",
    MaxIncCyc => 1,
    Desc      => "AK Ring Credit Unavailable",
    Defn      => "Number of times the S-Box has a pending NDR or S2C credit return message to send but there is no credit for the target egress FIFO.",
  },
  "CRD_UNAVAIL_BL" =>
  {
    Category  => "Ring Bound Credits",
    EvSel     => "0x89",
    MaxIncCyc => 1,
    Desc      => "BL Ring Credit Unavailable",
    Defn      => "Number of times the S-Box has a pending DRS or debug message to send and there is no credit for the target egress FIFO.",
  },
  "CRD_UNAVAIL_IPQ" =>
  {
    Category  => "Ring Bound Credits",
    EvSel     => "0x8A",
    MaxIncCyc => 1,
    Desc      => "IPQ Credit Unavailable",
    Defn      => "Number of times the S-Box has an incoming SNP to send but there is no IPQ credit available for the target C-Box.",
  },
  "EGRESS_ARB_LOSSES" =>
  {
    Category  => "Ring Bound Credits",
    EvSel     => "0x42",
    MaxIncCyc => 1,
    Desc      => "Egress ARB Losses",
    Defn      => "Egress Arbitration Losses.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b000000",
          Desc       => "(* nothing will be counted *)",
       },
       "AD_CW" =>
       {
          Umask    => "b000001",
          Desc       => "AD Clockwise",
       },
       "AD_CCW" =>
       {
          Umask    => "b000010",
          Desc       => "AD Counter-Clockwise",
       },
       "AD" =>
       {
          Umask    => "b000011",
          Desc       => "AD",
       },
       "AK_CW" =>
       {
          Umask    => "b000100",
          Desc       => "AK Clockwise",
       },
       "AK_CCW" =>
       {
          Umask    => "b001000",
          Desc       => "AK Counter-Clockwise",
       },
       "AK" =>
       {
          Umask    => "b001100",
          Desc       => "AK",
       },
       "BL_CW" =>
       {
          Umask    => "b010000",
          Desc       => "BL Clockwise",
       },
       "BL_CCW" =>
       {
          Umask    => "b100000",
          Desc       => "BL Counter-Clockwise",
       },
       "BL" =>
       {
          Umask    => "b110000",
          Desc       => "BL",
       },
     },
  },
  "EGRESS_ARB_WINS" =>
  {
    Category  => "Ring Bound Transmission",
    EvSel     => "0x41",
    MaxIncCyc => 1,
    Desc      => "Egress ARB Wins",
    Defn      => "Egress Arbitration Wins.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b000000",
          Desc       => "(* nothing will be counted *)",
       },
       "AD_CW" =>
       {
          Umask    => "b000001",
          Desc       => "AD Clockwise",
       },
       "AD_CCW" =>
       {
          Umask    => "b000010",
          Desc       => "AD Counter-Clockwise",
       },
       "AD" =>
       {
          Umask    => "b000011",
          Desc       => "AD",
       },
       "AK_CW" =>
       {
          Umask    => "b000100",
          Desc       => "AK Clockwise",
       },
       "AK_CCW" =>
       {
          Umask    => "b001000",
          Desc       => "AK Counter-Clockwise",
       },
       "AK" =>
       {
          Umask    => "b001100",
          Desc       => "AK",
       },
       "BL_CW" =>
       {
          Umask    => "b010000",
          Desc       => "BL Clockwise",
       },
       "BL_CCW" =>
       {
          Umask    => "b100000",
          Desc       => "BL Counter-Clockwise",
       },
       "BL" =>
       {
          Umask    => "b110000",
          Desc       => "BL",
       },
     },
  },
  "EGRESS_BYPASS" =>
  {
    Category  => "Ring Bound Enhancement",
    EvSel     => "0x40",
    MaxIncCyc => 1,
    Desc      => "Egress Bypass",
    Defn      => "Egress Bypass optimzation utilized.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b000000",
          Desc       => "(* nothing will be counted *)",
       },
       "AD_CW" =>
       {
          Umask    => "b000001",
          Desc       => "AD Clockwise",
       },
       "AD_CCW" =>
       {
          Umask    => "b000010",
          Desc       => "AD Counter-Clockwise",
       },
       "AD" =>
       {
          Umask    => "b000011",
          Desc       => "AD",
       },
       "AK_CW" =>
       {
          Umask    => "b000100",
          Desc       => "AK Clockwise",
       },
       "AK_CCW" =>
       {
          Umask    => "b001000",
          Desc       => "AK Counter-Clockwise",
       },
       "AK" =>
       {
          Umask    => "b001100",
          Desc       => "AK",
       },
       "BL_CW" =>
       {
          Umask    => "b010000",
          Desc       => "BL Clockwise",
       },
       "BL_CCW" =>
       {
          Umask    => "b100000",
          Desc       => "BL Counter-Clockwise",
       },
       "BL" =>
       {
          Umask    => "b110000",
          Desc       => "BL",
       },
     },
  },
  "EGRESS_STARVED" =>
  {
    Category  => "Ring Bound Credits",
    EvSel     => "0x43",
    MaxIncCyc => 1,
    Desc      => "Egress Cycles in Starvation",
    Defn      => "Number of cycles the S-Box egress FIFOs are in starvation.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b000000",
          Desc       => "(* nothing will be counted *)",
       },
       "AD_CW" =>
       {
          Umask    => "b000001",
          Desc       => "AD Clockwise",
       },
       "AD_CCW" =>
       {
          Umask    => "b000010",
          Desc       => "AD Counter-Clockwise",
       },
       "AD" =>
       {
          Umask    => "b000011",
          Desc       => "AD",
       },
       "AK_CW" =>
       {
          Umask    => "b000100",
          Desc       => "AK Clockwise",
       },
       "AK_CCW" =>
       {
          Umask    => "b001000",
          Desc       => "AK Counter-Clockwise",
       },
       "AK" =>
       {
          Umask    => "b001100",
          Desc       => "AK",
       },
       "BL_CW" =>
       {
          Umask    => "b010000",
          Desc       => "BL Clockwise",
       },
       "BL_CCW" =>
       {
          Umask    => "b100000",
          Desc       => "BL Counter-Clockwise",
       },
       "BL" =>
       {
          Umask    => "b110000",
          Desc       => "BL",
       },
     },
  },
  "FLITS_SENT_DRS" =>
  {
    Category  => "System Bound Transmission",
    EvSel     => "0x65",
    MaxIncCyc => 1,
    Desc      => "DRS Flits Sent to System",
    Defn      => "Number of data response flits the S-Box has transmitted to the system.",
  },
  "FLITS_SENT_NCB" =>
  {
    Category  => "System Bound Transmission",
    EvSel     => "0x69",
    MaxIncCyc => 1,
    Desc      => "NCB Flits Sent to System",
    Defn      => "Number of non-coherent bypass flits the S-Box has transmitted to the system.",
  },
  "FLITS_SENT_NCS" =>
  {
    Category  => "System Bound Transmission",
    EvSel     => "0x67",
    MaxIncCyc => 1,
    Desc      => "NCS Flits Sent to System",
    Defn      => "Number of non-coherent standard flits the S-Box has transmitted to the system.",
  },
  "HALFLINE_BYPASS" =>
  {
    Category  => "Ring Bound Enhancement",
    EvSel     => "0x30",
    MaxIncCyc => 1,
    Desc      => "Half Cacheline Bypass",
    Defn      => "Half Cacheline Bypass optimization (where the line is sent early) was utilized.",
  },
  "NO_CREDIT_DRS" =>
  {
    Category  => "System Bound Credits",
    EvSel     => "0x82",
    MaxIncCyc => 1,
    Desc      => "DRS Credit Unavailable",
    Defn      => "Number of times the S-Box has a pending data response message to send and there is no DRS or VNA credit available.",
  },
  "NO_CREDIT_HOM" =>
  {
    Category  => "System Bound Credits",
    EvSel     => "0x80",
    MaxIncCyc => 1,
    Desc      => "HOM Credit Unavailable",
    Defn      => "Number of times the S-Box has a pending home message to send and there is no HOM or VNA credit available.",
  },
  "NO_CREDIT_NCB" =>
  {
    Category  => "System Bound Credits",
    EvSel     => "0x84",
    MaxIncCyc => 1,
    Desc      => "NCB Credit Unavailable",
    Defn      => "Number of times the S-Box has a pending non-coherent bypass message to send and there is no NCB or VNA credit available.",
  },
  "NO_CREDIT_NCS" =>
  {
    Category  => "System Bound Credits",
    EvSel     => "0x83",
    MaxIncCyc => 1,
    Desc      => "NCS Credit Unavailable",
    Defn      => "Number of times the S-Box has a pending non-coherent standard message to send and there is no NCS or VNA credit available.",
  },
  "NO_CREDIT_VNA" =>
  {
    Category  => "System Bound Credits",
    EvSel     => "0x86",
    MaxIncCyc => 1,
    Desc      => "VNA Credit Unavailable",
    Defn      => "Number of times the S-Box has exhausted its VNA credit pool.",
  },
  "PKTS_RCVD_DRS_FROM_R" =>
  {
    Category  => "Ring Bound Transmission",
    EvSel     => "0x72",
    MaxIncCyc => 1,
    Desc      => "DRS Packets Received from B-Box",
    Defn      => "Number of data response packets the S-Box has received from the R-Box.",
  },
  "PKTS_RCVD_NDR" =>
  {
    Category  => "Ring Bound Transmission",
    EvSel     => "0x70",
    MaxIncCyc => 1,
    Desc      => "NDR Packets Received from System",
    Defn      => "Number of non-data response packets the S-Box has received from the system.",
  },
  "PKTS_RCVD_SNP" =>
  {
    Category  => "Ring Bound Transmission",
    EvSel     => "0x71",
    MaxIncCyc => 1,
    Desc      => "SNP Packets Received from System",
    Defn      => "Number of snoop packets the S-Box has received from the system.",
  },
  "PKTS_SENT_DRS" =>
  {
    Category  => "System Bound Transmission",
    EvSel     => "0x64",
    MaxIncCyc => 1,
    Desc      => "DRS Packets Sent to System",
    Defn      => "Number of DRS packets the S-Box has transmitted to the system.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b0000",
          Desc       => "(* nothing will be counted *)",
       },
       "CBOX0_4" =>
       {
          Umask    => "bxxx1",
          Desc       => "C-Boxes 0 and 4",
       },
       "CBOX1_5" =>
       {
          Umask    => "bxx1x",
          Desc       => "C-Boxes 1 and 5",
       },
       "CBOX2_6" =>
       {
          Umask    => "bx1xx",
          Desc       => "C-Boxes 2 and 6",
       },
       "CBOX3_7" =>
       {
          Umask    => "b1xxx",
          Desc       => "C-Boxes 3 and 7",
       },
     },
  },
  "PKTS_SENT_HOM" =>
  {
    Category  => "System Bound Transmission",
    EvSel     => "0x60",
    MaxIncCyc => 1,
    Desc      => "HOM Packets Sent to System",
    Defn      => "Number of home packets the S-Box has transmitted to the System.",
  },
  "PKTS_SENT_NCB" =>
  {
    Category  => "System Bound Transmission",
    EvSel     => "0x68",
    MaxIncCyc => 1,
    Desc      => "NCB Packets Sent to System",
    Defn      => "Number of NCB packets the S-Box has transmitted to the system.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b0000",
          Desc       => "(* nothing will be counted *)",
       },
       "CBOX0_4" =>
       {
          Umask    => "bxxx1",
          Desc       => "C-Boxes 0 and 4",
       },
       "CBOX1_5" =>
       {
          Umask    => "bxx1x",
          Desc       => "C-Boxes 1 and 5",
       },
       "CBOX2_6" =>
       {
          Umask    => "bx1xx",
          Desc       => "C-Boxes 2 and 6",
       },
       "CBOX3_7" =>
       {
          Umask    => "b1xxx",
          Desc       => "C-Boxes 3 and 7",
       },
     },
  },
  "PKTS_SENT_NCS" =>
  {
    Category  => "System Bound Transmission",
    EvSel     => "0x66",
    MaxIncCyc => 1,
    Desc      => "NCS Packets Sent to System",
    Defn      => "Number of NCS packets the S-Box has transmitted to the system.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b0000",
          Desc       => "(* nothing will be counted *)",
       },
       "CBOX0_4" =>
       {
          Umask    => "bxxx1",
          Desc       => "C-Boxes 0 and 4",
       },
       "CBOX1_5" =>
       {
          Umask    => "bxx1x",
          Desc       => "C-Boxes 1 and 5",
       },
       "CBOX2_6" =>
       {
          Umask    => "bx1xx",
          Desc       => "C-Boxes 2 and 6",
       },
       "CBOX3_7" =>
       {
          Umask    => "b1xxx",
          Desc       => "C-Boxes 3 and 7",
       },
     },
  },
  "QEAR_EVENT" =>
  {
    Category  => "Miscellaneous",
    EvSel     => "0x90",
    MaxIncCyc => 1,
    Desc      => "Event was captured in the CEAR",
    Defn      => "",
  },
  "RBOX_CREDITS" =>
  {
    Category  => "Ring Bound Transmission",
    EvSel     => "0x76",
    MaxIncCyc => 1,
    Desc      => "R-Box Credit Carrying Flits",
    Defn      => "Number credit carrying idle flits received from the R-Box.",
  },
  "RBOX_CREDIT_RETURNS" =>
  {
    Category  => "System Bound Transmission",
    EvSel     => "0x6A",
    MaxIncCyc => 1,
    Desc      => "R-Box Credit Returns",
    Defn      => "Number credit return idle flits sent to the R-Box.",
  },
  "RBOX_HOM_BYPASS" =>
  {
    Category  => "System Bound Enhancement",
    EvSel     => "0x50",
    MaxIncCyc => 1,
    Desc      => "R-Box HOM Bypass",
    Defn      => "R-Box HOM Bypass optimization was utilized.",
  },
  "REQ_TBL_OCPY" =>
  {
    Category  => "Ring Bound Queue",
    EvSel     => "0x31",
    MaxIncCyc => 1,
    Desc      => "Request Table Occupancy",
    Defn      => "Number of request table entries occupied by socket requests.",
  },
  "TO_RING_NDR_MSGQ_CYCLES_FULL" =>
  {
    Category  => "Ring Bound Queue",
    EvSel     => "0x27",
    MaxIncCyc => 1,
    Desc      => "Cycles Ring Bound NDR Message Queue Full",
    Defn      => "Number of cycles in which the header buffer, containing NDR messages on their way to the Ring, is full.",
  },
  "TO_RING_NDR_MSGQ_CYCLES_NE" =>
  {
    Category  => "Ring Bound Queue",
    EvSel     => "0x28",
    MaxIncCyc => 1,
    Desc      => "Cycles Ring Bound NDR Message Queue Not Empty",
    Defn      => "Number of cycles in which the header buffer, containing NDR messages on their way to the Ring, has one or more entries allocated.",
  },
  "TO_RING_NDR_MSGQ_OCCUPANCY" =>
  {
    Category  => "Ring Bound Queue",
    EvSel     => "0x29",
    MaxIncCyc => 1,
    Desc      => "Ring Bound NDR Message Queue Occupancy",
    Defn      => "Number of entries in header buffer containing NDR messages on their way to the Ring.",
  },
  "TO_RING_R2S_MSGQ_CYCLES_FULL" =>
  {
    Category  => "Ring Bound Queue",
    EvSel     => "0x2A",
    MaxIncCyc => 1,
    Desc      => "Cycles Ring Bound R2S Message Queue Full",
    Defn      => "Number of cycles in which the header buffer, containing R to S-Box messages on their way to the Ring, is full.",
  },
  "TO_RING_R2S_MSGQ_CYCLES_NE" =>
  {
    Category  => "Ring Bound Queue",
    EvSel     => "0x2C",
    MaxIncCyc => 1,
    Desc      => "Cycles Ring Bound R2S Message Queue Not Empty",
    Defn      => "Number of cycles in which the header buffer, containing R to S-Box messages on their way to the Ring, has one or more entries allocated.",
  },
  "TO_RING_R2S_MSGQ_OCCUPANCY" =>
  {
    Category  => "Ring Bound Queue",
    EvSel     => "0x2E",
    MaxIncCyc => 1,
    Desc      => "Ring Bound R2S Message Queue Occupancy",
    Defn      => "Number of entries in header buffer containing R to S messages on their way to the Ring.",
  },
  "TO_RING_SNP_MSGQ_CYCLES_FULL" =>
  {
    Category  => "Ring Bound Queue",
    EvSel     => "0x20",
    MaxIncCyc => 1,
    Desc      => "Cycles Ring Bound SNP Message Queue Full",
    Defn      => "Number of cycles in which the header buffer, containing SNP messages on their way to the Ring, is full.",
  },
  "TO_RING_SNP_MSGQ_CYCLES_NE" =>
  {
    Category  => "Ring Bound Queue",
    EvSel     => "0x23",
    MaxIncCyc => 1,
    Desc      => "Cycles Ring Bound SNP Message Queue Not Empty",
    Defn      => "Number of cycles in which the header buffer, containing SNP messages on their way to the Ring, has one or more entries allocated.",
  },
  "TO_RING_SNP_MSGQ_OCCUPANCY" =>
  {
    Category  => "Ring Bound Queue",
    EvSel     => "0x26",
    MaxIncCyc => 1,
    Desc      => "Ring Bound SNP Message Queue Occupancy",
    Defn      => "Number of entries in header buffer containing SNP messages headed for the Ring.",
  },
  "TO_R_DRS_MSGQ_CYCLES_FULL" =>
  {
    Category  => "System Bound Queue",
    EvSel     => "0x0E",
    MaxIncCyc => 1,
    Desc      => "Cycles System Bound DRS Message Queue Full.",
    Defn      => "Number of cycles in which the header buffer for the selected C-Box, containing DRS messages heading to a System Agent (through the R-Box), is full. Only one C-Boxs DRS header buffer should be selected for the buffer full checking to be correct, else the result is undefined.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b0000",
          Desc       => "(* nothing will be counted *)",
       },
       "CBOX0_4" =>
       {
          Umask    => "bxxx1",
          Desc       => "CBOX 0 and 4",
       },
       "CBOX1_5" =>
       {
          Umask    => "bxx1x",
          Desc       => "CBOX 1 and 5",
       },
       "CBOX2_6" =>
       {
          Umask    => "bx1xx",
          Desc       => "CBOX 2 and 6",
       },
       "CBOX3_7" =>
       {
          Umask    => "b1xxx",
          Desc       => "CBOX 3 and 7",
       },
       "ANY" =>
       {
          Umask    => "b1111",
          Desc       => "Any C-Box",
       },
     },
  },
  "TO_R_DRS_MSGQ_CYCLES_NE" =>
  {
    Category  => "System Bound Queue",
    EvSel     => "0x0F",
    MaxIncCyc => 1,
    Desc      => "Cycles System Bound DRS Message Queue Not Empty",
    Defn      => "Number of cycles in which the header buffer for the selected C-Box, containing DRS messages heading to a System Agent (through the R-Box), has one or more entries allocated. When more than one C-Box is selected, the event is asserted when any of the selected C-Box DRS header buffers are not empty.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b0000",
          Desc       => "(* nothing will be counted *)",
       },
       "CBOX0_4" =>
       {
          Umask    => "bxxx1",
          Desc       => "CBOX 0 and 4",
       },
       "CBOX1_5" =>
       {
          Umask    => "bxx1x",
          Desc       => "CBOX 1 and 5",
       },
       "CBOX2_6" =>
       {
          Umask    => "bx1xx",
          Desc       => "CBOX 2 and 6",
       },
       "CBOX3_7" =>
       {
          Umask    => "b1xxx",
          Desc       => "CBOX 3 and 7",
       },
       "ANY" =>
       {
          Umask    => "b1111",
          Desc       => "Any C-Box",
       },
     },
  },
  "TO_R_DRS_MSGQ_OCCUPANCY" =>
  {
    Category  => "System Bound Queue",
    EvSel     => "0x10",
    MaxIncCyc => 1,
    Desc      => "System Bound DRS Message Queue Occupancy",
    Defn      => "Number of entries in the header buffer for the selected C-Box, containing DRS messages heading to a System Agent (through the R-Box). When more than one C-Box is selected, the queue occupancy counter counts the total number of occupied entries in all selected C-Box DRS header buffers.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b0000",
          Desc       => "(* nothing will be counted *)",
       },
       "CBOX0_4" =>
       {
          Umask    => "bxxx1",
          Desc       => "CBOX 0 and 4",
       },
       "CBOX1_5" =>
       {
          Umask    => "bxx1x",
          Desc       => "CBOX 1 and 5",
       },
       "CBOX2_6" =>
       {
          Umask    => "bx1xx",
          Desc       => "CBOX 2 and 6",
       },
       "CBOX3_7" =>
       {
          Umask    => "b1xxx",
          Desc       => "CBOX 3 and 7",
       },
       "ALL" =>
       {
          Umask    => "b1111",
          Desc       => "All C-Boxes",
       },
     },
  },
  "TO_R_HOM_MSGQ_CYCLES_FULL" =>
  {
    Category  => "System Bound Queue",
    EvSel     => "0x03",
    MaxIncCyc => 1,
    Desc      => "Cycles System Bound HOM Message Queue Full.",
    Defn      => "Number of cycles in which the header buffer, containing HOM messages heading to the System is full.",
  },
  "TO_R_HOM_MSGQ_CYCLES_NE" =>
  {
    Category  => "System Bound Queue",
    EvSel     => "0x06",
    MaxIncCyc => 1,
    Desc      => "Cycles System Bound HOM Header Not Empty",
    Defn      => "Number of cycles in which the header buffer, containing HOM messages heading to the System.",
  },
  "TO_R_HOM_MSGQ_OCCUPANCY" =>
  {
    Category  => "System Bound Queue",
    EvSel     => "0x07",
    MaxIncCyc => 1,
    Desc      => "System Bound HOM Message Queue Occupancy",
    Defn      => "Number of entries in the header buffer containing HOM messages heading to the System.",
  },
  "TO_R_NCB_MSGQ_CYCLES_FULL" =>
  {
    Category  => "System Bound Queue",
    EvSel     => "0x11",
    MaxIncCyc => 1,
    Desc      => "Cycles System Bound NCB Message Queue Full.",
    Defn      => "Number of cycles in which the header buffer for the selected C-Box, containing NCB messages heading to a System Agent (through the R-Box), is full. Only one C-Boxs NCB header buffer should be selected for the buffer full checking to be correct, else the result is undefined.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b0000",
          Desc       => "(* nothing will be counted *)",
       },
       "CBOX0_4" =>
       {
          Umask    => "bxxx1",
          Desc       => "CBOX 0 and 4",
       },
       "CBOX1_5" =>
       {
          Umask    => "bxx1x",
          Desc       => "CBOX 1 and 5",
       },
       "CBOX2_6" =>
       {
          Umask    => "bx1xx",
          Desc       => "CBOX 2 and 6",
       },
       "CBOX3_7" =>
       {
          Umask    => "b1xxx",
          Desc       => "CBOX 3 and 7",
       },
       "ANY" =>
       {
          Umask    => "b1111",
          Desc       => "Any C-Box",
       },
     },
  },
  "TO_R_NCB_MSGQ_CYCLES_NE" =>
  {
    Category  => "System Bound Queue",
    EvSel     => "0x12",
    MaxIncCyc => 1,
    Desc      => "Cycles System Bound NCB Message Queue Not Empty",
    Defn      => "Number of cycles in which the header buffer for the selected C-Box, containing NCB messages heading to a System Agent (through the R-Box), has one or more entries allocated. When more than one C-Box is selected, the event is asserted when any of the selected C-Box DRS header buffers are not empty.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b0000",
          Desc       => "(* nothing will be counted *)",
       },
       "CBOX0_4" =>
       {
          Umask    => "bxxx1",
          Desc       => "CBOX 0 and 4",
       },
       "CBOX1_5" =>
       {
          Umask    => "bxx1x",
          Desc       => "CBOX 1 and 5",
       },
       "CBOX2_6" =>
       {
          Umask    => "bx1xx",
          Desc       => "CBOX 2 and 6",
       },
       "CBOX3_7" =>
       {
          Umask    => "b1xxx",
          Desc       => "CBOX 3 and 7",
       },
       "ANY" =>
       {
          Umask    => "b1111",
          Desc       => "Any C-Box",
       },
     },
  },
  "TO_R_NCB_MSGQ_OCCUPANCY" =>
  {
    Category  => "System Bound Queue",
    EvSel     => "0x13",
    MaxIncCyc => 1,
    Desc      => "System Bound NCB Message Queue Occupancy",
    Defn      => "Number of entries in the header buffer for the selected C-Box, containing NCB messages heading to a System Agent (through the R-Box). When more than one C-Box is selected, the queue occupancy counter counts the total number of occupied entries in all selected C-Box NCB header buffers.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b0000",
          Desc       => "(* nothing will be counted *)",
       },
       "CBOX0_4" =>
       {
          Umask    => "bxxx1",
          Desc       => "CBOX 0 and 4",
       },
       "CBOX1_5" =>
       {
          Umask    => "bxx1x",
          Desc       => "CBOX 1 and 5",
       },
       "CBOX2_6" =>
       {
          Umask    => "bx1xx",
          Desc       => "CBOX 2 and 6",
       },
       "CBOX3_7" =>
       {
          Umask    => "b1xxx",
          Desc       => "CBOX 3 and 7",
       },
       "ALL" =>
       {
          Umask    => "b1111",
          Desc       => "All C-Boxes",
       },
     },
  },
  "TO_R_NCS_MSGQ_CYCLES_FULL" =>
  {
    Category  => "System Bound Queue",
    EvSel     => "0x14",
    MaxIncCyc => 1,
    Desc      => "Cycles System Bound NCS Message Queue Full.",
    Defn      => "Number of cycles in which the header buffer for the selected C-Box, containing NCS messages heading to a System Agent (through the R-Box), is full. Only one C-Boxs NCS header buffer should be selected for the buffer full checking to be correct, else the result is undefined.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b0000",
          Desc       => "(* nothing will be counted *)",
       },
       "CBOX0_4" =>
       {
          Umask    => "bxxx1",
          Desc       => "CBOX 0 and 4",
       },
       "CBOX1_5" =>
       {
          Umask    => "bxx1x",
          Desc       => "CBOX 1 and 5",
       },
       "CBOX2_6" =>
       {
          Umask    => "bx1xx",
          Desc       => "CBOX 2 and 6",
       },
       "CBOX3_7" =>
       {
          Umask    => "b1xxx",
          Desc       => "CBOX 3 and 7",
       },
       "ANY" =>
       {
          Umask    => "b1111",
          Desc       => "Any C-Box",
       },
     },
  },
  "TO_R_NCS_MSGQ_CYCLES_NE" =>
  {
    Category  => "System Bound Queue",
    EvSel     => "0x15",
    MaxIncCyc => 1,
    Desc      => "Cycles System Bound NCS Message Queue Not Empty",
    Defn      => "Number of cycles in which the header buffer for the selected C-Box, containing NCS messages heading to a System Agent (through the R-Box), has one or more entries allocated. When more than one C-Box is selected, the event is asserted when any of the selected C-Box NCS header buffers are not empty.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b0000",
          Desc       => "(* nothing will be counted *)",
       },
       "CBOX0_4" =>
       {
          Umask    => "bxxx1",
          Desc       => "CBOX 0 and 4",
       },
       "CBOX1_5" =>
       {
          Umask    => "bxx1x",
          Desc       => "CBOX 1 and 5",
       },
       "CBOX2_6" =>
       {
          Umask    => "bx1xx",
          Desc       => "CBOX 2 and 6",
       },
       "CBOX3_7" =>
       {
          Umask    => "b1xxx",
          Desc       => "CBOX 3 and 7",
       },
       "ANY" =>
       {
          Umask    => "b1111",
          Desc       => "Any C-Box",
       },
     },
  },
  "TO_R_NCS_MSGQ_OCCUPANCY" =>
  {
    Category  => "System Bound Queue",
    EvSel     => "0x16",
    MaxIncCyc => 1,
    Desc      => "System Bound NCS Message Queue Occupancy",
    Defn      => "Number of entries in the header buffer for the selected C-Box, containing NCS messages heading to a System Agent (through the R-Box). When more than one C-Box is selected, the queue occupancy counter counts the total number of occupied entries in all selected C-Box NCS header buffers.",
    SubEvents  =>
    {
       "NONE1" =>
       {
          Umask    => "b0000",
          Desc       => "(* nothing will be counted *)",
       },
       "CBOX0_4" =>
       {
          Umask    => "bxxx1",
          Desc       => "CBOX 0 and 4",
       },
       "CBOX1_5" =>
       {
          Umask    => "bxx1x",
          Desc       => "CBOX 1 and 5",
       },
       "CBOX2_6" =>
       {
          Umask    => "bx1xx",
          Desc       => "CBOX 2 and 6",
       },
       "CBOX3_7" =>
       {
          Umask    => "b1xxx",
          Desc       => "CBOX 3 and 7",
       },
       "ALL" =>
       {
          Umask    => "b1111",
          Desc       => "All C-Boxes",
       },
     },
  },
  "TO_R_PROG_EV" =>
  {
    Category  => "System Bound Enhancement",
    EvSel     => "0x00",
    MaxIncCyc => 1,
    Desc      => "System Bound Programmable Event",
    Defn      => "Programmable Event heading to a System Agent (through the R-Box). Match/Mask on criteria set in S_MSR_MATCH/MASK registers (Refer to Section 5.6.3.4, S-Box Registers for Mask/Match Facility)",
  },
);



################################################################################
# Event List for Pouson WBox
################################################################################
%PSNWBoxEventList=
(
  "PSTATE_CHANGE" =>
  {
    Category  => "W-Box Events",
    EvSel     => "0x05",
    MaxIncCyc => 1,
    Desc      => "P-State Change",
    Defn      => "Any P-State Change",
    SubEvents  =>
    {
       "ILLEGAL" =>
       {
          Umask    => "0xfe-x00",
          Desc       => "(* illegal selection *)",
       },
       "ALL" =>
       {
          Umask    => "0xff",
          Desc       => "All Cores",
       },
     },
  },
  "S_C1E_CSTATE" =>
  {
    Category  => "W-Box Events",
    EvSel     => "0x06",
    MaxIncCyc => 1,
    Desc      => "Socket in C1E",
    Defn      => "Pcode detects that socket is in C1E C-State",
  },
  "S_FORCEPR" =>
  {
    Category  => "W-Box Events",
    EvSel     => "0x02",
    MaxIncCyc => 1,
    Desc      => "FORCEPR",
    Defn      => "Package is asserting the FORCEPR output.",
  },
  "S_P0_PSTATE" =>
  {
    Category  => "W-Box Events",
    EvSel     => "0x04",
    MaxIncCyc => 1,
    Desc      => "Socket in P0",
    Defn      => "Pcode detects that socket is in P0 P-State",
  },
  "S_P0_REQUEST" =>
  {
    Category  => "W-Box Events",
    EvSel     => "0x07",
    MaxIncCyc => 1,
    Desc      => "P0 Requests",
    Defn      => "Number times P0 state was requested.",
  },
  "S_PROCHOT" =>
  {
    Category  => "W-Box Events",
    EvSel     => "0x09",
    MaxIncCyc => 1,
    Desc      => "PROCHOT",
    Defn      => "Package is asserting the PROCHOT output.",
  },
  "S_THROTTLE_PROCHOT" =>
  {
    Category  => "W-Box Events",
    EvSel     => "0x03",
    MaxIncCyc => 1,
    Desc      => "Socket Throttled due to PROCHOT",
    Defn      => "Socket is thermally throttled due to PROCHOT condition (heavy throttling).",
  },
  "S_THROTTLE_TEMP" =>
  {
    Category  => "W-Box Events",
    EvSel     => "0x01",
    MaxIncCyc => 1,
    Desc      => "SocketThrottled due to Temp",
    Defn      => "Socket is thermally throttled due to thermal condition (lite throttling).",
    SubEvents  =>
    {
       "ILLEGAL" =>
       {
          Umask    => "0xfe-x00",
          Desc       => "(* illegal selection *)",
       },
       "ALL" =>
       {
          Umask    => "0xff",
          Desc       => "All Cores",
       },
     },
  },
);



################################################################################
# Event List for Pouson ZBox
################################################################################
%PSNZBoxEventList=
(
  "BBOX_CMNDS_ALL" =>
  {
    Category  => "Z-Box Commands Received",
    EvSel     => "0x1a",
    MaxIncCyc => 1,
    Desc      => "All B-Box Commands",
    Defn      => "Advance counter when a new command is detected from the Bbox to the Z Box.",
  },
  "CKE_LOW_CYCLES_R0" =>
  {
    Category  => "CKE Power Down",
    EvSel     => "0x2b",
    MaxIncCyc => 1,
    Desc      => "CKE Low Active For Rank 0",
    Defn      => "Cycles CKE Low power down active for rank/rank-pair 0",
  },
  "CKE_LOW_CYCLES_R1" =>
  {
    Category  => "CKE Power Down",
    EvSel     => "0x2c",
    MaxIncCyc => 1,
    Desc      => "CKE Low Active For Rank 1",
    Defn      => "Cycles CKE Low power down active for rank/rank-pair 1",
  },
  "CKE_LOW_CYCLES_R2" =>
  {
    Category  => "CKE Power Down",
    EvSel     => "0x2d",
    MaxIncCyc => 1,
    Desc      => "CKE Low Active For Rank 2",
    Defn      => "Cycles CKE Low power down active for rank/rank-pair 2",
  },
  "CKE_LOW_CYCLES_R3" =>
  {
    Category  => "CKE Power Down",
    EvSel     => "0x2e",
    MaxIncCyc => 1,
    Desc      => "CKE Low Active For Rank 3",
    Defn      => "Cycles CKE Low power down active for rank/rank-pair 3",
  },
  "CKE_LOW_CYCLES_R4" =>
  {
    Category  => "CKE Power Down",
    EvSel     => "0x2f",
    MaxIncCyc => 1,
    Desc      => "CKE Low Active For Rank 4",
    Defn      => "Cycles CKE Low power down active for rank/rank-pair 4",
  },
  "CKE_LOW_CYCLES_R5" =>
  {
    Category  => "CKE Power Down",
    EvSel     => "0x30",
    MaxIncCyc => 1,
    Desc      => "CKE Low Active For Rank 5",
    Defn      => "Cycles CKE Low power down active for rank/rank-pair 5",
  },
  "CKE_LOW_CYCLES_R6" =>
  {
    Category  => "CKE Power Down",
    EvSel     => "0x31",
    MaxIncCyc => 1,
    Desc      => "CKE Low Active For Rank 6",
    Defn      => "Cycles CKE Low power down active for rank/rank-pair 6",
  },
  "CKE_LOW_CYCLES_R7" =>
  {
    Category  => "CKE Power Down",
    EvSel     => "0x32",
    MaxIncCyc => 1,
    Desc      => "CKE Low Active For Rank 7",
    Defn      => "Cycles CKE Low power down active for rank/rank-pair 7",
  },
  "CKE_LOW_SENT_R0" =>
  {
    Category  => "CKE Power Down",
    EvSel     => "0x33",
    MaxIncCyc => 1,
    Desc      => "CKE Low Sent To Rank 0",
    Defn      => "Number of times CKE Low power down sent to rank/rank-pair 0",
  },
  "CKE_LOW_SENT_R1" =>
  {
    Category  => "CKE Power Down",
    EvSel     => "0x34",
    MaxIncCyc => 1,
    Desc      => "CKE Low Sent To Rank 1",
    Defn      => "Number of times CKE Low power down sent to rank/rank-pair 1",
  },
  "CKE_LOW_SENT_R2" =>
  {
    Category  => "CKE Power Down",
    EvSel     => "0x35",
    MaxIncCyc => 1,
    Desc      => "CKE Low Sent To Rank 2",
    Defn      => "Number of times CKE Low power down sent to rank/rank-pair 2",
  },
  "CKE_LOW_SENT_R3" =>
  {
    Category  => "CKE Power Down",
    EvSel     => "0x36",
    MaxIncCyc => 1,
    Desc      => "CKE Low Sent To Rank 3",
    Defn      => "Number of times CKE Low power down sent to rank/rank-pair 3",
  },
  "CKE_LOW_SENT_R4" =>
  {
    Category  => "CKE Power Down",
    EvSel     => "0x37",
    MaxIncCyc => 1,
    Desc      => "CKE Low Sent To Rank 4",
    Defn      => "Number of times CKE Low power down sent to rank/rank-pair 4",
  },
  "CKE_LOW_SENT_R5" =>
  {
    Category  => "CKE Power Down",
    EvSel     => "0x38",
    MaxIncCyc => 1,
    Desc      => "CKE Low Sent To Rank 5",
    Defn      => "Number of times CKE Low power down sent to rank/rank-pair 5",
  },
  "CKE_LOW_SENT_R6" =>
  {
    Category  => "CKE Power Down",
    EvSel     => "0x39",
    MaxIncCyc => 1,
    Desc      => "CKE Low Sent To Rank 6",
    Defn      => "Number of times CKE Low power down sent to rank/rank-pair 6",
  },
  "CKE_LOW_SENT_R7" =>
  {
    Category  => "CKE Power Down",
    EvSel     => "0x3a",
    MaxIncCyc => 1,
    Desc      => "CKE Low Sent To Rank 7",
    Defn      => "Number of times CKE Low power down sent to rank/rank-pair 7",
  },
  "CYCLES" =>
  {
    Category  => "Cycle Counters",
    EvSel     => "0x1b",
    MaxIncCyc => 1,
    Desc      => "Z-Box Cycles",
    Defn      => "Count Z-box cycles",
  },
  "CYCLES_DSP_FILL" =>
  {
    Category  => "Cycle Counters",
    EvSel     => "0x20",
    MaxIncCyc => 1,
    Desc      => "Time in DSP_FILL state",
    Defn      => "Advance counter every cycle the dispatch queue meets a certain condition.",
    SubEvents  =>
    {
       "NEMPTY" =>
       {
          RegDep => "Z_CSR_DSP_PMU",
          RegDepBits => "[10]0x0",
          AltCat => "",
          Desc       => "Advance counter every cycle that the dispatch queue is not empty",
       },
       "EMPTY" =>
       {
          RegDep => "Z_CSR_DSP_PMU",
          RegDepBits => "[10]0x1",
          AltCat => "",
          Desc       => "Advance counter every cycle that the dispatch queue is empty",
       },
     },
  },
  "CYCLES_PGT_STATE" =>
  {
    Category  => "Cycle Counters",
    EvSel     => "0x11",
    MaxIncCyc => 1,
    Desc      => "Time in Page Table State",
    Defn      => "Counts cycles the Page Table is in selected mode.",
    SubEvents  =>
    {
       "CLOSED" =>
       {
          RegDep => "Z_CSR_PGT_PMU",
          RegDepBits => "[7]0x0",
          AltCat => "",
          Desc       => "Advance counter every state the page table is in close page mode.",
       },
       "OPEN" =>
       {
          RegDep => "Z_CSR_PGT_PMU",
          RegDepBits => "[7]0x1",
          AltCat => "",
          Desc       => "Advance counter every state the page table is in open page mode.",
       },
     },
  },
  "CYCLES_RETRYQ_STARVED" =>
  {
    Category  => "Cycle Counters",
    EvSel     => "0x23",
    MaxIncCyc => 1,
    Desc      => "Time RetryQ Starved",
    Defn      => "Counts cycles RetryQ spends in the badly starved state.",
  },
  "CYCLES_SCHED_MODE" =>
  {
    Category  => "Cycle Counters",
    EvSel     => "0x24",
    MaxIncCyc => 1,
    Desc      => "Time in SCHED_MODE state",
    Defn      => "Counts cycles spent in scheduling mode specified in M_CSR_PMU_ISS.sched_mode",
    SubEvents  =>
    {
       "TRADEOFF" =>
       {
          RegDep => "Z_CSR_ISS_PMU",
          RegDepBits => "[6:4]0x1",
          AltCat => "",
          Desc       => "Advance counter every state that the scheduler is in static TRDOFF mode.",
       },
       "RDPRIO" =>
       {
          RegDep => "Z_CSR_ISS_PMU",
          RegDepBits => "[6:4]0x2",
          AltCat => "",
          Desc       => "Advance counter every state that the scheduler is in static RDPRIO mode.",
       },
       "WRPRIO" =>
       {
          RegDep => "Z_CSR_ISS_PMU",
          RegDepBits => "[6:4]0x4",
          AltCat => "",
          Desc       => "Advance counter every state that the scheduler is in static WRPRIO mode.",
       },
     },
  },
  "CYCLES_THROTTLE" =>
  {
    Category  => "Cycle Counters",
    EvSel     => "0x21",
    MaxIncCyc => 1,
    Desc      => "Throttled Cycles",
    Defn      => "Advance counter for every state that the Z-Box is in the platform throttle on state",
  },
  "CYCLES_ZFULL" =>
  {
    Category  => "Cycle Counters",
    EvSel     => "0x01",
    MaxIncCyc => 1,
    Desc      => "Z-Box Full Cycles",
    Defn      => "Advance counter when the \"zfull\" state is detected.",
  },
  "DRAM_CMD" =>
  {
    Category  => "DRAM Commands",
    EvSel     => "0x0a",
    MaxIncCyc => 1,
    Desc      => "PLD Related DRAM Events",
    Defn      => "Count PLD Related DRAM Events",
    Notes     => "Tn order to measure a non-filtered version of the .DRAM_CMD events, it is necessary to make sure the PLD Dep bits [13,7,0] are also set to 0.",
    SubEvents  =>
    {
       "NOP" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0x0",
          AltCat => "",
          Desc       => "Count NOP DRAM commands.",
       },
       "PRE" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0x1",
          AltCat => "",
          Desc       => "Count Precharge Single DRAM commands.",
       },
       "RAS" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0x2",
          AltCat => "",
          Desc       => "Count RAS DRAM commands.",
       },
       "CAS_RD_OPN" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0x4",
          AltCat => "",
          Desc       => "Count CAS Read (no auto-precharge, open page mode) DRAM commands.",
       },
       "CAS_RD_OPN.TRDOFF" =>
       {
          RegDep => "Z_CSR_PLD_PMU,Z_CSR_ISS_PMU",
          RegDepBits => "[0]0x1 && [12:8]0x4, [9:7]0x1",
          AltCat => "",
          Desc       => "Count CAS Read (no auto-precharge, open page mode) DRAM commands during \"static trade off\" scheduling mode",
       },
       "CAS_RD_OPN.RDPRIO" =>
       {
          RegDep => "Z_CSR_PLD_PMU,Z_CSR_ISS_PMU",
          RegDepBits => "[0]0x1 && [12:8]0x4, [9:7]0x2",
          AltCat => "",
          Desc       => "Count CAS Read (no auto-precharge, open page mode) DRAM commands during \"static read priority\" scheduling mode",
       },
       "CAS_RD_OPN.WRPRIO" =>
       {
          RegDep => "Z_CSR_PLD_PMU,Z_CSR_ISS_PMU",
          RegDepBits => "[0]0x1 && [12:8]0x4, [9:7]0x4",
          AltCat => "",
          Desc       => "Count CAS Read (no auto-precharge, open page mode) DRAM commands during \"static write priority\" scheduling mode",
       },
       "RFR" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0x8",
          AltCat => "",
          Desc       => "Count Refresh DRAM commands.",
       },
       "PREALL" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0x9",
          AltCat => "",
          Desc       => "Count Precharge All DRAM commands.",
       },
       "ALL" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0xa",
          AltCat => "",
          Desc       => "Advance counter when a DRAM command is detected.",
       },
       "ALL.TRDOFF" =>
       {
          RegDep => "Z_CSR_PLD_PMU,Z_CSR_ISS_PMU",
          RegDepBits => "[0]0x1 && [12:8]0xa, [9:7]0x1",
          AltCat => "",
          Desc       => "Count all DRAM commands during \"static trade off\" scheduling mode",
       },
       "ALL.RDPRIO" =>
       {
          RegDep => "Z_CSR_PLD_PMU,Z_CSR_ISS_PMU",
          RegDepBits => "[0]0x1 && [12:8]0xa, [9:7]0x2",
          AltCat => "",
          Desc       => "Count all DRAM commands during \"static write priority\" scheduling mode",
       },
       "ALL.WRPRIO" =>
       {
          RegDep => "Z_CSR_PLD_PMU,Z_CSR_ISS_PMU",
          RegDepBits => "[0]0x1 && [12:8]0xa, [9:7]0x4",
          AltCat => "",
          Desc       => "Count all DRAM commands during \"static read priority\" scheduling mode",
       },
       "CAS_RD_CLS" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0xc",
          AltCat => "",
          Desc       => "Count CAS Read (precharge, closed page mode) DRAM commands.",
       },
       "CAS_RD_CLS.TRDOFF" =>
       {
          RegDep => "Z_CSR_PLD_PMU,Z_CSR_ISS_PMU",
          RegDepBits => "[0]0x1 && [12:8]0xc, [9:7]0x1",
          AltCat => "",
          Desc       => "Count CAS Read (precharge, closed page mode) DRAM commands during \"static trade off\" scheduling mode",
       },
       "CAS_RD_CLS.RDPRIO" =>
       {
          RegDep => "Z_CSR_PLD_PMU,Z_CSR_ISS_PMU",
          RegDepBits => "[0]0x1 && [12:8]0xc, [9:7]0x2",
          AltCat => "",
          Desc       => "Count CAS Read (precharge, closed page mode) DRAM commands during \"static read priority\" scheduling mode",
       },
       "CAS_RD_CLS.WRPRIO" =>
       {
          RegDep => "Z_CSR_PLD_PMU,Z_CSR_ISS_PMU",
          RegDepBits => "[0]0x1 && [12:8]0xc, [9:7]0x4",
          AltCat => "",
          Desc       => "Count CAS Read (precharge, closed page mode) DRAM commands during \"static write priority\" scheduling mode",
       },
       "TRKL" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0x10",
          AltCat => "",
          Desc       => "Count Write Trickle DRAM commands.",
       },
       "SYNC" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0x11",
          AltCat => "",
          Desc       => "Count SYNC DRAM commands.",
       },
       "CKE_HI" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0x13",
          AltCat => "",
          Desc       => "Count Clock Enable DRAM commands.",
       },
       "CAS_WR_OPN" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0x14",
          AltCat => "",
          Desc       => "Count CAS Write (no auto-precharge, open page mode) DRAM commands.",
       },
       "CAS_WR_OPN.TRDOFF" =>
       {
          RegDep => "Z_CSR_PLD_PMU,Z_CSR_ISS_PMU",
          RegDepBits => "[0]0x1 && [12:8]0x14, [9:7]0x1",
          AltCat => "",
          Desc       => "Count CAS Write (no auto-precharge, open page mode) DRAM commands during \"static trade off\" scheduling mode",
       },
       "CAS_WR_OPN.RDPRIO" =>
       {
          RegDep => "Z_CSR_PLD_PMU,Z_CSR_ISS_PMU",
          RegDepBits => "[0]0x1 && [12:8]0x14, [9:7]0x2",
          AltCat => "",
          Desc       => "Count CAS Write (no auto-precharge, open page mode) DRAM commands during \"static read priority\" scheduling mode",
       },
       "CAS_WR_OPN.WRPRIO" =>
       {
          RegDep => "Z_CSR_PLD_PMU,Z_CSR_ISS_PMU",
          RegDepBits => "[0]0x1 && [12:8]0x14, [9:7]0x4",
          AltCat => "",
          Desc       => "Count CAS Write (no auto-precharge, open page mode) DRAM commands during \"static write priority\" scheduling mode",
       },
       "SOFT_RST" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0x15",
          AltCat => "",
          Desc       => "Count Soft Reset DRAM commands.",
       },
       "WR_CFG" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0x16",
          AltCat => "",
          Desc       => "Count Write Command Register DRAM commands.",
       },
       "RD_CFG" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0x17",
          AltCat => "",
          Desc       => "Count Read Command Register DRAM commands.",
       },
       "ZQCAL" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0x18",
          AltCat => "",
          Desc       => "Count ZQCAL DRAM commands.",
       },
       "CAS_WR_CLS" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[12:8]0x1c",
          AltCat => "",
          Desc       => "Count CAS Write (precharge, closed page mode) DRAM commands.",
       },
       "CAS_WR_CLS.TRDOFF" =>
       {
          RegDep => "Z_CSR_PLD_PMU,Z_CSR_ISS_PMU",
          RegDepBits => "[0]0x1 && [12:8]0x1c, [9:7]0x1",
          AltCat => "",
          Desc       => "Count CAS Write (precharge, closed page mode) DRAM DRAM commands during \"static trade off\" scheduling mode",
       },
       "CAS_WR_CLS.RDPRIO" =>
       {
          RegDep => "Z_CSR_PLD_PMU,Z_CSR_ISS_PMU",
          RegDepBits => "[0]0x1 && [12:8]0x1c, [9:7]0x2",
          AltCat => "",
          Desc       => "Count CAS Write (precharge, closed page mode) DRAM DRAM commands during \"static read priority\" scheduling mode",
       },
       "CAS_WR_CLS.WRPRIO" =>
       {
          RegDep => "Z_CSR_PLD_PMU,Z_CSR_ISS_PMU",
          RegDepBits => "[0]0x1 && [12:8]0x1c, [9:7]0x4",
          AltCat => "",
          Desc       => "Count CAS Write (precharge, closed page mode) DRAM DRAM commands during \"static write priority\" scheduling mode",
       },
     },
  },
  "DSPQ_CHANGES" =>
  {
    Category  => "Dispatch Queue",
    EvSel     => "0x00",
    MaxIncCyc => 1,
    Desc      => "DispatchQ Transitions",
    Defn      => "Counts DispatchQ transitions to specified state",
    SubEvents  =>
    {
       "NEMPTY" =>
       {
          RegDep => "Z_CSR_DSP_PMU",
          RegDepBits => "[10]0x0",
          AltCat => "",
          Desc       => "Counts number of times DispatchQ becomes non-empty",
       },
       "EMPTY" =>
       {
          RegDep => "Z_CSR_DSP_PMU",
          RegDepBits => "[10]0x1",
          AltCat => "",
          Desc       => "Counts number of times DispatchQ becomes empty",
       },
     },
  },
  "DSPQ_INSERT" =>
  {
    Category  => "Dispatch Queue",
    EvSel     => "0x28",
    MaxIncCyc => 1,
    Desc      => "Dispatch Queue Insert",
    Defn      => "Command inserted into Dispatch Queue",
  },
  "DSPQ_INSERT_ADDR" =>
  {
    Category  => "Dispatch Queue",
    EvSel     => "0x26",
    MaxIncCyc => 1,
    Desc      => "Dispatch Queue Insert w/Address",
    Defn      => "Command inserted into Dispatch Queue.   Specify address in Z_CSR_DSP_PMU.pgtAddr.",
  },
  "DSPQ_INSERT_ADDR_CNF" =>
  {
    Category  => "Dispatch Queue",
    EvSel     => "0x25",
    MaxIncCyc => 1,
    Desc      => "Dispatch Queue Insert w/Address Conflicts",
    Defn      => "Command inserted into Dispatch Queue with conflict  (same address as existing entry).  Specify address in Z_CSR_DSP_PMU.pgtAddr",
  },
  "DSPQ_INSERT_CNF" =>
  {
    Category  => "Dispatch Queue",
    EvSel     => "0x27",
    MaxIncCyc => 1,
    Desc      => "Dispatch Queue Insert Conflicts",
    Defn      => "Command inserted into Dispatch Queue with conflict (same address as existing entry)",
  },
  "DSPQ_RD_COUNT" =>
  {
    Category  => "Running-Depth Counters",
    EvSel     => "0x3b",
    MaxIncCyc => 32,
    Desc      => "Dispatch Queue Read Count",
    Defn      => "Advance counter by the number of read commands to the dispatch queue.  The amount can be zero to 32.",
  },
  "DSPQ_WR_COUNT" =>
  {
    Category  => "Running-Depth Counters",
    EvSel     => "0x3f",
    MaxIncCyc => 32,
    Desc      => "Dispatch Queue Write Count",
    Defn      => "Advance counter by the number of write commands to the dispatch queue.  The amount can be zero to 32.",
  },
  "FRM_TYPE" =>
  {
    Category  => "DRAM Commands",
    EvSel     => "0x09",
    MaxIncCyc => 1,
    Desc      => "ISS Related Events",
    Defn      => "Count ISS Related Events",
    SubEvents  =>
    {
       "3CMD" =>
       {
          RegDep => "Z_CSR_ISS_PMU",
          RegDepBits => "[3:0]0x0",
          AltCat => "",
          Desc       => "Counts 3CMD (3-command) Intel SMI frames",
       },
       "WDAT" =>
       {
          RegDep => "Z_CSR_ISS_PMU",
          RegDepBits => "[3:0]0x1",
          AltCat => "",
          Desc       => "Counts WDAT (Write Data) Intel SMI frames",
       },
       "SYNC" =>
       {
          RegDep => "Z_CSR_ISS_PMU",
          RegDepBits => "[3:0]0x2",
          AltCat => "",
          Desc       => "Counts SYNC Intel SMI frames",
       },
       "CHNL" =>
       {
          RegDep => "Z_CSR_ISS_PMU",
          RegDepBits => "[3:0]0x3",
          AltCat => "",
          Desc       => "Counts CHNL (channel) Intel SMI frames",
       },
       "ILLEGAL1" =>
       {
          RegDep => "Z_CSR_ISS_PMU",
          RegDepBits => "[3:0]0x7-0x4",
          AltCat => "",
          Desc       => "(*illegal selection*)",
       },
       "NOP" =>
       {
          RegDep => "Z_CSR_ISS_PMU",
          RegDepBits => "[3:0]0x8",
          AltCat => "",
          Desc       => "Counts nop Intel SMI frames",
       },
       "ILLEGAL2" =>
       {
          RegDep => "Z_CSR_ISS_PMU",
          RegDepBits => "[3:0]0xb-0x9",
          AltCat => "",
          Desc       => "(*illegal selection*)",
       },
       "1CMD" =>
       {
          RegDep => "Z_CSR_ISS_PMU",
          RegDepBits => "[3:0]0xc",
          AltCat => "",
          Desc       => "Counts all 1CMD (1-command) Intel SMI frames",
       },
       "ILLEGAL3" =>
       {
          RegDep => "Z_CSR_ISS_PMU",
          RegDepBits => "[3:0]0xf-0xd",
          AltCat => "",
          Desc       => "(*illegal selection*)",
       },
     },
  },
  "FVC_EV0" =>
  {
    Category  => "FVC Events",
    EvSel     => "0x0d",
    MaxIncCyc => 1,
    Desc      => "FVC Event 0",
    Defn      => "Measure an FVC related event.",
    Notes     => "It is possible to program the FVC register such that up to 4 events from the FVC can be independently monitored. However, the bcmd_match and resp_match subevents depend on the setting of additional bits in the FVC register (11:9 and 8:5 respectively). Therefore, only ONE Z_FVC_EVx.bcmd_match event may be monitored at any given time. The same holds true for Z_VC_EVx.resp_match",
    SubEvents  =>
    {
       "SMI_CRC_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x0",
          AltCat => "Z Box Errors",
          Desc       => "Count link level Intel SMI CRC errors",
       },
       "MEM_ECC_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x1",
          AltCat => "Z Box Errors",
          Desc       => "Count memory ECC errors (that is not a link-level CRC error)",
       },
       "POISON_TXN" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x2",
          AltCat => "Z Box Errors",
          Desc       => "Count poison (directory of a write to memory was encoded as poisoned) transactions",
       },
       "ALERT_FRAMES" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x3",
          AltCat => "Z Box Errors",
          Desc       => "Counts alert frames",
       },
       "BBOX_CMNDS.READS" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x5 && [8:5]0x0",
          AltCat => "Z box commands received",
          Desc       => "Reads commands to z from B",
       },
       "BBOX_CMNDS.WRITES" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x5 && [8:5]0x1",
          AltCat => "Z box commands received",
          Desc       => "Write commands from B box to Z box",
       },
       "BBOX_CMNDS_MERGE" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x5 && [8:5]0x2",
          AltCat => "Z box commands received",
          Desc       => "Merge commands from B box to Z box",
       },
       "BBOX_CMNDS.V2F" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x5 && [8:5]0x3",
          AltCat => "Z box commands received",
          Desc       => "Victim buffer to Fill buffer transfer (V2F)command from B to Z",
       },
       "BBOX_CMNDS.V2V" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x5 && [8:5]0x4",
          AltCat => "Z box commands received",
          Desc       => "Victim buffer to Victim buffer transfer (V2V) command from B to Z",
       },
       "BBOX_CMNDS.F2V" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x5 && [8:5]0x5",
          AltCat => "Z box commands received",
          Desc       => "Fill buffer to Victim buffer transfer (F2V) command from B to Z",
       },
       "BBOX_CMNDS.F2B" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x5 && [8:5]0x6",
          AltCat => "Z box commands received",
          Desc       => "Fill buffer read to B-Box (F2B) from Z",
       },
       "BBOX_CMNDS.SPRWR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x5 && [8:5]0x7",
          AltCat => "Z box commands received",
          Desc       => "spare write commands from b to z",
       },
       "BBOX_CMNDS.MEGAOP1" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x5 && [8:5]0x8",
          AltCat => "Z box commands received",
          Desc       => "MegaOp1 commands (F2B,F2V and then Write) from B TO Z",
       },
       "BBOX_CMNDS.MEGAOP2" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x5 && [8:5]0xc",
          AltCat => "Z box commands received",
          Desc       => "MegaOp2 commands (F2V and then Write) from B TO Z",
       },
       "BBOX_CMNDS.MEGAOP3" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x5 && [8:5]0xa",
          AltCat => "Z box commands received",
          Desc       => "MegaOp3 commands (F2B and then Write) from B TO Z",
       },
       "BBOX_CMNDS.MEGAOP4" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x5 && [8:5]0xf",
          AltCat => "Z box commands received",
          Desc       => "MegaOp4 commands (V2V and then Write) from B TO Z",
       },
       "BBOX_RSP.ACK" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x6 && [11:9]0x0",
          AltCat => "Z Box responses",
          Desc       => "Counts positive acknowledgements.  No error was detected.",
       },
       "BBOX_RSP.RETRY" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x6 && [11:9]0x1",
          AltCat => "Z Box responses",
          Desc       => "Count Retry Responses. Possibly a correctable error. Retries are generated until it is decided that the error was either correctable or uncorrectable.",
       },
       "BBOX_RSP.COR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x6 && [11:9]0x2",
          AltCat => "Z Box responses",
          Desc       => "Counts corrected (e.g. after error trials or just by a retry)",
       },
       "BBOX_RSP.UNCOR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x6 && [11:9]0x3",
          AltCat => "Z Box responses",
          Desc       => "Count Uncorrectable Responses.",
       },
       "BBOX_RSP.SPEC_ACK" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x6 && [11:9]0x4",
          AltCat => "Z Box responses",
          Desc       => "Speculative positive acknowledgement for optimized read flow. No error was detected for the transaction.",
       },
       "BBOX_RSP.SPR_ACK" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x6 && [11:9]0x5",
          AltCat => "Z Box responses",
          Desc       => "Count positive acknowledgements for command to misbehaving DIMM during sparing. No error was detected for the transaction.",
       },
       "BBOX_RSP.NONE" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x6 && [11:9]0x6",
          AltCat => "Z Box responses",
          Desc       => "(* nothing will be counted *)",
       },
       "BBOX_RSP.SPR_UNCOR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x6 && [11:9]0x7",
          AltCat => "Z Box responses",
          Desc       => "Counts Uncorrectable responses to Bbox as a result of commands issued to misbehaving DIMM during sparing",
       },
       "SMI_NB_TRIG" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x7",
          AltCat => "Z Box Errors",
          Desc       => "Select Intel SMI Northbound debug event bits from Intel SMI status frames as returned from the Millbrook memory buffers. Used for Debug purposes",
       },
       "VIC_BUF_CORR_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x8",
          AltCat => "Z Box Errors",
          Desc       => "Count Victim Buffer Correctible Error (Corresponds to Z_CSR_ERR_LOG.victim_buf_corr_err)",
       },
       "STATUS_FRM_PAR_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0x9",
          AltCat => "Z Box Errors",
          Desc       => "Count Status Frame Parity Error (Corresponds to Z_CSR_ERR_LOG.status_frm_par_err)",
       },
       "STATUS_FRM_DM_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0xa",
          AltCat => "Z Box Errors",
          Desc       => "Count Status Frame Data Merge Error (Corresponds to Z_CSR_ERR_LOG.status_frm_dm_err)",
       },
       "FILL_BUF_CORR_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0xc",
          AltCat => "Z Box Errors",
          Desc       => "Count Correctable Fill Buffer Data ECC Error (Corresponds to Z_CSR_ERR_LOG.fill_buf_corr_err)",
       },
       "ECC_CORR_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0xd",
          AltCat => "Z Box Errors",
          Desc       => "Count Correctable Memory Data Check Bit Error without re-mapping (Corresponds to Z_CSR_ERR_LOG.ecc_corr_err)",
       },
       "ECC_CORR_ERR_MAP" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[15:12]0xe",
          AltCat => "Z Box Errors",
          Desc       => "Count Correctable Memory Data Check Bit Error with re-mapping (Corresponds to Z_CSR_ERR_LOG.ecc_corr_mapped_err)",
       },
     },
  },
  "FVC_EV1" =>
  {
    Category  => "FVC Events",
    EvSel     => "0x0e",
    MaxIncCyc => 1,
    Desc      => "FVC Event 1",
    Defn      => "Measure an FVC related event.",
    Notes     => "It is possible to program the FVC register such that up to 4 events from the FVC can be independently monitored. However, the bcmd_match and resp_match subevents depend on the setting of additional bits in the FVC register (11:9 and 8:5 respectively). Therefore, only ONE Z_FVC_EVx.bcmd_match event may be monitored at any given time. The same holds true for Z_VC_EVx.resp_match",
    SubEvents  =>
    {
       "SMI_CRC_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x0",
          AltCat => "Z Box Errors",
          Desc       => "Count link level Intel SMI CRC errors",
       },
       "MEM_ECC_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x1",
          AltCat => "Z Box Errors",
          Desc       => "Count memory ECC errors (that is not a link-level CRC error)",
       },
       "POISON_TXN" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x2",
          AltCat => "Z Box Errors",
          Desc       => "Count poison (directory of a write to memory was encoded as poisoned) transactions",
       },
       "ALERT_FRAMES" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x3",
          AltCat => "Z Box Errors",
          Desc       => "Counts alert frames",
       },
       "BBOX_CMNDS.READS" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x5 && [8:5]0x0",
          AltCat => "Z box commands received",
          Desc       => "Reads commands to z from B",
       },
       "BBOX_CMNDS.WRITES" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x5 && [8:5]0x1",
          AltCat => "Z box commands received",
          Desc       => "Write commands from B box to Z box",
       },
       "BBOX_CMNDS_MERGE" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x5 && [8:5]0x2",
          AltCat => "Z box commands received",
          Desc       => "Merge commands from B box to Z box",
       },
       "BBOX_CMNDS.V2F" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x5 && [8:5]0x3",
          AltCat => "Z box commands received",
          Desc       => "Victim buffer to Fill buffer transfer (V2F)command from B to Z",
       },
       "BBOX_CMNDS.V2V" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x5 && [8:5]0x4",
          AltCat => "Z box commands received",
          Desc       => "Victim buffer to Victim buffer transfer (V2V) command from B to Z",
       },
       "BBOX_CMNDS.F2V" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x5 && [8:5]0x5",
          AltCat => "Z box commands received",
          Desc       => "Fill buffer to Victim buffer transfer (F2V) command from B to Z",
       },
       "BBOX_CMNDS.F2B" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x5 && [8:5]0x6",
          AltCat => "Z box commands received",
          Desc       => "Fill buffer read to B-Box (F2B) from Z",
       },
       "BBOX_CMNDS.SPRWR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x5 && [8:5]0x7",
          AltCat => "Z box commands received",
          Desc       => "spare write commands from b to z",
       },
       "BBOX_CMNDS.MEGAOP1" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x5 && [8:5]0x8",
          AltCat => "Z box commands received",
          Desc       => "MegaOp1 commands (F2B,F2V and then Write) from B TO Z",
       },
       "BBOX_CMNDS.MEGAOP2" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x5 && [8:5]0xc",
          AltCat => "Z box commands received",
          Desc       => "MegaOp2 commands (F2V and then Write) from B TO Z",
       },
       "BBOX_CMNDS.MEGAOP3" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x5 && [8:5]0xa",
          AltCat => "Z box commands received",
          Desc       => "MegaOp3 commands (F2B and then Write) from B TO Z",
       },
       "BBOX_CMNDS.MEGAOP4" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x5 && [8:5]0xf",
          AltCat => "Z box commands received",
          Desc       => "MegaOp4 commands (V2V and then Write) from B TO Z",
       },
       "BBOX_RSP.ACK" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x6 && [11:9]0x0",
          AltCat => "Z Box responses",
          Desc       => "Counts positive acknowledgements.  No error was detected.",
       },
       "BBOX_RSP.RETRY" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x6 && [11:9]0x1",
          AltCat => "Z Box responses",
          Desc       => "Count Retry Responses. Possibly a correctable error. Retries are generated until it is decided that the error was either correctable or uncorrectable.",
       },
       "BBOX_RSP.COR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x6 && [11:9]0x2",
          AltCat => "Z Box responses",
          Desc       => "Counts corrected (e.g. after error trials or just by a retry)",
       },
       "BBOX_RSP.UNCOR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x6 && [11:9]0x3",
          AltCat => "Z Box responses",
          Desc       => "Count Uncorrectable Responses.",
       },
       "BBOX_RSP.SPEC_ACK" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x6 && [11:9]0x4",
          AltCat => "Z Box responses",
          Desc       => "Speculative positive acknowledgement for optimized read flow. No error was detected for the transaction.",
       },
       "BBOX_RSP.SPR_ACK" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x6 && [11:9]0x5",
          AltCat => "Z Box responses",
          Desc       => "Count positive acknowledgements for command to misbehaving DIMM during sparing. No error was detected for the transaction.",
       },
       "BBOX_RSP.NONE" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x6 && [11:9]0x6",
          AltCat => "Z Box responses",
          Desc       => "(* nothing will be counted *)",
       },
       "BBOX_RSP.SPR_UNCOR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x6 && [11:9]0x7",
          AltCat => "Z Box responses",
          Desc       => "Counts Uncorrectable responses to Bbox as a result of commands issued to misbehaving DIMM during sparing",
       },
       "SMI_NB_TRIG" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x7",
          AltCat => "Z Box Errors",
          Desc       => "Select Intel SMI Northbound debug event bits from Intel SMI status frames as returned from the Millbrook memory buffers. Used for Debug purposes",
       },
       "VIC_BUF_CORR_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x8",
          AltCat => "Z Box Errors",
          Desc       => "Count Victim Buffer Correctible Error (Corresponds to Z_CSR_ERR_LOG.victim_buf_corr_err)",
       },
       "STATUS_FRM_PAR_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0x9",
          AltCat => "Z Box Errors",
          Desc       => "Count Status Frame Parity Error (Corresponds to Z_CSR_ERR_LOG.status_frm_par_err)",
       },
       "STATUS_FRM_DM_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0xa",
          AltCat => "Z Box Errors",
          Desc       => "Count Status Frame Data Merge Error (Corresponds to Z_CSR_ERR_LOG.status_frm_dm_err)",
       },
       "FILL_BUF_CORR_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0xc",
          AltCat => "Z Box Errors",
          Desc       => "Count Correctable Fill Buffer Data ECC Error (Corresponds to Z_CSR_ERR_LOG.fill_buf_corr_err)",
       },
       "ECC_CORR_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0xd",
          AltCat => "Z Box Errors",
          Desc       => "Count Correctable Memory Data Check Bit Error without re-mapping (Corresponds to Z_CSR_ERR_LOG.ecc_corr_err)",
       },
       "ECC_CORR_ERR_MAP" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[19:16]0xe",
          AltCat => "Z Box Errors",
          Desc       => "Count Correctable Memory Data Check Bit Error with re-mapping (Corresponds to Z_CSR_ERR_LOG.ecc_corr_mapped_err)",
       },
     },
  },
  "FVC_EV2" =>
  {
    Category  => "FVC Events",
    EvSel     => "0x0f",
    MaxIncCyc => 1,
    Desc      => "FVC Event 2",
    Defn      => "Measure an FVC related event.",
    Notes     => "It is possible to program the FVC register such that up to 4 events from the FVC can be independently monitored. However, the bcmd_match and resp_match subevents depend on the setting of additional bits in the FVC register (11:9 and 8:5 respectively). Therefore, only ONE Z_FVC_EVx.bcmd_match event may be monitored at any given time. The same holds true for Z_VC_EVx.resp_match",
    SubEvents  =>
    {
       "SMI_CRC_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x0",
          AltCat => "Z Box Errors",
          Desc       => "Count link level Intel SMI CRC errors",
       },
       "MEM_ECC_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x1",
          AltCat => "Z Box Errors",
          Desc       => "Count memory ECC errors (that is not a link-level CRC error)",
       },
       "POISON_TXN" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x2",
          AltCat => "Z Box Errors",
          Desc       => "Count poison (directory of a write to memory was encoded as poisoned) transactions",
       },
       "ALERT_FRAMES" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x3",
          AltCat => "Z Box Errors",
          Desc       => "Counts alert frames",
       },
       "BBOX_CMNDS.READS" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x5 && [8:5]0x0",
          AltCat => "Z box commands received",
          Desc       => "Reads commands to z from B",
       },
       "BBOX_CMNDS.WRITES" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x5 && [8:5]0x1",
          AltCat => "Z box commands received",
          Desc       => "Write commands from B box to Z box",
       },
       "BBOX_CMNDS_MERGE" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x5 && [8:5]0x2",
          AltCat => "Z box commands received",
          Desc       => "Merge commands from B box to Z box",
       },
       "BBOX_CMNDS.V2F" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x5 && [8:5]0x3",
          AltCat => "Z box commands received",
          Desc       => "Victim buffer to Fill buffer transfer (V2F)command from B to Z",
       },
       "BBOX_CMNDS.V2V" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x5 && [8:5]0x4",
          AltCat => "Z box commands received",
          Desc       => "Victim buffer to Victim buffer transfer (V2V) command from B to Z",
       },
       "BBOX_CMNDS.F2V" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x5 && [8:5]0x5",
          AltCat => "Z box commands received",
          Desc       => "Fill buffer to Victim buffer transfer (F2V) command from B to Z",
       },
       "BBOX_CMNDS.F2B" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x5 && [8:5]0x6",
          AltCat => "Z box commands received",
          Desc       => "Fill buffer read to B-Box (F2B) from Z",
       },
       "BBOX_CMNDS.SPRWR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x5 && [8:5]0x7",
          AltCat => "Z box commands received",
          Desc       => "spare write commands from b to z",
       },
       "BBOX_CMNDS.MEGAOP1" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x5 && [8:5]0x8",
          AltCat => "Z box commands received",
          Desc       => "MegaOp1 commands (F2B,F2V and then Write) from B TO Z",
       },
       "BBOX_CMNDS.MEGAOP2" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x5 && [8:5]0xc",
          AltCat => "Z box commands received",
          Desc       => "MegaOp2 commands (F2V and then Write) from B TO Z",
       },
       "BBOX_CMNDS.MEGAOP3" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x5 && [8:5]0xa",
          AltCat => "Z box commands received",
          Desc       => "MegaOp3 commands (F2B and then Write) from B TO Z",
       },
       "BBOX_CMNDS.MEGAOP4" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x5 && [8:5]0xf",
          AltCat => "Z box commands received",
          Desc       => "MegaOp4 commands (V2V and then Write) from B TO Z",
       },
       "BBOX_RSP.ACK" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x6 && [11:9]0x0",
          AltCat => "Z Box responses",
          Desc       => "Counts positive acknowledgements.  No error was detected.",
       },
       "BBOX_RSP.RETRY" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x6 && [11:9]0x1",
          AltCat => "Z Box responses",
          Desc       => "Count Retry Responses. Possibly a correctable error. Retries are generated until it is decided that the error was either correctable or uncorrectable.",
       },
       "BBOX_RSP.COR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x6 && [11:9]0x2",
          AltCat => "Z Box responses",
          Desc       => "Counts corrected (e.g. after error trials or just by a retry)",
       },
       "BBOX_RSP.UNCOR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x6 && [11:9]0x3",
          AltCat => "Z Box responses",
          Desc       => "Count Uncorrectable Responses.",
       },
       "BBOX_RSP.SPEC_ACK" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x6 && [11:9]0x4",
          AltCat => "Z Box responses",
          Desc       => "Speculative positive acknowledgement for optimized read flow. No error was detected for the transaction.",
       },
       "BBOX_RSP.SPR_ACK" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x6 && [11:9]0x5",
          AltCat => "Z Box responses",
          Desc       => "Count positive acknowledgements for command to misbehaving DIMM during sparing. No error was detected for the transaction.",
       },
       "BBOX_RSP.NONE" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x6 && [11:9]0x6",
          AltCat => "Z Box responses",
          Desc       => "(* nothing will be counted *)",
       },
       "BBOX_RSP.SPR_UNCOR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x6 && [11:9]0x7",
          AltCat => "Z Box responses",
          Desc       => "Counts Uncorrectable responses to Bbox as a result of commands issued to misbehaving DIMM during sparing",
       },
       "SMI_NB_TRIG" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x7",
          AltCat => "Z Box Errors",
          Desc       => "Select Intel SMI Northbound debug event bits from Intel SMI status frames as returned from the Millbrook memory buffers. Used for Debug purposes",
       },
       "VIC_BUF_CORR_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x8",
          AltCat => "Z Box Errors",
          Desc       => "Count Victim Buffer Correctible Error (Corresponds to Z_CSR_ERR_LOG.victim_buf_corr_err)",
       },
       "STATUS_FRM_PAR_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0x9",
          AltCat => "Z Box Errors",
          Desc       => "Count Status Frame Parity Error (Corresponds to Z_CSR_ERR_LOG.status_frm_par_err)",
       },
       "STATUS_FRM_DM_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0xa",
          AltCat => "Z Box Errors",
          Desc       => "Count Status Frame Data Merge Error (Corresponds to Z_CSR_ERR_LOG.status_frm_dm_err)",
       },
       "FILL_BUF_CORR_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0xc",
          AltCat => "Z Box Errors",
          Desc       => "Count Correctable Fill Buffer Data ECC Error (Corresponds to Z_CSR_ERR_LOG.fill_buf_corr_err)",
       },
       "ECC_CORR_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0xd",
          AltCat => "Z Box Errors",
          Desc       => "Count Correctable Memory Data Check Bit Error without re-mapping (Corresponds to Z_CSR_ERR_LOG.ecc_corr_err)",
       },
       "ECC_CORR_ERR_MAP" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[23:20]0xe",
          AltCat => "Z Box Errors",
          Desc       => "Count Correctable Memory Data Check Bit Error with re-mapping (Corresponds to Z_CSR_ERR_LOG.ecc_corr_mapped_err)",
       },
     },
  },
  "FVC_EV3" =>
  {
    Category  => "FVC Events",
    EvSel     => "0x10",
    MaxIncCyc => 1,
    Desc      => "FVC Event 3",
    Defn      => "Measure an FVC related event.",
    Notes     => "It is possible to program the FVC register such that up to 4 events from the FVC can be independently monitored. However, the bcmd_match and resp_match subevents depend on the setting of additional bits in the FVC register (11:9 and 8:5 respectively). Therefore, only ONE Z_FVC_EVx.bcmd_match event may be monitored at any given time. The same holds true for Z_VC_EVx.resp_match",
    SubEvents  =>
    {
       "SMI_CRC_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x0",
          AltCat => "Z Box Errors",
          Desc       => "Count link level Intel SMI CRC errors",
       },
       "MEM_ECC_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x1",
          AltCat => "Z Box Errors",
          Desc       => "Count memory ECC errors (that is not a link-level CRC error)",
       },
       "POISON_TXN" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x2",
          AltCat => "Z Box Errors",
          Desc       => "Count poison (directory of a write to memory was encoded as poisoned) transactions",
       },
       "ALERT_FRAMES" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x3",
          AltCat => "Z Box Errors",
          Desc       => "Counts alert frames",
       },
       "BBOX_CMNDS.READS" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x5 && [8:5]0x0",
          AltCat => "Z box commands received",
          Desc       => "Reads commands to z from B",
       },
       "BBOX_CMNDS.WRITES" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x5 && [8:5]0x1",
          AltCat => "Z box commands received",
          Desc       => "Write commands from B box to Z box",
       },
       "BBOX_CMNDS_MERGE" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x5 && [8:5]0x2",
          AltCat => "Z box commands received",
          Desc       => "Merge commands from B box to Z box",
       },
       "BBOX_CMNDS.V2F" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x5 && [8:5]0x3",
          AltCat => "Z box commands received",
          Desc       => "Victim buffer to Fill buffer transfer (V2F)command from B to Z",
       },
       "BBOX_CMNDS.V2V" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x5 && [8:5]0x4",
          AltCat => "Z box commands received",
          Desc       => "Victim buffer to Victim buffer transfer (V2V) command from B to Z",
       },
       "BBOX_CMNDS.F2V" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x5 && [8:5]0x5",
          AltCat => "Z box commands received",
          Desc       => "Fill buffer to Victim buffer transfer (F2V) command from B to Z",
       },
       "BBOX_CMNDS.F2B" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x5 && [8:5]0x6",
          AltCat => "Z box commands received",
          Desc       => "Fill buffer read to B-Box (F2B) from Z",
       },
       "BBOX_CMNDS.SPRWR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x5 && [8:5]0x7",
          AltCat => "Z box commands received",
          Desc       => "spare write commands from b to z",
       },
       "BBOX_CMNDS.MEGAOP1" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x5 && [8:5]0x8",
          AltCat => "Z box commands received",
          Desc       => "MegaOp1 commands (F2B,F2V and then Write) from B TO Z",
       },
       "BBOX_CMNDS.MEGAOP2" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x5 && [8:5]0xc",
          AltCat => "Z box commands received",
          Desc       => "MegaOp2 commands (F2V and then Write) from B TO Z",
       },
       "BBOX_CMNDS.MEGAOP3" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x5 && [8:5]0xa",
          AltCat => "Z box commands received",
          Desc       => "MegaOp3 commands (F2B and then Write) from B TO Z",
       },
       "BBOX_CMNDS.MEGAOP4" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x5 && [8:5]0xf",
          AltCat => "Z box commands received",
          Desc       => "MegaOp4 commands (V2V and then Write) from B TO Z",
       },
       "BBOX_RSP.ACK" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x6 && [11:9]0x0",
          AltCat => "Z Box responses",
          Desc       => "Counts positive acknowledgements.  No error was detected.",
       },
       "BBOX_RSP.RETRY" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x6 && [11:9]0x1",
          AltCat => "Z Box responses",
          Desc       => "Count Retry Responses. Possibly a correctable error. Retries are generated until it is decided that the error was either correctable or uncorrectable.",
       },
       "BBOX_RSP.COR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x6 && [11:9]0x2",
          AltCat => "Z Box responses",
          Desc       => "Counts corrected (e.g. after error trials or just by a retry)",
       },
       "BBOX_RSP.UNCOR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x6 && [11:9]0x3",
          AltCat => "Z Box responses",
          Desc       => "Count Uncorrectable Responses.",
       },
       "BBOX_RSP.SPEC_ACK" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x6 && [11:9]0x4",
          AltCat => "Z Box responses",
          Desc       => "Speculative positive acknowledgement for optimized read flow. No error was detected for the transaction.",
       },
       "BBOX_RSP.SPR_ACK" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x6 && [11:9]0x5",
          AltCat => "Z Box responses",
          Desc       => "Count positive acknowledgements for command to misbehaving DIMM during sparing. No error was detected for the transaction.",
       },
       "BBOX_RSP.NONE" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x6 && [11:9]0x6",
          AltCat => "Z Box responses",
          Desc       => "(* nothing will be counted *)",
       },
       "BBOX_RSP.SPR_UNCOR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x6 && [11:9]0x7",
          AltCat => "Z Box responses",
          Desc       => "Counts Uncorrectable responses to Bbox as a result of commands issued to misbehaving DIMM during sparing",
       },
       "SMI_NB_TRIG" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x7",
          AltCat => "Z Box Errors",
          Desc       => "Select Intel SMI Northbound debug event bits from Intel SMI status frames as returned from the Millbrook memory buffers. Used for Debug purposes",
       },
       "VIC_BUF_CORR_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x8",
          AltCat => "Z Box Errors",
          Desc       => "Count Victim Buffer Correctible Error (Corresponds to Z_CSR_ERR_LOG.victim_buf_corr_err)",
       },
       "STATUS_FRM_PAR_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0x9",
          AltCat => "Z Box Errors",
          Desc       => "Count Status Frame Parity Error (Corresponds to Z_CSR_ERR_LOG.status_frm_par_err)",
       },
       "STATUS_FRM_DM_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0xa",
          AltCat => "Z Box Errors",
          Desc       => "Count Status Frame Data Merge Error (Corresponds to Z_CSR_ERR_LOG.status_frm_dm_err)",
       },
       "FILL_BUF_CORR_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0xc",
          AltCat => "Z Box Errors",
          Desc       => "Count Correctable Fill Buffer Data ECC Error (Corresponds to Z_CSR_ERR_LOG.fill_buf_corr_err)",
       },
       "ECC_CORR_ERR" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0xd",
          AltCat => "Z Box Errors",
          Desc       => "Count Correctable Memory Data Check Bit Error without re-mapping (Corresponds to Z_CSR_ERR_LOG.ecc_corr_err)",
       },
       "ECC_CORR_ERR_MAP" =>
       {
          RegDep => "Z_CSR_PMU_ZDP_CTL_FVC",
          RegDepBits => "[27:24]0xe",
          AltCat => "Z Box Errors",
          Desc       => "Count Correctable Memory Data Check Bit Error with re-mapping (Corresponds to Z_CSR_ERR_LOG.ecc_corr_mapped_err)",
       },
     },
  },
  "FVID_FIFO_COUNT" =>
  {
    Category  => "Running-Depth Counters",
    EvSel     => "0x3c",
    MaxIncCyc => 32,
    Desc      => "FVID FIFO Count",
    Defn      => "Advance counter by the number of commands in the FVID FIFO.  The amount can be zero to 32.",
  },
  "FVID_FIFO_WRITES" =>
  {
    Category  => "Running-Depth Counters",
    EvSel     => "0x3d",
    MaxIncCyc => 2,
    Desc      => "FVID FIFO Writes",
    Defn      => "Advance counter by the number of writes to the FVID FIFO. The amount can be zero, one or two.",
  },
  "INFLIGHT_CMDS" =>
  {
    Category  => "Z-Box Commands Received",
    EvSel     => "0x1d",
    MaxIncCyc => 1,
    Desc      => "In-flight Commands",
    Defn      => "Advance counter when a new memory controller (read and write type) command is accepted",
  },
  "LIVE_OPS_INFLIGHT" =>
  {
    Category  => "Running-Depth Counters",
    EvSel     => "0x3e",
    MaxIncCyc => 32,
    Desc      => "Live Ops In-flight",
    Defn      => "Advance counter by the number of pending commands in the Zbox. The amount can be zero to 32.",
  },
  "NB_ERR_PERSISTENT" =>
  {
    Category  => "Northbound Errors",
    EvSel     => "0x2a",
    MaxIncCyc => 1,
    Desc      => "Northbound Persistent Errors",
    Defn      => "Northbound persistent CRC errors (corresponds to Z_CSR_ERF_CTL_STS_0.err[4])",
  },
  "NB_ERR_TRANSIENT" =>
  {
    Category  => "Northbound Errors",
    EvSel     => "0x29",
    MaxIncCyc => 1,
    Desc      => "Northbound Transient Errors",
    Defn      => "Northbound transient CRC errors (corresponds to Z_CSR_ERF_CTL_STS_0.err[3])",
  },
  "PAGE_AUTOCLS_CMD" =>
  {
    Category  => "Page Table",
    EvSel     => "0x15",
    MaxIncCyc => 1,
    Desc      => "Page Table Autoclose Commands",
    Defn      => "Advance counter when an auto page close command is detected.",
  },
  "PAGE_COLLISION" =>
  {
    Category  => "Page Table",
    EvSel     => "0x18",
    MaxIncCyc => 1,
    Desc      => "Refresh Commands",
    Defn      => "Advance counter when page collision is detected (i.e., a command requires a PRE-RAS-CAS sequence).",
  },
  "PAGE_HITS" =>
  {
    Category  => "Page Table",
    EvSel     => "0x14",
    MaxIncCyc => 1,
    Desc      => "Page Table Hits",
    Defn      => "Advance counter when a page hit is detected (i.e., a command requires only a CAS).",
    Notes     => "Will not increment in closed-page mode.",
  },
  "PAGE_MISS" =>
  {
    Category  => "Page Table",
    EvSel     => "0x13",
    MaxIncCyc => 1,
    Desc      => "Page Table Misses",
    Defn      => "Advance counter when a page miss is detected (i.e., a command requires a RAS-CAS to complete).",
  },
  "PGT_PAGE_EV" =>
  {
    Category  => "Page Table",
    EvSel     => "0x16",
    MaxIncCyc => 1,
    Desc      => "PGT Related Page Table Events",
    Defn      => "Counts PGT Related Page Table Events",
    SubEvents  =>
    {
       "OPN2CLS" =>
       {
          RegDep => "Z_CSR_PGT_PMU",
          RegDepBits => "[0]0x0",
          AltCat => "",
          Desc       => "Advance counter when an open-to-closed page transition is detected.",
       },
       "CLS2OPN" =>
       {
          RegDep => "Z_CSR_PGT_PMU",
          RegDepBits => "[0]0x1",
          AltCat => "",
          Desc       => "Advance counter when an closed-to-open page transition is detected.",
       },
     },
  },
  "REFRESH" =>
  {
    Category  => "DRAM Commands",
    EvSel     => "0x06",
    MaxIncCyc => 1,
    Desc      => "Refresh Commands",
    Defn      => "Advance counter when a refresh command is detected.",
  },
  "RETRIES" =>
  {
    Category  => "Retry Events",
    EvSel     => "0x0b",
    MaxIncCyc => 1,
    Desc      => "Retry Events",
    Defn      => "Count PLD Related PLD Events",
    SubEvents  =>
    {
       "ALL" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[7]0x0",
          AltCat => "",
          Desc       => "Advance counter when a retry is detected.",
       },
       "FVID" =>
       {
          RegDep => "Z_CSR_PLD_PMU",
          RegDepBits => "[7]0x1 && [6:1]US",
          AltCat => "",
          Desc       => "Advance counter when a retry to a certain FVID is detected.",
       },
     },
  },
  "RETRY_OPS" =>
  {
    Category  => "RetryQ",
    EvSel     => "0x22",
    MaxIncCyc => 1,
    Desc      => "Retry ops",
    Defn      => "Advance counter for every new command that gets pushed into the retry queue.",
  },
  "RETRY_STARVE" =>
  {
    Category  => "Retry Events",
    EvSel     => "0x03",
    MaxIncCyc => 1,
    Desc      => "Retry Starve",
    Defn      => "Advance counter every cycle when a retry is detected in the \"starved\" state.",
  },
  "RETRY_ZFULL" =>
  {
    Category  => "Retry Events",
    EvSel     => "0x02",
    MaxIncCyc => 1,
    Desc      => "Retry Zfull",
    Defn      => "Advance counter when a retry is detected in the \"zfull\" state.",
  },
  "SCHED_INFLIGHT_CMDS" =>
  {
    Category  => "Z-Box Commands Received",
    EvSel     => "0x1c",
    MaxIncCyc => 1,
    Desc      => "Scheduler In-flight Commands",
    Defn      => "Advance counter when a new scheduler command is accepted",
  },
  "SCHED_MODE_CHANGES" =>
  {
    Category  => "DRAM Commands",
    EvSel     => "0x08",
    MaxIncCyc => 1,
    Desc      => "Scheduling Mode Changes",
    Defn      => "Advance counter when an ISS scheduling mode transition is detected.",
  },
  "SMI_FAST_RESETS" =>
  {
    Category  => "DRAM Commands",
    EvSel     => "0x0c",
    MaxIncCyc => 1,
    Desc      => "Fast Resets",
    Defn      => "Advance counter when an Intel SMI fast reset occurs.",
  },
  "THERM_TRP_DN" =>
  {
    Category  => "Thermal Throttle",
    EvSel     => "0x05",
    MaxIncCyc => 1,
    Desc      => "DIMM Down Thermal Trip Points Crossed",
    Defn      => "Counts when a specified thermal trip point is crossed in the down direction.",
    SubEvents  =>
    {
       "ALL.GT_MID_RISE" =>
       {
          RegDep => "Z_CSR_PMU_MSC_THR",
          RegDepBits => "[10:9] 0x3 && [3]0x1",
          AltCat => "",
          Desc       => "Advance the counter when the above mid temp thermal trip point (rising) is crossed in the \"down\" direction for any DIMM",
       },
       "ALL.GT_MID_FALL" =>
       {
          RegDep => "Z_CSR_PMU_MSC_THR",
          RegDepBits => "[10:9] 0x2 && [3]0x1",
          AltCat => "",
          Desc       => "Advance the counter when the above mid temp thermal trip point (falling) is crossed in the \"down\" direction for any DIMM",
       },
       "ALL.GT_LO" =>
       {
          RegDep => "Z_CSR_PMU_MSC_THR",
          RegDepBits => "[10:9] 0x1 && [3]0x1",
          AltCat => "",
          Desc       => "Advance the counter when the above low temp, but below mid temp thermal trip point is crossed in the \"down\" direction for any DIMM",
       },
       "ALL.LT_LO" =>
       {
          RegDep => "Z_CSR_PMU_MSC_THR",
          RegDepBits => "[10:9] 0x0 && [3]0x1",
          AltCat => "",
          Desc       => "Advance the counter when the below low temp thermal trip point is crossed in the \"down\" direction for any DIMM",
       },
       "DIMM{n}.GT_MID_RISE" =>
       {
          RegDep => "Z_CSR_PMU_MSC_THR",
          RegDepBits => "[10:9] 0x3 && [6:4] US && [3]0x0",
          AltCat => "",
          Desc       => "Advance the counter when the above mid temp thermal trip point (rising) is crossed in the \"down\" direction for  DIMM #?",
       },
       "DIMM{n}.GT_MID_FALL" =>
       {
          RegDep => "Z_CSR_PMU_MSC_THR",
          RegDepBits => "[10:9] 0x2 && [6:4] US && [3]0x0",
          AltCat => "",
          Desc       => "Advance the counter when the above mid temp thermal trip point (falling) is crossed in the \"down\" direction for DIMM #?",
       },
       "DIMM{n}.GT_LO" =>
       {
          RegDep => "Z_CSR_PMU_MSC_THR",
          RegDepBits => "[10:9] 0x1 && [6:4] US && [3]0x0",
          AltCat => "",
          Desc       => "Advance the counter when the above low temp, but below mid temp thermal trip point is crossed in the \"down\" direction for DIMM #?",
       },
       "DIMM{n}.LT_LO" =>
       {
          RegDep => "Z_CSR_PMU_MSC_THR",
          RegDepBits => "[10:9] 0x0 && [6:4] US && [3]0x0",
          AltCat => "",
          Desc       => "Advance the counter when the below low temp thermal trip point is crossed in the \"down\" direction for DIMM ?",
       },
     },
  },
  "THERM_TRP_UP" =>
  {
    Category  => "Thermal Throttle",
    EvSel     => "0x4",
    MaxIncCyc => 1,
    Desc      => "DIMM Up Thermal Trip Points Crossed",
    Defn      => "Counts when a specified thermal trip point is crossed in the \"up\" direction.",
    SubEvents  =>
    {
       "ALL.GT_MID_RISE" =>
       {
          RegDep => "Z_CSR_PMU_MSC_THR",
          RegDepBits => "[8:7] 0x3 && [3]0x1",
          AltCat => "",
          Desc       => "Advance the counter when the above mid temp thermal trip point (rising) is crossed in the \"up\" direction for any DIMM",
       },
       "ALL.GT_MID_FALL" =>
       {
          RegDep => "Z_CSR_PMU_MSC_THR",
          RegDepBits => "[8:7] 0x2 && [3]0x1",
          AltCat => "",
          Desc       => "Advance the counter when the above mid temp thermal trip point (falling) is crossed in the \"up\" direction for any DIMM",
       },
       "" =>
       {
          RegDep => "Z_CSR_PMU_MSC_THR",
          RegDepBits => "[8:7] 0x1 && [3]0x1",
          AltCat => "",
          Desc       => "Advance the counter when the above low temp, but below mid temp thermal trip point is crossed in the \"up\" direction for any DIMM",
       },
       "ALL.LT_LO" =>
       {
          RegDep => "Z_CSR_PMU_MSC_THR",
          RegDepBits => "[8:7] 0x0 && [3]0x1",
          AltCat => "",
          Desc       => "Advance the counter when the below low temp thermal trip point is crossed in the \"up\" direction for any DIMM",
       },
       "DIMM{n}.GT_MID_RISE" =>
       {
          RegDep => "Z_CSR_PMU_MSC_THR",
          RegDepBits => "[10:9] 0x3 && [6:4] US && [3]0x0",
          AltCat => "",
          Desc       => "Advance the counter when the above mid temp thermal trip point (rising) is crossed in the \"up\" direction for DIMM ?",
       },
       "DIMM{n}.GT_MID_FALL" =>
       {
          RegDep => "Z_CSR_PMU_MSC_THR",
          RegDepBits => "[10:9] 0x2 && [6:4] US && [3]0x0",
          AltCat => "",
          Desc       => "Advance the counter when the above mid temp thermal trip point (falling) is crossed in the \"up\" direction for DIMM ?",
       },
       "DIMM{n}.GT_LO" =>
       {
          RegDep => "Z_CSR_PMU_MSC_THR",
          RegDepBits => "[10:9] 0x1 && [6:4] US && [3]0x0",
          AltCat => "",
          Desc       => "Advance the counter when the above low temp, but below mid temp thermal trip point is crossed in the \"up\" direction for DIMM ?",
       },
       "DIMM{n}.LT_LO" =>
       {
          RegDep => "Z_CSR_PMU_MSC_THR",
          RegDepBits => "[10:9] 0x0 && [6:4] US && [3]0x0",
          AltCat => "",
          Desc       => "Advance the counter when the below low temp thermal trip point is crossed in the \"up\" direction for DIMM ?",
       },
     },
  },
  "TRANS_CMDS" =>
  {
    Category  => "Dispatch Queue",
    EvSel     => "0x12",
    MaxIncCyc => 1,
    Desc      => "Translated Commands",
    Defn      => "Counts read/write commands entered into the Dispatch Queue",
    SubEvents  =>
    {
       "NONE" =>
       {
          RegDep => "Z_CSR_PGT_PMU",
          RegDepBits => "[9:8]0x3",
          AltCat => "",
          Desc       => "(*nothing is counted*)",
       },
       "INSERTS_WR" =>
       {
          RegDep => "Z_CSR_PGT_PMU",
          RegDepBits => "[9:8] 0x2",
          AltCat => "",
          Desc       => "Advance counter when a translated write command enters any DispQ.",
       },
       "INSERTS_RD" =>
       {
          RegDep => "Z_CSR_PGT_PMU",
          RegDepBits => "[9:8] 0x1",
          AltCat => "",
          Desc       => "Advance counter when a translated read (includes read, preall, refresh, zqcal and auto-close) command enters any DispQ.",
       },
       "INSERTS_ALL" =>
       {
          RegDep => "Z_CSR_PGT_PMU",
          RegDepBits => "[9:8] 0x0",
          AltCat => "",
          Desc       => "Advance counter when a translated command enters any DispQ.",
       },
     },
  },
  "TT_CMD_CONFLICT" =>
  {
    Category  => "Thermal Throttle",
    EvSel     => "0x19",
    MaxIncCyc => 1,
    Desc      => "Thermal Throttling Command Conflicts",
    Defn      => "Count PGT Related Conflict Events",
    SubEvents  =>
    {
       "TT_RANK_ALL" =>
       {
          RegDep => "Z_CSR_PGT_PMU",
          RegDepBits => "[1]0x0",
          AltCat => "",
          Desc       => "Advance counter when a command conflict occurs due to thermal throttling.",
       },
       "TT_RANK_N" =>
       {
          RegDep => "Z_CSR_PGT_PMU",
          RegDepBits => "[1]0x1 && [5:2] US",
          AltCat => "",
          Desc       => "Advance counter when a command conflict occurs due to thermal throttling.",
       },
     },
  },
  "ZERO" =>
  {
    Category  => "Cycle Counters",
    EvSel     => "0x1f",
    MaxIncCyc => 0,
    Desc      => "Zero",
    Defn      => "Increment by 0",
  },
);



