%PSNCoreEventList =
(
  "ALAT_ENTRY_REPLACED" =>
  {
    Code     => 0x15,
    Umask    => 0x02,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "ALAT entry replaced",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 0,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x55550,
    Defn     => "",
    Notes    => "ALAT Entry Replaced",
  },
  "ALAT_STORE_HIT" =>
  {
    Code     => 0x15,
    Umask    => 0x01,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "ALAT store hit",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 0,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0xaaaa0,
    Defn     => "",
  },
  "BR_BE_PRED_DETAIL" =>
  {
    Code     => 0x80,
    Umask    => 0x07,
    AltCodes => [],
    Category => "Branch Events",
    Desc     => "be br mispredict any bru resteer of any kind",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x80,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "be br mispredict any bru resteer of any kind",
       },
       "STG" =>
       {
          Code     => 0x80,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "be br mispredict stg",
       },
       "ROT" =>
       {
          Code     => 0x80,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "be br mispredict rot",
       },
       "PFS" =>
       {
          Code     => 0x80,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "be br mispredict pfs",
       },
       "OTHER" =>
       {
          Code     => 0x80,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "be br mispredict other causes",
       },
       "ANY_RETIRED" =>
       {
          Code     => 0x80,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "be br mispredict any of the above causes",
       },
       "UNRETIRED" =>
       {
          Code     => 0x80,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "be br mispredict an unretiring b-syllable caused this",
       },
     },
  },
  "BR_ENC_PRED_DETAIL" =>
  {
    Code     => 0x83,
    Umask    => 0x00,
    AltCodes => [],
    Category => "Branch Events",
    Desc     => "all encoded br, regardless of prediction result",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ENC_ANY_PRED" =>
       {
          Code     => 0x83,
          Umask    => 0x00,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "all encoded br, regardless of prediction result",
       },
       "ENC_CORR_PRED" =>
       {
          Code     => 0x83,
          Umask    => 0x01,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "all encoded br, correctly predicted",
       },
       "ENC_WRONG_PATH" =>
       {
          Code     => 0x83,
          Umask    => 0x02,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "all encoded br, mispredicted due to wrong br direction",
       },
       "ENC_WRONG_TARGET" =>
       {
          Code     => 0x83,
          Umask    => 0x03,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "all encoded br, mispredicted br due to wrong target for taken br",
       },
       "OVRSUB_ANY_PRED" =>
       {
          Code     => 0x83,
          Umask    => 0x04,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "br that cause oversubscription, regardless of prediction result",
       },
       "OVRSUB_CORR_PRED" =>
       {
          Code     => 0x83,
          Umask    => 0x05,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "br that cause oversubscription, correctly predicted",
       },
       "OVRSUB_WRONG_PATH" =>
       {
          Code     => 0x83,
          Umask    => 0x06,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "br that cause oversubscription, mispredicted due to wrong br direction",
       },
       "OVRSUB_WRONG_TARGET" =>
       {
          Code     => 0x83,
          Umask    => 0x07,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "br that cause oversubscription, mispredicted due to wrong target for taken br",
       },
       "ENC_OVRSUB_ANY_PRED" =>
       {
          Code     => 0x83,
          Umask    => 0x08,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "encoded br that cause oversubscription, regardless of prediction result",
       },
       "ENC_OVRSUB_CORR_PRED" =>
       {
          Code     => 0x83,
          Umask    => 0x09,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "encoded br that cause oversubscription, correctly predicted",
       },
       "ENC_OVRSUB_WRONG_PATH" =>
       {
          Code     => 0x83,
          Umask    => 0x0a,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "encoded br that cause oversubscription, mispredicted due to wrong br direction",
       },
       "ENC_OVRSUB_WRONG_TARGET" =>
       {
          Code     => 0x83,
          Umask    => 0x0b,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "encoded br that cause oversubscription, mispredicted due to wrong target for taken br",
       },
     },
  },
  "BR_PATH_PRED" =>
  {
    Code     => 0x80,
    Umask    => 0x08,
    AltCodes => [],
    Category => "Branch Events",
    Desc     => "all br types, incorrectly predicted path, not taken br",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY_MISPRED_NOT_TAKEN" =>
       {
          Code     => 0x80,
          Umask    => 0x08,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "all br types, incorrectly predicted path, not taken br",
       },
       "ANY_MISPRED_TAKEN" =>
       {
          Code     => 0x80,
          Umask    => 0x09,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "all br types, incorrectly predicted path, taken br",
       },
       "ANY_OKPRED_NOT_TAKEN" =>
       {
          Code     => 0x80,
          Umask    => 0x0a,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "all br types, correctly predicted path, not taken br",
       },
       "ANY_OKPRED_TAKEN" =>
       {
          Code     => 0x80,
          Umask    => 0x0b,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "all br types, correctly predicted path, taken br",
       },
       "IPREL_MISPRED_NOT_TAKEN" =>
       {
          Code     => 0x80,
          Umask    => 0x0c,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "ip  br types, incorrectly predicted path, not taken br",
       },
       "IPREL_MISPRED_TAKEN" =>
       {
          Code     => 0x80,
          Umask    => 0x0d,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "ip  br types, incorrectly predicted path, taken br",
       },
       "IPREL_OKPRED_NOT_TAKEN" =>
       {
          Code     => 0x80,
          Umask    => 0x0e,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "ip  br types, correctly predicted path, not taken br",
       },
       "IPREL_OKPRED_TAKEN" =>
       {
          Code     => 0x80,
          Umask    => 0x0f,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "ip  br types, correctly predicted path, taken br",
       },
       "RETURN_MISPRED_NOT_TAKEN" =>
       {
          Code     => 0x81,
          Umask    => 0x00,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "ret br types, incorrectly predicted path, not taken br",
       },
       "RETURN_MISPRED_TAKEN" =>
       {
          Code     => 0x81,
          Umask    => 0x01,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "ret br types, incorrectly predicted path, taken br",
       },
       "RETURN_OKPRED_NOT_TAKEN" =>
       {
          Code     => 0x81,
          Umask    => 0x02,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "ret br types, correctly predicted path, not taken br",
       },
       "RETURN_OKPRED_TAKEN" =>
       {
          Code     => 0x81,
          Umask    => 0x03,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "ret br types, correctly predicted path, taken br",
       },
       "NON_RETIND_MISPRED_NOT_TAKEN" =>
       {
          Code     => 0x81,
          Umask    => 0x04,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "nonret indirect  br types, incorrectly predicted path, not taken br",
       },
       "NON_RETIND_MISPRED_TAKEN" =>
       {
          Code     => 0x81,
          Umask    => 0x05,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "nonret indirect  br types, incorrectly predicted path, taken br",
       },
       "NON_RETIND_OKPRED_NOT_TAKEN" =>
       {
          Code     => 0x81,
          Umask    => 0x06,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "nonret indirect  br types, correctly predicted path, not taken br",
       },
       "NON_RETIND_OKPRED_TAKEN" =>
       {
          Code     => 0x81,
          Umask    => 0x07,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "nonret indirect  br types, correctly predicted path, taken br",
       },
     },
  },
  "BR_PRED_DETAIL" =>
  {
    Code     => 0x82,
    Umask    => 0x00,
    AltCodes => [],
    Category => "Branch Events",
    Desc     => "all br types, regardless of prediction result",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY_ANY_PRED" =>
       {
          Code     => 0x82,
          Umask    => 0x00,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "all br types, regardless of prediction result",
       },
       "ANY_CORR_PRED" =>
       {
          Code     => 0x82,
          Umask    => 0x01,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "all br types, correctly predicted br",
       },
       "ANY_WRONG_PATH" =>
       {
          Code     => 0x82,
          Umask    => 0x02,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "all br types, mispred br due to wrong br direction",
       },
       "ANY_WRONG_TARGET" =>
       {
          Code     => 0x82,
          Umask    => 0x03,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "all br types, mispred br due to wrong trg for taken br",
       },
       "IPREL_ANY_PRED" =>
       {
          Code     => 0x82,
          Umask    => 0x04,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "ip  br types, regardless of prediction result",
       },
       "IPREL_CORR_PRED" =>
       {
          Code     => 0x82,
          Umask    => 0x05,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "ip  br types, correctly predicted br",
       },
       "IPREL_WRONG_PATH" =>
       {
          Code     => 0x82,
          Umask    => 0x06,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "ip  br types, mispred br due to wrong br direction",
       },
       "IPREL_WRONG_TARGET" =>
       {
          Code     => 0x82,
          Umask    => 0x07,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "ip  br types, regardless of prediction result",
       },
       "RETURN_ANY_PRED" =>
       {
          Code     => 0x82,
          Umask    => 0x08,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "ret br types, regardless of prediction result",
       },
       "RETURN_CORR_PRED" =>
       {
          Code     => 0x82,
          Umask    => 0x09,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "ret br types, correctly predicted br",
       },
       "RETURN_WRONG_PATH" =>
       {
          Code     => 0x82,
          Umask    => 0x0a,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "ret br types, mispred br due to wrong br direction",
       },
       "RETURN_WRONG_TARGET" =>
       {
          Code     => 0x82,
          Umask    => 0x0b,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "ret br types, regardless of prediction result",
       },
       "NON_RETIND_ANY_PRED" =>
       {
          Code     => 0x82,
          Umask    => 0x0c,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "nonret indirect br types, regardless of prediction result",
       },
       "NON_RETIND_CORR_PRED" =>
       {
          Code     => 0x82,
          Umask    => 0x0d,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "nonret indirect br types, correctly predicted br",
       },
       "NON_RETIND_WRONG_PATH" =>
       {
          Code     => 0x82,
          Umask    => 0x0e,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "nonret indirect br types, mispred br due to wrong br direction",
       },
       "NON_RETIND_WRONG_TARGET" =>
       {
          Code     => 0x82,
          Umask    => 0x0f,
          MaxInc   => 3,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "nonret indirect br types, regardless of prediction result",
       },
     },
  },
  "BR_PRED_UNKNOWN" =>
  {
    Code     => 0x81,
    Umask    => 0x08,
    AltCodes => [],
    Category => "Branch Events",
    Desc     => "all br types, unknown predicted path",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x81,
          Umask    => 0x08,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "all br types, unknown predicted path",
       },
       "ANY_TAKEN" =>
       {
          Code     => 0x81,
          Umask    => 0x09,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "all br types, unknown predicted path, taken br",
       },
       "IPREL" =>
       {
          Code     => 0x81,
          Umask    => 0x0a,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "ip  br types, unknown predicted path",
       },
       "IPREL_TAKEN" =>
       {
          Code     => 0x81,
          Umask    => 0x0b,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "ip  br types, unknown predicted path, taken br",
       },
       "RETURN" =>
       {
          Code     => 0x81,
          Umask    => 0x0c,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "ret br types, unknown predicted path",
       },
       "RETURN_TAKEN" =>
       {
          Code     => 0x81,
          Umask    => 0x0d,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "ret br types, unknown predicted path, taken br",
       },
       "NON_RETIND" =>
       {
          Code     => 0x81,
          Umask    => 0x0e,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "nonret indirect br types, unknown predicted path",
       },
       "NON_RETIND_TAKEN" =>
       {
          Code     => 0x81,
          Umask    => 0x0f,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "nonret indirect br types, unknown predicted path, taken br",
       },
     },
  },
  "CPU_CPL_CHANGE" =>
  {
    Code     => 0x01,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "System Events",
    Desc     => "CPU privilege level change, any",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x01,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "CPU privilege level change, any",
       },
       "FROM0" =>
       {
          Code     => 0x01,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "CPU privilege level change, level 0",
       },
       "FROM1" =>
       {
          Code     => 0x01,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "CPU privilege level change, level 1",
       },
       "FROM2" =>
       {
          Code     => 0x01,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "CPU privilege level change, level 2",
       },
       "FROM3" =>
       {
          Code     => 0x01,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "CPU privilege level change, level 3",
       },
     },
  },
  "CPU_OP_CYCLES" =>
  {
    Code     => 0x00,
    Umask    => 0x02,
    AltCodes => [],
    Category => "Basic Events",
    Desc     => "CPU cycle count",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ALL" =>
       {
          Code     => 0x00,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0xffff0,
          Core     => "",
          Desc     => "CPU cycle count",
       },
       "HALTED" =>
       {
          Code     => 0x00,
          Umask    => 0x03,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Halted state cycle count",
       },
       "TAGGED" =>
       {
          Code     => 0x00,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "C",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Tagged CPU cycle count",
       },
     },
  },
  "CPU_REF_CYCLES" =>
  {
    Code     => 0x00,
    Umask    => 0x01,
    AltCodes => [],
    Category => "Basic Events",
    Desc     => "Reference cycle count",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0xffff0,
    Defn     => "",
  },
  "CSPEC_CHKS" =>
  {
    Code     => 0x01,
    Umask    => 0x04,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "Retired CHK.S instructions",
    AltCat   => "",
    Defn     => "",
    Notes    => "Speculative Check Loads",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x01,
          Umask    => 0x04,
          MaxInc   => 6,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Retired CHK.S instructions",
       },
     },
  },
  "CSPEC_CHKS_FAIL" =>
  {
    Code     => 0x01,
    Umask    => 0x05,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "Failed CHK.S instructions",
    AltCat   => "",
    Defn     => "",
    Notes    => "Failed Speculative Check Loads",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x01,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Failed CHK.S instructions",
       },
       "INT" =>
       {
          Code     => 0x01,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Failed integer CHK.S instructions",
       },
       "FP" =>
       {
          Code     => 0x01,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Failed floating point CHK.S instructions",
       },
     },
  },
  "CSPEC_LOAD" =>
  {
    Code     => 0xca,
    Umask    => 0x01,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "ld.s inst commits",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xca,
          Umask    => 0x01,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "ld.s inst commits",
       },
       "NAT" =>
       {
          Code     => 0xca,
          Umask    => 0x02,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "ld.s inst commits, fails (i.e. Nat bit is set)",
       },
     },
  },
  "CYC_BE_BUBBLE" =>
  {
    Code     => 0x02,
    Umask    => 0x04,
    AltCodes => [],
    Category => "Stall Events",
    Desc     => "Backend cycles stalled",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x02,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend cycles stalled",
       },
     },
  },
  "CYC_BE_DET_REPLAY" =>
  {
    Code     => 0x04,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "Stall Events",
    Desc     => "Backend DET replay cycles",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x04,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend DET replay cycles",
       },
       "GR_LOAD" =>
       {
          Code     => 0x04,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend DET replay cycles due to GR load",
       },
       "DCS_HZRD" =>
       {
          Code     => 0x04,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend DET replay cycles due to DCS hazard",
       },
       "STORE_VS_STORE" =>
       {
          Code     => 0x04,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend DET replay cycles due to Store vs Store",
       },
       "LOAD_AFTER_WRITE" =>
       {
          Code     => 0x04,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend DET replay cycles due to Load after Write",
       },
       "LOAD_ACQ" =>
       {
          Code     => 0x04,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend DET replay cycles due to Load Acquire",
       },
       "FLUSH_DST" =>
       {
          Code     => 0x05,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend DET replay cycles due to Flush Destination",
       },
       "HPW_HZRD" =>
       {
          Code     => 0x05,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend DET replay cycles due to HPW conflict",
       },
       "WRITE_HIT_VS_FILL" =>
       {
          Code     => 0x05,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend DET replay cycles due to Write Hit vs Fill",
       },
       "WRITE_MISS_VS_FILL" =>
       {
          Code     => 0x05,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend DET replay cycles due to Write Miss vs Fill",
       },
       "MT1" =>
       {
          Code     => 0x05,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend DET replay cycles due to more than 1 simultaneously",
       },
     },
  },
  "CYC_BE_EXE_REPLAY" =>
  {
    Code     => 0x03,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "Stall Events",
    Desc     => "Backend EXE replay cycles",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x03,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend EXE replay cycles",
       },
       "GR_LOAD_RAW" =>
       {
          Code     => 0x03,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend EXE replay cycles due to GR load RAW hazard",
       },
       "FR_LOAD_RAW" =>
       {
          Code     => 0x03,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend EXE replay cycles due to FR load RAW hazard",
       },
       "GR_LOAD_WAW" =>
       {
          Code     => 0x03,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend EXE replay cycles due to GR load WAW hazard",
       },
       "FR_LOAD_WAW" =>
       {
          Code     => 0x03,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend EXE replay cycles due to FR load WAW hazard",
       },
       "GR_GR" =>
       {
          Code     => 0x03,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend EXE replay cycles due to GR-GR hazard",
       },
       "FR_FR" =>
       {
          Code     => 0x04,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend EXE replay cycles due to FR-FR hazard",
       },
       "MT1_HIGH" =>
       {
          Code     => 0x04,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend EXE replay cycles due to more than 1 of the upper",
       },
       "FCMP" =>
       {
          Code     => 0x04,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend EXE replay cycles due to fcmp",
       },
       "PRED" =>
       {
          Code     => 0x04,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend EXE replay cycles due to predicates",
       },
       "NOTN" =>
       {
          Code     => 0x04,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Not needed backend speculative EXE replay cycles",
       },
       "FPSR" =>
       {
          Code     => 0x04,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend EXE replay cycles due to fpsr",
       },
       "SRLZ" =>
       {
          Code     => 0x04,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend EXE replay cycles due to serialize",
       },
       "REL" =>
       {
          Code     => 0x04,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend EXE replay cycles due to release",
       },
       "ARCR" =>
       {
          Code     => 0x04,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend EXE replay cycles due to AR-CR hazard",
       },
       "MT1_LOW" =>
       {
          Code     => 0x04,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend EXE replay cycles due to more than one of the lower",
       },
     },
  },
  "CYC_BE_IBD_STALL" =>
  {
    Code     => 0x02,
    Umask    => 0x05,
    AltCodes => [],
    Category => "Stall Events",
    Desc     => "Backend IBD stall cycles",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x02,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend IBD stall cycles",
       },
       "RSE_ANY" =>
       {
          Code     => 0x02,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to RSE",
       },
       "RSE_CFLE" =>
       {
          Code     => 0x02,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to RSE fill by br.ret or rfi",
       },
       "RSE_ST" =>
       {
          Code     => 0x02,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to RSE store by alloc or flushrs",
       },
       "RSE_LOAD" =>
       {
          Code     => 0x02,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to RSE fill by loadrs",
       },
       "RSE_WAIT" =>
       {
          Code     => 0x02,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to RSE wait",
       },
       "THRSW" =>
       {
          Code     => 0x02,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to thread switch",
       },
       "HPW" =>
       {
          Code     => 0x02,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to HPW",
       },
       "OZQFULL" =>
       {
          Code     => 0x02,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to OZQ full",
       },
       "ACQ" =>
       {
          Code     => 0x02,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to acquire op",
       },
       "GR_LOAD" =>
       {
          Code     => 0x02,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to GR load",
       },
       "FR_LOAD" =>
       {
          Code     => 0x03,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to FR load",
       },
       "SRLZ" =>
       {
          Code     => 0x03,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to serialize",
       },
       "ARCR" =>
       {
          Code     => 0x03,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to AR-CR hazard",
       },
       "MTOM" =>
       {
          Code     => 0x03,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend IBD stall cycles doe to M to M hazard",
       },
       "FTOF" =>
       {
          Code     => 0x03,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to F to F hazard",
       },
       "FLD_DMND" =>
       {
          Code     => 0x03,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to FLD",
       },
       "WB2_TRAP" =>
       {
          Code     => 0x03,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to WB2 trap",
       },
       "QFULL" =>
       {
          Code     => 0x03,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to speculative IBQ full bubble",
       },
       "FEBUB" =>
       {
          Code     => 0x03,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to FE bubble",
       },
       "DEBUG" =>
       {
          Code     => 0x03,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend IBD stall cycles due to debug",
       },
     },
  },
  "CYC_BE_NO_BUBBLE" =>
  {
    Code     => 0x02,
    Umask    => 0x03,
    AltCodes => [],
    Category => "Stall Events",
    Desc     => "Backend cycles not stalled",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0xaaaa0,
    Defn     => "",
  },
  "CYC_BE_WB2_FLUSH" =>
  {
    Code     => 0x06,
    Umask    => 0x05,
    AltCodes => [],
    Category => "Stall Events",
    Desc     => "Backend WB2 flush cycles",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x06,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend WB2 flush cycles",
       },
       "XPN" =>
       {
          Code     => 0x06,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend WB2 flush cycles due to XPN",
       },
       "BRU" =>
       {
          Code     => 0x06,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend WB2 flush cycles due to BRU",
       },
     },
  },
  "CYC_BE_WB2_REPLAY" =>
  {
    Code     => 0x05,
    Umask    => 0x05,
    AltCodes => [],
    Category => "Stall Events",
    Desc     => "Backend WB2 replay cycles",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x05,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend WB2 replay cycles",
       },
       "BLK_HPW" =>
       {
          Code     => 0x05,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend WB2 replay cycles due to blocking HPW",
       },
       "OZQ_FULL" =>
       {
          Code     => 0x05,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend WB2 replay cycles due to OZQ full",
       },
       "STORE_ALIAS" =>
       {
          Code     => 0x05,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend WB2 replay cycles due to store alias",
       },
       "NAT_HZRD" =>
       {
          Code     => 0x06,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend WB2 replay cycles due to NaT hazard",
       },
       "DAHR_HZRD" =>
       {
          Code     => 0x06,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend WB2 replay cycles due to DAHR RAW hazard",
       },
       "LOAD_ACQ" =>
       {
          Code     => 0x06,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend WB2 replay cycles due to load acquire",
       },
       "LDC" =>
       {
          Code     => 0x05,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend WB2 replay cycles due to a ld.c",
       },
       "PAUSE" =>
       {
          Code     => 0x05,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend WB2 replay cycles due to hint \@pause",
       },
       "ALLOC_PEC" =>
       {
          Code     => 0x05,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend WB2 replay cycles due to alloc pec hazard",
       },
       "MOV_PSR_UM" =>
       {
          Code     => 0x05,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend WB2 replay cycles due to move to psr.um",
       },
       "VIRT_INT" =>
       {
          Code     => 0x05,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend WB2 replay cycles due to virtual interrupt",
       },
       "FP_DEN" =>
       {
          Code     => 0x05,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend WB2 replay cycles due to FPU denormal",
       },
       "FP_SIR" =>
       {
          Code     => 0x05,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend WB2 replay cycles due to FPU SIR",
       },
       "MT1" =>
       {
          Code     => 0x06,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Backend WB2 replay cycles due to more than 1",
       },
       "SER" =>
       {
          Code     => 0x06,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Backend WB2 replay cycles due to parity and similar errors",
       },
     },
  },
  "CYC_FE_BUBBLE" =>
  {
    Code     => 0x8a,
    Umask    => 0x03,
    AltCodes => [],
    Category => "Stall Events",
    Desc     => "Front end stalled cycles",
    AltCat   => "",
    Defn     => "",
    Notes    => "Front-end stall",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x8a,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end stalled cycles",
       },
     },
  },
  "CYC_FE_FET_REPLAY" =>
  {
    Code     => 0x8a,
    Umask    => 0x0b,
    AltCodes => [],
    Category => "Stall Events",
    Desc     => "Front end bubbles due to FET replay",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x8a,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end bubbles due to FET replay",
       },
       "BR_INIT" =>
       {
          Code     => 0x8a,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end bubbles due to Br init FET replay",
       },
       "BRQ_FULL" =>
       {
          Code     => 0x8a,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end bubbles due to BRQ full FET replay",
       },
       "BRQ_WAIT" =>
       {
          Code     => 0x8a,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end bubbles due to BRQ wait FET replay",
       },
       "BR_INTRLCK" =>
       {
          Code     => 0x8a,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end bubbles due to Br interlock FET replay",
       },
       "RAB_FULL" =>
       {
          Code     => 0x8b,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end bubbles due to RAB full FET replay",
       },
       "MT1" =>
       {
          Code     => 0x8b,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end bubbles due to more than 1 FET replay",
       },
     },
  },
  "CYC_FE_FET_STALL" =>
  {
    Code     => 0x8b,
    Umask    => 0x02,
    AltCodes => [],
    Category => "Stall Events",
    Desc     => "Front end FET stall cycles",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x8b,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end FET stall cycles",
       },
       "IBQ_FULL" =>
       {
          Code     => 0x8b,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end FET stall cycles due to IBQ full",
       },
       "FLI_MISS" =>
       {
          Code     => 0x8b,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end FET stall cycles due to FLI miss",
       },
       "FLITLB_MISS" =>
       {
          Code     => 0x8b,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end FET stall cycles due to FLI TLB miss",
       },
       "MT1" =>
       {
          Code     => 0x8b,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end FET stall cycles due to more than 1",
       },
     },
  },
  "CYC_FE_FWPROG" =>
  {
    Code     => 0x8a,
    Umask    => 0x01,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "Number of cycles in forward progress screen",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "F",
    RegRst   => 0xa0aa0,
    Defn     => "",
  },
  "CYC_FE_NO_BUBBLE" =>
  {
    Code     => 0x8a,
    Umask    => 0x02,
    AltCodes => [],
    Category => "Stall Events",
    Desc     => "Cycles with valid bundles delivered to IBD",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0x50550,
    Defn     => "",
    Notes    => "No front-end stall",
  },
  "CYC_FE_RESTEER" =>
  {
    Code     => 0x8a,
    Umask    => 0x04,
    AltCodes => [],
    Category => "Stall Events",
    Desc     => "Front end bubble cycles",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x8a,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end bubble cycles",
       },
       "IPREL" =>
       {
          Code     => 0x8a,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end bubbles due to IP relative branch",
       },
       "BR_RETIND" =>
       {
          Code     => 0x8a,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end bubbles due to Br return ind",
       },
       "NON_RETIND" =>
       {
          Code     => 0x8a,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end bubbles due to Br not return ind",
       },
       "SEQ_BR" =>
       {
          Code     => 0x8a,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end bubbles due to squential Br",
       },
       "TSWITCH" =>
       {
          Code     => 0x8a,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end bubbles due to thread switch",
       },
       "BE_FLUSH" =>
       {
          Code     => 0x8a,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end bubbles due to Back-end resteer",
       },
     },
  },
  "DAF_EVENTS" =>
  {
    Code     => 0x30,
    Umask    => 0x00,
    AltCodes => [],
    Category => "Debug Events",
    Desc     => "Digital Activity Factor Events",
    AltCat   => "",
    Defn     => "",
    Notes    => "Sets of events from DAF in pmds 10-19 selected by EvId[4:0]",
    Subcat  =>
    {
       "EVTS" =>
       {
          Code     => 0x30,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0xff300,
          Core     => "",
          Desc     => "Digital Activity Factor Events",
       },
       "TYPC_CMP" =>
       {
          Code     => 0x34,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0xff300,
          Core     => "",
          Desc     => "",
       },
       "IWC_CMP" =>
       {
          Code     => 0x38,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0xff300,
          Core     => "",
          Desc     => "",
       },
       "IWC_EXP" =>
       {
          Code     => 0x3c,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0xff300,
          Core     => "",
          Desc     => "",
       },
     },
  },
  "DAHS_UNDERFLOW" =>
  {
    Code     => 0x0c,
    Umask    => 0x09,
    AltCodes => [],
    Category => "DPF Events",
    Desc     => "Data prefetch ASB stack undreflowed",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0xaaaa0,
    Defn     => "",
    Notes    => "FLD HWPF inserted into DPFQ",
  },
  "DATA_REF" =>
  {
    Code     => 0xca,
    Umask    => 0x04,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "UC data load retired",
    AltCat   => "",
    Defn     => "",
    Notes    => "Retired Uncacheable Loads",
    Subcat  =>
    {
       "LOAD_UC" =>
       {
          Code     => 0xca,
          Umask    => 0x04,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x11100,
          Core     => "",
          Desc     => "UC data load retired",
       },
       "STORE_UC" =>
       {
          Code     => 0xca,
          Umask    => 0x05,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x22200,
          Core     => "",
          Desc     => "UC data store retired",
       },
       "ANY" =>
       {
          Code     => 0x0d,
          Umask    => 0x0d,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD data reference",
       },
       "LOAD_INT" =>
       {
          Code     => 0x0d,
          Umask    => 0x0e,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD data reference int load",
       },
       "LOAD_FP" =>
       {
          Code     => 0x0d,
          Umask    => 0x0f,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD data reference fp load",
       },
       "LOAD_ANY" =>
       {
          Code     => 0x0e,
          Umask    => 0x08,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD data reference data loads",
       },
       "LOAD_RSE" =>
       {
          Code     => 0x0e,
          Umask    => 0x00,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD data reference rse load",
       },
       "STORE_ANY" =>
       {
          Code     => 0x0e,
          Umask    => 0x09,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD data reference data stores",
       },
       "STORE_INT" =>
       {
          Code     => 0x0e,
          Umask    => 0x01,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD data reference int store",
       },
       "STORE_FP" =>
       {
          Code     => 0x0e,
          Umask    => 0x02,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD data reference fp store",
       },
       "STORE_RSE" =>
       {
          Code     => 0x0e,
          Umask    => 0x03,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD data reference rse store",
       },
       "LFETCH" =>
       {
          Code     => 0x0e,
          Umask    => 0x04,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD data reference lfetch",
       },
       "SEMAPHORE" =>
       {
          Code     => 0x0e,
          Umask    => 0x05,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD data reference semaphore",
       },
       "HW_PREF" =>
       {
          Code     => 0x0e,
          Umask    => 0x06,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD data reference hw prefetch",
       },
       "LOAD_HPW" =>
       {
          Code     => 0x0e,
          Umask    => 0x07,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD data reference HPW load",
       },
     },
  },
  "DBG_CDC_LOG" =>
  {
    Code     => 0x15,
    Umask    => 0x0d,
    AltCodes => [],
    Category => "Debug Events",
    Desc     => "History Buffer/CDC entry written",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0xf0000,
    Defn     => "",
  },
  "DBG_DBR_MATCH" =>
  {
    Code     => 0x15,
    Umask    => 0x0b,
    AltCodes => [],
    Category => "Debug Events",
    Desc     => "Data debug register match",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0xaaaa0,
    Defn     => "",
    Notes    => "Data debug register matches data address of memory reference",
  },
  "DBG_EPN_SER_SIGNALED" =>
  {
    Code     => 0x16,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "Debug Events",
    Desc     => "An error was signalled to XPN",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0x55550,
    Defn     => "",
  },
  "DBG_HW_EVENT_INJECT" =>
  {
    Code     => 0x15,
    Umask    => 0x0c,
    AltCodes => [],
    Category => "Debug Events",
    Desc     => "Hardware Event Injection fired",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0xf0000,
    Defn     => "",
  },
  "DBG_SROSL_EXE" =>
  {
    Code     => 0x16,
    Umask    => 0x06,
    AltCodes => [],
    Category => "Debug Events",
    Desc     => "Chain 0 of the EXE TDC",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "0" =>
       {
          Code     => 0x16,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Chain 0 of the EXE TDC",
       },
       "1" =>
       {
          Code     => 0x16,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Chain 1 of the EXE TDC",
       },
       "2" =>
       {
          Code     => 0x16,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Chain 2 of the EXE TDC",
       },
       "3" =>
       {
          Code     => 0x16,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Chain 3 of the EXE TDC",
       },
     },
  },
  "DBG_SROSL_FE" =>
  {
    Code     => 0x8c,
    Umask    => 0x04,
    AltCodes => [],
    Category => "Debug Events",
    Desc     => "Chain 0 of the FE TDC",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "0" =>
       {
          Code     => 0x8c,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Chain 0 of the FE TDC",
       },
       "1" =>
       {
          Code     => 0x8c,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Chain 1 of the FE TDC",
       },
       "2" =>
       {
          Code     => 0x8c,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Chain 2 of the FE TDC",
       },
       "3" =>
       {
          Code     => 0x8c,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Chain 3 of the FE TDC",
       },
     },
  },
  "DBG_SROSL_FPU" =>
  {
    Code     => 0x8c,
    Umask    => 0x08,
    AltCodes => [],
    Category => "Debug Events",
    Desc     => "Chain 0 of the FPU TDC",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "0" =>
       {
          Code     => 0x8c,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Chain 0 of the FPU TDC",
       },
       "1" =>
       {
          Code     => 0x8c,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Chain 1 of the FPU TDC",
       },
       "2" =>
       {
          Code     => 0x8c,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Chain 2 of the FPU TDC",
       },
       "3" =>
       {
          Code     => 0x8c,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Chain 3 of the FPU TDC",
       },
     },
  },
  "DBG_SROSL_PC" =>
  {
    Code     => 0x8c,
    Umask    => 0x0c,
    AltCodes => [],
    Category => "Debug Events",
    Desc     => "Chain 0 of the PC TDC",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "0" =>
       {
          Code     => 0x8c,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Chain 0 of the PC TDC",
       },
       "1" =>
       {
          Code     => 0x8c,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Chain 1 of the PC TDC",
       },
       "2" =>
       {
          Code     => 0x8c,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Chain 2 of the PC TDC",
       },
       "3" =>
       {
          Code     => 0x8c,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Chain 3 of the PC TDC",
       },
     },
  },
  "DBG_TRR_TRIG" =>
  {
    Code     => 0x15,
    Umask    => 0x0e,
    AltCodes => [],
    Category => "Debug Events",
    Desc     => "Debug TRR 0 fired",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "0" =>
       {
          Code     => 0x15,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xf0000,
          Core     => "",
          Desc     => "Debug TRR 0 fired",
       },
       "1" =>
       {
          Code     => 0x15,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xf0000,
          Core     => "",
          Desc     => "Debug TRR 1 fired",
       },
       "2" =>
       {
          Code     => 0x16,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xf0000,
          Core     => "",
          Desc     => "Debug TRR 2 fired",
       },
       "3" =>
       {
          Code     => 0x16,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xf0000,
          Core     => "",
          Desc     => "Debug TRR 3 fired",
       },
       "4" =>
       {
          Code     => 0x16,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xf0000,
          Core     => "",
          Desc     => "Debug TRR 4 fired",
       },
       "5" =>
       {
          Code     => 0x16,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xf0000,
          Core     => "",
          Desc     => "Debug TRR 5 fired",
       },
       "6" =>
       {
          Code     => 0x16,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xf0000,
          Core     => "",
          Desc     => "Debug TRR 6 fired",
       },
       "7" =>
       {
          Code     => 0x16,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xf0000,
          Core     => "",
          Desc     => "Debug TRR 7 fired",
       },
     },
  },
  "DPFQ_DEQ" =>
  {
    Code     => 0x0a,
    Umask    => 0x03,
    AltCodes => [],
    Category => "DPF Events",
    Desc     => "Data prefetch queue dequeue",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x0a,
          Umask    => 0x03,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue",
       },
       "INST_ANY" =>
       {
          Code     => 0x0a,
          Umask    => 0x04,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue any instruction",
       },
       "LFETCH" =>
       {
          Code     => 0x0a,
          Umask    => 0x05,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue lfetch",
       },
       "LFETCH_COUNT" =>
       {
          Code     => 0x0a,
          Umask    => 0x06,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue counted lfetch",
       },
       "MOV_BSPST" =>
       {
          Code     => 0x0a,
          Umask    => 0x07,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue mv bspst",
       },
       "RSE_ANY" =>
       {
          Code     => 0x0a,
          Umask    => 0x08,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue any RSE",
       },
       "RSE_LOAD" =>
       {
          Code     => 0x0a,
          Umask    => 0x09,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue RSE load",
       },
       "RSE_STORE" =>
       {
          Code     => 0x0a,
          Umask    => 0x0a,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue RSE store",
       },
       "FLD_ANY" =>
       {
          Code     => 0x0a,
          Umask    => 0x0b,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue any FLD",
       },
       "FLD_TARGET" =>
       {
          Code     => 0x0a,
          Umask    => 0x0c,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue FLD target",
       },
       "FLD_FWD" =>
       {
          Code     => 0x0a,
          Umask    => 0x0d,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue FLD forward",
       },
       "FLD_BWD" =>
       {
          Code     => 0x0a,
          Umask    => 0x0e,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue FLD backward",
       },
       "FLD_BIDI" =>
       {
          Code     => 0x0a,
          Umask    => 0x0f,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue FLD bidir",
       },
       "MLD" =>
       {
          Code     => 0x0b,
          Umask    => 0x00,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue MLD",
       },
     },
  },
  "DPFQ_DEQ_PREEMPT" =>
  {
    Code     => 0x0b,
    Umask    => 0x01,
    AltCodes => [],
    Category => "DPF Events",
    Desc     => "Data prefetch queue dequeue with preempt attribute",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x0b,
          Umask    => 0x01,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue with preempt attribute",
       },
       "INST_ANY" =>
       {
          Code     => 0x0b,
          Umask    => 0x02,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue with preempt attribute any instruction",
       },
       "LFETCH" =>
       {
          Code     => 0x0b,
          Umask    => 0x03,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue with preempt attribute lfetch",
       },
       "LFETCH_COUNT" =>
       {
          Code     => 0x0b,
          Umask    => 0x04,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue with preempt attribute counted lfetch",
       },
       "MOV_BSPST" =>
       {
          Code     => 0x0b,
          Umask    => 0x05,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue with preempt attribute mv bspst",
       },
       "TIMEOUT" =>
       {
          Code     => 0x0b,
          Umask    => 0x06,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue with preempt timeout",
       },
     },
  },
  "DPFQ_DEQ_PREEMPT_REJECT" =>
  {
    Code     => 0x0c,
    Umask    => 0x05,
    AltCodes => [],
    Category => "DPF Events",
    Desc     => "Data prefetch queue dequeue with preempt attribute rejected",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x0c,
          Umask    => 0x05,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue with preempt attribute rejected",
       },
       "LFETCH" =>
       {
          Code     => 0x0c,
          Umask    => 0x06,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue with preempt attribute rejected lfetch",
       },
       "LFETCH_COUNT" =>
       {
          Code     => 0x0c,
          Umask    => 0x07,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue with preempt attribute rejected counted lfetch",
       },
       "MOV_BSPST" =>
       {
          Code     => 0x0c,
          Umask    => 0x08,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue with preempt attribute rejected mv bspst",
       },
     },
  },
  "DPFQ_DEQ_REJECT" =>
  {
    Code     => 0x0b,
    Umask    => 0x07,
    AltCodes => [],
    Category => "DPF Events",
    Desc     => "Data prefetch queue dequeue rejected",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x0b,
          Umask    => 0x07,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue rejected",
       },
       "INST_ANY" =>
       {
          Code     => 0x0b,
          Umask    => 0x08,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue rejected any instruction",
       },
       "LFETCH" =>
       {
          Code     => 0x0b,
          Umask    => 0x09,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue rejected lfetch",
       },
       "LFETCH_COUNT" =>
       {
          Code     => 0x0b,
          Umask    => 0x0a,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue rejected counted lfetch",
       },
       "MOV_BSPST" =>
       {
          Code     => 0x0b,
          Umask    => 0x0b,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue rejected mv bspst",
       },
       "RSE_ANY" =>
       {
          Code     => 0x0b,
          Umask    => 0x0c,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue rejected any RSE",
       },
       "RSE_LOAD" =>
       {
          Code     => 0x0b,
          Umask    => 0x0d,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue rejected RSE load",
       },
       "RSE_STORE" =>
       {
          Code     => 0x0b,
          Umask    => 0x0e,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue rejected RSE store",
       },
       "FLD_ANY" =>
       {
          Code     => 0x0b,
          Umask    => 0x0f,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue rejected any FLD",
       },
       "FLD_TARGET" =>
       {
          Code     => 0x0c,
          Umask    => 0x00,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue rejected FLD target",
       },
       "FLD_FWD" =>
       {
          Code     => 0x0c,
          Umask    => 0x01,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue rejected FLD forward",
       },
       "FLD_BWD" =>
       {
          Code     => 0x0c,
          Umask    => 0x02,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue rejected FLD backward",
       },
       "FLD_BIDI" =>
       {
          Code     => 0x0c,
          Umask    => 0x03,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue dequeue rejected FLD bidir",
       },
       "MLD" =>
       {
          Code     => 0x0c,
          Umask    => 0x04,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue dequeue rejected MLD",
       },
     },
  },
  "DPFQ_ENQ" =>
  {
    Code     => 0x08,
    Umask    => 0x07,
    AltCodes => [],
    Category => "DPF Events",
    Desc     => "Data prefetch queue enqueue",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x08,
          Umask    => 0x07,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue enqueue",
       },
       "INST_ANY" =>
       {
          Code     => 0x08,
          Umask    => 0x08,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue enqueue any instruction",
       },
       "LFETCH" =>
       {
          Code     => 0x08,
          Umask    => 0x09,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue enqueue lfetch",
       },
       "LFETCH_COUNT" =>
       {
          Code     => 0x08,
          Umask    => 0x0a,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue enqueue counted lfetch",
       },
       "MOV_BSPST" =>
       {
          Code     => 0x08,
          Umask    => 0x0b,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue enqueue mv bspst",
       },
       "RSE_ANY" =>
       {
          Code     => 0x08,
          Umask    => 0x0c,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue enqueue any RSE",
       },
       "RSE_LOAD" =>
       {
          Code     => 0x08,
          Umask    => 0x0d,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue enqueue RSE load",
       },
       "RSE_STORE" =>
       {
          Code     => 0x08,
          Umask    => 0x0e,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue enqueue RSE store",
       },
       "FLD_ANY" =>
       {
          Code     => 0x08,
          Umask    => 0x0f,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue enqueue any FLD",
       },
       "FLD_TARGET" =>
       {
          Code     => 0x09,
          Umask    => 0x00,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue enqueue FLD target",
       },
       "FLD_FWD" =>
       {
          Code     => 0x09,
          Umask    => 0x01,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue enqueue FLD forward",
       },
       "FLD_BWD" =>
       {
          Code     => 0x09,
          Umask    => 0x02,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue enqueue FLD backward",
       },
       "FLD_BIDI" =>
       {
          Code     => 0x09,
          Umask    => 0x03,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue enqueue FLD bidir",
       },
       "MLD" =>
       {
          Code     => 0x09,
          Umask    => 0x04,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue enqueue MLD",
       },
     },
  },
  "DPFQ_ENQ_OVERFLOW" =>
  {
    Code     => 0x09,
    Umask    => 0x05,
    AltCodes => [],
    Category => "DPF Events",
    Desc     => "Data prefetch queue enqueue overflow",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x09,
          Umask    => 0x05,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue enqueue overflow",
       },
       "INST_ANY" =>
       {
          Code     => 0x09,
          Umask    => 0x06,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue enqueue overflow any instruction",
       },
       "LFETCH" =>
       {
          Code     => 0x09,
          Umask    => 0x07,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue enqueue overflow lfetch",
       },
       "LFETCH_COUNT" =>
       {
          Code     => 0x09,
          Umask    => 0x08,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue enqueue overflow counted lfetch",
       },
       "MOV_BSPST" =>
       {
          Code     => 0x09,
          Umask    => 0x09,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue enqueue overflow mv bspst",
       },
       "RSE_ANY" =>
       {
          Code     => 0x09,
          Umask    => 0x0a,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue enqueue overflow any RSE",
       },
       "RSE_LOAD" =>
       {
          Code     => 0x09,
          Umask    => 0x0b,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue enqueue overflow RSE load",
       },
       "RSE_STORE" =>
       {
          Code     => 0x09,
          Umask    => 0x0c,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue enqueue overflow RSE store",
       },
       "FLD_ANY" =>
       {
          Code     => 0x09,
          Umask    => 0x0d,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue enqueue overflow any FLD",
       },
       "FLD_TARGET" =>
       {
          Code     => 0x09,
          Umask    => 0x0e,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue enqueue overflow FLD target",
       },
       "FLD_FWD" =>
       {
          Code     => 0x09,
          Umask    => 0x0f,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue enqueue overflow FLD forward",
       },
       "FLD_BWD" =>
       {
          Code     => 0x0a,
          Umask    => 0x00,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue enqueue overflow FLD backward",
       },
       "FLD_BIDI" =>
       {
          Code     => 0x0a,
          Umask    => 0x01,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Data prefetch queue enqueue overflow FLD bidir",
       },
       "MLD" =>
       {
          Code     => 0x0a,
          Umask    => 0x02,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch queue enqueue overflow MLD",
       },
     },
  },
  "DSPEC_CHKA_LDC" =>
  {
    Code     => 0x00,
    Umask    => 0x0f,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "ALAT chka ldc",
    AltCat   => "",
    Defn     => "",
    Notes    => "Advanced Check Loads",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x00,
          Umask    => 0x0f,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "ALAT chka ldc",
       },
     },
  },
  "DSPEC_CHKA_LDC_FAIL" =>
  {
    Code     => 0x01,
    Umask    => 0x01,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "ALAT failed chka ldc",
    AltCat   => "",
    Defn     => "",
    Notes    => "Failed Advanced Check Loads",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x01,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "ALAT failed chka ldc",
       },
       "INT" =>
       {
          Code     => 0x01,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "ALAT failed chka ldc",
       },
       "FP" =>
       {
          Code     => 0x01,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "ALAT failed chka ldc",
       },
     },
  },
  "DSPEC_LDC" =>
  {
    Code     => 0x01,
    Umask    => 0x00,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "LD.C hitting the ALAT",
    AltCat   => "",
    Defn     => "",
    Notes    => "Advanced Check Loads",
    Subcat  =>
    {
       "HIT" =>
       {
          Code     => 0x01,
          Umask    => 0x00,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "LD.C hitting the ALAT",
       },
     },
  },
  "DTLB_HPWHINT_BLK" =>
  {
    Code     => 0xca,
    Umask    => 0x03,
    AltCodes => [],
    Category => "MLDTLB Events",
    Desc     => "speculative blocking imiss launches hpw req",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x49200,
    Defn     => "",
  },
  "DTLB_HPWREQ_BLK_MISS" =>
  {
    Code     => 0xc9,
    Umask    => 0x0c,
    AltCodes => [],
    Category => "MLDTLB Events",
    Desc     => "blocking inst misses DTB, launches HPW request",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "SUCCEED" =>
       {
          Code     => 0xc9,
          Umask    => 0x0c,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "blocking inst misses DTB, launches HPW request",
       },
       "COAL" =>
       {
          Code     => 0xc9,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Blocking walk missed the DTB, coalesced with non-blocking walk",
       },
       "FAIL" =>
       {
          Code     => 0xca,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Blocking walk missed the DTB, HPW walk failed",
       },
     },
  },
  "DTLB_HPWREQ_SPEC_MISS" =>
  {
    Code     => 0xc9,
    Umask    => 0x0e,
    AltCodes => [],
    Category => "MLDTLB Events",
    Desc     => "speculative inst commits and misses the DTB",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x92400,
    Defn     => "",
  },
  "DTLB_REF" =>
  {
    Code     => 0xca,
    Umask    => 0x06,
    AltCodes => [],
    Category => "MLDTLB Events",
    Desc     => "Committed instruction used the DTB",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xca,
          Umask    => 0x06,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55500,
          Core     => "",
          Desc     => "Committed instruction used the DTB",
       },
       "NONSPEC" =>
       {
          Code     => 0xc9,
          Umask    => 0x0d,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaa00,
          Core     => "",
          Desc     => "Committed instruction used the DTB, no spec lfetch, ld.s with spont defer and dcr.dm = 1",
       },
     },
  },
  "EAR_EVENT_DATA" =>
  {
    Code     => 0x01,
    Umask    => 0x09,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "Data cache EAR capture",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "F",
    RegRst   => 0xaaaa0,
    Defn     => "",
  },
  "EAR_EVENT_ETB_IP_MT" =>
  {
    Code     => 0x01,
    Umask    => 0x08,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "ETB/IP-EAR capture",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x55550,
    Defn     => "",
  },
  "EAR_EVENT_INST" =>
  {
    Code     => 0x87,
    Umask    => 0x01,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "FLI EAR event captured",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0xa0aa0,
    Defn     => "",
    Notes    => "Instruction EAR Events",
  },
  "FE_OP_CYCLES" =>
  {
    Code     => 0x87,
    Umask    => 0x05,
    AltCodes => [],
    Category => "Basic Events",
    Desc     => "Front end in thread",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "F",
    RegRst   => 0xa0aa0,
    Defn     => "",
  },
  "FE_RESTEER" =>
  {
    Code     => 0x8b,
    Umask    => 0x07,
    AltCodes => [],
    Category => "Stall Events",
    Desc     => "Front end resteer",
    AltCat   => "",
    Defn     => "",
    Notes    => "Resteer Events (not cycs)",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x8b,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end resteer",
       },
       "FET_REPLAY" =>
       {
          Code     => 0x8b,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end resteer, FET replay",
       },
       "0B_IPREL" =>
       {
          Code     => 0x8b,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end resteer, 0-bubble IP relative",
       },
       "1B_IPREL" =>
       {
          Code     => 0x8b,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end resteer, 1-bubble IP relative",
       },
       "3B_IPREL" =>
       {
          Code     => 0x8b,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end resteer, 3-bubble IP relative",
       },
       "1B_BR_RETIND" =>
       {
          Code     => 0x8b,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end resteer, 1-bubble BR return indirect",
       },
       "3B_BR_RETIND" =>
       {
          Code     => 0x8b,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end resteer, 3-bubble BR return indirect",
       },
       "3B_NON_RETIND" =>
       {
          Code     => 0x8b,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end resteer, 3-bubble BR non-return indirect",
       },
       "1B_SEQ_BR" =>
       {
          Code     => 0x8b,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end resteer, 1-bubble sequential BR",
       },
       "3B_SEQ_BR" =>
       {
          Code     => 0x8c,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end resteer, 3-bubble sequential BR",
       },
       "3B_MT" =>
       {
          Code     => 0x8c,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end resteer, 3-bubble thread switch",
       },
       "4B_MT" =>
       {
          Code     => 0x8c,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end resteer, 4-bubble thread switch",
       },
       "BE_FLUSH" =>
       {
          Code     => 0x8c,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end resteer, back-end resteer",
       },
     },
  },
  "FLDTLB_INS_REQ" =>
  {
    Code     => 0x10,
    Umask    => 0x08,
    AltCodes => [],
    Category => "FLDTLB Events",
    Desc     => "DTB transfer from non retired instructions",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "NON_RETIRED" =>
       {
          Code     => 0x10,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "DTB transfer from non retired instructions",
       },
       "RETIRED" =>
       {
          Code     => 0x10,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "DTB transfer from retired instructions",
       },
       "CANCEL" =>
       {
          Code     => 0x10,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "DTB transfer cancelled",
       },
       "COMPLETE" =>
       {
          Code     => 0x10,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "DTB transfer to FLDTLB",
       },
     },
  },
  "FLDTLB_LOAD_MISS" =>
  {
    Code     => 0x10,
    Umask    => 0x03,
    AltCodes => [],
    Category => "FLDTLB Events",
    Desc     => "FLD TLB miss",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x10,
          Umask    => 0x03,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD TLB miss",
       },
       "INT" =>
       {
          Code     => 0x10,
          Umask    => 0x04,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD TLB miss, integer loads",
       },
       "RSE" =>
       {
          Code     => 0x10,
          Umask    => 0x05,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD TLB miss, RSE load",
       },
     },
  },
  "FLD_FILL" =>
  {
    Code     => 0x10,
    Umask    => 0x01,
    AltCodes => [],
    Category => "FLD Events",
    Desc     => "FLD fill",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0xaaaa0,
    Defn     => "",
  },
  "FLD_FILL_CANCEL" =>
  {
    Code     => 0x0f,
    Umask    => 0x0d,
    AltCodes => [],
    Category => "FLD Events",
    Desc     => "FLD fill cancels",
    AltCat   => "",
    Defn     => "",
    Notes    => "FLD fill cancelled",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x0f,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD fill cancels",
       },
       "MLD" =>
       {
          Code     => 0x0f,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD MLD fill cancels",
       },
       "INFAB" =>
       {
          Code     => 0x0f,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD in FAB fill cancels",
       },
       "POSTFAB" =>
       {
          Code     => 0x10,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD post FAB fill requests",
       },
     },
  },
  "FLD_FILL_LRU" =>
  {
    Code     => 0x10,
    Umask    => 0x02,
    AltCodes => [],
    Category => "FLD Events",
    Desc     => "FLD fill NRU",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x55550,
    Defn     => "",
  },
  "FLD_FILL_REQ" =>
  {
    Code     => 0x0f,
    Umask    => 0x08,
    AltCodes => [],
    Category => "FLD Events",
    Desc     => "FLD fill requests",
    AltCat   => "",
    Defn     => "",
    Notes    => "FLD fill requests",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x0f,
          Umask    => 0x08,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD fill requests",
       },
       "LOAD_INT" =>
       {
          Code     => 0x0f,
          Umask    => 0x09,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD int load fill requests",
       },
       "LOAD_RSE" =>
       {
          Code     => 0x0f,
          Umask    => 0x0a,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD rse load fill requests",
       },
       "LFETCH" =>
       {
          Code     => 0x0f,
          Umask    => 0x0b,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD lfetch fill requests",
       },
       "HW_PREF" =>
       {
          Code     => 0x0f,
          Umask    => 0x0c,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD HW prefetch fill requests",
       },
     },
  },
  "FLD_HINT_NOALLOC" =>
  {
    Code     => 0x0f,
    Umask    => 0x06,
    AltCodes => [],
    Category => "FLD Events",
    Desc     => "FLD no alloc hinted",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x55550,
    Defn     => "",
    Notes    => "FLD fill not requested due to hint",
  },
  "FLD_HINT_NO_HWPREF" =>
  {
    Code     => 0x0d,
    Umask    => 0x08,
    AltCodes => [],
    Category => "FLD Events",
    Desc     => "FLD no HW prefetch hinted",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x55550,
    Defn     => "",
    Notes    => "FLD HWPF NOT inserted into DPFQ due to hint",
  },
  "FLD_HIT" =>
  {
    Code     => 0x0e,
    Umask    => 0x0f,
    AltCodes => [],
    Category => "FLD Events",
    Desc     => "FLD hits",
    AltCat   => "",
    Defn     => "",
    Notes    => "FLD hits (not predicted off or flushed)",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x0e,
          Umask    => 0x0f,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD hits",
       },
     },
  },
  "FLD_HWPREF_INS" =>
  {
    Code     => 0x0c,
    Umask    => 0x0b,
    AltCodes => [],
    Category => "DPF Events",
    Desc     => "Any FLD HW prefetch inserted",
    AltCat   => "",
    Defn     => "",
    Notes    => "FLD HWPF inserted into DPFQ",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x0c,
          Umask    => 0x0b,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Any FLD HW prefetch inserted",
       },
       "CANCEL_FILL" =>
       {
          Code     => 0x0c,
          Umask    => 0x0c,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD HW prefetch inserted due to cancelled fill",
       },
       "DTLB_MISS" =>
       {
          Code     => 0x0c,
          Umask    => 0x0d,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD HW prefetch inserted due to DTB miss",
       },
       "FLDTLB_MISS" =>
       {
          Code     => 0x0c,
          Umask    => 0x0e,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD HW prefetch inserted due to FLD TLB miss",
       },
       "NEIGHBOR" =>
       {
          Code     => 0x0c,
          Umask    => 0x0f,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD HW prefetch inserted due to neighbor line",
       },
       "STORE_ALIAS" =>
       {
          Code     => 0x0d,
          Umask    => 0x00,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD HW prefetch inserted due to store alias",
       },
       "OZQ_FULL" =>
       {
          Code     => 0x0d,
          Umask    => 0x01,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD HW prefetch inserted due to OZQ full",
       },
       "FLUSH_DST" =>
       {
          Code     => 0x0d,
          Umask    => 0x02,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD HW prefetch inserted due to flush dest",
       },
       "ACQ_PEND" =>
       {
          Code     => 0x0d,
          Umask    => 0x03,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD HW prefetch inserted due to acquire pending",
       },
       "REL_OP" =>
       {
          Code     => 0x0d,
          Umask    => 0x04,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD HW prefetch inserted due to release op",
       },
       "DTLB_MISS_LFETCH" =>
       {
          Code     => 0x0d,
          Umask    => 0x05,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD HW prefetch inserted due to lfetch DTB miss",
       },
       "FLDTLB_MISS_LFETCH" =>
       {
          Code     => 0x0d,
          Umask    => 0x06,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD HW prefetch inserted due to lfetch FLD TLB miss",
       },
       "OZQ_FULL_LFETCH" =>
       {
          Code     => 0x0d,
          Umask    => 0x07,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD HW prefetch inserted due to lfetch OZQ full",
       },
     },
  },
  "FLD_LINE_DEMOTE" =>
  {
    Code     => 0x0f,
    Umask    => 0x07,
    AltCodes => [],
    Category => "FLD Events",
    Desc     => "FLD line demoted",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0xaaaa0,
    Defn     => "",
    Notes    => "FLD cache line demoted to NRU due to hint",
  },
  "FLD_LOAD" =>
  {
    Code     => 0x0e,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "FLD Events",
    Desc     => "FLD loads",
    AltCat   => "",
    Defn     => "",
    Notes    => "Loads serviced by FLD (not predicted off or flushed)",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x0e,
          Umask    => 0x0a,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD loads",
       },
       "INT" =>
       {
          Code     => 0x0e,
          Umask    => 0x0b,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD integer loads",
       },
     },
  },
  "FLD_LOAD_MISS" =>
  {
    Code     => 0x0e,
    Umask    => 0x0c,
    AltCodes => [],
    Category => "FLD Events",
    Desc     => "FLD load misses",
    AltCat   => "",
    Defn     => "",
    Notes    => "Load misses serviced by FLD (not predicted off or flushed)",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x0e,
          Umask    => 0x0c,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD load misses",
       },
       "INT" =>
       {
          Code     => 0x0e,
          Umask    => 0x0d,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD integer load misses",
       },
       "RSE" =>
       {
          Code     => 0x0e,
          Umask    => 0x0e,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD rse load misses",
       },
     },
  },
  "FLD_SPEC_INVAL" =>
  {
    Code     => 0x0f,
    Umask    => 0x00,
    AltCodes => [],
    Category => "FLD Events",
    Desc     => "FLD spec invalidates",
    AltCat   => "",
    Defn     => "",
    Notes    => "speculative invalidations of FLD cache lines",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x0f,
          Umask    => 0x00,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD spec invalidates",
       },
       "INST" =>
       {
          Code     => 0x0f,
          Umask    => 0x01,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD spec invalidates due to instructions",
       },
       "FLUSH_DST" =>
       {
          Code     => 0x0f,
          Umask    => 0x02,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD spec invalidates due to flush dest",
       },
       "SNOOP" =>
       {
          Code     => 0x0f,
          Umask    => 0x03,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 1,
          DRF      => 1,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD spec invalidates due to snoops",
       },
     },
  },
  "FLITLB_INSERT_HPW" =>
  {
    Code     => 0x86,
    Umask    => 0x0f,
    AltCodes => [],
    Category => "FLITLB Events",
    Desc     => "FLI HPW insert",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0xa0aa0,
    Defn     => "",
  },
  "FLITLB_MISS" =>
  {
    Code     => 0x86,
    Umask    => 0x0d,
    AltCodes => [],
    Category => "FLITLB Events",
    Desc     => "FLI TLB miss",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0xa0aa0,
    Defn     => "",
  },
  "FLI_FETCH_JIT_HIT" =>
  {
    Code     => 0x86,
    Umask    => 0x0b,
    AltCodes => [],
    Category => "FLI Events",
    Desc     => "FLI demand fetch ISB hit",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0xa0aa0,
    Defn     => "",
    Notes    => "\"Just-in-time\" instruction fetch hitting fill data",
  },
  "FLI_FETCH_RAB_HIT" =>
  {
    Code     => 0x86,
    Umask    => 0x09,
    AltCodes => [],
    Category => "FLI Events",
    Desc     => "FLI demand fetch RAB hit",
    AltCat   => "",
    Defn     => "",
    Notes    => "Instruction fetch hitting in RAB",
    Subcat  =>
    {
       "DMND" =>
       {
          Code     => 0x86,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "FLI demand fetch RAB hit",
       },
       "PREF" =>
       {
          Code     => 0x86,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "FLI prefetch fetch RAB hit",
       },
     },
  },
  "FLI_FILL" =>
  {
    Code     => 0x85,
    Umask    => 0x0c,
    AltCodes => [],
    Category => "FLI Events",
    Desc     => "FLI fills",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0x50550,
    Defn     => "",
    Notes    => "L1 Instruction Cache Fills",
  },
  "FLI_INST_INSERT_RAB" =>
  {
    Code     => 0x87,
    Umask    => 0x02,
    AltCodes => [],
    Category => "FLI Events",
    Desc     => "FLI instr fetch inserts REB(TBD)",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0x50550,
    Defn     => "",
  },
  "FLI_PREF_STALL" =>
  {
    Code     => 0x86,
    Umask    => 0x01,
    AltCodes => [],
    Category => "FLI Events",
    Desc     => "FLI Prefetch stall",
    AltCat   => "",
    Defn     => "",
    Notes    => "Why prefetch pipeline is stalled?",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x86,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "FLI Prefetch stall",
       },
       "FLOW" =>
       {
          Code     => 0x86,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "FLI Prefetch stall due to flow",
       },
     },
  },
  "FLI_PURGE" =>
  {
    Code     => 0x86,
    Umask    => 0x05,
    AltCodes => [],
    Category => "FLI Events",
    Desc     => "FLI TLB purges",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0xa0aa0,
    Defn     => "",
    Notes    => "L1ITLB purges handled by L1I",
  },
  "FLI_PVAB_OVERFLOW" =>
  {
    Code     => 0x86,
    Umask    => 0x0c,
    AltCodes => [],
    Category => "FLI Events",
    Desc     => "FLI PVAB lost",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0x50550,
    Defn     => "",
    Notes    => "PVAB overflow",
  },
  "FLI_RAB_ALMOST_FULL" =>
  {
    Code     => 0x86,
    Umask    => 0x08,
    AltCodes => [],
    Category => "FLI Events",
    Desc     => "FLI RAB almost full",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0x50550,
    Defn     => "",
    Notes    => "Is RAB almost full? - more spec in psn",
  },
  "FLI_RAB_FULL" =>
  {
    Code     => 0x86,
    Umask    => 0x07,
    AltCodes => [],
    Category => "FLI Events",
    Desc     => "FLI RAB full",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0xa0aa0,
    Defn     => "",
    Notes    => "Is RAB full?",
  },
  "FLI_READ" =>
  {
    Code     => 0x85,
    Umask    => 0x09,
    AltCodes => [],
    Category => "FLI Events",
    Desc     => "FLI reads all",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x85,
          Umask    => 0x09,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "FLI reads all",
       },
       "PREF" =>
       {
          Code     => 0x85,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "FLI prefetch requests",
       },
       "DMND" =>
       {
          Code     => 0x85,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "FLI demand fetch reads",
       },
       "SNOOP" =>
       {
          Code     => 0x86,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "FLI snoop requests",
       },
       "SNOOP_HIT" =>
       {
          Code     => 0x86,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "FLI snoop hits",
       },
     },
  },
  "FLI_READ_MISS" =>
  {
    Code     => 0x85,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "FLI Events",
    Desc     => "FLI read misses all",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x85,
          Umask    => 0x0a,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "FLI read misses all",
       },
       "PREF" =>
       {
          Code     => 0x85,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "FLI prefetch request misses",
       },
       "DMND" =>
       {
          Code     => 0x85,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "FLI demand fetch misses",
       },
     },
  },
  "FLI_STEPPING" =>
  {
    Code     => 0x87,
    Umask    => 0x03,
    AltCodes => [],
    Category => "FLI Events",
    Desc     => "FLI demand pipe is stepping",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0xa0aa0,
    Defn     => "",
  },
  "FLI_STREAM_PREF" =>
  {
    Code     => 0x86,
    Umask    => 0x06,
    AltCodes => [],
    Category => "FLI Events",
    Desc     => "FLI stream prefetch requests",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0x50550,
    Defn     => "",
    Notes    => "L1 Instruction Cache line prefetch requests",
  },
  "FP_DENORMAL" =>
  {
    Code     => 0x85,
    Umask    => 0x06,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "FPU DENORM causing REPLAY",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x50550,
    Defn     => "",
  },
  "FP_FALSE_SIR" =>
  {
    Code     => 0x85,
    Umask    => 0x04,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "FPU FALSE SIR",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x50550,
    Defn     => "",
    Notes    => "SIR stall without a trap",
  },
  "FP_FCHKF_FAIL" =>
  {
    Code     => 0x85,
    Umask    => 0x03,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "FPU FAILEDFCHKF",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0xa0aa0,
    Defn     => "",
    Notes    => "Failed fchkf",
  },
  "FP_FLOP" =>
  {
    Code     => 0x00,
    Umask    => 0x0c,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "Floating point weighed flop count",
    AltCat   => "",
    MaxInc   => 4,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x55550,
    Defn     => "",
  },
  "FP_FLUSH_TO_ZERO" =>
  {
    Code     => 0x85,
    Umask    => 0x07,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "FPU flush to zero RES",
    AltCat   => "",
    Defn     => "",
    Notes    => "FP Result Flushed to Zero",
    Subcat  =>
    {
       "FTZ_REAL" =>
       {
          Code     => 0x85,
          Umask    => 0x07,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "FPU flush to zero RES",
       },
       "FTZ_POSS" =>
       {
          Code     => 0x85,
          Umask    => 0x08,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "FPU any flush to zero RES",
       },
     },
  },
  "FP_TRUE_SIR" =>
  {
    Code     => 0x85,
    Umask    => 0x05,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "FPU TRUE SIR",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0xa0aa0,
    Defn     => "",
    Notes    => "SIR stall asserted and leads to a trap",
  },
  "IA64_INST_RETIRED" =>
  {
    Code     => 0x00,
    Umask    => 0x05,
    AltCodes => [],
    Category => "Basic Events",
    Desc     => "ALIAS for RETIRED_INST_TAGGED.IAM0_OPM0",
    AltCat   => "",
    MaxInc   => 12,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0xffff0,
    Defn     => "",
    Notes    => "alias for RETIRED_INST_TAGGED.IAM0_OPM0",
  },
  "IBL_ISSUE" =>
  {
    Code     => 0x06,
    Umask    => 0x08,
    AltCodes => [],
    Category => "Dispersal Events",
    Desc     => "Syllables dispersed at IBD",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x06,
          Umask    => 0x08,
          MaxInc   => 12,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Syllables dispersed at IBD",
       },
       "M_PIPE" =>
       {
          Code     => 0x06,
          Umask    => 0x09,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "M pipe syllables dispersed at IBD",
       },
     },
  },
  "IBL_ISSUE_LOST_BW" =>
  {
    Code     => 0x07,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "Dispersal Events",
    Desc     => "Issue syllables lost",
    AltCat   => "",
    Defn     => "",
    Notes    => "Syllables prevented from potentially issuing",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x07,
          Umask    => 0x0a,
          MaxInc   => 11,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Issue syllables lost",
       },
       "POWER" =>
       {
          Code     => 0x07,
          Umask    => 0x0b,
          MaxInc   => 11,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Issue syllables lost due to power",
       },
       "DROOP" =>
       {
          Code     => 0x07,
          Umask    => 0x0c,
          MaxInc   => 11,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Issue syllables lost due to power",
       },
       "ASYM_I" =>
       {
          Code     => 0x07,
          Umask    => 0x0d,
          MaxInc   => 11,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Issue syllables lost due to I pipe asymmetry",
       },
       "ASYM_M" =>
       {
          Code     => 0x07,
          Umask    => 0x0e,
          MaxInc   => 11,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Issue syllables lost due to M pipe asymmetry",
       },
       "FLD_DMND_M0" =>
       {
          Code     => 0x07,
          Umask    => 0x0f,
          MaxInc   => 11,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Issue syllables lost due to FLD request for M0",
       },
       "FLD_DMND_M1" =>
       {
          Code     => 0x08,
          Umask    => 0x00,
          MaxInc   => 11,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Issue syllables lost due to FLD request for M1",
       },
       "OVRSUB_A" =>
       {
          Code     => 0x08,
          Umask    => 0x01,
          MaxInc   => 11,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Issue syllables lost due to A pipe oversubscription",
       },
       "OVRSUB_F" =>
       {
          Code     => 0x08,
          Umask    => 0x02,
          MaxInc   => 11,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Issue syllables lost due to F pipe oversubscription",
       },
       "OVRSUB_I" =>
       {
          Code     => 0x08,
          Umask    => 0x03,
          MaxInc   => 11,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Issue syllables lost due to I pipe oversubscription",
       },
       "OVRSUB_M" =>
       {
          Code     => 0x08,
          Umask    => 0x04,
          MaxInc   => 11,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Issue syllables lost due to M pipe oversubscription",
       },
       "STRUCT" =>
       {
          Code     => 0x08,
          Umask    => 0x05,
          MaxInc   => 11,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Issue syllables lost due to structural hazard",
       },
       "9PLUS3" =>
       {
          Code     => 0x08,
          Umask    => 0x06,
          MaxInc   => 11,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Issue syllables lost due to bundle restrictions",
       },
     },
  },
  "IBL_ISSUE_STOP" =>
  {
    Code     => 0x06,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "Dispersal Events",
    Desc     => "Issue stop due to issue stall or instruction buffer empty",
    AltCat   => "",
    Defn     => "",
    Notes    => "Stalled, or nothing valid to issue",
    Subcat  =>
    {
       "NONE" =>
       {
          Code     => 0x06,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Issue stop due to issue stall or instruction buffer empty",
       },
       "REPLAY" =>
       {
          Code     => 0x06,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Issue stop due to replay boundary",
       },
       "EXPLICIT" =>
       {
          Code     => 0x06,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Issue stop due to explicit stop",
       },
       "POWER" =>
       {
          Code     => 0x06,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Issue stop due to power",
       },
       "DROOP" =>
       {
          Code     => 0x06,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Issue stop due to droop",
       },
       "ASYM_I" =>
       {
          Code     => 0x06,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Issue stop due to I pipe asymmetry",
       },
       "ASYM_M" =>
       {
          Code     => 0x07,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Issue stop due to M pipe asymmetry",
       },
       "FLD_DMND_M0" =>
       {
          Code     => 0x07,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Issue stop due to FLD request for M0",
       },
       "FLD_DMND_M1" =>
       {
          Code     => 0x07,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Issue stop due to FLD request for M1",
       },
       "OVRSUB_A" =>
       {
          Code     => 0x07,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Issue stop due to I pipe oversubscription",
       },
       "OVRSUB_F" =>
       {
          Code     => 0x07,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Issue stop due to M pipe oversubscription",
       },
       "OVRSUB_I" =>
       {
          Code     => 0x07,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Issue stop due to F pipe oversubscription",
       },
       "OVRSUB_M" =>
       {
          Code     => 0x07,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Issue stop due to A pipe oversubscription",
       },
       "STRUCT" =>
       {
          Code     => 0x07,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Issue stop due to structural hazard",
       },
       "BUNDLE" =>
       {
          Code     => 0x07,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Issue stop due to lack of bundles",
       },
       "9PLUS3" =>
       {
          Code     => 0x07,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Issue stop due to bundle restrictions",
       },
     },
  },
  "INTERRUPT_EVENT" =>
  {
    Code     => 0x01,
    Umask    => 0x0f,
    AltCodes => [],
    Category => "System Events",
    Desc     => "IVA interrupt event",
    AltCat   => "",
    Defn     => "",
    Notes    => "IVA Based Interrupts Taken to a Preprogrammed IVA Offset",
    Subcat  =>
    {
       "MASKED" =>
       {
          Code     => 0x01,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "IVA interrupt event",
       },
       "UNMASKED" =>
       {
          Code     => 0x02,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Unmasked IVA interrupt event",
       },
     },
  },
  "LLC_REF" =>
  {
    Code     => 0xc4,
    Umask    => 0x00,
    AltCodes => [],
    Category => "LLC Events",
    Desc     => "Request satisfied by non-RAM system address (PRI->RIL) (DRQ/FRQ misses only)",
    AltCat   => "",
    Defn     => "",
    Notes    => "LLC miss to system address",
    Subcat  =>
    {
       "SYS_ANY" =>
       {
          Code     => 0xc4,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x55500,
          Core     => "",
          Desc     => "Request satisfied by non-RAM system address (PRI->RIL) (DRQ/FRQ misses only)",
       },
     },
  },
  "LLC_REF_HIT" =>
  {
    Code     => 0xc3,
    Umask    => 0x0c,
    AltCodes => [],
    Category => "LLC Events",
    Desc     => "Any LLC hit (PRI->RIL) (DRQ/FRQ misses only)",
    AltCat   => "",
    Defn     => "",
    Notes    => "LLC hit",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xc3,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x55500,
          Core     => "",
          Desc     => "Any LLC hit (PRI->RIL) (DRQ/FRQ misses only)",
       },
       "NO_SNOOP" =>
       {
          Code     => 0xc3,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "LLC hit requiring no snoops (PRI->RIL) (DRQ/FRQ misses only)",
       },
       "SNOOP" =>
       {
          Code     => 0xc3,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "LLC hit requiring snoops, not resulting in forwarded data (PRI->RIL) (DRQ/FRQ misses only)",
       },
       "SNOOP_FWD" =>
       {
          Code     => 0xc3,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "LLC hit requiring snoops, resulting in forwarded data (PRI->RIL) (DRQ/FRQ misses only)",
       },
     },
  },
  "LLC_REF_MISS" =>
  {
    Code     => 0xc4,
    Umask    => 0x01,
    AltCodes => [],
    Category => "LLC Events",
    Desc     => "Any LLC miss (PRI->RIL) (DRQ/FRQ misses only)",
    AltCat   => "",
    Defn     => "",
    Notes    => "LLC miss",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xc4,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0xaaa00,
          Core     => "",
          Desc     => "Any LLC miss (PRI->RIL) (DRQ/FRQ misses only)",
       },
       "MEM_LCL_ANY" =>
       {
          Code     => 0xc4,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Miss to local RAM (PRI->RIL) (DRQ/FRQ misses only)",
       },
       "MEM_LCL_NO_SNOOP" =>
       {
          Code     => 0xc4,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Miss to local RAM requiring no snoops (PRI->RIL) (DRQ/FRQ misses only)",
       },
       "MEM_LCL_SNOOP" =>
       {
          Code     => 0xc4,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Miss to local RAM requiring snoops, not resulting in forwarded data (PRI->RIL) (DRQ/FRQ misses only)",
       },
       "MEM_LCL_SNOOP_FWD" =>
       {
          Code     => 0xc4,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Miss to local RAM requiring snoops, resulting in forwarded data (PRI->RIL) (DRQ/FRQ misses only)",
       },
       "MEM_RMT_ANY" =>
       {
          Code     => 0xc4,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Miss to remote RAM (PRI->RIL) (DRQ/FRQ misses only)",
       },
       "MEM_RMT_NO_SNOOP" =>
       {
          Code     => 0xc4,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Miss to remote RAM requiring no snoops (PRI->RIL) (DRQ/FRQ misses only)",
       },
       "MEM_RMT_SNOOP" =>
       {
          Code     => 0xc4,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Miss to remote RAM requiring snoops, not resulting in forwarded data (PRI->RIL) (DRQ/FRQ misses only)",
       },
       "MEM_RMT_SNOOP_FWD" =>
       {
          Code     => 0xc4,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Miss to remote RAM requiring snoops, resulting in forwarded data (PRI->RIL) (DRQ/FRQ misses only)",
       },
     },
  },
  "LLC_REF_MISS_DATA" =>
  {
    Code     => 0xc4,
    Umask    => 0x0b,
    AltCodes => [],
    Category => "LLC Events",
    Desc     => "Any data read or write that misses LLC (PRI->RIL) (DRQ misses only)",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xc4,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Any data read or write that misses LLC (PRI->RIL) (DRQ misses only)",
       },
       "READ" =>
       {
          Code     => 0xc4,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Any data read that misses LLC (PRI->RIL) (DRQ misses only)",
       },
     },
  },
  "LLC_REF_MISS_INST" =>
  {
    Code     => 0xc4,
    Umask    => 0x0d,
    AltCodes => [],
    Category => "LLC Events",
    Desc     => "Any instruction miss that misses LLC (PRI->RIL) (FRQ misses only)",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xc4,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Any instruction miss that misses LLC (PRI->RIL) (FRQ misses only)",
       },
       "PRIMARY" =>
       {
          Code     => 0xc4,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Any primary instruction miss that misses LLC (PRI->RIL) (FRQ misses only)",
       },
     },
  },
  "LLC_REF_UNKNOWN" =>
  {
    Code     => 0xc4,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "LLC Events",
    Desc     => "Hit/Miss response unknown/NA (DRQ/FRQ misses only)",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "F",
    RegRst   => 0x92400,
    Defn     => "",
    Notes    => "LLC miss to remote RAM, snoop, data forwarded",
  },
  "MLD_BWMODE_CYC" =>
  {
    Code     => 0xcd,
    Umask    => 0x06,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "Cycles MLD is in bandwidth mode",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0x49200,
    Defn     => "",
  },
  "MLD_BYPASS" =>
  {
    Code     => 0xcd,
    Umask    => 0x04,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "MLD op that succesfully bypassed",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "C",
    RegRst   => 0x92400,
    Defn     => "",
    Notes    => "These are ops that meet all the bypass criteria, but may or may not commit",
  },
  "MLD_BYPASS_ATTEMPT" =>
  {
    Code     => 0xcd,
    Umask    => 0x03,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "MLD op that attempted to bypass",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "C",
    RegRst   => 0x49200,
    Defn     => "",
  },
  "MLD_CYC_STALL" =>
  {
    Code     => 0xcd,
    Umask    => 0x08,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "Any MLD stall",
    AltCat   => "",
    Defn     => "",
    Notes    => "The stall events aren't mutually exclusive?  Sum >= \"any\"?",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xcd,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x55500,
          Core     => "",
          Desc     => "Any MLD stall",
       },
       "RW_BANK" =>
       {
          Code     => 0xcd,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Bank conflict betw P0 and older st",
       },
       "RAW" =>
       {
          Code     => 0xcd,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Bank conflict betw P0 and older st",
       },
       "SEMAPHORE" =>
       {
          Code     => 0xcd,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Semaphore stall (P0)",
       },
       "FILL_W" =>
       {
          Code     => 0xcd,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Conflict betw fill and older st (P0)",
       },
       "CRIT_BYP" =>
       {
          Code     => 0xcd,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Critical bypass conflict for P0",
       },
       "WB_FIFO" =>
       {
          Code     => 0xcd,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Write buffer FIFO full stall",
       },
       "TAG_ERR" =>
       {
          Code     => 0xce,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Tag error correction stall",
       },
       "HPW" =>
       {
          Code     => 0xcd,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "MLD stalled due to back to back HPW loads",
       },
       "SPLIT_WW_BANK" =>
       {
          Code     => 0xce,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Read-read Bank conflict betw P0 and P1",
       },
       "SPLIT_RR_BANK" =>
       {
          Code     => 0xce,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Write-write bank conflict betw P0 and P1",
       },
       "SPLIT_RW_BANK" =>
       {
          Code     => 0xce,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Bank conflict betw P1 and older store",
       },
       "SPLIT_RAW" =>
       {
          Code     => 0xce,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Bank conflict betw P1 and older store",
       },
       "SPLIT_OVERSUB" =>
       {
          Code     => 0xce,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Return port oversubscription (P1)",
       },
       "SPLIT_CRIT_BYP" =>
       {
          Code     => 0xce,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Critical bypass conflict for P1",
       },
     },
  },
  "MLD_FAB_COUNT" =>
  {
    Code     => 0xcf,
    Umask    => 0x08,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "Number of valid FAB entries",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "MSB" =>
       {
          Code     => 0xcf,
          Umask    => 0x08,
          MaxInc   => 8,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Number of valid FAB entries",
       },
       "LSB" =>
       {
          Code     => 0xcf,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Number of valid FAB entries",
       },
     },
  },
  "MLD_FAB_OVERFLOW" =>
  {
    Code     => 0xcd,
    Umask    => 0x01,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "MLD FAB overflowed",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "C",
    RegRst   => 0x92400,
    Defn     => "",
  },
  "MLD_FILL_MESI_STATE_BUDDY" =>
  {
    Code     => 0xcc,
    Umask    => 0x04,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "MLD fill op to non-crit buddy",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xcc,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "MLD fill op to non-crit buddy",
       },
       "E" =>
       {
          Code     => 0xcc,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x22200,
          Core     => "",
          Desc     => "MLD fill op to non-crit buddy with MESI=E",
       },
       "S" =>
       {
          Code     => 0xcc,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x44400,
          Core     => "",
          Desc     => "MLD fill op to non-crit buddy with MESI=S",
       },
       "I" =>
       {
          Code     => 0xcc,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x88800,
          Core     => "",
          Desc     => "MLD fill op to non-crit buddy with MESI=I",
       },
     },
  },
  "MLD_FILL_MESI_STATE_PRIMARY" =>
  {
    Code     => 0xcb,
    Umask    => 0x0f,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "MLD fill op to crit buddy",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xcb,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "MLD fill op to crit buddy",
       },
       "M" =>
       {
          Code     => 0xcc,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "MLD fill op to crit buddy with MESI=M",
       },
       "E" =>
       {
          Code     => 0xcc,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "MLD fill op to crit buddy with MESI=E",
       },
       "S" =>
       {
          Code     => 0xcc,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "MLD fill op to crit buddy with MESI=S",
       },
       "I" =>
       {
          Code     => 0xcc,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "F",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "MLD fill op to crit buddy with MESI=I",
       },
     },
  },
  "MLD_HINT_DEFER" =>
  {
    Code     => 0xcd,
    Umask    => 0x00,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "MLD ld.s w/miss deferred due to hint",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "C",
    RegRst   => 0x49200,
    Defn     => "",
  },
  "MLD_HINT_LRU" =>
  {
    Code     => 0xcc,
    Umask    => 0x0c,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "MLD NRU fill due to a hint",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "C",
    RegRst   => 0x24900,
    Defn     => "",
  },
  "MLD_HINT_NOALLOC" =>
  {
    Code     => 0xcc,
    Umask    => 0x0b,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "MLD no-allocate fill due to a hint",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "C",
    RegRst   => 0x92400,
    Defn     => "",
  },
  "MLD_HINT_NO_BUDDY" =>
  {
    Code     => 0xcc,
    Umask    => 0x0d,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "MLD fill w/o buddy due to a hint",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "C",
    RegRst   => 0x49200,
    Defn     => "",
  },
  "MLD_HINT_NO_HWPREF" =>
  {
    Code     => 0xcc,
    Umask    => 0x0e,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "MLD fill w/o hwpf due to a hint",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "C",
    RegRst   => 0x92400,
    Defn     => "",
  },
  "MLD_HINT_PREF_DROP" =>
  {
    Code     => 0xcc,
    Umask    => 0x0f,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "MLD lfetch w/miss dropped due to hint",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "C",
    RegRst   => 0x24900,
    Defn     => "",
  },
  "MLD_ISSUE_SRC" =>
  {
    Code     => 0xca,
    Umask    => 0x07,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "Any Valid MLD op",
    AltCat   => "",
    Defn     => "",
    Notes    => "Not tagged?",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xca,
          Umask    => 0x07,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaa00,
          Core     => "",
          Desc     => "Any Valid MLD op",
       },
       "BYPASS" =>
       {
          Code     => 0xca,
          Umask    => 0x08,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Valid Bypassed MLD op",
       },
       "OZQ" =>
       {
          Code     => 0xca,
          Umask    => 0x09,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Valid MLD op from OZQ",
       },
       "SMQ" =>
       {
          Code     => 0xca,
          Umask    => 0x0a,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Valid MLD op from SMQ",
       },
       "FAB" =>
       {
          Code     => 0xca,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Valid MLD op from FAB",
       },
       "SNOOP" =>
       {
          Code     => 0xca,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Valid MLD op from SNQ",
       },
     },
  },
  "MLD_LOAD" =>
  {
    Code     => 0xcb,
    Umask    => 0x04,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "Any Valid MLD ld issued from OZQ/bypass",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xcb,
          Umask    => 0x04,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55500,
          Core     => "",
          Desc     => "Any Valid MLD ld issued from OZQ/bypass",
       },
       "HIT" =>
       {
          Code     => 0xcb,
          Umask    => 0x05,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Valid MLD ld that hit MLD issued from OZQ/bypass",
       },
       "MISS" =>
       {
          Code     => 0xcb,
          Umask    => 0x06,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Valid MLD ld that missed MLD issued from OZQ/bypass",
       },
       "PRIMARY" =>
       {
          Code     => 0xcb,
          Umask    => 0x07,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Valid MLD ld that was a primary miss issued from OZQ/bypass",
       },
       "SECONDARY" =>
       {
          Code     => 0xcb,
          Umask    => 0x08,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Valid MLD ld that was a secondary miss issued from OZQ/bypass",
       },
     },
  },
  "MLD_LOST_BW" =>
  {
    Code     => 0xce,
    Umask    => 0x07,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "Invalid ops or stalls",
    AltCat   => "",
    Defn     => "",
    Notes    => "The lost BW events aren't mutually exclusive?  Sum >= \"any\"?",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xce,
          Umask    => 0x07,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0xaaa00,
          Core     => "",
          Desc     => "Invalid ops or stalls",
       },
       "OZQ_NOP" =>
       {
          Code     => 0xce,
          Umask    => 0x08,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Ordering or hazards prevented valid OZQ entries from issuing",
       },
       "OZQ_NOP_ACQ" =>
       {
          Code     => 0xce,
          Umask    => 0x09,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Outstanding acquire prevented valid OZQ entries from issuing",
       },
       "OZQ_FAB_FULL" =>
       {
          Code     => 0xce,
          Umask    => 0x0a,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Full FAB/WLB prevented valid OZQ entries from issuing",
       },
       "OZQ_SMQ_FULL" =>
       {
          Code     => 0xce,
          Umask    => 0x0b,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Full SMQ prevented valid OZQ entries from issuing",
       },
       "OZQ_FAB_PREEMPT" =>
       {
          Code     => 0xce,
          Umask    => 0x0c,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "FAB prevented valid OZQ entries from issuing",
       },
       "OZQ_SMQ_PREEMPT" =>
       {
          Code     => 0xce,
          Umask    => 0x0d,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "SMQ prevented valid OZQ entry from issuing",
       },
       "OZQ_SNOOP_PREEMPT" =>
       {
          Code     => 0xce,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Snoop prevented valid OZQ entry from issuing",
       },
       "FAB_NOP" =>
       {
          Code     => 0xce,
          Umask    => 0x0f,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Ready FAB entry did not issue",
       },
       "SMQ_NOP" =>
       {
          Code     => 0xcf,
          Umask    => 0x00,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Ready SMQ entry did not issue",
       },
       "SPLIT_BUBBLE" =>
       {
          Code     => 0xcf,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "MLD split stall forced P0 to be invalid",
       },
       "NOP_STALL" =>
       {
          Code     => 0xcf,
          Umask    => 0x02,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "MLD stall on invalid op",
       },
       "STALL" =>
       {
          Code     => 0xcf,
          Umask    => 0x03,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "MLD stall prevented valid ops from retiring",
       },
       "NOP" =>
       {
          Code     => 0xcf,
          Umask    => 0x04,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "No valid ops for MLD",
       },
     },
  },
  "MLD_NOALLOC_CASTOUT" =>
  {
    Code     => 0xcc,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "MLD no-allocate castout",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "C",
    RegRst   => 0x49200,
    Defn     => "",
  },
  "MLD_NOALLOC_FILL" =>
  {
    Code     => 0xcc,
    Umask    => 0x09,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "MLD no-allocate fill",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "C",
    RegRst   => 0x24900,
    Defn     => "",
  },
  "MLD_OZDATA_COUNT" =>
  {
    Code     => 0xcf,
    Umask    => 0x0f,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "Number of valid OZDATA entries",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "MSB" =>
       {
          Code     => 0xcf,
          Umask    => 0x0f,
          MaxInc   => 8,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Number of valid OZDATA entries",
       },
       "LSB" =>
       {
          Code     => 0xcf,
          Umask    => 0x0e,
          MaxInc   => 3,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Number of valid OZDATA entries",
       },
     },
  },
  "MLD_OZQ_COUNT" =>
  {
    Code     => 0xcf,
    Umask    => 0x06,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "Number of reserved OZQ entries",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "MSB" =>
       {
          Code     => 0xcf,
          Umask    => 0x06,
          MaxInc   => 8,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Number of reserved OZQ entries",
       },
       "LSB" =>
       {
          Code     => 0xcf,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Number of reserved OZQ entries",
       },
     },
  },
  "MLD_OZQ_INSERT" =>
  {
    Code     => 0xcd,
    Umask    => 0x02,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "MLD op inserted into OZQ (incl. bypasses)",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "C",
    RegRst   => 0x24900,
    Defn     => "",
    Notes    => "This includes ops that don't commit",
  },
  "MLD_OZQ_PREEMPTED" =>
  {
    Code     => 0xcd,
    Umask    => 0x05,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "Valid OZQ op was preempted by the SMQ, FAB or SNQ",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0x24900,
    Defn     => "",
  },
  "MLD_REF" =>
  {
    Code     => 0xca,
    Umask    => 0x0d,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "Any Valid MLD prefetch, ld, st or sem issued from OZQ/bypass",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xca,
          Umask    => 0x0d,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaa00,
          Core     => "",
          Desc     => "Any Valid MLD prefetch, ld, st or sem issued from OZQ/bypass",
       },
       "HIT" =>
       {
          Code     => 0xca,
          Umask    => 0x0e,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Valid MLD prefetch, ld, st or sem, hit MLD issued from OZQ/bypass",
       },
       "MISS" =>
       {
          Code     => 0xca,
          Umask    => 0x0f,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Valid MLD prefetch, ld, st or sem, missed MLD issued from OZQ/bypass",
       },
       "PRIMARY" =>
       {
          Code     => 0xcb,
          Umask    => 0x00,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Valid MLD prefetch, ld, st or sem, primary miss issued from OZQ/bypass",
       },
       "SECONDARY" =>
       {
          Code     => 0xcb,
          Umask    => 0x01,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Valid MLD prefetch, ld, st or sem, secondary miss issued from OZQ/bypass",
       },
       "SECONDARY_DROP" =>
       {
          Code     => 0xcb,
          Umask    => 0x02,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Valid MLD prefetch, droppped due to secondary miss issued from OZQ/bypass",
       },
       "UC_WC_STORE" =>
       {
          Code     => 0xcb,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Valid MLD st to UC or WC space",
       },
     },
  },
  "MLD_SMQ_COUNT" =>
  {
    Code     => 0xcf,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "Number of valid SMQ entries",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "MSB" =>
       {
          Code     => 0xcf,
          Umask    => 0x0a,
          MaxInc   => 8,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Number of valid SMQ entries",
       },
       "LSB" =>
       {
          Code     => 0xcf,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Number of valid SMQ entries",
       },
     },
  },
  "MLD_SMQ_PRIORITY" =>
  {
    Code     => 0xcd,
    Umask    => 0x07,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "MLD SMQ has priority over RIL issue",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0x92400,
    Defn     => "",
  },
  "MLD_SMQ_REF" =>
  {
    Code     => 0xcb,
    Umask    => 0x09,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "Any Valid MLD prefetch, ld, st or sem issued from SMQ",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xcb,
          Umask    => 0x09,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaa00,
          Core     => "",
          Desc     => "Any Valid MLD prefetch, ld, st or sem issued from SMQ",
       },
       "HIT" =>
       {
          Code     => 0xcb,
          Umask    => 0x0a,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Valid MLD prefetch, ld, st or sem, hit MLD issued from SMQ",
       },
       "MISS" =>
       {
          Code     => 0xcb,
          Umask    => 0x0b,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Valid MLD prefetch, ld, st or sem, missed MLD issued from SMQ",
       },
       "PRIMARY" =>
       {
          Code     => 0xcb,
          Umask    => 0x0c,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Valid MLD prefetch, ld, st or sem, primary miss issued from SMQ",
       },
       "SECONDARY" =>
       {
          Code     => 0xcb,
          Umask    => 0x0d,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Valid MLD prefetch, ld, st or sem, secondary miss issued from SMQ",
       },
       "SECONDARY_DROP" =>
       {
          Code     => 0xcb,
          Umask    => 0x0e,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Valid MLD prefetch, dropped due to secondary miss issued from SMQ",
       },
     },
  },
  "MLD_SNOOP_DEFER" =>
  {
    Code     => 0xcc,
    Umask    => 0x08,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "Deferred MLD snoop",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "C",
    RegRst   => 0x92400,
    Defn     => "",
  },
  "MLD_WCB_CREDIT" =>
  {
    Code     => 0xcf,
    Umask    => 0x0d,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "Number of reserved WCB entries",
    AltCat   => "",
    MaxInc   => 8,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0x49200,
    Defn     => "",
  },
  "MLD_WLB_COUNT" =>
  {
    Code     => 0xcf,
    Umask    => 0x0c,
    AltCodes => [],
    Category => "MLD Events",
    Desc     => "Number of reserved WLB entries",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "MSB" =>
       {
          Code     => 0xcf,
          Umask    => 0x0c,
          MaxInc   => 8,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Number of reserved WLB entries",
       },
       "LSB" =>
       {
          Code     => 0xcf,
          Umask    => 0x0b,
          MaxInc   => 3,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Number of reserved WLB entries",
       },
     },
  },
  "MLITLB_HPW_ABORTS" =>
  {
    Code     => 0x87,
    Umask    => 0x00,
    AltCodes => [],
    Category => "MLITLB Events",
    Desc     => "FLI HPW abort",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0x50550,
    Defn     => "",
  },
  "MLITLB_MISS" =>
  {
    Code     => 0x86,
    Umask    => 0x0e,
    AltCodes => [],
    Category => "MLITLB Events",
    Desc     => "FLI MLI TLB miss",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0x50550,
    Defn     => "",
  },
  "MLI_HIT_CONFLICT" =>
  {
    Code     => 0x84,
    Umask    => 0x0e,
    AltCodes => [],
    Category => "MLI Events",
    Desc     => "MLI hitcnflcnt all",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x84,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "MLI hitcnflcnt all",
       },
       "DMND" =>
       {
          Code     => 0x84,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "MLI hitcnflcnt demand",
       },
       "PREF" =>
       {
          Code     => 0x85,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "MLI hitcnflcnt prefetch",
       },
     },
  },
  "MLI_READ" =>
  {
    Code     => 0x83,
    Umask    => 0x0c,
    AltCodes => [],
    Category => "MLI Events",
    Desc     => "MLI read all: demand or prefetch",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY_ANY" =>
       {
          Code     => 0x83,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "MLI read all: demand or prefetch",
       },
       "ANY_DMND" =>
       {
          Code     => 0x83,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "MLI read hit demand",
       },
       "ANY_PREF" =>
       {
          Code     => 0x83,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "MLI read all prefetch",
       },
       "HIT_ANY" =>
       {
          Code     => 0x83,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "MLI read hit: demand or prefetch",
       },
       "HIT_DMND_NOLRU" =>
       {
          Code     => 0x84,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "MLI read hit demand",
       },
       "HIT_PREF_NOLRU" =>
       {
          Code     => 0x84,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "MLI read hit prefetch",
       },
       "HIT_DMND_LRU" =>
       {
          Code     => 0x84,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "MLI read hit demand",
       },
       "HIT_PREF_LRU" =>
       {
          Code     => 0x84,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "MLI read hit prefetch",
       },
       "MISS_ANY" =>
       {
          Code     => 0x84,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "MLI read miss: demand or prefetch",
       },
       "MISS_DMND" =>
       {
          Code     => 0x84,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "MLI read hit demand",
       },
       "MISS_PREF" =>
       {
          Code     => 0x84,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "MLI read miss prefetch",
       },
     },
  },
  "MLI_READ_UC" =>
  {
    Code     => 0x84,
    Umask    => 0x07,
    AltCodes => [],
    Category => "MLI Events",
    Desc     => "MLI UC read all",
    AltCat   => "",
    Defn     => "",
    Notes    => "This will fire for all UCs AND, when MLI is deconfigured, it indicates we had too many outstanding requests to one index.",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x84,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "MLI UC read all",
       },
       "DMND" =>
       {
          Code     => 0x84,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "MLI UC read demand",
       },
       "PREF" =>
       {
          Code     => 0x84,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "MLI UC read prefetch",
       },
     },
  },
  "MLI_RECIRCULATE" =>
  {
    Code     => 0x84,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "MLI Events",
    Desc     => "MLI recircnt all",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x84,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "MLI recircnt all",
       },
       "DMND" =>
       {
          Code     => 0x84,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "MLI recircnt demand",
       },
       "PREF" =>
       {
          Code     => 0x84,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "MLI recircnt prefetch",
       },
     },
  },
  "MLI_RETURN_LINE" =>
  {
    Code     => 0x86,
    Umask    => 0x00,
    AltCodes => [],
    Category => "FLI Events",
    Desc     => "FLI L1 lines ISB",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0x50550,
    Defn     => "",
    Notes    => "Bundles written from L2I into FE",
  },
  "MLI_SNOOP_HIT" =>
  {
    Code     => 0x85,
    Umask    => 0x02,
    AltCodes => [],
    Category => "MLI Events",
    Desc     => "MLI snphits",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0x50550,
    Defn     => "",
  },
  "MLI_SNOOP_INVAL_BLK_LOOKUP" =>
  {
    Code     => 0x84,
    Umask    => 0x0d,
    AltCodes => [],
    Category => "MLI Events",
    Desc     => "MLI invalidating snoop hold off lookup",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0xa0aa0,
    Defn     => "",
  },
  "MLI_SPEC_ABORT" =>
  {
    Code     => 0x85,
    Umask    => 0x01,
    AltCodes => [],
    Category => "MLI Events",
    Desc     => "MLI specabort",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0xa0aa0,
    Defn     => "",
  },
  "MT_BE_BGND_CYC_IN_STATE" =>
  {
    Code     => 0x14,
    Umask    => 0x03,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "BE thread in background in high unstalled state",
    AltCat   => "",
    Defn     => "",
    Notes    => "Cycles Thread in the Background with Specified Urgency",
    Subcat  =>
    {
       "HU" =>
       {
          Code     => 0x14,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaa20,
          Core     => "",
          Desc     => "BE thread in background in high unstalled state",
       },
       "HW" =>
       {
          Code     => 0x14,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x54550,
          Core     => "",
          Desc     => "BE thread in background in high stalled state",
       },
       "NU" =>
       {
          Code     => 0x14,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaa20,
          Core     => "",
          Desc     => "BE thread in background in nominal unstalled state",
       },
       "NW" =>
       {
          Code     => 0x14,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x54550,
          Core     => "",
          Desc     => "BE thread in background in nominal stalled state",
       },
       "LU" =>
       {
          Code     => 0x14,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaa20,
          Core     => "",
          Desc     => "BE thread in background in low unstalled state",
       },
       "LW" =>
       {
          Code     => 0x14,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x54550,
          Core     => "",
          Desc     => "BE thread in background in low stalled state",
       },
     },
  },
  "MT_BE_THRSW_ACTUAL_IN" =>
  {
    Code     => 0x13,
    Umask    => 0x02,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "BE thread switch in timed-out",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "TIMEOUT" =>
       {
          Code     => 0x13,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "BE thread switch in timed-out",
       },
       "MLDRTN" =>
       {
          Code     => 0x13,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "BE thread switch in MLD return",
       },
       "HPWINS" =>
       {
          Code     => 0x13,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "BE thread switch in HPW insert",
       },
       "IBQ_NOTEMPTY" =>
       {
          Code     => 0x13,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "BE thread switch in IBQ not empty",
       },
       "ALAT_INVAL" =>
       {
          Code     => 0x13,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "BE thread switch in ALAT invalidate",
       },
       "LP_EXIT" =>
       {
          Code     => 0x13,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "BE thread switch in LP exit",
       },
       "UNFAIR" =>
       {
          Code     => 0x13,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "BE thread switch in unfairness",
       },
     },
  },
  "MT_BE_THRSW_ACTUAL_OUT" =>
  {
    Code     => 0x12,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "BE thread switch out any",
    AltCat   => "",
    Defn     => "",
    Notes    => "Counts number of times the thread is switched out due to various causes.",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x12,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "BE thread switch out any",
       },
       "MLD_USE" =>
       {
          Code     => 0x12,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "BE thread switch out mld use",
       },
       "HPW_MISS" =>
       {
          Code     => 0x12,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "BE thread switch out HPW miss",
       },
       "IBQ_EMPTY" =>
       {
          Code     => 0x12,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "BE thread switch out IBQ empty",
       },
       "ATPAUSE" =>
       {
          Code     => 0x12,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "BE thread switch out hint \@pause",
       },
       "LP_ENTER" =>
       {
          Code     => 0x12,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "BE thread switch out LP enter",
       },
       "RFIX" =>
       {
          Code     => 0x13,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "BE thread switch out for rfi.x",
       },
       "INJ_DBG" =>
       {
          Code     => 0x13,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "BE thread switch out random/debug",
       },
     },
  },
  "MT_BE_THRSW_DISABLE" =>
  {
    Code     => 0x13,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "BE thread switch explicitly disables cycles",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "EXPL" =>
       {
          Code     => 0x13,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "BE thread switch explicitly disables cycles",
       },
       "IMPL" =>
       {
          Code     => 0x13,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "BE thread switch implicitly disables cycles",
       },
     },
  },
  "MT_BE_THRSW_DROP" =>
  {
    Code     => 0x13,
    Umask    => 0x09,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "BE dropped thread switch",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0xaaaa0,
    Defn     => "",
  },
  "MT_BE_THRSW_HOLD" =>
  {
    Code     => 0x13,
    Umask    => 0x0c,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "BE thread switch held cycles",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0x55550,
    Defn     => "",
  },
  "MT_BE_THRSW_STALL" =>
  {
    Code     => 0x13,
    Umask    => 0x0d,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "BE thread switch stall cycles",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x13,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "BE thread switch stall cycles",
       },
       "SWITCH" =>
       {
          Code     => 0x13,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "BE thread switch stall cycles, switch blocked, in switch",
       },
       "PIPE" =>
       {
          Code     => 0x13,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "BE thread switch stall cycles, switch blocked by pipeline",
       },
       "RSE" =>
       {
          Code     => 0x14,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "BE thread switch stall cycles, switch blocked by RSE",
       },
       "CRAB" =>
       {
          Code     => 0x14,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "BE thread switch stall cycles, switch blocked by CRAB",
       },
       "FLD" =>
       {
          Code     => 0x14,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "BE thread switch stall cycles, switch blocked by FLD",
       },
     },
  },
  "MT_BE_UNFAIR" =>
  {
    Code     => 0x14,
    Umask    => 0x09,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "Unfairness counter green state",
    AltCat   => "",
    Defn     => "",
    Notes    => "# cycles the unfair counter is in state",
    Subcat  =>
    {
       "GREEN" =>
       {
          Code     => 0x14,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Unfairness counter green state",
       },
       "YELLOW" =>
       {
          Code     => 0x14,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Unfairness counter yellow state",
       },
       "ORANGE" =>
       {
          Code     => 0x14,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Unfairness counter yellow state",
       },
       "RED" =>
       {
          Code     => 0x14,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Unfairness counter red state",
       },
     },
  },
  "MT_BE_UNFAIR_TRANSITION" =>
  {
    Code     => 0x15,
    Umask    => 0x00,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "Unfairness green 0 transitions",
    AltCat   => "",
    Defn     => "",
    Notes    => "Number of region transitions of the unfairness ctr",
    Subcat  =>
    {
       "GRN0" =>
       {
          Code     => 0x15,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Unfairness green 0 transitions",
       },
       "GRN2YLW" =>
       {
          Code     => 0x14,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Unfairness transitions green to yellow",
       },
       "YLW2ORN" =>
       {
          Code     => 0x14,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Unfairness transitions yellow to orange",
       },
       "ORN2RED" =>
       {
          Code     => 0x14,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "Unfairness transitions orange to red",
       },
     },
  },
  "MT_FE_BE_IN_SAME_THREAD" =>
  {
    Code     => 0x87,
    Umask    => 0x04,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "Cycles front and back end are in same thread",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "F",
    RegRst   => 0x50550,
    Defn     => "",
  },
  "MT_FE_BGND_CYC_IN_STATE" =>
  {
    Code     => 0x89,
    Umask    => 0x0e,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "BE thread in background with low urgency",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "LOW" =>
       {
          Code     => 0x89,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "BE thread in background with low urgency",
       },
       "NOMINAL" =>
       {
          Code     => 0x89,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "BE thread in background with nominal urgency",
       },
       "HIGH" =>
       {
          Code     => 0x8a,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "BE thread in background with high urgency",
       },
     },
  },
  "MT_FE_THRSW_ACTUAL_IN" =>
  {
    Code     => 0x87,
    Umask    => 0x09,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "Front end thread switch in due to IBQ not full",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "IBQ_NOTFULL" =>
       {
          Code     => 0x87,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end thread switch in due to IBQ not full",
       },
       "IBQ_EMPTY" =>
       {
          Code     => 0x87,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end thread switch in due to IBQ empty",
       },
       "MLI_WBRTN" =>
       {
          Code     => 0x87,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end thread switch in due to MLI write back return",
       },
       "MLI_UCRTN" =>
       {
          Code     => 0x87,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end thread switch in due to MLI UC return",
       },
       "BRQ_NON_BLK" =>
       {
          Code     => 0x88,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end thread switch in due to BRQ non blocking",
       },
     },
  },
  "MT_FE_THRSW_ACTUAL_OUT" =>
  {
    Code     => 0x87,
    Umask    => 0x06,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "FE thread switch out any",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x87,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "F",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "FE thread switch out any",
       },
       "TIMEOUT" =>
       {
          Code     => 0x87,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end thread switch out due to switch timeout",
       },
       "IBQ_FULL" =>
       {
          Code     => 0x87,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end thread switch out due to IBQ full",
       },
       "IBQ_NOTEMPTY" =>
       {
          Code     => 0x87,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end thread switch out due to IBQ not empty",
       },
       "MLI_WBMISS" =>
       {
          Code     => 0x87,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end thread switch out due to MLI wirte back miss",
       },
       "MLI_UCMISS" =>
       {
          Code     => 0x87,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end thread switch out due to MLI UC miss",
       },
       "BRQ_BLK" =>
       {
          Code     => 0x88,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end thread switch out due to BRQ blocking",
       },
       "HINT_BSWT" =>
       {
          Code     => 0x88,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end thread switch out due to hint bswt",
       },
       "BE_FOLLOW" =>
       {
          Code     => 0x88,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Front end thread switch out due to back-end follow",
       },
       "LOCKED" =>
       {
          Code     => 0x88,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Front end thread switch out due to locked to BE",
       },
     },
  },
  "MT_FE_THRSW_MISS_IN" =>
  {
    Code     => 0x88,
    Umask    => 0x06,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "FE missed thread switch in opportunity",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x88,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "FE missed thread switch in opportunity",
       },
       "IBQ_NOTFULL" =>
       {
          Code     => 0x88,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "qnfull",
       },
       "IBQ_EMPTY" =>
       {
          Code     => 0x88,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "qempty",
       },
       "MLI_WBRTN" =>
       {
          Code     => 0x88,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "mliwbrtn",
       },
       "MLI_UCRTN" =>
       {
          Code     => 0x88,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "mliucrtn_act",
       },
       "BRQ_NON_BLK" =>
       {
          Code     => 0x89,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "brqnblk",
       },
     },
  },
  "MT_FE_THRSW_MISS_OUT" =>
  {
    Code     => 0x88,
    Umask    => 0x05,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "FE missed thread switch out opportunity",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x88,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "FE missed thread switch out opportunity",
       },
       "TIMEOUT" =>
       {
          Code     => 0x88,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "tmout",
       },
       "IBQ_FULL" =>
       {
          Code     => 0x88,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "qfull",
       },
       "IBQ_NOTEMPTY" =>
       {
          Code     => 0x88,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "qnempty",
       },
       "MLI_WBMISS" =>
       {
          Code     => 0x88,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "mliwbmiss",
       },
       "MLI_UCMISS" =>
       {
          Code     => 0x88,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "mliucmiss",
       },
       "BRQ_BLK" =>
       {
          Code     => 0x89,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "brqblk",
       },
       "HINT_BSWT" =>
       {
          Code     => 0x89,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "hintbswt",
       },
       "BE_FOLLOW" =>
       {
          Code     => 0x89,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "BE follow",
       },
       "LOCKED" =>
       {
          Code     => 0x89,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "locked to BE",
       },
     },
  },
  "MT_FE_THRSW_STALL" =>
  {
    Code     => 0x89,
    Umask    => 0x05,
    AltCodes => [],
    Category => "Multithreading Events",
    Desc     => "Any",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x89,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Any",
       },
       "MTLCK" =>
       {
          Code     => 0x89,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "MT locked",
       },
       "EXPL" =>
       {
          Code     => 0x89,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Explicitly disabled",
       },
       "IMPL" =>
       {
          Code     => 0x89,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Implicitly disabled",
       },
       "BLK_ANY" =>
       {
          Code     => 0x89,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Switch blocked",
       },
       "BLK_IPC_MISS" =>
       {
          Code     => 0x89,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Switch blocked for IPC miss",
       },
       "BLK_IN_PROG" =>
       {
          Code     => 0x89,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Switch blocked, other switch in progress",
       },
       "BLK_FW_PROG" =>
       {
          Code     => 0x89,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x50550,
          Core     => "",
          Desc     => "Switch blocked, forward progress",
       },
       "BLK_THRESH" =>
       {
          Code     => 0x89,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xa0aa0,
          Core     => "",
          Desc     => "Switch blocked for threshold",
       },
     },
  },
  "M_ASYNC_OP_ISSUE" =>
  {
    Code     => 0x10,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "Dispersal Events",
    Desc     => "FLD asynchronous operation",
    AltCat   => "",
    Defn     => "",
    Notes    => "asynchronous operation injection into M-pipes",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x10,
          Umask    => 0x0a,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD asynchronous operation",
       },
       "NONE" =>
       {
          Code     => 0x10,
          Umask    => 0x0b,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD asynchronous operation none issued",
       },
       "SNOOP_PALKUP" =>
       {
          Code     => 0x10,
          Umask    => 0x0c,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD asynchronous operation snoop PA lookup",
       },
       "SNOOP" =>
       {
          Code     => 0x10,
          Umask    => 0x0d,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD asynchronous operation snoop",
       },
       "SNOOP_S" =>
       {
          Code     => 0x10,
          Umask    => 0x0e,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD asynchronous operation snoop shared",
       },
       "HPW_LOAD" =>
       {
          Code     => 0x10,
          Umask    => 0x0f,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD asynchronous operation HPW load",
       },
       "CRAB_RET" =>
       {
          Code     => 0x11,
          Umask    => 0x00,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD asynchronous operation CRAB return",
       },
       "HW_PREF" =>
       {
          Code     => 0x11,
          Umask    => 0x01,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD asynchronous operation HW prefetch",
       },
       "PAPURGE" =>
       {
          Code     => 0x11,
          Umask    => 0x02,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD asynchronous operation PA purge",
       },
       "VAMERR_VAPURGE" =>
       {
          Code     => 0x11,
          Umask    => 0x03,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD asynchronous operation VA purge",
       },
       "DTLBTRNSFR_TLBINSERT" =>
       {
          Code     => 0x11,
          Umask    => 0x04,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD asynchronous operation DTB transfer TLB insert",
       },
       "FLUSH_ST_INVAL" =>
       {
          Code     => 0x11,
          Umask    => 0x05,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD asynchronous operation flushed store invalidate",
       },
       "PAMERR_PAPURGE" =>
       {
          Code     => 0x11,
          Umask    => 0x06,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD asynchronous operation FLDTLBPAM error pa purge",
       },
       "VRNRIDVPN_PURGE" =>
       {
          Code     => 0x11,
          Umask    => 0x07,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD asynchronous operation VRN RID VPN purge",
       },
       "RIDVPN_PURGE" =>
       {
          Code     => 0x11,
          Umask    => 0x08,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD asynchronous operation RID VPN Purge",
       },
       "TLB_TSWITCH" =>
       {
          Code     => 0x11,
          Umask    => 0x09,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD asynchronous operation TLB thread switch",
       },
       "TSWITCH" =>
       {
          Code     => 0x11,
          Umask    => 0x0a,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD asynchronous operation thread switch",
       },
       "HPW_TLBINSERT" =>
       {
          Code     => 0x11,
          Umask    => 0x0b,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD asynchronous operation HPW TLB insert",
       },
       "HPW_FAULT" =>
       {
          Code     => 0x11,
          Umask    => 0x0c,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD asynchronous operation HPW fault",
       },
       "ITC_D" =>
       {
          Code     => 0x11,
          Umask    => 0x0d,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD asynchronous operation ITC.D",
       },
       "ITR_D" =>
       {
          Code     => 0x11,
          Umask    => 0x0e,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD asynchronous operation ITR.D",
       },
       "PTR_D" =>
       {
          Code     => 0x11,
          Umask    => 0x0f,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD asynchronous operation PTR.D",
       },
       "MOVTORR" =>
       {
          Code     => 0x12,
          Umask    => 0x00,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD asynchronous operation move to RR",
       },
       "MOVTOPKR" =>
       {
          Code     => 0x12,
          Umask    => 0x01,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD asynchronous operation move to PKR",
       },
       "PTC_L" =>
       {
          Code     => 0x12,
          Umask    => 0x02,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD asynchronous operation PTC.L",
       },
       "PTC_E" =>
       {
          Code     => 0x12,
          Umask    => 0x03,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD asynchronous operation PTC.E",
       },
       "PTC_G" =>
       {
          Code     => 0x12,
          Umask    => 0x04,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD asynchronous operation PTC.G",
       },
       "PTC_GA" =>
       {
          Code     => 0x12,
          Umask    => 0x05,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD asynchronous operation PTC.GA",
       },
       "SHOOTDOWN_G" =>
       {
          Code     => 0x12,
          Umask    => 0x06,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD asynchronous operation shootdown G",
       },
       "SHOOTDOWN_GA" =>
       {
          Code     => 0x12,
          Umask    => 0x07,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD asynchronous operation shootdown GA",
       },
       "RSE_STORE" =>
       {
          Code     => 0x12,
          Umask    => 0x08,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD asynchronous operation RSE store",
       },
       "RSE_LOAD" =>
       {
          Code     => 0x12,
          Umask    => 0x09,
          MaxInc   => 2,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD asynchronous operation RSE load",
       },
     },
  },
  "PREF_DROP" =>
  {
    Code     => 0x0d,
    Umask    => 0x09,
    AltCodes => [],
    Category => "DPF Events",
    Desc     => "HW prefetch dropped due to FLD TLB miss",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "FLDTLB_MISS" =>
       {
          Code     => 0x0d,
          Umask    => 0x09,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "HW prefetch dropped due to FLD TLB miss",
       },
       "DTLB_MISS" =>
       {
          Code     => 0x0d,
          Umask    => 0x0a,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "HW prefetch dropped due to DTB miss",
       },
       "FLD_HIT" =>
       {
          Code     => 0x0d,
          Umask    => 0x0b,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "HW prefetch dropped due to FLD hit",
       },
       "FLD_SECONDARY_MISS" =>
       {
          Code     => 0x0d,
          Umask    => 0x0c,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "HW prefetch dropped due to secondary miss",
       },
     },
  },
  "RETIRED_INST_BR" =>
  {
    Code     => 0x82,
    Umask    => 0x00,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "ALIAS for BR_PRED_DETAIL.ANY_ANY_PRED",
    AltCat   => "",
    MaxInc   => 3,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x50550,
    Defn     => "",
    Notes    => "alias for BR_PRED_DETAIL__ANY_ANY_PRED",
  },
  "RETIRED_INST_CC" =>
  {
    Code     => 0xc3,
    Umask    => 0x02,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "ALIAS for RIL_REQ_OTHER.CC",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x92400,
    Defn     => "",
    Notes    => "alias for RIL_REQ_OTHER.CC",
  },
  "RETIRED_INST_FC" =>
  {
    Code     => 0xc3,
    Umask    => 0x00,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "ALIAS for RIL_REQ_OTHER.FC",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x24900,
    Defn     => "",
    Notes    => "alias for RIL_REQ_OTHER.FC",
  },
  "RETIRED_INST_FCI" =>
  {
    Code     => 0xc3,
    Umask    => 0x01,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "ALIAS for RIL_REQ_OTHER.FCI",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x49200,
    Defn     => "",
    Notes    => "alias for RIL_REQ_OTHER.FCI",
  },
  "RETIRED_INST_FP" =>
  {
    Code     => 0x00,
    Umask    => 0x0b,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "Floating point ops count",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0xaaaa0,
    Defn     => "",
  },
  "RETIRED_INST_LD_FP" =>
  {
    Code     => 0x0d,
    Umask    => 0x0f,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "ALIAS for DATA_REF.LOAD_FP",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0xaaaa0,
    Defn     => "",
    Notes    => "alias for DATA_REF__LOAD_FP",
  },
  "RETIRED_INST_LD_INT" =>
  {
    Code     => 0x0d,
    Umask    => 0x0e,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "ALIAS for DATA_REF.LOAD_INT",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x55550,
    Defn     => "",
    Notes    => "alias for DATA_REF__LOAD_INT",
  },
  "RETIRED_INST_M" =>
  {
    Code     => 0x00,
    Umask    => 0x0d,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "M ops retired",
    AltCat   => "",
    Defn     => "",
    Notes    => "M-op retired",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x00,
          Umask    => 0x0d,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "M ops retired",
       },
       "MOVTODAHR" =>
       {
          Code     => 0x00,
          Umask    => 0x0e,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "M ops retired with DAHR update",
       },
       "ACQ" =>
       {
          Code     => 0x0f,
          Umask    => 0x04,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "FLD acquire ops",
       },
       "REL" =>
       {
          Code     => 0x0f,
          Umask    => 0x05,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "FLD release ops",
       },
       "MOVTOBSPST" =>
       {
          Code     => 0x0c,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "Data prefetch ASB invalidated by BSP store",
       },
     },
  },
  "RETIRED_INST_NOP" =>
  {
    Code     => 0x00,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "Nops retired",
    AltCat   => "",
    MaxInc   => 12,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x55550,
    Defn     => "",
    Notes    => "If noop sqashing is enabled this will include all noops, otherwise noops with qp=1",
  },
  "RETIRED_INST_PTCG" =>
  {
    Code     => 0xc3,
    Umask    => 0x04,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "ALIAS for RIL_REQ_OTHER.PTCG",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x49200,
    Defn     => "",
    Notes    => "alias for RIL_REQ_OTHER.PTCG",
  },
  "RETIRED_INST_RSE" =>
  {
    Code     => 0x15,
    Umask    => 0x07,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "RSE event retired",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0xaaaa0,
    Defn     => "",
    Notes    => "(RseLdFlAlWb2H & XpnCommit0Wb2H), RseCoverWb2H, RseCallWb2H, RseRetWb2H, RseRfiWb3H",
  },
  "RETIRED_INST_SEMAPHORE" =>
  {
    Code     => 0x0e,
    Umask    => 0x05,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "ALIAS for DATA_REF.SEMAPHORE",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0xaaaa0,
    Defn     => "",
    Notes    => "alias for DATA_REF__SEMAPHORE",
  },
  "RETIRED_INST_ST_FP" =>
  {
    Code     => 0x0e,
    Umask    => 0x02,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "ALIAS for DATA_REF.STORE_FP",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0x55550,
    Defn     => "",
    Notes    => "alias for DATA_REF__STORE_FP",
  },
  "RETIRED_INST_ST_INT" =>
  {
    Code     => 0x0e,
    Umask    => 0x01,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "ALIAS for DATA_REF.STORE_INT",
    AltCat   => "",
    MaxInc   => 2,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0xaaaa0,
    Defn     => "",
    Notes    => "alias for DATA_REF__STORE_INT",
  },
  "RETIRED_INST_TAGGED" =>
  {
    Code     => 0x00,
    Umask    => 0x05,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "Instructions retired, tag channel 0 qualified",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "IAM0_OPM0" =>
       {
          Code     => 0x00,
          Umask    => 0x05,
          MaxInc   => 12,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xffff0,
          Core     => "",
          Desc     => "Instructions retired, tag channel 0 qualified",
       },
       "IAM1_OPM1" =>
       {
          Code     => 0x00,
          Umask    => 0x06,
          MaxInc   => 12,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xffff0,
          Core     => "",
          Desc     => "Instructions retired, tag channel 1 qualified",
       },
       "IAM2_OPM0" =>
       {
          Code     => 0x00,
          Umask    => 0x07,
          MaxInc   => 12,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xffff0,
          Core     => "",
          Desc     => "Instructions retired, tag channel 2 qualified",
       },
       "IAM3_OPM1" =>
       {
          Code     => 0x00,
          Umask    => 0x08,
          MaxInc   => 12,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xffff0,
          Core     => "",
          Desc     => "Instructions retired, tag channel 3 qualified",
       },
     },
  },
  "RETIRED_PREDICATE_SQUASHED" =>
  {
    Code     => 0x00,
    Umask    => 0x09,
    AltCodes => [],
    Category => "Execution Events",
    Desc     => "Instructions retired with predicate off",
    AltCat   => "",
    MaxInc   => 12,
    IAR      => 1,
    DAR      => 0,
    DRF      => 0,
    OPC      => 1,
    MT       => "A",
    RegRst   => 0xaaaa0,
    Defn     => "",
    Notes    => "If noop squashing is disabled, this count will include noops with qp = 0",
  },
  "RIL_ADDRESS" =>
  {
    Code     => 0xc9,
    Umask    => 0x08,
    AltCodes => [],
    Category => "Debug Events",
    Desc     => "RIL DBG0 Address matcher detected a match",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "MATCH1" =>
       {
          Code     => 0xc9,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "C",
          RegRst   => 0xf0000,
          Core     => "",
          Desc     => "RIL DBG0 Address matcher detected a match",
       },
       "MATCH2" =>
       {
          Code     => 0xc9,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "C",
          RegRst   => 0xf0000,
          Core     => "",
          Desc     => "RIL DBG1 Address matcher detected a match",
       },
     },
  },
  "RIL_ARB_PRI_LOST" =>
  {
    Code     => 0xc6,
    Umask    => 0x00,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "An arbitrator for the AD ring lost arbitration (RIL->PRI)",
    AltCat   => "",
    Defn     => "",
    Notes    => "The AD arb events aren't mutually exclusive - their sum >= \"any\"",
    Subcat  =>
    {
       "AD" =>
       {
          Code     => 0xc6,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x11100,
          Core     => "",
          Desc     => "An arbitrator for the AD ring lost arbitration (RIL->PRI)",
       },
       "AD_FWD_PROG" =>
       {
          Code     => 0xc6,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x22200,
          Core     => "",
          Desc     => "One or more AD-ring aribtrators are in fwd-prog mode (RIL->PRI)",
       },
       "BL" =>
       {
          Code     => 0xc6,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x44400,
          Core     => "",
          Desc     => "An arbitrator for the BL ring lost arbitration (RIL->PRI)",
       },
       "BL_FWD_PROG" =>
       {
          Code     => 0xc6,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x88800,
          Core     => "",
          Desc     => "One or more BL-ring aribtrators are in fwd-prog mode (RIL->PRI)",
       },
     },
  },
  "RIL_BL_WRITE" =>
  {
    Code     => 0xc5,
    Umask    => 0x0c,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "Data sent from RIL on BL ring (RIL->PRI)",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xc5,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x55500,
          Core     => "",
          Desc     => "Data sent from RIL on BL ring (RIL->PRI)",
       },
       "WLB" =>
       {
          Code     => 0xc5,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Data sent from WLB on BL ring (RIL->PRI)",
       },
       "WLB_BOGUS" =>
       {
          Code     => 0xc5,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Bogus Data transactions sent (RIL->PRI)",
       },
       "SLB" =>
       {
          Code     => 0xc5,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Data sent from SLB on BL ring (RIL->PRI)",
       },
     },
  },
  "RIL_CBQ_EVICT" =>
  {
    Code     => 0xc5,
    Umask    => 0x02,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "CBQ is flushing due to a MLD signalling flush instruction (PRI->RIL)",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "WCB_FLUSH" =>
       {
          Code     => 0xc5,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "CBQ is flushing due to a MLD signalling flush instruction (PRI->RIL)",
       },
       "FULL" =>
       {
          Code     => 0xc5,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "CBQ is flushing due to being full (PRI->RIL)",
       },
     },
  },
  "RIL_CRDT_MLD_FDB_FULL" =>
  {
    Code     => 0xc6,
    Umask    => 0x0e,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "MLD FDB is out of credits (RIL->MLD)",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0x92400,
    Defn     => "",
  },
  "RIL_CRDT_MLD_FDB_FULL_BLK" =>
  {
    Code     => 0xc6,
    Umask    => 0x0f,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "MLD FDB is out of credits and data is pending (RIL->MLD)",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0x24900,
    Defn     => "",
  },
  "RIL_CRDT_PRI_BLK" =>
  {
    Code     => 0xc6,
    Umask    => 0x04,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "AD ring is blocked for all active requestors (RIL->PRI)",
    AltCat   => "",
    Defn     => "",
    Notes    => "The AD blocked events aren't mutually exclusive - their sum >= \"any\"",
    Subcat  =>
    {
       "AD_ALL" =>
       {
          Code     => 0xc6,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "AD ring is blocked for all active requestors (RIL->PRI)",
       },
       "AD_FRQ" =>
       {
          Code     => 0xc6,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x22200,
          Core     => "",
          Desc     => "AD ring is blocked for FRQ head (RIL->PRI)",
       },
       "AD_DRQ" =>
       {
          Code     => 0xc6,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x44400,
          Core     => "",
          Desc     => "AD ring is blocked for DRQ head (RIL->PRI)",
       },
       "AD_WRQ" =>
       {
          Code     => 0xc6,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x88800,
          Core     => "",
          Desc     => "AD ring is blocked for WRQ head (RIL->PRI)",
       },
       "AD_CBQ" =>
       {
          Code     => 0xc6,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x11100,
          Core     => "",
          Desc     => "AD ring is blocked for CBQ head (RIL->PRI)",
       },
       "AK_ALL" =>
       {
          Code     => 0xc6,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "AK ring is blocked for all active requestors (RIL->PRI)",
       },
       "BL_ALL" =>
       {
          Code     => 0xc6,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "BL ring is blocked for all active requestors (RIL->PRI)",
       },
       "BL_SNQ" =>
       {
          Code     => 0xc6,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x88800,
          Core     => "",
          Desc     => "BL ring is blocked for SNQ head (RIL->PRI)",
       },
       "BL_WRQ" =>
       {
          Code     => 0xc6,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x11100,
          Core     => "",
          Desc     => "BL ring is blocked for WRQ head (RIL->PRI)",
       },
       "BL_CBQ" =>
       {
          Code     => 0xc6,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x22200,
          Core     => "",
          Desc     => "BL ring is blocked for CBQ head (RIL->PRI)",
       },
     },
  },
  "RIL_CRDT_SNQ_BLK" =>
  {
    Code     => 0xc7,
    Umask    => 0x00,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "Snoops ready but blocked for any reason into the core (RIL->PRI)",
    AltCat   => "",
    Defn     => "",
    Notes    => "The snoop blocked events aren't mutually exclusive - their sum >= \"any\"",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xc7,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x55500,
          Core     => "",
          Desc     => "Snoops ready but blocked for any reason into the core (RIL->PRI)",
       },
       "HALT" =>
       {
          Code     => 0xc7,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x22200,
          Core     => "",
          Desc     => "Snoops blocked -> halt.dg or diag block (RIL->CORE)",
       },
       "SRLZ" =>
       {
          Code     => 0xc7,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x44400,
          Core     => "",
          Desc     => "Snoops blocked -> no pipelined snoops (RIL->CORE)",
       },
       "MLI_FWD_PROG" =>
       {
          Code     => 0xc7,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x88800,
          Core     => "",
          Desc     => "Snoops blocked -> MLI Fwd Prog limit (RIL->CORE)",
       },
       "MLD_FWD_PROG" =>
       {
          Code     => 0xc7,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x11100,
          Core     => "",
          Desc     => "Snoops blocked -> MLD Fwd Prog limit (RIL->CORE)",
       },
       "MLI_OR_MLD_FWD_PROG" =>
       {
          Code     => 0xc7,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x22200,
          Core     => "",
          Desc     => "Snoops blocked -> MLI or MLD Fwd Prog limit (RIL->CORE)",
       },
       "MLI_FULL" =>
       {
          Code     => 0xc7,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x44400,
          Core     => "",
          Desc     => "Snoops blocked -> No FwdProg, blocked for MLI max in core (RIL->CORE)",
       },
       "MLD_FULL" =>
       {
          Code     => 0xc7,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x88800,
          Core     => "",
          Desc     => "Snoops blocked -> No FwdProg, blocked for MLD max in core (RIL->CORE)",
       },
       "MLI_OR_MLD_FULL" =>
       {
          Code     => 0xc7,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x11100,
          Core     => "",
          Desc     => "Snoops blocked -> No FwdProg, blocked for MLI or MLD max in core (RIL->CORE)",
       },
       "DFRQ" =>
       {
          Code     => 0xc7,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x22200,
          Core     => "",
          Desc     => "Snoops blocked -> No Mli/Mld Full, no credits for MLD DfrQ (RIL->CORE)",
       },
       "RSPQ" =>
       {
          Code     => 0xc7,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x44400,
          Core     => "",
          Desc     => "Snoops blocked -> No Mli/Mld Full, no credits for PRI RspQ (RIL->CORE)",
       },
       "SLB_DQ" =>
       {
          Code     => 0xc7,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x88800,
          Core     => "",
          Desc     => "Snoops blocked -> No Mli/Mld Full, no credits for SLB DataQ (RIL->CORE)",
       },
       "WLB_DQ" =>
       {
          Code     => 0xc7,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x11100,
          Core     => "",
          Desc     => "Snoops blocked -> No Mli/Mld Full, no credits for WLB DataQ (RIL->CORE)",
       },
       "ANY_Q_FULL" =>
       {
          Code     => 0xc7,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x22200,
          Core     => "",
          Desc     => "Snoops blocked -> No Mli/Mld Full, DFRQ/RSPQ/SLBQ/WLBQ full (RIL->CORE)",
       },
       "USEMANY_ANY" =>
       {
          Code     => 0xc9,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Snoops blocked -> blocked by UseMany",
       },
       "USEMANY_BYP" =>
       {
          Code     => 0xc9,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Snoops blocked -> blocked due to a snoop bypass",
       },
     },
  },
  "RIL_DATA_MATCH" =>
  {
    Code     => 0xc9,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "Debug Events",
    Desc     => "RIL DBG Data matcher detected a match",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0xf0000,
    Defn     => "",
  },
  "RIL_DATA_RETURN" =>
  {
    Code     => 0xc5,
    Umask    => 0x04,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "Data returning from PRI (PRI->RIL)",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "PRI_ANY" =>
       {
          Code     => 0xc5,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x55500,
          Core     => "",
          Desc     => "Data returning from PRI (PRI->RIL)",
       },
       "PRI_MLD" =>
       {
          Code     => 0xc5,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "MLD Fill return data from PRI (PRI->RIL)",
       },
       "MLD_ANY" =>
       {
          Code     => 0xc5,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Data sent to MLD (RIL->MLD)",
       },
       "MLD_CRIT" =>
       {
          Code     => 0xc5,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Crit-bypass data for WB returns sent to MLD (RIL->MLD)",
       },
       "EARLY_FILL_EM" =>
       {
          Code     => 0xc5,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Early-fill to E/M state (PRI->RIL)",
       },
       "EARLY_FILL_S" =>
       {
          Code     => 0xc5,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Early-fill to S state (PRI->RIL)",
       },
     },
  },
  "RIL_DBG" =>
  {
    Code     => 0xc9,
    Umask    => 0x05,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "DRQ Bypass cam-hit in the WRQ",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "DRQ_BYP_HIT_WRQ" =>
       {
          Code     => 0xc9,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "DRQ Bypass cam-hit in the WRQ",
       },
     },
  },
  "RIL_DRQ" =>
  {
    Code     => 0xc8,
    Umask    => 0x00,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "DRQ Issue Queue is empty",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "EMPTY" =>
       {
          Code     => 0xc8,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "DRQ Issue Queue is empty",
       },
       "LIMIT_HIT" =>
       {
          Code     => 0xc8,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "DRQ Issue Queue throttled due to hitting the issue limit",
       },
     },
  },
  "RIL_DRQ_PACE_BUBBLE" =>
  {
    Code     => 0xc8,
    Umask    => 0x0f,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "DRQ Pacing prevented DRQ from nominating (RIL->PRI)",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 1,
    DAR      => 1,
    DRF      => 1,
    OPC      => 1,
    MT       => "C",
    RegRst   => 0x92400,
    Defn     => "",
  },
  "RIL_DRQ_VALID" =>
  {
    Code     => 0xc8,
    Umask    => 0x09,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "DRQ Transactions in flight on PRI (count[5:2])",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "MSB" =>
       {
          Code     => 0xc8,
          Umask    => 0x09,
          MaxInc   => 8,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "DRQ Transactions in flight on PRI (count[5:2])",
       },
       "LSB" =>
       {
          Code     => 0xc8,
          Umask    => 0x0a,
          MaxInc   => 3,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "DRQ Transactions in flight on PRI (count[1:0])",
       },
     },
  },
  "RIL_FRQ" =>
  {
    Code     => 0xc7,
    Umask    => 0x0e,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "FRQ Issue Queue is empty",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "EMPTY" =>
       {
          Code     => 0xc7,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "FRQ Issue Queue is empty",
       },
       "LIMIT_HIT" =>
       {
          Code     => 0xc7,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "FRQ Issue Queue throttled due to hitting the issue limit",
       },
     },
  },
  "RIL_FRQ_VALID" =>
  {
    Code     => 0xc8,
    Umask    => 0x07,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "FRQ Transactions in flight on PRI (count[4:1])",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "MSB" =>
       {
          Code     => 0xc8,
          Umask    => 0x07,
          MaxInc   => 8,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "FRQ Transactions in flight on PRI (count[4:1])",
       },
       "LSB" =>
       {
          Code     => 0xc8,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "FRQ Transactions in flight on PRI (count[0])",
       },
     },
  },
  "RIL_INTERRUPT" =>
  {
    Code     => 0xc5,
    Umask    => 0x01,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "Incoming Interrupt (PRI->RIL)",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0x24900,
    Defn     => "",
  },
  "RIL_PRI_THROTTLE_ASSERTED" =>
  {
    Code     => 0xc9,
    Umask    => 0x00,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "AD issue throttling asserted",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0x24900,
    Defn     => "",
  },
  "RIL_PRI_THROTTLE_RECOV" =>
  {
    Code     => 0xc9,
    Umask    => 0x01,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "AD issue throttling is not asserted but still recovering",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0x49200,
    Defn     => "",
  },
  "RIL_REQ" =>
  {
    Code     => 0xc1,
    Umask    => 0x02,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "Any PRI Request sent on the AD ring (RIL->PRI)",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xc1,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55500,
          Core     => "",
          Desc     => "Any PRI Request sent on the AD ring (RIL->PRI)",
       },
     },
  },
  "RIL_REQ_ATTR" =>
  {
    Code     => 0xc3,
    Umask    => 0x0b,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "PRI Requests with the NTA bit set (RIL->PRI)",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "NTA" =>
       {
          Code     => 0xc3,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "PRI Requests with the NTA bit set (RIL->PRI)",
       },
     },
  },
  "RIL_REQ_OTHER" =>
  {
    Code     => 0xc2,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "Writebacks issued to PRI as WbMtoS (RIL->PRI)",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "WRTBCK_WRQ" =>
       {
          Code     => 0xc2,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Writebacks issued to PRI as WbMtoS (RIL->PRI)",
       },
       "WRQ_FC_FCI" =>
       {
          Code     => 0xc2,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "WRQ-issued FC/FCI transactions (RIL->PRI)",
       },
       "WRTBCK_WRQ_SKIP" =>
       {
          Code     => 0xc2,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "WRQ Writeback not issued (hit by snoop) (RIL->PRI)",
       },
       "WRQ_SKIP_LRUHINT" =>
       {
          Code     => 0xc2,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "WRQ LRUHnt not issued (too many outstanding) (RIL->PRI)",
       },
       "WRTBCK_MLD_EVICT" =>
       {
          Code     => 0xc2,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Writebacks due to an MLD capacity eviction issued from MLD (MLD->RIL)",
       },
       "WRTBCK_MLD_FC" =>
       {
          Code     => 0xc2,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Writebacks due to an FC instruction issued from MLD (MLD->RIL)",
       },
       "FC" =>
       {
          Code     => 0xc3,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "PRI FC transactions due to an FC instruction (RIL->PRI)",
       },
       "FCI" =>
       {
          Code     => 0xc3,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "PRI FCI transactions due to an FCI instruction (RIL->PRI)",
       },
       "CC" =>
       {
          Code     => 0xc3,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "CC operations issued to PRI (RIL->PRI)",
       },
       "DRQ_ANY" =>
       {
          Code     => 0xc3,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "MISC DRQ transactions (FC/FCI/CC) (RIL->PRI)",
       },
       "PTCG" =>
       {
          Code     => 0xc3,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "PTC.G transactions issued to PRI (RIL->PRI)",
       },
       "PTCG_PEND" =>
       {
          Code     => 0xc3,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "A PTC.G is outstanding (RIL)",
       },
       "LRUHINT_FROM_MLD" =>
       {
          Code     => 0xc3,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "LRUHints issued from MLD (MLD->RIL)",
       },
       "LRUHINT_ANY" =>
       {
          Code     => 0xc3,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "MLI or MLD LRUHints issued to PRI (RIL->PRI)",
       },
       "LRUHINT_MLD" =>
       {
          Code     => 0xc3,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "MLD LRUHints issued to PRI (RIL->PRI)",
       },
       "LRUHINT_MISS_ANY" =>
       {
          Code     => 0xc3,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "MLI or MLD LRUHints that miss in LLC (PRI->RIL)",
       },
       "LRUHINT_MISS_MLD" =>
       {
          Code     => 0xc3,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "MLD LRUHints that miss in LLC (PRI->RIL)",
       },
     },
  },
  "RIL_REQ_REF" =>
  {
    Code     => 0xc1,
    Umask    => 0x03,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "Any instruction or data reference (RIL->PRI)",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xc1,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaa00,
          Core     => "",
          Desc     => "Any instruction or data reference (RIL->PRI)",
       },
     },
  },
  "RIL_REQ_REF_DATA" =>
  {
    Code     => 0xc1,
    Umask    => 0x08,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "Any PRI data ref (CRd, DRd, RFO, UC/WC read/write) (RIL->PRI)",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xc1,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55500,
          Core     => "",
          Desc     => "Any PRI data ref (CRd, DRd, RFO, UC/WC read/write) (RIL->PRI)",
       },
       "WB_ANY" =>
       {
          Code     => 0xc1,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaa00,
          Core     => "",
          Desc     => "Any CRd, DRd, or RFO issued to PRI (RIL->PRI)",
       },
       "WB_MLD_ANY" =>
       {
          Code     => 0xc1,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "cacheable MLD requests (not incl. buddy requests) (MLD->RIL)",
       },
       "WB_MLD_BUDDY" =>
       {
          Code     => 0xc1,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "cacheable MLD buddy requests (MLD->RIL)",
       },
       "WB_CRD" =>
       {
          Code     => 0xc1,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "PRI CRd requests (data-side only) (RIL->PRI)",
       },
       "WB_DRD" =>
       {
          Code     => 0xc1,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "PRI DRd requests (RIL->PRI)",
       },
       "WB_RFO" =>
       {
          Code     => 0xc1,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "PRI RFO requests (RIL->PRI)",
       },
       "WB_SELF_SNOOP" =>
       {
          Code     => 0xc1,
          Umask    => 0x0f,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "MLD requests that hit in the WRQ (RIL)",
       },
       "NC_ANY" =>
       {
          Code     => 0xc2,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Any PRI WC or UC data read or write (RIL->PRI)",
       },
       "NC_READ_ANY" =>
       {
          Code     => 0xc2,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x22200,
          Core     => "",
          Desc     => "Any PRI WC or UC data read (RIL->PRI)",
       },
       "NC_READ_UC" =>
       {
          Code     => 0xc2,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x44400,
          Core     => "",
          Desc     => "PRI UC data reads (RIL->PRI)",
       },
       "NC_WRITE_ANY" =>
       {
          Code     => 0xc2,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x88800,
          Core     => "",
          Desc     => "Any PRI WC or UC data write (RIL->PRI)",
       },
       "NC_WRITE_WC_ANY" =>
       {
          Code     => 0xc2,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x11100,
          Core     => "",
          Desc     => "Any PRI WC data write (RIL->PRI)",
       },
       "NC_WRITE_WC_FULL" =>
       {
          Code     => 0xc2,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x22200,
          Core     => "",
          Desc     => "PRI full-line WC data writes (RIL->PRI)",
       },
       "NC_WRITE_UC" =>
       {
          Code     => 0xc2,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x44400,
          Core     => "",
          Desc     => "PRI UC data writes (RIL->PRI)",
       },
       "NC_WRITE_WC_MLD" =>
       {
          Code     => 0xc2,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x88800,
          Core     => "",
          Desc     => "MLD WC transaction issued from MLD (before coallescing) (MLD->RIL)",
       },
       "DRQ_ANY" =>
       {
          Code     => 0xc2,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "All MLD requests that write to the DRQ (MLD->RIL)",
       },
       "WRQ_ANY" =>
       {
          Code     => 0xc2,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "All MLD requests that write to the WRQ (MLD->RIL)",
       },
     },
  },
  "RIL_REQ_REF_INST" =>
  {
    Code     => 0xc1,
    Umask    => 0x04,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "Any instruction ref (CRd, PRdCode) (RIL->PRI)",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xc1,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55500,
          Core     => "",
          Desc     => "Any instruction ref (CRd, PRdCode) (RIL->PRI)",
       },
       "NC" =>
       {
          Code     => 0xc1,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x22200,
          Core     => "",
          Desc     => "Any PRI UC or WC code read (RIL->PRI)",
       },
       "WB_ANY" =>
       {
          Code     => 0xc1,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "PRI WB code reads (RIL->PRI)",
       },
       "WB_DMND" =>
       {
          Code     => 0xc1,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 1,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "PRI demand WB requests (RIL->PRI)",
       },
     },
  },
  "RIL_RESP" =>
  {
    Code     => 0xc5,
    Umask    => 0x0a,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "PRI GO response (PRI->RIL)",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "GO" =>
       {
          Code     => 0xc5,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "PRI GO response (PRI->RIL)",
       },
       "WRITEPULL" =>
       {
          Code     => 0xc5,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "PRI Writepull response (PRI->RIL)",
       },
     },
  },
  "RIL_RRQ" =>
  {
    Code     => 0xc8,
    Umask    => 0x04,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "RRQ Issue Queue throttled due to hitting the issue limit",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "LIMIT_HIT" =>
       {
          Code     => 0xc8,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "RRQ Issue Queue throttled due to hitting the issue limit",
       },
     },
  },
  "RIL_SEB" =>
  {
    Code     => 0xc9,
    Umask    => 0x02,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "SEB PTC Quiesce still pending",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "PTC_QUIESCE_PEND" =>
       {
          Code     => 0xc9,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "SEB PTC Quiesce still pending",
       },
       "LDST_QUIESCE_PEND" =>
       {
          Code     => 0xc9,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "SEB PTC Quiesce still pending",
       },
       "BGF_QUIESCE_ACTIVE" =>
       {
          Code     => 0xc9,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "SEB PTC Quiesce still pending",
       },
     },
  },
  "RIL_SHOOTDOWN" =>
  {
    Code     => 0xc4,
    Umask    => 0x0f,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "Incoming shootdowns (PRI->RIL)",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0x88800,
    Defn     => "",
  },
  "RIL_SHOOTDOWN_PEND_CYC" =>
  {
    Code     => 0xc5,
    Umask    => 0x00,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "Shootdown is pending (RIL)",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0x11100,
    Defn     => "",
  },
  "RIL_SNOOP_REQ" =>
  {
    Code     => 0xc0,
    Umask    => 0x01,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "Any PRI snoop request (PRI->RIL)",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0xc0,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0xaaa00,
          Core     => "",
          Desc     => "Any PRI snoop request (PRI->RIL)",
       },
       "CODE_ANY" =>
       {
          Code     => 0xc0,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x55500,
          Core     => "",
          Desc     => "Any PRI SnpCode request (PRI->RIL)",
       },
       "CODE_SELF" =>
       {
          Code     => 0xc0,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "PRI SnpCode due to request from this core (PRI->RIL)",
       },
       "CODE_SIBLING" =>
       {
          Code     => 0xc0,
          Umask    => 0x04,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "PRI SnpCode due to sibling core request (PRI->RIL)",
       },
       "DATA_ANY" =>
       {
          Code     => 0xc0,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0xaaa00,
          Core     => "",
          Desc     => "Any SnpData request (PRI->RIL)",
       },
       "DATA_SELF" =>
       {
          Code     => 0xc0,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "PRI SnpData due to request from this core (PRI->RIL)",
       },
       "DATA_SIBLING" =>
       {
          Code     => 0xc0,
          Umask    => 0x07,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "PRI SnpData due to sibling core request (PRI->RIL)",
       },
       "INVAL_ANY" =>
       {
          Code     => 0xc0,
          Umask    => 0x08,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x55500,
          Core     => "",
          Desc     => "Any SnpInv request (PRI->RIL)",
       },
       "INVAL_SELF" =>
       {
          Code     => 0xc0,
          Umask    => 0x09,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "PRI SnpInv due to request from this core (PRI->RIL)",
       },
       "INVAL_SIBLING" =>
       {
          Code     => 0xc0,
          Umask    => 0x0a,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "PRI SnpInv due to sibling core request (PRI->RIL)",
       },
       "INVAL_LLC_EVICT" =>
       {
          Code     => 0xc0,
          Umask    => 0x0b,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "PRI SnpInv due to an LLC eviction (PRI->RIL)",
       },
     },
  },
  "RIL_SNOOP_RESP" =>
  {
    Code     => 0xc0,
    Umask    => 0x0c,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "Snoop missed MLD (MLD->RIL)",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "MLD_MISS" =>
       {
          Code     => 0xc0,
          Umask    => 0x0c,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Snoop missed MLD (MLD->RIL)",
       },
       "WRQ_HIT_M" =>
       {
          Code     => 0xc0,
          Umask    => 0x0d,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Snoop missed MLD, hit WRQ dirty (MLD->RIL)",
       },
       "MLD_HIT_S" =>
       {
          Code     => 0xc0,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "Snoop hit MLD Snoop shared (MLD->RIL)",
       },
       "MLD_HIT_E" =>
       {
          Code     => 0xc0,
          Umask    => 0x0f,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "Snoop hit MLD Snoop exclusive (MLD->RIL)",
       },
       "MLD_HIT_M" =>
       {
          Code     => 0xc1,
          Umask    => 0x00,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "Snoop hit MLD Snoop modifyed (dirty) (MLD->RIL)",
       },
       "MLD_DEFER" =>
       {
          Code     => 0xc1,
          Umask    => 0x01,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "MLD Snoop was deferred (MLD->RIL)",
       },
     },
  },
  "RIL_SNQ" =>
  {
    Code     => 0xc8,
    Umask    => 0x05,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "No snoops in the issue queue or active in the core",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "EMPTY" =>
       {
          Code     => 0xc8,
          Umask    => 0x05,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "No snoops in the issue queue or active in the core",
       },
       "LIMIT_HIT" =>
       {
          Code     => 0xc8,
          Umask    => 0x06,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "SNQ throttled due to hitting the issue limit",
       },
     },
  },
  "RIL_SNQ_VALID" =>
  {
    Code     => 0xc8,
    Umask    => 0x0d,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "SNQ Transactions in flight in Core (count[4:1])",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "MSB" =>
       {
          Code     => 0xc8,
          Umask    => 0x0d,
          MaxInc   => 15,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x24900,
          Core     => "",
          Desc     => "SNQ Transactions in flight in Core (count[4:1])",
       },
       "LSB" =>
       {
          Code     => 0xc8,
          Umask    => 0x0e,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "SNQ Transactions in flight in Core (count[0])",
       },
     },
  },
  "RIL_WRQ" =>
  {
    Code     => 0xc8,
    Umask    => 0x02,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "WRQ Issue Queue is empty",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "EMPTY" =>
       {
          Code     => 0xc8,
          Umask    => 0x02,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "WRQ Issue Queue is empty",
       },
       "LIMIT_HIT" =>
       {
          Code     => 0xc8,
          Umask    => 0x03,
          MaxInc   => 1,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "WRQ Issue Queue throttled due to hitting the issue limit",
       },
     },
  },
  "RIL_WRQ_VALID" =>
  {
    Code     => 0xc8,
    Umask    => 0x0b,
    AltCodes => [],
    Category => "RIL Events",
    Desc     => "WRQ Transactions in flight on PRI (count[5:2])",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "MSB" =>
       {
          Code     => 0xc8,
          Umask    => 0x0b,
          MaxInc   => 8,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x49200,
          Core     => "",
          Desc     => "WRQ Transactions in flight on PRI (count[5:2])",
       },
       "LSB" =>
       {
          Code     => 0xc8,
          Umask    => 0x0c,
          MaxInc   => 3,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "C",
          RegRst   => 0x92400,
          Core     => "",
          Desc     => "WRQ Transactions in flight on PRI (count[1:0])",
       },
     },
  },
  "RSE_CURRENT_REG" =>
  {
    Code     => 0x15,
    Umask    => 0x04,
    AltCodes => [],
    Category => "RSE Events",
    Desc     => "RSE current registers lower bits",
    AltCat   => "",
    Defn     => "",
    Notes    => "Current RSE registers",
    Subcat  =>
    {
       "LSB" =>
       {
          Code     => 0x15,
          Umask    => 0x04,
          MaxInc   => 7,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "RSE current registers lower bits",
       },
       "MSB" =>
       {
          Code     => 0x15,
          Umask    => 0x03,
          MaxInc   => 12,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "RSE current registers upper bits",
       },
     },
  },
  "RSE_DIRTY_REG" =>
  {
    Code     => 0x15,
    Umask    => 0x06,
    AltCodes => [],
    Category => "RSE Events",
    Desc     => "RSE dirty registers lower bits",
    AltCat   => "",
    Defn     => "",
    Notes    => "Dirty RSE registers",
    Subcat  =>
    {
       "LSB" =>
       {
          Code     => 0x15,
          Umask    => 0x06,
          MaxInc   => 15,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "RSE dirty registers lower bits",
       },
       "MSB" =>
       {
          Code     => 0x15,
          Umask    => 0x05,
          MaxInc   => 8,
          IAR      => 0,
          DAR      => 0,
          DRF      => 0,
          OPC      => 0,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "RSE dirty registers upper bits",
       },
     },
  },
  "RSE_REF_RETIRED" =>
  {
    Code     => 0x15,
    Umask    => 0x08,
    AltCodes => [],
    Category => "RSE Events",
    Desc     => "RSE reference retired",
    AltCat   => "",
    Defn     => "",
    Subcat  =>
    {
       "ANY" =>
       {
          Code     => 0x15,
          Umask    => 0x08,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "RSE reference retired",
       },
       "LOAD" =>
       {
          Code     => 0x15,
          Umask    => 0x09,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0xaaaa0,
          Core     => "",
          Desc     => "RSE load reference retired",
       },
       "STORE" =>
       {
          Code     => 0x15,
          Umask    => 0x0a,
          MaxInc   => 2,
          IAR      => 1,
          DAR      => 1,
          DRF      => 1,
          OPC      => 1,
          MT       => "A",
          RegRst   => 0x55550,
          Core     => "",
          Desc     => "RSE store reference retired",
       },
     },
  },
  "SERIALIZATION_EVENT" =>
  {
    Code     => 0x02,
    Umask    => 0x01,
    AltCodes => [],
    Category => "System Events",
    Desc     => "Serialize event",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0xaaaa0,
    Defn     => "",
    Notes    => "Number of srlz.I instructions",
  },
  "TAL_EVENT" =>
  {
    Code     => 0x02,
    Umask    => 0x02,
    AltCodes => [],
    Category => "System Events",
    Desc     => "TAL event as programmed by XPN",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "A",
    RegRst   => 0x55550,
    Defn     => "",
  },
  "UNCORE_FREEZE" =>
  {
    Code     => 0xc9,
    Umask    => 0x0b,
    AltCodes => [],
    Category => "System Events",
    Desc     => "UNCORE PMU freeze signal from the uncore seen",
    AltCat   => "",
    MaxInc   => 1,
    IAR      => 0,
    DAR      => 0,
    DRF      => 0,
    OPC      => 0,
    MT       => "C",
    RegRst   => 0xaaa00,
    Defn     => "",
  },
);
